/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.os.Parcel;
import android.os.Parcelable;
import android.view.textclassifier.SystemTextClassifierMetadata;
import java.util.Locale;
import java.util.Objects;

public class TextClassificationContext
implements Parcelable {
    private String mPackageName;
    private final String mWidgetType;
    private final String mWidgetVersion;
    private SystemTextClassifierMetadata mSystemTcMetadata;
    public static final Parcelable.Creator<TextClassificationContext> CREATOR = new Parcelable.Creator<TextClassificationContext>(){

        @Override
        public TextClassificationContext createFromParcel(Parcel parcel) {
            return new TextClassificationContext(parcel);
        }

        public TextClassificationContext[] newArray(int size) {
            return new TextClassificationContext[size];
        }
    };

    private TextClassificationContext(String packageName, String widgetType, String widgetVersion) {
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mWidgetType = Objects.requireNonNull(widgetType);
        this.mWidgetVersion = widgetVersion;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    void setSystemTextClassifierMetadata(SystemTextClassifierMetadata systemTcMetadata) {
        this.mSystemTcMetadata = systemTcMetadata;
    }

    public SystemTextClassifierMetadata getSystemTextClassifierMetadata() {
        return this.mSystemTcMetadata;
    }

    public String getWidgetType() {
        return this.mWidgetType;
    }

    public String getWidgetVersion() {
        return this.mWidgetVersion;
    }

    public String toString() {
        return String.format(Locale.US, "TextClassificationContext{packageName=%s, widgetType=%s, widgetVersion=%s, systemTcMetadata=%s}", this.mPackageName, this.mWidgetType, this.mWidgetVersion, this.mSystemTcMetadata);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mPackageName);
        parcel.writeString(this.mWidgetType);
        parcel.writeString(this.mWidgetVersion);
        parcel.writeParcelable(this.mSystemTcMetadata, flags);
    }

    private TextClassificationContext(Parcel in) {
        this.mPackageName = in.readString();
        this.mWidgetType = in.readString();
        this.mWidgetVersion = in.readString();
        this.mSystemTcMetadata = in.readParcelable(null, SystemTextClassifierMetadata.class);
    }

    public static class Builder {
        private final String mPackageName;
        private final String mWidgetType;
        private String mWidgetVersion;

        public Builder(String packageName, String widgetType) {
            this.mPackageName = Objects.requireNonNull(packageName);
            this.mWidgetType = Objects.requireNonNull(widgetType);
        }

        public Builder setWidgetVersion(String widgetVersion) {
            this.mWidgetVersion = widgetVersion;
            return this;
        }

        public TextClassificationContext build() {
            return new TextClassificationContext(this.mPackageName, this.mWidgetType, this.mWidgetVersion);
        }
    }
}

