/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.content.ContentCaptureOptions;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IContentCaptureOptionsCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.view.contentcapture.IContentCaptureOptionsCallback";

    public void setContentCaptureOptions(ContentCaptureOptions var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContentCaptureOptionsCallback {
        static final int TRANSACTION_setContentCaptureOptions = 1;

        public Stub() {
            this.attachInterface(this, IContentCaptureOptionsCallback.DESCRIPTOR);
        }

        public static IContentCaptureOptionsCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IContentCaptureOptionsCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IContentCaptureOptionsCallback) {
                return (IContentCaptureOptionsCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setContentCaptureOptions";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IContentCaptureOptionsCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ContentCaptureOptions _arg0 = data.readTypedObject(ContentCaptureOptions.CREATOR);
                    data.enforceNoDataAvail();
                    this.setContentCaptureOptions(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IContentCaptureOptionsCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IContentCaptureOptionsCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setContentCaptureOptions(ContentCaptureOptions options) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContentCaptureOptionsCallback.DESCRIPTOR);
                    _data.writeTypedObject(options, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IContentCaptureOptionsCallback {
        @Override
        public void setContentCaptureOptions(ContentCaptureOptions options) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

