/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Dumpable;
import android.util.Log;
import android.util.Slog;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowManagerGlobal;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillPopupWindow;
import android.view.autofill.Helper;
import android.view.autofill.IAutofillWindowPresenter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class AutofillClientController
implements AutofillManager.AutofillClient,
Dumpable {
    private static final String TAG = "AutofillClientController";
    private static final String LOG_TAG = "autofill_client";
    public static final boolean DEBUG = Log.isLoggable("autofill_client", 3);
    public static final String LAST_AUTOFILL_ID = "android:lastAutofillId";
    public static final String AUTOFILL_RESET_NEEDED = "@android:autofillResetNeeded";
    public static final String AUTO_FILL_AUTH_WHO_PREFIX = "@android:autoFillAuth:";
    public static final String DUMPABLE_NAME = "AutofillManager";
    public int mLastAutofillId = 0x3FFFFFFF;
    private final Activity mActivity;
    private AutofillManager mAutofillManager;
    private AutofillPopupWindow mAutofillPopupWindow;
    private boolean mAutoFillResetNeeded;
    private boolean mAutoFillIgnoreFirstResumePause;

    public AutofillClientController(Activity activity) {
        this.mActivity = activity;
    }

    private AutofillManager getAutofillManager() {
        if (this.mAutofillManager == null) {
            this.mAutofillManager = this.mActivity.getSystemService(AutofillManager.class);
        }
        return this.mAutofillManager;
    }

    public void onActivityAttached(Application application) {
        this.mActivity.setAutofillOptions(application.getAutofillOptions());
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        this.mAutoFillResetNeeded = savedInstanceState.getBoolean(AUTOFILL_RESET_NEEDED, false);
        this.mLastAutofillId = savedInstanceState.getInt(LAST_AUTOFILL_ID, 0x3FFFFFFF);
        if (this.mAutoFillResetNeeded) {
            this.getAutofillManager().onCreate(savedInstanceState);
        }
    }

    public void onActivityStarted() {
        if (this.mAutoFillResetNeeded) {
            this.getAutofillManager().onVisibleForAutofill();
        }
    }

    public void onActivityResumed() {
        View focus;
        this.enableAutofillCompatibilityIfNeeded();
        if (this.mAutoFillResetNeeded && !this.mAutoFillIgnoreFirstResumePause && (focus = this.mActivity.getCurrentFocus()) != null && focus.canNotifyAutofillEnterExitEvent()) {
            this.getAutofillManager().notifyViewEntered(focus);
        }
    }

    public void onActivityPerformResume(boolean followedByPause) {
        if (this.mAutoFillResetNeeded) {
            this.mAutoFillIgnoreFirstResumePause = followedByPause;
            if (this.mAutoFillIgnoreFirstResumePause && DEBUG) {
                Slog.v(TAG, "autofill will ignore first pause when relaunching " + this);
            }
        }
    }

    public void onActivityPaused() {
        if (this.mAutoFillResetNeeded) {
            if (!this.mAutoFillIgnoreFirstResumePause) {
                View focus;
                if (DEBUG) {
                    Log.v(TAG, "autofill notifyViewExited " + this);
                }
                if ((focus = this.mActivity.getCurrentFocus()) != null && focus.canNotifyAutofillEnterExitEvent()) {
                    this.getAutofillManager().notifyViewExited(focus);
                }
            } else {
                if (DEBUG) {
                    Log.v(TAG, "autofill got first pause " + this);
                }
                this.mAutoFillIgnoreFirstResumePause = false;
            }
        }
    }

    public void onActivityStopped(Intent intent, boolean changingConfigurations) {
        if (this.mAutoFillResetNeeded) {
            this.getAutofillManager().onInvisibleForAutofill(!changingConfigurations);
        } else if (intent != null && intent.hasExtra("android.view.autofill.extra.RESTORE_SESSION_TOKEN") && intent.hasExtra("android.view.autofill.extra.RESTORE_CROSS_ACTIVITY")) {
            this.restoreAutofillSaveUi(intent);
        }
    }

    public void onActivityDestroyed() {
        if (this.mActivity.isFinishing() && this.mAutoFillResetNeeded) {
            this.getAutofillManager().onActivityFinishing();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(LAST_AUTOFILL_ID, this.mLastAutofillId);
        if (this.mAutoFillResetNeeded) {
            outState.putBoolean(AUTOFILL_RESET_NEEDED, true);
            this.getAutofillManager().onSaveInstanceState(outState);
        }
    }

    public void onActivityFinish(Intent intent) {
        if (intent != null && intent.hasExtra("android.view.autofill.extra.RESTORE_SESSION_TOKEN")) {
            this.restoreAutofillSaveUi(intent);
        }
    }

    public void onActivityBackPressed(Intent intent) {
        if (intent != null && intent.hasExtra("android.view.autofill.extra.RESTORE_SESSION_TOKEN")) {
            this.restoreAutofillSaveUi(intent);
        }
    }

    public void onDispatchActivityResult(int requestCode, int resultCode, Intent data) {
        Intent resultData = resultCode == -1 ? data : null;
        this.getAutofillManager().onAuthenticationResult(requestCode, resultData, this.mActivity.getCurrentFocus());
    }

    public void onStartActivity(Intent startIntent, Intent cachedIntent) {
        if (cachedIntent != null && cachedIntent.hasExtra("android.view.autofill.extra.RESTORE_SESSION_TOKEN") && cachedIntent.hasExtra("android.view.autofill.extra.RESTORE_CROSS_ACTIVITY") && TextUtils.equals(this.mActivity.getPackageName(), startIntent.resolveActivity(this.mActivity.getPackageManager()).getPackageName())) {
            IBinder token = cachedIntent.getIBinderExtra("android.view.autofill.extra.RESTORE_SESSION_TOKEN");
            cachedIntent.removeExtra("android.view.autofill.extra.RESTORE_SESSION_TOKEN");
            cachedIntent.removeExtra("android.view.autofill.extra.RESTORE_CROSS_ACTIVITY");
            startIntent.putExtra("android.view.autofill.extra.RESTORE_SESSION_TOKEN", token);
            startIntent.putExtra("android.view.autofill.extra.RESTORE_CROSS_ACTIVITY", true);
        }
    }

    public void restoreAutofillSaveUi(Intent intent) {
        IBinder token = intent.getIBinderExtra("android.view.autofill.extra.RESTORE_SESSION_TOKEN");
        intent.removeExtra("android.view.autofill.extra.RESTORE_SESSION_TOKEN");
        intent.removeExtra("android.view.autofill.extra.RESTORE_CROSS_ACTIVITY");
        this.getAutofillManager().onPendingSaveUi(2, token);
    }

    public void enableAutofillCompatibilityIfNeeded() {
        AutofillManager afm;
        if (this.mActivity.isAutofillCompatibilityEnabled() && (afm = this.mActivity.getSystemService(AutofillManager.class)) != null) {
            afm.enableCompatibilityMode();
        }
    }

    @Override
    public String getDumpableName() {
        return DUMPABLE_NAME;
    }

    @Override
    public void dump(PrintWriter writer, String[] args) {
        String prefix = "";
        AutofillManager afm = this.getAutofillManager();
        if (afm != null) {
            afm.dump("", writer);
            writer.print("");
            writer.print("Autofill Compat Mode: ");
            writer.println(this.mActivity.isAutofillCompatibilityEnabled());
        } else {
            writer.print("");
            writer.println("No AutofillManager");
        }
    }

    public int getNextAutofillId() {
        if (this.mLastAutofillId == 0x7FFFFFFE) {
            this.mLastAutofillId = 0x3FFFFFFF;
        }
        ++this.mLastAutofillId;
        return this.mLastAutofillId;
    }

    @Override
    public AutofillId autofillClientGetNextAutofillId() {
        return new AutofillId(this.getNextAutofillId());
    }

    @Override
    public boolean autofillClientIsCompatibilityModeEnabled() {
        return this.mActivity.isAutofillCompatibilityEnabled();
    }

    @Override
    public boolean autofillClientIsVisibleForAutofill() {
        return this.mActivity.isVisibleForAutofill();
    }

    @Override
    public ComponentName autofillClientGetComponentName() {
        return this.mActivity.getComponentName();
    }

    @Override
    public IBinder autofillClientGetActivityToken() {
        return this.mActivity.getActivityToken();
    }

    @Override
    public boolean[] autofillClientGetViewVisibility(AutofillId[] autofillIds) {
        int autofillIdCount = autofillIds.length;
        boolean[] visible = new boolean[autofillIdCount];
        for (int i = 0; i < autofillIdCount; ++i) {
            AutofillId autofillId = autofillIds[i];
            View view = this.autofillClientFindViewByAutofillIdTraversal(autofillId);
            if (view == null) continue;
            visible[i] = !autofillId.isVirtualInt() ? view.isVisibleToUser() : view.isVisibleToUserForAutofill(autofillId.getVirtualChildIntId());
        }
        if (Helper.sVerbose) {
            Log.v(TAG, "autofillClientGetViewVisibility(): " + Arrays.toString(visible));
        }
        return visible;
    }

    @Override
    public View autofillClientFindViewByAccessibilityIdTraversal(int viewId, int windowId) {
        ArrayList<ViewRootImpl> roots = WindowManagerGlobal.getInstance().getRootViews(this.mActivity.getActivityToken());
        for (int rootNum = 0; rootNum < roots.size(); ++rootNum) {
            Object view;
            View rootView = roots.get(rootNum).getView();
            if (rootView == null || rootView.getAccessibilityWindowId() != windowId || (view = rootView.findViewByAccessibilityIdTraversal(viewId)) == null) continue;
            return view;
        }
        return null;
    }

    @Override
    public View autofillClientFindViewByAutofillIdTraversal(AutofillId autofillId) {
        ArrayList<ViewRootImpl> roots = WindowManagerGlobal.getInstance().getRootViews(this.mActivity.getActivityToken());
        for (int rootNum = 0; rootNum < roots.size(); ++rootNum) {
            Object view;
            View rootView = roots.get(rootNum).getView();
            if (rootView == null || (view = rootView.findViewByAutofillIdTraversal(autofillId.getViewId())) == null) continue;
            return view;
        }
        return null;
    }

    @Override
    public View[] autofillClientFindViewsByAutofillIdTraversal(AutofillId[] autofillIds) {
        View[] views = new View[autofillIds.length];
        ArrayList<ViewRootImpl> roots = WindowManagerGlobal.getInstance().getRootViews(this.mActivity.getActivityToken());
        for (int rootNum = 0; rootNum < roots.size(); ++rootNum) {
            View rootView = roots.get(rootNum).getView();
            if (rootView == null) continue;
            int viewCount = autofillIds.length;
            for (int viewNum = 0; viewNum < viewCount; ++viewNum) {
                if (views[viewNum] != null) continue;
                views[viewNum] = rootView.findViewByAutofillIdTraversal(autofillIds[viewNum].getViewId());
            }
        }
        return views;
    }

    @Override
    public boolean autofillClientIsFillUiShowing() {
        return this.mAutofillPopupWindow != null && this.mAutofillPopupWindow.isShowing();
    }

    @Override
    public boolean autofillClientRequestHideFillUi() {
        if (this.mAutofillPopupWindow == null) {
            return false;
        }
        this.mAutofillPopupWindow.dismiss();
        this.mAutofillPopupWindow = null;
        return true;
    }

    @Override
    public boolean autofillClientRequestShowFillUi(View anchor, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) {
        boolean wasShowing;
        if (this.mAutofillPopupWindow == null) {
            wasShowing = false;
            this.mAutofillPopupWindow = new AutofillPopupWindow(presenter);
        } else {
            wasShowing = this.mAutofillPopupWindow.isShowing();
        }
        this.mAutofillPopupWindow.update(anchor, 0, 0, width, height, anchorBounds);
        return !wasShowing && this.mAutofillPopupWindow.isShowing();
    }

    @Override
    public void autofillClientDispatchUnhandledKey(View anchor, KeyEvent keyEvent) {
        ViewRootImpl rootImpl = anchor.getViewRootImpl();
        if (rootImpl != null) {
            rootImpl.dispatchKeyFromAutofill(keyEvent);
        }
    }

    @Override
    public boolean isDisablingEnterExitEventForAutofill() {
        return this.mAutoFillIgnoreFirstResumePause || !this.mActivity.isResumed();
    }

    @Override
    public void autofillClientResetableStateAvailable() {
        this.mAutoFillResetNeeded = true;
    }

    @Override
    public void autofillClientRunOnUiThread(Runnable action) {
        this.mActivity.runOnUiThread(action);
    }

    @Override
    public void autofillClientAuthenticate(int authenticationId, IntentSender intent, Intent fillInIntent, boolean authenticateInline) {
        try {
            this.mActivity.startIntentSenderForResult(intent, AUTO_FILL_AUTH_WHO_PREFIX, authenticationId, fillInIntent, 0, 0, null);
        }
        catch (IntentSender.SendIntentException e) {
            Log.e(TAG, "authenticate() failed for intent:" + intent, e);
        }
    }
}

