/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Insets;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.internal.R;

public class ExtendAnimation
extends Animation {
    protected Insets mFromInsets = Insets.NONE;
    protected Insets mToInsets = Insets.NONE;
    private int mFromLeftType = 0;
    private int mFromTopType = 0;
    private int mFromRightType = 0;
    private int mFromBottomType = 0;
    private int mToLeftType = 0;
    private int mToTopType = 0;
    private int mToRightType = 0;
    private int mToBottomType = 0;
    private float mFromLeftValue;
    private float mFromTopValue;
    private float mFromRightValue;
    private float mFromBottomValue;
    private float mToLeftValue;
    private float mToTopValue;
    private float mToRightValue;
    private float mToBottomValue;

    public ExtendAnimation(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExtendAnimation);
        Animation.Description d = Animation.Description.parseValue(a.peekValue(0), context);
        this.mFromLeftType = d.type;
        this.mFromLeftValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(1), context);
        this.mFromTopType = d.type;
        this.mFromTopValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(2), context);
        this.mFromRightType = d.type;
        this.mFromRightValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(3), context);
        this.mFromBottomType = d.type;
        this.mFromBottomValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(4), context);
        this.mToLeftType = d.type;
        this.mToLeftValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(5), context);
        this.mToTopType = d.type;
        this.mToTopValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(6), context);
        this.mToRightType = d.type;
        this.mToRightValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(7), context);
        this.mToBottomType = d.type;
        this.mToBottomValue = d.value;
        a.recycle();
    }

    public ExtendAnimation(Insets fromInsets, Insets toInsets) {
        if (fromInsets == null || toInsets == null) {
            throw new RuntimeException("Expected non-null animation outsets");
        }
        this.mFromLeftValue = -fromInsets.left;
        this.mFromTopValue = -fromInsets.top;
        this.mFromRightValue = -fromInsets.right;
        this.mFromBottomValue = -fromInsets.bottom;
        this.mToLeftValue = -toInsets.left;
        this.mToTopValue = -toInsets.top;
        this.mToRightValue = -toInsets.right;
        this.mToBottomValue = -toInsets.bottom;
    }

    public ExtendAnimation(int fromL, int fromT, int fromR, int fromB, int toL, int toT, int toR, int toB) {
        this(Insets.of(-fromL, -fromT, -fromR, -fromB), Insets.of(-toL, -toT, -toR, -toB));
    }

    @Override
    protected void applyTransformation(float it, Transformation tr) {
        int l = this.mFromInsets.left + (int)((float)(this.mToInsets.left - this.mFromInsets.left) * it);
        int t = this.mFromInsets.top + (int)((float)(this.mToInsets.top - this.mFromInsets.top) * it);
        int r = this.mFromInsets.right + (int)((float)(this.mToInsets.right - this.mFromInsets.right) * it);
        int b = this.mFromInsets.bottom + (int)((float)(this.mToInsets.bottom - this.mFromInsets.bottom) * it);
        tr.setInsets(l, t, r, b);
    }

    @Override
    public boolean willChangeTransformationMatrix() {
        return false;
    }

    @Override
    public boolean hasExtension() {
        return this.mFromInsets.left < 0 || this.mFromInsets.top < 0 || this.mFromInsets.right < 0 || this.mFromInsets.bottom < 0;
    }

    @Override
    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.mFromInsets = Insets.min(Insets.of(-((int)this.resolveSize(this.mFromLeftType, this.mFromLeftValue, width, parentWidth)), -((int)this.resolveSize(this.mFromTopType, this.mFromTopValue, height, parentHeight)), -((int)this.resolveSize(this.mFromRightType, this.mFromRightValue, width, parentWidth)), -((int)this.resolveSize(this.mFromBottomType, this.mFromBottomValue, height, parentHeight))), Insets.NONE);
        this.mToInsets = Insets.min(Insets.of(-((int)this.resolveSize(this.mToLeftType, this.mToLeftValue, width, parentWidth)), -((int)this.resolveSize(this.mToTopType, this.mToTopValue, height, parentHeight)), -((int)this.resolveSize(this.mToRightType, this.mToRightValue, width, parentWidth)), -((int)this.resolveSize(this.mToBottomType, this.mToBottomValue, height, parentHeight))), Insets.NONE);
    }
}

