/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os._Original_Build;
import android.util.ArraySet;
import android.util.Log;
import android.util.LongArray;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import java.util.ArrayList;
import java.util.List;

public class AccessibilityCache {
    private static final String LOG_TAG = "AccessibilityCache";
    private static final boolean DEBUG = Log.isLoggable("AccessibilityCache", 3) && _Original_Build.IS_DEBUGGABLE;
    private static final boolean VERBOSE = Log.isLoggable("AccessibilityCache", 2) && _Original_Build.IS_DEBUGGABLE;
    private static final boolean CHECK_INTEGRITY = _Original_Build.IS_ENG;
    private boolean mEnabled = true;
    public static final int CACHE_CRITICAL_EVENTS_MASK = 4307005;
    private final Object mLock = new Object();
    private final AccessibilityNodeRefresher mAccessibilityNodeRefresher;
    private long mAccessibilityFocus = Integer.MAX_VALUE;
    private long mInputFocus = Integer.MAX_VALUE;
    private long mValidWindowCacheTimeStamp = 0L;
    private int mAccessibilityFocusedWindow = -1;
    private int mInputFocusWindow = -1;
    private boolean mIsAllWindowsCached;
    private final SparseArray<SparseArray<AccessibilityWindowInfo>> mWindowCacheByDisplay = new SparseArray();
    private final SparseArray<LongSparseArray<AccessibilityNodeInfo>> mNodeCache = new SparseArray();
    private final SparseArray<AccessibilityWindowInfo> mTempWindowArray = new SparseArray();

    public AccessibilityCache(AccessibilityNodeRefresher nodeRefresher) {
        this.mAccessibilityNodeRefresher = nodeRefresher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            this.mEnabled = enabled;
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowsOnAllDisplays(SparseArray<List<AccessibilityWindowInfo>> windowsOnAllDisplays, long populationTimeStamp) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled) {
                if (DEBUG) {
                    Log.i(LOG_TAG, "Cache is disabled");
                }
                return;
            }
            if (DEBUG) {
                Log.i(LOG_TAG, "Set windows");
            }
            if (this.mValidWindowCacheTimeStamp > populationTimeStamp) {
                return;
            }
            this.clearWindowCacheLocked();
            if (windowsOnAllDisplays == null) {
                return;
            }
            int displayCounts = windowsOnAllDisplays.size();
            for (int i = 0; i < displayCounts; ++i) {
                List<AccessibilityWindowInfo> windowsOfDisplay = windowsOnAllDisplays.valueAt(i);
                if (windowsOfDisplay == null) continue;
                int displayId = windowsOnAllDisplays.keyAt(i);
                int windowCount = windowsOfDisplay.size();
                for (int j = 0; j < windowCount; ++j) {
                    this.addWindowByDisplayLocked(displayId, windowsOfDisplay.get(j));
                }
            }
            this.mIsAllWindowsCached = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindow(AccessibilityWindowInfo window) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled) {
                if (DEBUG) {
                    Log.i(LOG_TAG, "Cache is disabled");
                }
                return;
            }
            if (DEBUG) {
                Log.i(LOG_TAG, "Caching window: " + window.getId() + " at display Id [ " + window.getDisplayId() + " ]");
            }
            this.addWindowByDisplayLocked(window.getDisplayId(), window);
        }
    }

    private void addWindowByDisplayLocked(int displayId, AccessibilityWindowInfo window) {
        SparseArray<AccessibilityWindowInfo> windows = this.mWindowCacheByDisplay.get(displayId);
        if (windows == null) {
            windows = new SparseArray();
            this.mWindowCacheByDisplay.put(displayId, windows);
        }
        int windowId = window.getId();
        windows.put(windowId, new AccessibilityWindowInfo(window));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAccessibilityEvent(AccessibilityEvent event) {
        AccessibilityNodeInfo nodeToRefresh = null;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled) {
                if (DEBUG) {
                    Log.i(LOG_TAG, "Cache is disabled");
                }
                return;
            }
            if (DEBUG) {
                Log.i(LOG_TAG, "onAccessibilityEvent(" + event + ")");
            }
            int eventType = event.getEventType();
            switch (eventType) {
                case 32768: {
                    if (this.mAccessibilityFocus != Integer.MAX_VALUE) {
                        this.removeCachedNodeLocked(this.mAccessibilityFocusedWindow, this.mAccessibilityFocus);
                    }
                    this.mAccessibilityFocus = event.getSourceNodeId();
                    this.mAccessibilityFocusedWindow = event.getWindowId();
                    nodeToRefresh = this.removeCachedNodeLocked(this.mAccessibilityFocusedWindow, this.mAccessibilityFocus);
                    break;
                }
                case 65536: {
                    if (this.mAccessibilityFocus != event.getSourceNodeId() || this.mAccessibilityFocusedWindow != event.getWindowId()) break;
                    nodeToRefresh = this.removeCachedNodeLocked(this.mAccessibilityFocusedWindow, this.mAccessibilityFocus);
                    this.mAccessibilityFocus = Integer.MAX_VALUE;
                    this.mAccessibilityFocusedWindow = -1;
                    break;
                }
                case 8: {
                    if (this.mInputFocus != Integer.MAX_VALUE) {
                        this.removeCachedNodeLocked(event.getWindowId(), this.mInputFocus);
                    }
                    this.mInputFocus = event.getSourceNodeId();
                    this.mInputFocusWindow = event.getWindowId();
                    nodeToRefresh = this.removeCachedNodeLocked(event.getWindowId(), this.mInputFocus);
                    break;
                }
                case 1: 
                case 4: 
                case 16: 
                case 8192: {
                    nodeToRefresh = this.removeCachedNodeLocked(event.getWindowId(), event.getSourceNodeId());
                    break;
                }
                case 2048: {
                    Object object2 = this.mLock;
                    synchronized (object2) {
                        int windowId = event.getWindowId();
                        long sourceId = event.getSourceNodeId();
                        if ((event.getContentChangeTypes() & 1) != 0) {
                            this.clearSubTreeLocked(windowId, sourceId);
                        } else {
                            nodeToRefresh = this.removeCachedNodeLocked(windowId, sourceId);
                        }
                        break;
                    }
                }
                case 4096: {
                    this.clearSubTreeLocked(event.getWindowId(), event.getSourceNodeId());
                    break;
                }
                case 0x400000: {
                    this.mValidWindowCacheTimeStamp = event.getEventTime();
                    if (event.getWindowChanges() == 128) {
                        this.clearWindowCacheLocked();
                        break;
                    }
                }
                case 32: {
                    this.mValidWindowCacheTimeStamp = event.getEventTime();
                    this.clear();
                }
            }
        }
        if (nodeToRefresh != null) {
            if (DEBUG) {
                Log.i(LOG_TAG, "Refreshing and re-adding cached node.");
            }
            if (this.mAccessibilityNodeRefresher.refreshNode(nodeToRefresh, true)) {
                this.add(nodeToRefresh);
            }
        }
        if (CHECK_INTEGRITY) {
            this.checkIntegrity();
        }
    }

    private AccessibilityNodeInfo removeCachedNodeLocked(int windowId, long sourceId) {
        LongSparseArray<AccessibilityNodeInfo> nodes;
        if (DEBUG) {
            Log.i(LOG_TAG, "Removing cached node.");
        }
        if ((nodes = this.mNodeCache.get(windowId)) == null) {
            return null;
        }
        AccessibilityNodeInfo cachedInfo = nodes.get(sourceId);
        if (cachedInfo == null) {
            return null;
        }
        nodes.remove(sourceId);
        return cachedInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityNodeInfo getNode(int windowId, long accessibilityNodeId) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled) {
                if (DEBUG) {
                    Log.i(LOG_TAG, "Cache is disabled");
                }
                return null;
            }
            LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.get(windowId);
            if (nodes == null) {
                return null;
            }
            AccessibilityNodeInfo info = nodes.get(accessibilityNodeId);
            if (info != null) {
                info = new AccessibilityNodeInfo(info);
            }
            if (VERBOSE) {
                Log.i(LOG_TAG, "get(0x" + Long.toHexString(accessibilityNodeId) + ") = " + info);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNodeInCache(AccessibilityNodeInfo info) {
        if (info == null) {
            return false;
        }
        int windowId = info.getWindowId();
        long accessibilityNodeId = info.getSourceNodeId();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled) {
                if (DEBUG) {
                    Log.i(LOG_TAG, "Cache is disabled");
                }
                return false;
            }
            LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.get(windowId);
            if (nodes == null) {
                return false;
            }
            return nodes.get(accessibilityNodeId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparseArray<List<AccessibilityWindowInfo>> getWindowsOnAllDisplays() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled) {
                if (DEBUG) {
                    Log.i(LOG_TAG, "Cache is disabled");
                }
                return null;
            }
            if (!this.mIsAllWindowsCached) {
                return null;
            }
            SparseArray<List<AccessibilityWindowInfo>> returnWindows = new SparseArray<List<AccessibilityWindowInfo>>();
            int displayCounts = this.mWindowCacheByDisplay.size();
            if (displayCounts > 0) {
                for (int i = 0; i < displayCounts; ++i) {
                    int windowCount;
                    int displayId = this.mWindowCacheByDisplay.keyAt(i);
                    SparseArray<AccessibilityWindowInfo> windowsOfDisplay = this.mWindowCacheByDisplay.valueAt(i);
                    if (windowsOfDisplay == null || (windowCount = windowsOfDisplay.size()) <= 0) continue;
                    SparseArray<AccessibilityWindowInfo> sortedWindows = this.mTempWindowArray;
                    sortedWindows.clear();
                    for (int j = 0; j < windowCount; ++j) {
                        AccessibilityWindowInfo window = windowsOfDisplay.valueAt(j);
                        sortedWindows.put(window.getLayer(), window);
                    }
                    int sortedWindowCount = sortedWindows.size();
                    ArrayList<AccessibilityWindowInfo> windows = new ArrayList<AccessibilityWindowInfo>(sortedWindowCount);
                    for (int j = sortedWindowCount - 1; j >= 0; --j) {
                        AccessibilityWindowInfo window = sortedWindows.valueAt(j);
                        windows.add(new AccessibilityWindowInfo(window));
                        sortedWindows.removeAt(j);
                    }
                    returnWindows.put(displayId, windows);
                }
                return returnWindows;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityWindowInfo getWindow(int windowId) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled) {
                if (DEBUG) {
                    Log.i(LOG_TAG, "Cache is disabled");
                }
                return null;
            }
            int displayCounts = this.mWindowCacheByDisplay.size();
            for (int i = 0; i < displayCounts; ++i) {
                AccessibilityWindowInfo window;
                SparseArray<AccessibilityWindowInfo> windowsOfDisplay = this.mWindowCacheByDisplay.valueAt(i);
                if (windowsOfDisplay == null || (window = windowsOfDisplay.get(windowId)) == null) continue;
                return new AccessibilityWindowInfo(window);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AccessibilityNodeInfo info) {
        Object object = this.mLock;
        synchronized (object) {
            long sourceId;
            AccessibilityNodeInfo oldInfo;
            int windowId;
            LongSparseArray<AccessibilityNodeInfo> nodes;
            if (!this.mEnabled) {
                if (DEBUG) {
                    Log.i(LOG_TAG, "Cache is disabled");
                }
                return;
            }
            if (VERBOSE) {
                Log.i(LOG_TAG, "add(" + info + ")");
            }
            if ((nodes = this.mNodeCache.get(windowId = info.getWindowId())) == null) {
                nodes = new LongSparseArray();
                this.mNodeCache.put(windowId, nodes);
            }
            if ((oldInfo = nodes.get(sourceId = info.getSourceNodeId())) != null) {
                LongArray newChildrenIds = info.getChildNodeIds();
                int oldChildCount = oldInfo.getChildCount();
                for (int i = 0; i < oldChildCount; ++i) {
                    long oldChildId = oldInfo.getChildId(i);
                    if (newChildrenIds == null || newChildrenIds.indexOf(oldChildId) < 0) {
                        this.clearSubTreeLocked(windowId, oldChildId);
                    }
                    if (nodes.get(sourceId) != null) continue;
                    this.clearNodesForWindowLocked(windowId);
                    return;
                }
                long oldParentId = oldInfo.getParentNodeId();
                if (info.getParentNodeId() != oldParentId) {
                    this.clearSubTreeLocked(windowId, oldParentId);
                }
            }
            AccessibilityNodeInfo clone = new AccessibilityNodeInfo(info);
            nodes.put(sourceId, clone);
            if (clone.isAccessibilityFocused()) {
                if (this.mAccessibilityFocus != Integer.MAX_VALUE && this.mAccessibilityFocus != sourceId) {
                    this.removeCachedNodeLocked(windowId, this.mAccessibilityFocus);
                }
                this.mAccessibilityFocus = sourceId;
                this.mAccessibilityFocusedWindow = windowId;
            } else if (this.mAccessibilityFocus == sourceId) {
                this.mAccessibilityFocus = Integer.MAX_VALUE;
                this.mAccessibilityFocusedWindow = -1;
            }
            if (clone.isFocused()) {
                this.mInputFocus = sourceId;
                this.mInputFocusWindow = windowId;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            if (DEBUG) {
                Log.i(LOG_TAG, "clear()");
            }
            this.clearWindowCacheLocked();
            int nodesForWindowCount = this.mNodeCache.size();
            for (int i = nodesForWindowCount - 1; i >= 0; --i) {
                int windowId = this.mNodeCache.keyAt(i);
                this.clearNodesForWindowLocked(windowId);
            }
            this.mAccessibilityFocus = Integer.MAX_VALUE;
            this.mInputFocus = Integer.MAX_VALUE;
            this.mAccessibilityFocusedWindow = -1;
            this.mInputFocusWindow = -1;
        }
    }

    private void clearWindowCacheLocked() {
        int displayCounts;
        if (DEBUG) {
            Log.i(LOG_TAG, "clearWindowCacheLocked");
        }
        if ((displayCounts = this.mWindowCacheByDisplay.size()) > 0) {
            for (int i = displayCounts - 1; i >= 0; --i) {
                int displayId = this.mWindowCacheByDisplay.keyAt(i);
                SparseArray<AccessibilityWindowInfo> windows = this.mWindowCacheByDisplay.get(displayId);
                if (windows != null) {
                    windows.clear();
                }
                this.mWindowCacheByDisplay.remove(displayId);
            }
        }
        this.mIsAllWindowsCached = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityNodeInfo getFocus(int focusType, long initialNodeId, int windowId) {
        Object object = this.mLock;
        synchronized (object) {
            long currentFocusId;
            int currentFocusWindowId;
            if (!this.mEnabled) {
                if (DEBUG) {
                    Log.i(LOG_TAG, "Cache is disabled");
                }
                return null;
            }
            if (focusType == 2) {
                currentFocusWindowId = this.mAccessibilityFocusedWindow;
                currentFocusId = this.mAccessibilityFocus;
            } else {
                currentFocusWindowId = this.mInputFocusWindow;
                currentFocusId = this.mInputFocus;
            }
            if (currentFocusWindowId == -1) {
                return null;
            }
            if (windowId != -2 && windowId != currentFocusWindowId) {
                return null;
            }
            LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.get(currentFocusWindowId);
            if (nodes == null) {
                return null;
            }
            AccessibilityNodeInfo currentFocusedNode = nodes.get(currentFocusId);
            if (currentFocusedNode == null) {
                return null;
            }
            if (initialNodeId == currentFocusId || this.isCachedNodeOrDescendantLocked(currentFocusedNode.getParentNodeId(), initialNodeId, nodes)) {
                if (VERBOSE) {
                    Log.i(LOG_TAG, "getFocus(0x" + Long.toHexString(currentFocusId) + ") = " + currentFocusedNode + " with type: " + (focusType == 2 ? "FOCUS_ACCESSIBILITY" : "FOCUS_INPUT"));
                }
                return new AccessibilityNodeInfo(currentFocusedNode);
            }
            if (VERBOSE) {
                Log.i(LOG_TAG, "getFocus is null with type: " + (focusType == 2 ? "FOCUS_ACCESSIBILITY" : "FOCUS_INPUT"));
            }
            return null;
        }
    }

    private boolean isCachedNodeOrDescendantLocked(long nodeId, long ancestorId, LongSparseArray<AccessibilityNodeInfo> nodes) {
        if (ancestorId == nodeId) {
            return true;
        }
        AccessibilityNodeInfo node = nodes.get(nodeId);
        if (node == null) {
            return false;
        }
        return this.isCachedNodeOrDescendantLocked(node.getParentNodeId(), ancestorId, nodes);
    }

    private void clearNodesForWindowLocked(int windowId) {
        LongSparseArray<AccessibilityNodeInfo> nodes;
        if (DEBUG) {
            Log.i(LOG_TAG, "clearNodesForWindowLocked(" + windowId + ")");
        }
        if ((nodes = this.mNodeCache.get(windowId)) == null) {
            return;
        }
        this.mNodeCache.remove(windowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearSubTree(AccessibilityNodeInfo info) {
        if (info == null) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled) {
                if (DEBUG) {
                    Log.i(LOG_TAG, "Cache is disabled");
                }
                return false;
            }
            this.clearSubTreeLocked(info.getWindowId(), info.getSourceNodeId());
            return true;
        }
    }

    private void clearSubTreeLocked(int windowId, long rootNodeId) {
        LongSparseArray<AccessibilityNodeInfo> nodes;
        if (DEBUG) {
            Log.i(LOG_TAG, "Clearing cached subtree.");
        }
        if ((nodes = this.mNodeCache.get(windowId)) != null) {
            this.clearSubTreeRecursiveLocked(nodes, rootNodeId);
        }
    }

    private boolean clearSubTreeRecursiveLocked(LongSparseArray<AccessibilityNodeInfo> nodes, long rootNodeId) {
        AccessibilityNodeInfo current = nodes.get(rootNodeId);
        if (current == null) {
            this.clear();
            return true;
        }
        nodes.remove(rootNodeId);
        int childCount = current.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            long childNodeId = current.getChildId(i);
            if (!this.clearSubTreeRecursiveLocked(nodes, childNodeId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIntegrity() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWindowCacheByDisplay.size() <= 0 && this.mNodeCache.size() == 0) {
                return;
            }
            AccessibilityWindowInfo focusedWindow = null;
            AccessibilityWindowInfo activeWindow = null;
            int displayCounts = this.mWindowCacheByDisplay.size();
            for (int i = 0; i < displayCounts; ++i) {
                SparseArray<AccessibilityWindowInfo> windowsOfDisplay = this.mWindowCacheByDisplay.valueAt(i);
                if (windowsOfDisplay == null) continue;
                int windowCount = windowsOfDisplay.size();
                for (int j = 0; j < windowCount; ++j) {
                    AccessibilityWindowInfo window = windowsOfDisplay.valueAt(j);
                    if (window.isActive()) {
                        if (activeWindow != null) {
                            Log.e(LOG_TAG, "Duplicate active window:" + window);
                        } else {
                            activeWindow = window;
                        }
                    }
                    if (!window.isFocused()) continue;
                    if (focusedWindow != null) {
                        Log.e(LOG_TAG, "Duplicate focused window:" + window);
                        continue;
                    }
                    focusedWindow = window;
                }
            }
            AccessibilityNodeInfo accessFocus = null;
            AccessibilityNodeInfo inputFocus = null;
            int nodesForWindowCount = this.mNodeCache.size();
            for (int i = 0; i < nodesForWindowCount; ++i) {
                LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.valueAt(i);
                if (nodes.size() <= 0) continue;
                ArraySet<AccessibilityNodeInfo> seen = new ArraySet<AccessibilityNodeInfo>();
                int windowId = this.mNodeCache.keyAt(i);
                int nodeCount = nodes.size();
                for (int j = 0; j < nodeCount; ++j) {
                    AccessibilityNodeInfo nodeParent;
                    AccessibilityNodeInfo node = nodes.valueAt(j);
                    if (!seen.add(node)) {
                        Log.e(LOG_TAG, "Duplicate node: " + node + " in window:" + windowId);
                        continue;
                    }
                    if (node.isAccessibilityFocused()) {
                        if (accessFocus != null) {
                            Log.e(LOG_TAG, "Duplicate accessibility focus:" + node + " in window:" + windowId);
                        } else {
                            accessFocus = node;
                        }
                    }
                    if (node.isFocused()) {
                        if (inputFocus != null) {
                            Log.e(LOG_TAG, "Duplicate input focus: " + node + " in window:" + windowId);
                        } else {
                            inputFocus = node;
                        }
                    }
                    if ((nodeParent = nodes.get(node.getParentNodeId())) != null) {
                        boolean childOfItsParent = false;
                        int childCount = nodeParent.getChildCount();
                        for (int k = 0; k < childCount; ++k) {
                            AccessibilityNodeInfo child = nodes.get(nodeParent.getChildId(k));
                            if (child != node) continue;
                            childOfItsParent = true;
                            break;
                        }
                        if (!childOfItsParent) {
                            Log.e(LOG_TAG, "Invalid parent-child relation between parent: " + nodeParent + " and child: " + node);
                        }
                    }
                    int childCount = node.getChildCount();
                    for (int k = 0; k < childCount; ++k) {
                        AccessibilityNodeInfo parent;
                        AccessibilityNodeInfo child = nodes.get(node.getChildId(k));
                        if (child == null || (parent = nodes.get(child.getParentNodeId())) == node) continue;
                        Log.e(LOG_TAG, "Invalid child-parent relation between child: " + node + " and parent: " + nodeParent);
                    }
                }
            }
        }
    }

    public static class AccessibilityNodeRefresher {
        public boolean refreshNode(AccessibilityNodeInfo info, boolean bypassCache) {
            return info.refresh(null, bypassCache);
        }

        public boolean refreshWindow(AccessibilityWindowInfo info) {
            return info.refresh();
        }
    }
}

