/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;

class RoundScrollbarRenderer {
    private static final int SCROLLBAR_ANGLE_RANGE = 90;
    private static final int MAX_SCROLLBAR_ANGLE_SWIPE = 16;
    private static final int MIN_SCROLLBAR_ANGLE_SWIPE = 6;
    private static final float WIDTH_PERCENTAGE = 0.02f;
    private static final int DEFAULT_THUMB_COLOR = -1512723;
    private static final int DEFAULT_TRACK_COLOR = 0x4CFFFFFF;
    private final Paint mThumbPaint = new Paint();
    private final Paint mTrackPaint = new Paint();
    private final RectF mRect = new RectF();
    private final View mParent;
    private final int mMaskThickness;

    public RoundScrollbarRenderer(View parent) {
        this.mThumbPaint.setAntiAlias(true);
        this.mThumbPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mThumbPaint.setStyle(Paint.Style.STROKE);
        this.mTrackPaint.setAntiAlias(true);
        this.mTrackPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mTrackPaint.setStyle(Paint.Style.STROKE);
        this.mParent = parent;
        this.mMaskThickness = parent.getContext().getResources().getDimensionPixelSize(17105060);
    }

    public void drawRoundScrollbars(Canvas canvas, float alpha, Rect bounds) {
        if (alpha == 0.0f) {
            return;
        }
        float maxScroll = this.mParent.computeVerticalScrollRange();
        float scrollExtent = this.mParent.computeVerticalScrollExtent();
        if (scrollExtent <= 0.0f || maxScroll <= scrollExtent) {
            return;
        }
        float currentScroll = Math.max(0, this.mParent.computeVerticalScrollOffset());
        float linearThumbLength = this.mParent.computeVerticalScrollExtent();
        float thumbWidth = (float)this.mParent.getWidth() * 0.02f;
        this.mThumbPaint.setStrokeWidth(thumbWidth);
        this.mTrackPaint.setStrokeWidth(thumbWidth);
        this.setThumbColor(RoundScrollbarRenderer.applyAlpha(-1512723, alpha));
        this.setTrackColor(RoundScrollbarRenderer.applyAlpha(0x4CFFFFFF, alpha));
        float sweepAngle = linearThumbLength / maxScroll * 90.0f;
        sweepAngle = RoundScrollbarRenderer.clamp(sweepAngle, 6.0f, 16.0f);
        float startAngle = currentScroll * (90.0f - sweepAngle) / (maxScroll - linearThumbLength) - 45.0f;
        startAngle = RoundScrollbarRenderer.clamp(startAngle, -45.0f, 45.0f - sweepAngle);
        float inset = thumbWidth / 2.0f + (float)this.mMaskThickness;
        this.mRect.set((float)bounds.left + inset, (float)bounds.top + inset, (float)bounds.right - inset, (float)bounds.bottom - inset);
        canvas.drawArc(this.mRect, -45.0f, 90.0f, false, this.mTrackPaint);
        canvas.drawArc(this.mRect, startAngle, sweepAngle, false, this.mThumbPaint);
    }

    private static float clamp(float val, float min, float max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    private static int applyAlpha(int color2, float alpha) {
        int alphaByte = (int)((float)Color.alpha(color2) * alpha);
        return Color.argb(alphaByte, Color.red(color2), Color.green(color2), Color.blue(color2));
    }

    private void setThumbColor(int thumbColor) {
        if (this.mThumbPaint.getColor() != thumbColor) {
            this.mThumbPaint.setColor(thumbColor);
        }
    }

    private void setTrackColor(int trackColor) {
        if (this.mTrackPaint.getColor() != trackColor) {
            this.mTrackPaint.setColor(trackColor);
        }
    }
}

