/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.IRecentsAnimationController;
import android.view.RemoteAnimationTarget;
import android.window.TaskSnapshot;

public interface IRecentsAnimationRunner
extends IInterface {
    public void onAnimationCanceled(int[] var1, TaskSnapshot[] var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IRecentsAnimationRunner.aidl:57:1:57:69")
    public void onAnimationStart(IRecentsAnimationController var1, RemoteAnimationTarget[] var2, RemoteAnimationTarget[] var3, Rect var4, Rect var5) throws RemoteException;

    public void onTasksAppeared(RemoteAnimationTarget[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRecentsAnimationRunner {
        public static final String DESCRIPTOR = "android.view.IRecentsAnimationRunner";
        static final int TRANSACTION_onAnimationCanceled = 2;
        static final int TRANSACTION_onAnimationStart = 3;
        static final int TRANSACTION_onTasksAppeared = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IRecentsAnimationRunner asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IRecentsAnimationRunner) {
                return (IRecentsAnimationRunner)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 2: {
                    return "onAnimationCanceled";
                }
                case 3: {
                    return "onAnimationStart";
                }
                case 4: {
                    return "onTasksAppeared";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 2: {
                    int[] _arg0 = data.createIntArray();
                    TaskSnapshot[] _arg1 = data.createTypedArray(TaskSnapshot.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAnimationCanceled(_arg0, _arg1);
                    break;
                }
                case 3: {
                    IRecentsAnimationController _arg0 = IRecentsAnimationController.Stub.asInterface(data.readStrongBinder());
                    RemoteAnimationTarget[] _arg1 = data.createTypedArray(RemoteAnimationTarget.CREATOR);
                    RemoteAnimationTarget[] _arg2 = data.createTypedArray(RemoteAnimationTarget.CREATOR);
                    Rect _arg3 = data.readTypedObject(Rect.CREATOR);
                    Rect _arg4 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAnimationStart(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 4: {
                    RemoteAnimationTarget[] _arg0 = data.createTypedArray(RemoteAnimationTarget.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTasksAppeared(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IRecentsAnimationRunner {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAnimationCanceled(int[] taskIds, TaskSnapshot[] taskSnapshots) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(taskIds);
                    _data.writeTypedArray(taskSnapshots, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAnimationStart(IRecentsAnimationController controller, RemoteAnimationTarget[] apps, RemoteAnimationTarget[] wallpapers, Rect homeContentInsets, Rect minimizedHomeBounds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(controller);
                    _data.writeTypedArray(apps, 0);
                    _data.writeTypedArray(wallpapers, 0);
                    _data.writeTypedObject(homeContentInsets, 0);
                    _data.writeTypedObject(minimizedHomeBounds, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTasksAppeared(RemoteAnimationTarget[] app) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(app, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRecentsAnimationRunner {
        @Override
        public void onAnimationCanceled(int[] taskIds, TaskSnapshot[] taskSnapshots) throws RemoteException {
        }

        @Override
        public void onAnimationStart(IRecentsAnimationController controller, RemoteAnimationTarget[] apps, RemoteAnimationTarget[] wallpapers, Rect homeContentInsets, Rect minimizedHomeBounds) throws RemoteException {
        }

        @Override
        public void onTasksAppeared(RemoteAnimationTarget[] app) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

