/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.ComponentName;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IPinnedTaskListener
extends IInterface {
    public static final String DESCRIPTOR = "android.view.IPinnedTaskListener";

    public void onMovementBoundsChanged(boolean var1) throws RemoteException;

    public void onImeVisibilityChanged(boolean var1, int var2) throws RemoteException;

    public void onActivityHidden(ComponentName var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPinnedTaskListener {
        static final int TRANSACTION_onMovementBoundsChanged = 1;
        static final int TRANSACTION_onImeVisibilityChanged = 2;
        static final int TRANSACTION_onActivityHidden = 3;

        public Stub() {
            this.attachInterface(this, IPinnedTaskListener.DESCRIPTOR);
        }

        public static IPinnedTaskListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IPinnedTaskListener.DESCRIPTOR);
            if (iin != null && iin instanceof IPinnedTaskListener) {
                return (IPinnedTaskListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onMovementBoundsChanged";
                }
                case 2: {
                    return "onImeVisibilityChanged";
                }
                case 3: {
                    return "onActivityHidden";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IPinnedTaskListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onMovementBoundsChanged(_arg0);
                    break;
                }
                case 2: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onImeVisibilityChanged(_arg0, _arg1);
                    break;
                }
                case 3: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.onActivityHidden(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IPinnedTaskListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IPinnedTaskListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMovementBoundsChanged(boolean fromImeAdjustment) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPinnedTaskListener.DESCRIPTOR);
                    _data.writeBoolean(fromImeAdjustment);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImeVisibilityChanged(boolean imeVisible, int imeHeight) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPinnedTaskListener.DESCRIPTOR);
                    _data.writeBoolean(imeVisible);
                    _data.writeInt(imeHeight);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivityHidden(ComponentName componentName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPinnedTaskListener.DESCRIPTOR);
                    _data.writeTypedObject(componentName, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPinnedTaskListener {
        @Override
        public void onMovementBoundsChanged(boolean fromImeAdjustment) throws RemoteException {
        }

        @Override
        public void onImeVisibilityChanged(boolean imeVisible, int imeHeight) throws RemoteException {
        }

        @Override
        public void onActivityHidden(ComponentName componentName) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

