/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.IInputFilterHost;
import android.view.InputEvent;

public interface IInputFilter
extends IInterface {
    public void install(IInputFilterHost var1) throws RemoteException;

    public void uninstall() throws RemoteException;

    public void filterInputEvent(InputEvent var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputFilter {
        public static final String DESCRIPTOR = "android.view.IInputFilter";
        static final int TRANSACTION_install = 1;
        static final int TRANSACTION_uninstall = 2;
        static final int TRANSACTION_filterInputEvent = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInputFilter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInputFilter) {
                return (IInputFilter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "install";
                }
                case 2: {
                    return "uninstall";
                }
                case 3: {
                    return "filterInputEvent";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IInputFilterHost _arg0 = IInputFilterHost.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.install(_arg0);
                    break;
                }
                case 2: {
                    this.uninstall();
                    break;
                }
                case 3: {
                    InputEvent _arg0 = data.readTypedObject(InputEvent.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.filterInputEvent(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IInputFilter {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void install(IInputFilterHost host) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(host);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void uninstall() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void filterInputEvent(InputEvent event, int policyFlags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    _data.writeInt(policyFlags);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputFilter {
        @Override
        public void install(IInputFilterHost host) throws RemoteException {
        }

        @Override
        public void uninstall() throws RemoteException {
        }

        @Override
        public void filterInputEvent(InputEvent event, int policyFlags) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

