/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class ContentRecordingSession
implements Parcelable {
    public static final int RECORD_CONTENT_DISPLAY = 0;
    public static final int RECORD_CONTENT_TASK = 1;
    private int mDisplayId = -1;
    private int mContentToRecord = 0;
    @VisibleForTesting
    private IBinder mTokenToRecord = null;
    public static final Parcelable.Creator<ContentRecordingSession> CREATOR = new Parcelable.Creator<ContentRecordingSession>(){

        public ContentRecordingSession[] newArray(int size) {
            return new ContentRecordingSession[size];
        }

        @Override
        public ContentRecordingSession createFromParcel(Parcel in) {
            return new ContentRecordingSession(in);
        }
    };

    private ContentRecordingSession() {
    }

    public static ContentRecordingSession createDisplaySession(IBinder displayContentWindowToken) {
        return new ContentRecordingSession().setContentToRecord(0).setTokenToRecord(displayContentWindowToken);
    }

    public static ContentRecordingSession createTaskSession(IBinder taskWindowContainerToken) {
        return new ContentRecordingSession().setContentToRecord(1).setTokenToRecord(taskWindowContainerToken);
    }

    public static boolean isValid(ContentRecordingSession session) {
        return session != null && session.getDisplayId() > -1 && session.getTokenToRecord() != null;
    }

    public static boolean isSameDisplay(ContentRecordingSession session, ContentRecordingSession incomingSession) {
        return session != null && incomingSession != null && session.getDisplayId() == incomingSession.getDisplayId();
    }

    public static String recordContentToString(int value) {
        switch (value) {
            case 0: {
                return "RECORD_CONTENT_DISPLAY";
            }
            case 1: {
                return "RECORD_CONTENT_TASK";
            }
        }
        return Integer.toHexString(value);
    }

    ContentRecordingSession(int displayId, int contentToRecord, @VisibleForTesting IBinder tokenToRecord) {
        this.mDisplayId = displayId;
        this.mContentToRecord = contentToRecord;
        if (this.mContentToRecord != 0 && this.mContentToRecord != 1) {
            throw new IllegalArgumentException("contentToRecord was " + this.mContentToRecord + " but must be one of: RECORD_CONTENT_DISPLAY(" + 0 + "), RECORD_CONTENT_TASK(" + 1 + ")");
        }
        this.mTokenToRecord = tokenToRecord;
        AnnotationValidations.validate(VisibleForTesting.class, null, (Object)this.mTokenToRecord);
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    public int getContentToRecord() {
        return this.mContentToRecord;
    }

    @VisibleForTesting
    public IBinder getTokenToRecord() {
        return this.mTokenToRecord;
    }

    public ContentRecordingSession setDisplayId(int value) {
        this.mDisplayId = value;
        return this;
    }

    public ContentRecordingSession setContentToRecord(int value) {
        this.mContentToRecord = value;
        if (this.mContentToRecord != 0 && this.mContentToRecord != 1) {
            throw new IllegalArgumentException("contentToRecord was " + this.mContentToRecord + " but must be one of: RECORD_CONTENT_DISPLAY(" + 0 + "), RECORD_CONTENT_TASK(" + 1 + ")");
        }
        return this;
    }

    public ContentRecordingSession setTokenToRecord(@VisibleForTesting IBinder value) {
        this.mTokenToRecord = value;
        AnnotationValidations.validate(VisibleForTesting.class, null, (Object)this.mTokenToRecord);
        return this;
    }

    public String toString() {
        return "ContentRecordingSession { displayId = " + this.mDisplayId + ", contentToRecord = " + ContentRecordingSession.recordContentToString(this.mContentToRecord) + ", tokenToRecord = " + this.mTokenToRecord + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentRecordingSession that = (ContentRecordingSession)o;
        return this.mDisplayId == that.mDisplayId && this.mContentToRecord == that.mContentToRecord && Objects.equals(this.mTokenToRecord, that.mTokenToRecord);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mDisplayId;
        _hash = 31 * _hash + this.mContentToRecord;
        _hash = 31 * _hash + Objects.hashCode(this.mTokenToRecord);
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mTokenToRecord != null) {
            flg = (byte)(flg | 4);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mDisplayId);
        dest.writeInt(this.mContentToRecord);
        if (this.mTokenToRecord != null) {
            dest.writeStrongBinder(this.mTokenToRecord);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    ContentRecordingSession(Parcel in) {
        byte flg = in.readByte();
        int displayId = in.readInt();
        int contentToRecord = in.readInt();
        IBinder tokenToRecord = (flg & 4) == 0 ? null : in.readStrongBinder();
        this.mDisplayId = displayId;
        this.mContentToRecord = contentToRecord;
        if (this.mContentToRecord != 0 && this.mContentToRecord != 1) {
            throw new IllegalArgumentException("contentToRecord was " + this.mContentToRecord + " but must be one of: RECORD_CONTENT_DISPLAY(" + 0 + "), RECORD_CONTENT_TASK(" + 1 + ")");
        }
        this.mTokenToRecord = tokenToRecord;
        AnnotationValidations.validate(VisibleForTesting.class, null, (Object)this.mTokenToRecord);
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        private int mDisplayId;
        private int mContentToRecord;
        @VisibleForTesting
        private IBinder mTokenToRecord;
        private long mBuilderFieldsSet = 0L;

        public Builder setDisplayId(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mDisplayId = value;
            return this;
        }

        public Builder setContentToRecord(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mContentToRecord = value;
            return this;
        }

        public Builder setTokenToRecord(@VisibleForTesting IBinder value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mTokenToRecord = value;
            return this;
        }

        public ContentRecordingSession build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mDisplayId = -1;
            }
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mContentToRecord = 0;
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mTokenToRecord = null;
            }
            ContentRecordingSession o = new ContentRecordingSession(this.mDisplayId, this.mContentToRecord, this.mTokenToRecord);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 8L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecordContent {
    }
}

