/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.uwb.RangingReport;
import android.uwb.SessionHandle;
import android.uwb.UwbAddress;

public interface IUwbRangingCallbacks
extends IInterface {
    public static final String DESCRIPTOR = "android.uwb.IUwbRangingCallbacks";

    public void onRangingOpened(SessionHandle var1) throws RemoteException;

    public void onRangingOpenFailed(SessionHandle var1, int var2, PersistableBundle var3) throws RemoteException;

    public void onRangingStarted(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void onRangingStartFailed(SessionHandle var1, int var2, PersistableBundle var3) throws RemoteException;

    public void onRangingReconfigured(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void onRangingReconfigureFailed(SessionHandle var1, int var2, PersistableBundle var3) throws RemoteException;

    public void onRangingStopped(SessionHandle var1, int var2, PersistableBundle var3) throws RemoteException;

    public void onRangingStopFailed(SessionHandle var1, int var2, PersistableBundle var3) throws RemoteException;

    public void onRangingClosed(SessionHandle var1, int var2, PersistableBundle var3) throws RemoteException;

    public void onRangingResult(SessionHandle var1, RangingReport var2) throws RemoteException;

    public void onControleeAdded(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void onControleeAddFailed(SessionHandle var1, int var2, PersistableBundle var3) throws RemoteException;

    public void onControleeRemoved(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void onControleeRemoveFailed(SessionHandle var1, int var2, PersistableBundle var3) throws RemoteException;

    public void onRangingPaused(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void onRangingPauseFailed(SessionHandle var1, int var2, PersistableBundle var3) throws RemoteException;

    public void onRangingResumed(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void onRangingResumeFailed(SessionHandle var1, int var2, PersistableBundle var3) throws RemoteException;

    public void onDataSent(SessionHandle var1, UwbAddress var2, PersistableBundle var3) throws RemoteException;

    public void onDataSendFailed(SessionHandle var1, UwbAddress var2, int var3, PersistableBundle var4) throws RemoteException;

    public void onDataReceived(SessionHandle var1, UwbAddress var2, PersistableBundle var3, byte[] var4) throws RemoteException;

    public void onDataReceiveFailed(SessionHandle var1, UwbAddress var2, int var3, PersistableBundle var4) throws RemoteException;

    public void onServiceDiscovered(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void onServiceConnected(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUwbRangingCallbacks {
        static final int TRANSACTION_onRangingOpened = 1;
        static final int TRANSACTION_onRangingOpenFailed = 2;
        static final int TRANSACTION_onRangingStarted = 3;
        static final int TRANSACTION_onRangingStartFailed = 4;
        static final int TRANSACTION_onRangingReconfigured = 5;
        static final int TRANSACTION_onRangingReconfigureFailed = 6;
        static final int TRANSACTION_onRangingStopped = 7;
        static final int TRANSACTION_onRangingStopFailed = 8;
        static final int TRANSACTION_onRangingClosed = 9;
        static final int TRANSACTION_onRangingResult = 10;
        static final int TRANSACTION_onControleeAdded = 11;
        static final int TRANSACTION_onControleeAddFailed = 12;
        static final int TRANSACTION_onControleeRemoved = 13;
        static final int TRANSACTION_onControleeRemoveFailed = 14;
        static final int TRANSACTION_onRangingPaused = 15;
        static final int TRANSACTION_onRangingPauseFailed = 16;
        static final int TRANSACTION_onRangingResumed = 17;
        static final int TRANSACTION_onRangingResumeFailed = 18;
        static final int TRANSACTION_onDataSent = 19;
        static final int TRANSACTION_onDataSendFailed = 20;
        static final int TRANSACTION_onDataReceived = 21;
        static final int TRANSACTION_onDataReceiveFailed = 22;
        static final int TRANSACTION_onServiceDiscovered = 23;
        static final int TRANSACTION_onServiceConnected = 24;

        public Stub() {
            this.attachInterface(this, IUwbRangingCallbacks.DESCRIPTOR);
        }

        public static IUwbRangingCallbacks asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IUwbRangingCallbacks.DESCRIPTOR);
            if (iin != null && iin instanceof IUwbRangingCallbacks) {
                return (IUwbRangingCallbacks)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IUwbRangingCallbacks.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRangingOpened(_arg0);
                    break;
                }
                case 2: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRangingOpenFailed(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRangingStarted(_arg0, _arg1);
                    break;
                }
                case 4: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRangingStartFailed(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRangingReconfigured(_arg0, _arg1);
                    break;
                }
                case 6: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRangingReconfigureFailed(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRangingStopped(_arg0, _arg1, _arg2);
                    break;
                }
                case 8: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRangingStopFailed(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRangingClosed(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    RangingReport _arg1 = data.readTypedObject(RangingReport.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRangingResult(_arg0, _arg1);
                    break;
                }
                case 11: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onControleeAdded(_arg0, _arg1);
                    break;
                }
                case 12: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onControleeAddFailed(_arg0, _arg1, _arg2);
                    break;
                }
                case 13: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onControleeRemoved(_arg0, _arg1);
                    break;
                }
                case 14: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onControleeRemoveFailed(_arg0, _arg1, _arg2);
                    break;
                }
                case 15: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRangingPaused(_arg0, _arg1);
                    break;
                }
                case 16: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRangingPauseFailed(_arg0, _arg1, _arg2);
                    break;
                }
                case 17: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRangingResumed(_arg0, _arg1);
                    break;
                }
                case 18: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    int _arg1 = data.readInt();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRangingResumeFailed(_arg0, _arg1, _arg2);
                    break;
                }
                case 19: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    UwbAddress _arg1 = data.readTypedObject(UwbAddress.CREATOR);
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDataSent(_arg0, _arg1, _arg2);
                    break;
                }
                case 20: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    UwbAddress _arg1 = data.readTypedObject(UwbAddress.CREATOR);
                    int _arg2 = data.readInt();
                    PersistableBundle _arg3 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDataSendFailed(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 21: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    UwbAddress _arg1 = data.readTypedObject(UwbAddress.CREATOR);
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onDataReceived(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 22: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    UwbAddress _arg1 = data.readTypedObject(UwbAddress.CREATOR);
                    int _arg2 = data.readInt();
                    PersistableBundle _arg3 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDataReceiveFailed(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 23: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onServiceDiscovered(_arg0, _arg1);
                    break;
                }
                case 24: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onServiceConnected(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IUwbRangingCallbacks {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IUwbRangingCallbacks.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingOpened(SessionHandle sessionHandle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingOpenFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeInt(reason);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingStarted(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingStartFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeInt(reason);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingReconfigured(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingReconfigureFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeInt(reason);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingStopped(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeInt(reason);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingStopFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeInt(reason);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingClosed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeInt(reason);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingResult(SessionHandle sessionHandle, RangingReport result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(result, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onControleeAdded(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onControleeAddFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeInt(reason);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onControleeRemoved(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onControleeRemoveFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeInt(reason);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingPaused(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingPauseFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeInt(reason);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingResumed(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingResumeFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeInt(reason);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDataSent(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(remoteDeviceAddress, 0);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDataSendFailed(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, int reason, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(remoteDeviceAddress, 0);
                    _data.writeInt(reason);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDataReceived(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, PersistableBundle parameters, byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(remoteDeviceAddress, 0);
                    _data.writeTypedObject(parameters, 0);
                    _data.writeByteArray(data);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDataReceiveFailed(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, int reason, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(remoteDeviceAddress, 0);
                    _data.writeInt(reason);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceDiscovered(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceConnected(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbRangingCallbacks.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(parameters, 0);
                    boolean bl = this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IUwbRangingCallbacks {
        @Override
        public void onRangingOpened(SessionHandle sessionHandle) throws RemoteException {
        }

        @Override
        public void onRangingOpenFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onRangingStarted(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onRangingStartFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onRangingReconfigured(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onRangingReconfigureFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onRangingStopped(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onRangingStopFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onRangingClosed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onRangingResult(SessionHandle sessionHandle, RangingReport result) throws RemoteException {
        }

        @Override
        public void onControleeAdded(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onControleeAddFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onControleeRemoved(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onControleeRemoveFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onRangingPaused(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onRangingPauseFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onRangingResumed(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onRangingResumeFailed(SessionHandle sessionHandle, int reason, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onDataSent(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onDataSendFailed(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, int reason, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onDataReceived(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, PersistableBundle parameters, byte[] data) throws RemoteException {
        }

        @Override
        public void onDataReceiveFailed(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, int reason, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onServiceDiscovered(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void onServiceConnected(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

