/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class AngleMeasurement
implements Parcelable {
    private final double mRadians;
    private final double mErrorRadians;
    private final double mConfidenceLevel;
    public static final Parcelable.Creator<AngleMeasurement> CREATOR = new Parcelable.Creator<AngleMeasurement>(){

        @Override
        public AngleMeasurement createFromParcel(Parcel in) {
            return new AngleMeasurement(in.readDouble(), in.readDouble(), in.readDouble());
        }

        public AngleMeasurement[] newArray(int size) {
            return new AngleMeasurement[size];
        }
    };

    public AngleMeasurement(double radians, double errorRadians, double confidenceLevel) {
        if (radians < -Math.PI || radians > Math.PI) {
            throw new IllegalArgumentException("Invalid radians: " + radians);
        }
        this.mRadians = radians;
        if (errorRadians < 0.0 || errorRadians > Math.PI) {
            throw new IllegalArgumentException("Invalid error radians: " + errorRadians);
        }
        this.mErrorRadians = errorRadians;
        if (confidenceLevel < 0.0 || confidenceLevel > 1.0) {
            throw new IllegalArgumentException("Invalid confidence level: " + confidenceLevel);
        }
        this.mConfidenceLevel = confidenceLevel;
    }

    public double getRadians() {
        return this.mRadians;
    }

    public double getErrorRadians() {
        return this.mErrorRadians;
    }

    public double getConfidenceLevel() {
        return this.mConfidenceLevel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AngleMeasurement) {
            AngleMeasurement other = (AngleMeasurement)obj;
            return this.mRadians == other.getRadians() && this.mErrorRadians == other.getErrorRadians() && this.mConfidenceLevel == other.getConfidenceLevel();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mRadians, this.mErrorRadians, this.mConfidenceLevel);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.mRadians);
        dest.writeDouble(this.mErrorRadians);
        dest.writeDouble(this.mConfidenceLevel);
    }

    public String toString() {
        return "AngleMeasurement[radians: " + this.mRadians + ", errorRadians: " + this.mErrorRadians + ", confidenceLevel: " + this.mConfidenceLevel + "]";
    }
}

