/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.IOException;
import java.util.UUID;
import libcore.io.IoUtils;

public class MemoryIntArray
implements Parcelable,
Closeable {
    private static final String TAG = "MemoryIntArray";
    private static final int MAX_SIZE = 1024;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final boolean mIsOwner;
    private final long mMemoryAddr;
    private int mFd = -1;
    public static final Parcelable.Creator<MemoryIntArray> CREATOR = new Parcelable.Creator<MemoryIntArray>(){

        @Override
        public MemoryIntArray createFromParcel(Parcel parcel) {
            try {
                return new MemoryIntArray(parcel);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Error unparceling MemoryIntArray");
            }
        }

        public MemoryIntArray[] newArray(int size) {
            return new MemoryIntArray[size];
        }
    };

    public MemoryIntArray(int size) throws IOException {
        if (size > 1024) {
            throw new IllegalArgumentException("Max size is 1024");
        }
        this.mIsOwner = true;
        String name = UUID.randomUUID().toString();
        this.mFd = this.nativeCreate(name, size);
        this.mMemoryAddr = this.nativeOpen(this.mFd, this.mIsOwner);
        this.mCloseGuard.open("MemoryIntArray.close");
    }

    private MemoryIntArray(Parcel parcel) throws IOException {
        this.mIsOwner = false;
        ParcelFileDescriptor pfd = parcel.readParcelable(null, ParcelFileDescriptor.class);
        if (pfd == null) {
            throw new IOException("No backing file descriptor");
        }
        this.mFd = pfd.detachFd();
        this.mMemoryAddr = this.nativeOpen(this.mFd, this.mIsOwner);
        this.mCloseGuard.open("MemoryIntArray.close");
    }

    public boolean isWritable() {
        this.enforceNotClosed();
        return this.mIsOwner;
    }

    public int get(int index) throws IOException {
        this.enforceNotClosed();
        this.enforceValidIndex(index);
        return this.nativeGet(this.mFd, this.mMemoryAddr, index);
    }

    public void set(int index, int value) throws IOException {
        this.enforceNotClosed();
        this.enforceWritable();
        this.enforceValidIndex(index);
        this.nativeSet(this.mFd, this.mMemoryAddr, index, value);
    }

    public int size() throws IOException {
        this.enforceNotClosed();
        return this.nativeSize(this.mFd);
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed()) {
            this.nativeClose(this.mFd, this.mMemoryAddr, this.mIsOwner);
            this.mFd = -1;
            this.mCloseGuard.close();
        }
    }

    public boolean isClosed() {
        return this.mFd == -1;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            IoUtils.closeQuietly(this);
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public int describeContents() {
        return 1;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.fromFd(this.mFd);){
            parcel.writeParcelable(pfd, flags);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryIntArray other = (MemoryIntArray)obj;
        return this.mFd == other.mFd;
    }

    public int hashCode() {
        return this.mFd;
    }

    private void enforceNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("cannot interact with a closed instance");
        }
    }

    private void enforceValidIndex(int index) throws IOException {
        int size = this.size();
        if (index < 0 || index > size - 1) {
            throw new IndexOutOfBoundsException(index + " not between 0 and " + (size - 1));
        }
    }

    private void enforceWritable() {
        if (!this.isWritable()) {
            throw new UnsupportedOperationException("array is not writable");
        }
    }

    private int nativeCreate(String string2, int n) {
        return OverrideMethod.invokeI("android.util.MemoryIntArray#nativeCreate(Ljava/lang/String;I)I", true, this);
    }

    private long nativeOpen(int n, boolean bl) {
        return OverrideMethod.invokeL("android.util.MemoryIntArray#nativeOpen(IZ)J", true, this);
    }

    private void nativeClose(int n, long l, boolean bl) {
        OverrideMethod.invokeV("android.util.MemoryIntArray#nativeClose(IJZ)V", true, this);
    }

    private int nativeGet(int n, long l, int n2) {
        return OverrideMethod.invokeI("android.util.MemoryIntArray#nativeGet(IJI)I", true, this);
    }

    private void nativeSet(int n, long l, int n2, int n3) {
        OverrideMethod.invokeV("android.util.MemoryIntArray#nativeSet(IJII)V", true, this);
    }

    private int nativeSize(int n) {
        return OverrideMethod.invokeI("android.util.MemoryIntArray#nativeSize(I)I", true, this);
    }

    public static int getMaxSize() {
        return 1024;
    }
}

