/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.icu.util.Calendar;
import android.icu.util.GregorianCalendar;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.lang.System_Delegate;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class DateUtilsBridge {
    public static TimeZone icuTimeZone(java.util.TimeZone tz) {
        TimeZone icuTimeZone = TimeZone.getTimeZone(tz.getID());
        icuTimeZone.freeze();
        return icuTimeZone;
    }

    public static Calendar createIcuCalendar(TimeZone icuTimeZone, ULocale icuLocale, long timeInMillis) {
        GregorianCalendar calendar = new GregorianCalendar(icuTimeZone, icuLocale);
        calendar.setTimeInMillis(timeInMillis);
        return calendar;
    }

    public static String toSkeleton(Calendar calendar, int flags) {
        return DateUtilsBridge.toSkeleton(calendar, calendar, flags);
    }

    public static String toSkeleton(Calendar startCalendar, Calendar endCalendar, int flags) {
        if ((flags & 0x80000) != 0) {
            flags |= 0x1C000;
        }
        String monthPart = "MMMM";
        if ((flags & 0x20000) != 0) {
            monthPart = "M";
        } else if ((flags & 0x10000) != 0) {
            monthPart = "MMM";
        }
        String weekPart = "EEEE";
        if ((flags & 0x8000) != 0) {
            weekPart = "EEE";
        }
        String timePart = "j";
        if ((flags & 0x80) != 0) {
            timePart = "H";
        } else if ((flags & 0x40) != 0) {
            timePart = "h";
        }
        if ((flags & 0x4000) == 0 || (flags & 0x80) != 0) {
            timePart = timePart + "m";
        } else if (!DateUtilsBridge.onTheHour(startCalendar) || !DateUtilsBridge.onTheHour(endCalendar)) {
            timePart = timePart + "m";
        }
        if (DateUtilsBridge.fallOnDifferentDates(startCalendar, endCalendar)) {
            flags |= 0x10;
        }
        if (DateUtilsBridge.fallInSameMonth(startCalendar, endCalendar) && (flags & 0x20) != 0) {
            flags &= 0xFFFFFFFD;
            flags &= 0xFFFFFFFE;
        }
        if ((flags & 0x13) == 0) {
            flags |= 0x10;
        }
        if (!((flags & 0x10) == 0 || (flags & 4) != 0 || (flags & 8) != 0 || DateUtilsBridge.fallInSameYear(startCalendar, endCalendar) && DateUtilsBridge.isThisYear(startCalendar))) {
            flags |= 4;
        }
        StringBuilder builder = new StringBuilder();
        if ((flags & 0x30) != 0) {
            if ((flags & 4) != 0) {
                builder.append("y");
            }
            builder.append(monthPart);
            if ((flags & 0x20) == 0) {
                builder.append("d");
            }
        }
        if ((flags & 2) != 0) {
            builder.append(weekPart);
        }
        if ((flags & 1) != 0) {
            builder.append(timePart);
        }
        return builder.toString();
    }

    public static int dayDistance(Calendar c1, Calendar c2) {
        return c2.get(20) - c1.get(20);
    }

    public static boolean isDisplayMidnightUsingSkeleton(Calendar c) {
        return c.get(11) == 0 && c.get(12) == 0;
    }

    private static boolean onTheHour(Calendar c) {
        return c.get(12) == 0 && c.get(13) == 0;
    }

    private static boolean fallOnDifferentDates(Calendar c1, Calendar c2) {
        return c1.get(1) != c2.get(1) || c1.get(2) != c2.get(2) || c1.get(5) != c2.get(5);
    }

    private static boolean fallInSameMonth(Calendar c1, Calendar c2) {
        return c1.get(2) == c2.get(2);
    }

    private static boolean fallInSameYear(Calendar c1, Calendar c2) {
        return c1.get(1) == c2.get(1);
    }

    private static boolean isThisYear(Calendar c) {
        Calendar now = (Calendar)c.clone();
        now.setTimeInMillis(System_Delegate.currentTimeMillis());
        return c.get(1) == now.get(1);
    }
}

