/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.compat.annotation.UnsupportedAppUsage;
import android.text.Editable;
import android.text.Layout;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextWatcher;

public class Selection {
    private static final Object SELECTION_MEMORY = new MEMORY();
    public static final Object SELECTION_START = new START();
    public static final Object SELECTION_END = new END();

    private Selection() {
    }

    public static int getSelectionStart(CharSequence text) {
        if (text instanceof Spanned) {
            return ((Spanned)text).getSpanStart(SELECTION_START);
        }
        return -1;
    }

    public static int getSelectionEnd(CharSequence text) {
        if (text instanceof Spanned) {
            return ((Spanned)text).getSpanStart(SELECTION_END);
        }
        return -1;
    }

    private static int getSelectionMemory(CharSequence text) {
        if (text instanceof Spanned) {
            return ((Spanned)text).getSpanStart(SELECTION_MEMORY);
        }
        return -1;
    }

    public static void setSelection(Spannable text, int start, int stop) {
        Selection.setSelection(text, start, stop, -1);
    }

    private static void setSelection(Spannable text, int start, int stop, int memory) {
        int ostart = Selection.getSelectionStart(text);
        int oend = Selection.getSelectionEnd(text);
        if (ostart != start || oend != stop) {
            text.setSpan(SELECTION_START, start, start, 546);
            text.setSpan(SELECTION_END, stop, stop, 34);
            Selection.updateMemory(text, memory);
        }
    }

    private static void updateMemory(Spannable text, int memory) {
        if (memory > -1) {
            int currentMemory = Selection.getSelectionMemory(text);
            if (memory != currentMemory) {
                text.setSpan(SELECTION_MEMORY, memory, memory, 34);
                if (currentMemory == -1) {
                    MemoryTextWatcher watcher = new MemoryTextWatcher();
                    text.setSpan(watcher, 0, text.length(), 18);
                }
            }
        } else {
            Selection.removeMemory(text);
        }
    }

    private static void removeMemory(Spannable text) {
        MemoryTextWatcher[] watchers;
        text.removeSpan(SELECTION_MEMORY);
        for (MemoryTextWatcher watcher : watchers = text.getSpans(0, text.length(), MemoryTextWatcher.class)) {
            text.removeSpan(watcher);
        }
    }

    public static void setSelection(Spannable text, int index) {
        Selection.setSelection(text, index, index);
    }

    public static void selectAll(Spannable text) {
        Selection.setSelection(text, 0, text.length());
    }

    public static void extendSelection(Spannable text, int index) {
        Selection.extendSelection(text, index, -1);
    }

    private static void extendSelection(Spannable text, int index, int memory) {
        if (text.getSpanStart(SELECTION_END) != index) {
            text.setSpan(SELECTION_END, index, index, 34);
        }
        Selection.updateMemory(text, memory);
    }

    public static void removeSelection(Spannable text) {
        text.removeSpan(SELECTION_START, 512);
        text.removeSpan(SELECTION_END);
        Selection.removeMemory(text);
    }

    public static boolean moveUp(Spannable text, Layout layout2) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            int min = Math.min(start, end);
            int max = Math.max(start, end);
            Selection.setSelection(text, min);
            return min != 0 || max != text.length();
        }
        int line = layout2.getLineForOffset(end);
        if (line > 0) {
            Selection.setSelectionAndMemory(text, layout2, line, end, -1, false);
            return true;
        }
        if (end != 0) {
            Selection.setSelection(text, 0);
            return true;
        }
        return false;
    }

    private static void setSelectionAndMemory(Spannable text, Layout layout2, int line, int end, int direction, boolean extend) {
        int newMemory;
        int move;
        if (layout2.getParagraphDirection(line) == layout2.getParagraphDirection(line + direction)) {
            int memory = Selection.getSelectionMemory(text);
            if (memory > -1) {
                float h = layout2.getPrimaryHorizontal(memory);
                move = layout2.getOffsetForHorizontal(line + direction, h);
                newMemory = memory;
            } else {
                float h = layout2.getPrimaryHorizontal(end);
                move = layout2.getOffsetForHorizontal(line + direction, h);
                newMemory = end;
            }
        } else {
            move = layout2.getLineStart(line + direction);
            newMemory = -1;
        }
        if (extend) {
            Selection.extendSelection(text, move, newMemory);
        } else {
            Selection.setSelection(text, move, move, newMemory);
        }
    }

    public static boolean moveDown(Spannable text, Layout layout2) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            int min = Math.min(start, end);
            int max = Math.max(start, end);
            Selection.setSelection(text, max);
            return min != 0 || max != text.length();
        }
        int line = layout2.getLineForOffset(end);
        if (line < layout2.getLineCount() - 1) {
            Selection.setSelectionAndMemory(text, layout2, line, end, 1, false);
            return true;
        }
        if (end != text.length()) {
            Selection.setSelection(text, text.length());
            return true;
        }
        return false;
    }

    public static boolean moveLeft(Spannable text, Layout layout2) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            Selection.setSelection(text, Selection.chooseHorizontal(layout2, -1, start, end));
            return true;
        }
        int to = layout2.getOffsetToLeftOf(end);
        if (to != end) {
            Selection.setSelection(text, to);
            return true;
        }
        return false;
    }

    public static boolean moveRight(Spannable text, Layout layout2) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            Selection.setSelection(text, Selection.chooseHorizontal(layout2, 1, start, end));
            return true;
        }
        int to = layout2.getOffsetToRightOf(end);
        if (to != end) {
            Selection.setSelection(text, to);
            return true;
        }
        return false;
    }

    public static boolean extendUp(Spannable text, Layout layout2) {
        int end = Selection.getSelectionEnd(text);
        int line = layout2.getLineForOffset(end);
        if (line > 0) {
            Selection.setSelectionAndMemory(text, layout2, line, end, -1, true);
            return true;
        }
        if (end != 0) {
            Selection.extendSelection(text, 0);
            return true;
        }
        return true;
    }

    public static boolean extendDown(Spannable text, Layout layout2) {
        int end = Selection.getSelectionEnd(text);
        int line = layout2.getLineForOffset(end);
        if (line < layout2.getLineCount() - 1) {
            Selection.setSelectionAndMemory(text, layout2, line, end, 1, true);
            return true;
        }
        if (end != text.length()) {
            Selection.extendSelection(text, text.length(), -1);
            return true;
        }
        return true;
    }

    public static boolean extendLeft(Spannable text, Layout layout2) {
        int end = Selection.getSelectionEnd(text);
        int to = layout2.getOffsetToLeftOf(end);
        if (to != end) {
            Selection.extendSelection(text, to);
            return true;
        }
        return true;
    }

    public static boolean extendRight(Spannable text, Layout layout2) {
        int end = Selection.getSelectionEnd(text);
        int to = layout2.getOffsetToRightOf(end);
        if (to != end) {
            Selection.extendSelection(text, to);
            return true;
        }
        return true;
    }

    public static boolean extendToLeftEdge(Spannable text, Layout layout2) {
        int where = Selection.findEdge(text, layout2, -1);
        Selection.extendSelection(text, where);
        return true;
    }

    public static boolean extendToRightEdge(Spannable text, Layout layout2) {
        int where = Selection.findEdge(text, layout2, 1);
        Selection.extendSelection(text, where);
        return true;
    }

    public static boolean moveToLeftEdge(Spannable text, Layout layout2) {
        int where = Selection.findEdge(text, layout2, -1);
        Selection.setSelection(text, where);
        return true;
    }

    public static boolean moveToRightEdge(Spannable text, Layout layout2) {
        int where = Selection.findEdge(text, layout2, 1);
        Selection.setSelection(text, where);
        return true;
    }

    @UnsupportedAppUsage
    public static boolean moveToPreceding(Spannable text, PositionIterator iter, boolean extendSelection) {
        int offset = iter.preceding(Selection.getSelectionEnd(text));
        if (offset != -1) {
            if (extendSelection) {
                Selection.extendSelection(text, offset);
            } else {
                Selection.setSelection(text, offset);
            }
        }
        return true;
    }

    @UnsupportedAppUsage
    public static boolean moveToFollowing(Spannable text, PositionIterator iter, boolean extendSelection) {
        int offset = iter.following(Selection.getSelectionEnd(text));
        if (offset != -1) {
            if (extendSelection) {
                Selection.extendSelection(text, offset);
            } else {
                Selection.setSelection(text, offset);
            }
        }
        return true;
    }

    private static int findEdge(Spannable text, Layout layout2, int dir) {
        int pt = Selection.getSelectionEnd(text);
        int line = layout2.getLineForOffset(pt);
        int pdir = layout2.getParagraphDirection(line);
        if (dir * pdir < 0) {
            return layout2.getLineStart(line);
        }
        int end = layout2.getLineEnd(line);
        if (line == layout2.getLineCount() - 1) {
            return end;
        }
        return end - 1;
    }

    private static int chooseHorizontal(Layout layout2, int direction, int off1, int off2) {
        int line2;
        int line1 = layout2.getLineForOffset(off1);
        if (line1 == (line2 = layout2.getLineForOffset(off2))) {
            float h1 = layout2.getPrimaryHorizontal(off1);
            float h2 = layout2.getPrimaryHorizontal(off2);
            if (direction < 0) {
                if (h1 < h2) {
                    return off1;
                }
                return off2;
            }
            if (h1 > h2) {
                return off1;
            }
            return off2;
        }
        int line = layout2.getLineForOffset(off1);
        int textdir = layout2.getParagraphDirection(line);
        if (textdir == direction) {
            return Math.max(off1, off2);
        }
        return Math.min(off1, off2);
    }

    private static class MEMORY
    implements NoCopySpan {
        private MEMORY() {
        }
    }

    private static class END
    implements NoCopySpan {
        private END() {
        }
    }

    private static class START
    implements NoCopySpan {
        private START() {
        }
    }

    public static interface PositionIterator {
        public static final int DONE = -1;

        public int preceding(int var1);

        public int following(int var1);
    }

    public static class MemoryTextWatcher
    implements TextWatcher {
        @Override
        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        @Override
        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        @Override
        public void afterTextChanged(Editable s) {
            s.removeSpan(SELECTION_MEMORY);
            s.removeSpan(this);
        }
    }
}

