/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.stub;

import android.annotation.SystemApi;
import android.content.Context;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.telephony.ims.RcsClientConfiguration;
import android.telephony.ims.RcsConfig;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsConfigCallback;
import android.telephony.ims.aidl.IRcsConfigCallback;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.util.RemoteCallbackListExt;
import com.android.internal.telephony.util.TelephonyUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

@SystemApi
public class ImsConfigImplBase {
    private static final String TAG = "ImsConfigImplBase";
    public static final int CONFIG_RESULT_UNKNOWN = -1;
    public static final int CONFIG_RESULT_SUCCESS = 0;
    public static final int CONFIG_RESULT_FAILED = 1;
    private final RemoteCallbackListExt<IImsConfigCallback> mCallbacks = new RemoteCallbackListExt();
    private final RemoteCallbackListExt<IRcsConfigCallback> mRcsCallbacks = new RemoteCallbackListExt();
    private byte[] mRcsConfigData;
    ImsConfigStub mImsConfigStub;

    public ImsConfigImplBase(Executor executor) {
        this.mImsConfigStub = new ImsConfigStub(this, executor);
    }

    public ImsConfigImplBase(Context context) {
        this.mImsConfigStub = new ImsConfigStub(this, null);
    }

    public ImsConfigImplBase() {
        this.mImsConfigStub = new ImsConfigStub(this, null);
    }

    private void addImsConfigCallback(IImsConfigCallback c) {
        this.mCallbacks.register(c);
    }

    private void removeImsConfigCallback(IImsConfigCallback c) {
        this.mCallbacks.unregister(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConfigChanged(int item, int value) {
        if (this.mCallbacks == null) {
            return;
        }
        RemoteCallbackListExt<IImsConfigCallback> remoteCallbackListExt = this.mCallbacks;
        synchronized (remoteCallbackListExt) {
            this.mCallbacks.broadcastAction(c -> {
                try {
                    c.onIntConfigChanged(item, value);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "notifyConfigChanged(int): dead binder in notify, skipping.");
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConfigChanged(int item, String value) {
        if (this.mCallbacks == null) {
            return;
        }
        RemoteCallbackListExt<IImsConfigCallback> remoteCallbackListExt = this.mCallbacks;
        synchronized (remoteCallbackListExt) {
            this.mCallbacks.broadcastAction(c -> {
                try {
                    c.onStringConfigChanged(item, value);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "notifyConfigChanged(string): dead binder in notify, skipping.");
                }
            });
        }
    }

    private void addRcsConfigCallback(IRcsConfigCallback c) {
        this.mRcsCallbacks.register(c);
        if (this.mRcsConfigData != null) {
            try {
                c.onConfigurationChanged(this.mRcsConfigData);
            }
            catch (RemoteException e) {
                Log.w(TAG, "dead binder to call onConfigurationChanged, skipping.");
            }
        }
    }

    private void removeRcsConfigCallback(IRcsConfigCallback c) {
        this.mRcsCallbacks.unregister(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNotifyRcsAutoConfigurationReceived(byte[] config, boolean isCompressed) {
        byte[] byArray = config = isCompressed ? RcsConfig.decompressGzip(config) : config;
        if (Arrays.equals(this.mRcsConfigData, config)) {
            return;
        }
        this.mRcsConfigData = config;
        if (this.mRcsCallbacks != null) {
            RemoteCallbackListExt<IRcsConfigCallback> remoteCallbackListExt = this.mRcsCallbacks;
            synchronized (remoteCallbackListExt) {
                this.mRcsCallbacks.broadcastAction(c -> {
                    try {
                        c.onConfigurationChanged(this.mRcsConfigData);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "dead binder in notifyRcsAutoConfigurationReceived, skipping.");
                    }
                });
            }
        }
        this.notifyRcsAutoConfigurationReceived(config, isCompressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNotifyRcsAutoConfigurationRemoved() {
        this.mRcsConfigData = null;
        if (this.mRcsCallbacks != null) {
            RemoteCallbackListExt<IRcsConfigCallback> remoteCallbackListExt = this.mRcsCallbacks;
            synchronized (remoteCallbackListExt) {
                this.mRcsCallbacks.broadcastAction(c -> {
                    try {
                        c.onConfigurationReset();
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "dead binder in notifyRcsAutoConfigurationRemoved, skipping.");
                    }
                });
            }
        }
        this.notifyRcsAutoConfigurationRemoved();
    }

    public IImsConfig getIImsConfig() {
        return this.mImsConfigStub;
    }

    public void notifyProvisionedValueChanged(int item, int value) {
        this.mImsConfigStub.updateCachedValue(item, value);
        try {
            this.mImsConfigStub.notifyImsConfigChanged(item, value);
        }
        catch (RemoteException e) {
            Log.w(TAG, "notifyProvisionedValueChanged(int): Framework connection is dead.");
        }
    }

    public void notifyProvisionedValueChanged(int item, String value) {
        this.mImsConfigStub.updateCachedValue(item, value);
        try {
            this.mImsConfigStub.notifyImsConfigChanged(item, value);
        }
        catch (RemoteException e) {
            Log.w(TAG, "notifyProvisionedValueChanged(string): Framework connection is dead.");
        }
    }

    public void notifyRcsAutoConfigurationReceived(byte[] config, boolean isCompressed) {
    }

    public void notifyRcsAutoConfigurationRemoved() {
    }

    public int setConfig(int item, int value) {
        return 1;
    }

    public int setConfig(int item, String value) {
        return 1;
    }

    public int getConfigInt(int item) {
        return -1;
    }

    public String getConfigString(int item) {
        return null;
    }

    public void updateImsCarrierConfigs(PersistableBundle bundle) {
    }

    public void setRcsClientConfiguration(RcsClientConfiguration rcc) {
    }

    public void triggerAutoConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAutoConfigurationErrorReceived(int errorCode, String errorString) {
        if (this.mRcsCallbacks == null) {
            return;
        }
        RemoteCallbackListExt<IRcsConfigCallback> remoteCallbackListExt = this.mRcsCallbacks;
        synchronized (remoteCallbackListExt) {
            this.mRcsCallbacks.broadcastAction(c -> {
                try {
                    c.onAutoConfigurationErrorReceived(errorCode, errorString);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "dead binder in notifyAutoConfigurationErrorReceived, skipping.");
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPreProvisioningReceived(byte[] configXml) {
        if (this.mRcsCallbacks == null) {
            return;
        }
        RemoteCallbackListExt<IRcsConfigCallback> remoteCallbackListExt = this.mRcsCallbacks;
        synchronized (remoteCallbackListExt) {
            this.mRcsCallbacks.broadcastAction(c -> {
                try {
                    c.onPreProvisioningReceived(configXml);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "dead binder in notifyPreProvisioningReceived, skipping.");
                }
            });
        }
    }

    public void setDefaultExecutor(Executor executor) {
        if (this.mImsConfigStub.mExecutor == null) {
            this.mImsConfigStub.mExecutor = executor;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetConfigResult {
    }

    @VisibleForTesting
    public static class ImsConfigStub
    extends IImsConfig.Stub {
        WeakReference<ImsConfigImplBase> mImsConfigImplBaseWeakReference;
        private HashMap<Integer, Integer> mProvisionedIntValue = new HashMap();
        private HashMap<Integer, String> mProvisionedStringValue = new HashMap();
        private final Object mLock = new Object();
        private Executor mExecutor;

        @VisibleForTesting
        public ImsConfigStub(ImsConfigImplBase imsConfigImplBase, Executor executor) {
            this.mExecutor = executor;
            this.mImsConfigImplBaseWeakReference = new WeakReference<ImsConfigImplBase>(imsConfigImplBase);
        }

        @Override
        public void addImsConfigCallback(IImsConfigCallback c) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            this.executeMethodAsync(() -> {
                try {
                    this.getImsConfigImpl().addImsConfigCallback(c);
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                }
            }, "addImsConfigCallback");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception addImsConfigCallback");
                throw (RemoteException)exceptionRef.get();
            }
        }

        @Override
        public void removeImsConfigCallback(IImsConfigCallback c) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            this.executeMethodAsync(() -> {
                try {
                    this.getImsConfigImpl().removeImsConfigCallback(c);
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                }
            }, "removeImsConfigCallback");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception removeImsConfigCallback");
                throw (RemoteException)exceptionRef.get();
            }
        }

        @Override
        public int getConfigInt(int item) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            int retVal = this.executeMethodAsyncForResult(() -> {
                int returnVal = -1;
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mProvisionedIntValue.containsKey(item)) {
                        return this.mProvisionedIntValue.get(item);
                    }
                    try {
                        returnVal = this.getImsConfigImpl().getConfigInt(item);
                        if (returnVal != -1) {
                            this.mProvisionedIntValue.put(item, returnVal);
                        }
                    }
                    catch (RemoteException e) {
                        exceptionRef.set(e);
                        return returnVal;
                    }
                }
                return returnVal;
            }, "getConfigInt");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception getConfigString");
                throw (RemoteException)exceptionRef.get();
            }
            return retVal;
        }

        @Override
        public String getConfigString(int item) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            String retVal = this.executeMethodAsyncForResult(() -> {
                String returnVal = null;
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mProvisionedStringValue.containsKey(item)) {
                        returnVal = this.mProvisionedStringValue.get(item);
                    } else {
                        try {
                            returnVal = this.getImsConfigImpl().getConfigString(item);
                            if (returnVal != null) {
                                this.mProvisionedStringValue.put(item, returnVal);
                            }
                        }
                        catch (RemoteException e) {
                            exceptionRef.set(e);
                            return returnVal;
                        }
                    }
                }
                return returnVal;
            }, "getConfigString");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception getConfigString");
                throw (RemoteException)exceptionRef.get();
            }
            return retVal;
        }

        @Override
        public int setConfigInt(int item, int value) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            int retVal = this.executeMethodAsyncForResult(() -> {
                int returnVal = -1;
                try {
                    Object object = this.mLock;
                    synchronized (object) {
                        this.mProvisionedIntValue.remove(item);
                        returnVal = this.getImsConfigImpl().setConfig(item, value);
                        if (returnVal == 0) {
                            this.mProvisionedIntValue.put(item, value);
                        } else {
                            Log.d(ImsConfigImplBase.TAG, "Set provision value of " + item + " to " + value + " failed with error code " + returnVal);
                        }
                    }
                    this.notifyImsConfigChanged(item, value);
                    return returnVal;
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                    return returnVal;
                }
            }, "setConfigInt");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception setConfigInt");
                throw (RemoteException)exceptionRef.get();
            }
            return retVal;
        }

        @Override
        public int setConfigString(int item, String value) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            int retVal = this.executeMethodAsyncForResult(() -> {
                int returnVal = -1;
                try {
                    Object object = this.mLock;
                    synchronized (object) {
                        this.mProvisionedStringValue.remove(item);
                        returnVal = this.getImsConfigImpl().setConfig(item, value);
                        if (returnVal == 0) {
                            this.mProvisionedStringValue.put(item, value);
                        }
                    }
                    this.notifyImsConfigChanged(item, value);
                    return returnVal;
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                    return returnVal;
                }
            }, "setConfigString");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception setConfigInt");
                throw (RemoteException)exceptionRef.get();
            }
            return retVal;
        }

        @Override
        public void updateImsCarrierConfigs(PersistableBundle bundle) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            this.executeMethodAsync(() -> {
                try {
                    this.getImsConfigImpl().updateImsCarrierConfigs(bundle);
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                }
            }, "updateImsCarrierConfigs");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception updateImsCarrierConfigs");
                throw (RemoteException)exceptionRef.get();
            }
        }

        private ImsConfigImplBase getImsConfigImpl() throws RemoteException {
            ImsConfigImplBase ref = (ImsConfigImplBase)this.mImsConfigImplBaseWeakReference.get();
            if (ref == null) {
                throw new RemoteException("Fail to get ImsConfigImpl");
            }
            return ref;
        }

        @Override
        public void notifyRcsAutoConfigurationReceived(byte[] config, boolean isCompressed) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            this.executeMethodAsync(() -> {
                try {
                    this.getImsConfigImpl().onNotifyRcsAutoConfigurationReceived(config, isCompressed);
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                }
            }, "notifyRcsAutoConfigurationReceived");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception notifyRcsAutoConfigurationReceived");
                throw (RemoteException)exceptionRef.get();
            }
        }

        @Override
        public void notifyRcsAutoConfigurationRemoved() throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            this.executeMethodAsync(() -> {
                try {
                    this.getImsConfigImpl().onNotifyRcsAutoConfigurationRemoved();
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                }
            }, "notifyRcsAutoConfigurationRemoved");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception notifyRcsAutoConfigurationRemoved");
                throw (RemoteException)exceptionRef.get();
            }
        }

        private void notifyImsConfigChanged(int item, int value) throws RemoteException {
            this.getImsConfigImpl().notifyConfigChanged(item, value);
        }

        private void notifyImsConfigChanged(int item, String value) throws RemoteException {
            this.getImsConfigImpl().notifyConfigChanged(item, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateCachedValue(int item, int value) {
            Object object = this.mLock;
            synchronized (object) {
                this.mProvisionedIntValue.put(item, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateCachedValue(int item, String value) {
            Object object = this.mLock;
            synchronized (object) {
                this.mProvisionedStringValue.put(item, value);
            }
        }

        @Override
        public void addRcsConfigCallback(IRcsConfigCallback c) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            this.executeMethodAsync(() -> {
                try {
                    this.getImsConfigImpl().addRcsConfigCallback(c);
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                }
            }, "addRcsConfigCallback");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception addRcsConfigCallback");
                throw (RemoteException)exceptionRef.get();
            }
        }

        @Override
        public void removeRcsConfigCallback(IRcsConfigCallback c) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            this.executeMethodAsync(() -> {
                try {
                    this.getImsConfigImpl().removeRcsConfigCallback(c);
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                }
            }, "removeRcsConfigCallback");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception removeRcsConfigCallback");
                throw (RemoteException)exceptionRef.get();
            }
        }

        @Override
        public void triggerRcsReconfiguration() throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            this.executeMethodAsync(() -> {
                try {
                    this.getImsConfigImpl().triggerAutoConfiguration();
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                }
            }, "triggerRcsReconfiguration");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception triggerRcsReconfiguration");
                throw (RemoteException)exceptionRef.get();
            }
        }

        @Override
        public void setRcsClientConfiguration(RcsClientConfiguration rcc) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            this.executeMethodAsync(() -> {
                try {
                    this.getImsConfigImpl().setRcsClientConfiguration(rcc);
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                }
            }, "setRcsClientConfiguration");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception setRcsClientConfiguration");
                throw (RemoteException)exceptionRef.get();
            }
        }

        @Override
        public void notifyIntImsConfigChanged(int item, int value) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            this.executeMethodAsync(() -> {
                try {
                    this.notifyImsConfigChanged(item, value);
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                }
            }, "notifyIntImsConfigChanged");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception notifyIntImsConfigChanged");
                throw (RemoteException)exceptionRef.get();
            }
        }

        @Override
        public void notifyStringImsConfigChanged(int item, String value) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            this.executeMethodAsync(() -> {
                try {
                    this.notifyImsConfigChanged(item, value);
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                }
            }, "notifyStringImsConfigChanged");
            if (exceptionRef.get() != null) {
                Log.d(ImsConfigImplBase.TAG, "ImsConfigImplBase Exception notifyStringImsConfigChanged");
                throw (RemoteException)exceptionRef.get();
            }
        }

        private void executeMethodAsync(Runnable r, String errorLogName) throws RemoteException {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(ImsConfigImplBase.TAG, "ImsConfigImplBase Binder - " + errorLogName + " exception: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }

        private <T> T executeMethodAsyncForResult(Supplier<T> r, String errorLogName) throws RemoteException {
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), this.mExecutor);
            try {
                return (T)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.w(ImsConfigImplBase.TAG, "ImsConfigImplBase Binder - " + errorLogName + " exception: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }
    }
}

