/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.ims.DelegateRegistrationState;
import android.telephony.ims.FeatureTagState;
import android.telephony.ims.SipDelegateConfiguration;
import android.telephony.ims.SipDelegateConnection;
import android.telephony.ims.SipDelegateImsConfiguration;
import android.telephony.ims.SipMessage;
import android.telephony.ims.aidl.ISipDelegate;
import android.telephony.ims.aidl.ISipDelegateConnectionStateCallback;
import android.telephony.ims.aidl.ISipDelegateMessageCallback;
import android.telephony.ims.stub.DelegateConnectionMessageCallback;
import android.telephony.ims.stub.DelegateConnectionStateCallback;
import android.util.ArraySet;
import android.util.Log;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public class SipDelegateConnectionAidlWrapper
implements SipDelegateConnection,
IBinder.DeathRecipient {
    private static final String LOG_TAG = "SipDelegateCAW";
    private final ISipDelegateConnectionStateCallback.Stub mStateBinder = new ISipDelegateConnectionStateCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCreated(ISipDelegate c) {
            SipDelegateConnectionAidlWrapper.this.associateSipDelegate(c);
            long token = Binder.clearCallingIdentity();
            try {
                SipDelegateConnectionAidlWrapper.this.mExecutor.execute(() -> SipDelegateConnectionAidlWrapper.this.mStateCallback.onCreated(SipDelegateConnectionAidlWrapper.this));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFeatureTagStatusChanged(DelegateRegistrationState registrationState, List<FeatureTagState> deniedFeatureTags) {
            long token = Binder.clearCallingIdentity();
            try {
                SipDelegateConnectionAidlWrapper.this.mExecutor.execute(() -> SipDelegateConnectionAidlWrapper.this.mStateCallback.onFeatureTagStatusChanged(registrationState, new ArraySet<FeatureTagState>(deniedFeatureTags)));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onImsConfigurationChanged(SipDelegateImsConfiguration registeredSipConfig) {
            long token = Binder.clearCallingIdentity();
            try {
                SipDelegateConnectionAidlWrapper.this.mExecutor.execute(() -> SipDelegateConnectionAidlWrapper.this.mStateCallback.onImsConfigurationChanged(registeredSipConfig));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConfigurationChanged(SipDelegateConfiguration registeredSipConfig) {
            long token = Binder.clearCallingIdentity();
            try {
                SipDelegateConnectionAidlWrapper.this.mExecutor.execute(() -> SipDelegateConnectionAidlWrapper.this.mStateCallback.onConfigurationChanged(registeredSipConfig));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDestroyed(int reason) {
            SipDelegateConnectionAidlWrapper.this.invalidateSipDelegateBinder();
            long token = Binder.clearCallingIdentity();
            try {
                SipDelegateConnectionAidlWrapper.this.mExecutor.execute(() -> SipDelegateConnectionAidlWrapper.this.mStateCallback.onDestroyed(reason));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    };
    private final ISipDelegateMessageCallback.Stub mMessageBinder = new ISipDelegateMessageCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessageReceived(SipMessage message) {
            long token = Binder.clearCallingIdentity();
            try {
                SipDelegateConnectionAidlWrapper.this.mExecutor.execute(() -> SipDelegateConnectionAidlWrapper.this.mMessageCallback.onMessageReceived(message));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessageSent(String viaTransactionId) {
            long token = Binder.clearCallingIdentity();
            try {
                SipDelegateConnectionAidlWrapper.this.mExecutor.execute(() -> SipDelegateConnectionAidlWrapper.this.mMessageCallback.onMessageSent(viaTransactionId));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessageSendFailure(String viaTransactionId, int reason) {
            long token = Binder.clearCallingIdentity();
            try {
                SipDelegateConnectionAidlWrapper.this.mExecutor.execute(() -> SipDelegateConnectionAidlWrapper.this.mMessageCallback.onMessageSendFailure(viaTransactionId, reason));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    };
    private final Executor mExecutor;
    private final DelegateConnectionStateCallback mStateCallback;
    private final DelegateConnectionMessageCallback mMessageCallback;
    private final AtomicReference<ISipDelegate> mDelegateBinder = new AtomicReference();

    public SipDelegateConnectionAidlWrapper(Executor executor, DelegateConnectionStateCallback stateCallback, DelegateConnectionMessageCallback messageCallback) {
        this.mExecutor = executor;
        this.mStateCallback = stateCallback;
        this.mMessageCallback = messageCallback;
    }

    @Override
    public void sendMessage(SipMessage sipMessage, long configVersion) {
        try {
            ISipDelegate conn = this.getSipDelegateBinder();
            if (conn == null) {
                this.notifyLocalMessageFailedToSend(sipMessage, 2);
                return;
            }
            conn.sendMessage(sipMessage, configVersion);
        }
        catch (RemoteException e) {
            this.notifyLocalMessageFailedToSend(sipMessage, 1);
        }
    }

    @Override
    public void notifyMessageReceived(String viaTransactionId) {
        try {
            ISipDelegate conn = this.getSipDelegateBinder();
            if (conn == null) {
                return;
            }
            conn.notifyMessageReceived(viaTransactionId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyMessageReceiveError(String viaTransactionId, int reason) {
        try {
            ISipDelegate conn = this.getSipDelegateBinder();
            if (conn == null) {
                return;
            }
            conn.notifyMessageReceiveError(viaTransactionId, reason);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void cleanupSession(String callId) {
        try {
            ISipDelegate conn = this.getSipDelegateBinder();
            if (conn == null) {
                return;
            }
            conn.cleanupSession(callId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void binderDied() {
        this.invalidateSipDelegateBinder();
        this.mExecutor.execute(() -> this.mStateCallback.onDestroyed(1));
    }

    public ISipDelegateConnectionStateCallback getStateCallbackBinder() {
        return this.mStateBinder;
    }

    public ISipDelegateMessageCallback getMessageCallbackBinder() {
        return this.mMessageBinder;
    }

    public ISipDelegate getSipDelegateBinder() {
        return this.mDelegateBinder.get();
    }

    private void associateSipDelegate(ISipDelegate c) {
        if (c != null) {
            try {
                c.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                c = null;
            }
        }
        this.mDelegateBinder.set(c);
    }

    private void invalidateSipDelegateBinder() {
        ISipDelegate oldVal = this.mDelegateBinder.getAndUpdate(unused -> null);
        if (oldVal != null) {
            try {
                oldVal.asBinder().unlinkToDeath(this, 0);
            }
            catch (NoSuchElementException e) {
                Log.i(LOG_TAG, "invalidateSipDelegateBinder: " + e);
            }
        }
    }

    private void notifyLocalMessageFailedToSend(SipMessage m, int reason) {
        String transactionId = m.getViaBranchParameter();
        this.mExecutor.execute(() -> this.mMessageCallback.onMessageSendFailure(transactionId, reason));
    }
}

