/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsRcsFeature;
import android.telephony.ims.aidl.IImsRegistration;
import android.telephony.ims.aidl.IImsServiceController;
import android.telephony.ims.aidl.IImsServiceControllerListener;
import android.telephony.ims.aidl.ISipTransport;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.feature.MmTelFeature;
import android.telephony.ims.feature.RcsFeature;
import android.telephony.ims.stub.ImsConfigImplBase;
import android.telephony.ims.stub.ImsFeatureConfiguration;
import android.telephony.ims.stub.ImsRegistrationImplBase;
import android.telephony.ims.stub.SipTransportImplBase;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.util.TelephonyUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@SystemApi
public class ImsService
extends Service {
    private static final String LOG_TAG = "ImsService";
    public static final long CAPABILITY_EMERGENCY_OVER_MMTEL = 1L;
    public static final long CAPABILITY_SIP_DELEGATE_CREATION = 2L;
    public static final long CAPABILITY_MAX_INDEX = Long.numberOfTrailingZeros(2L);
    private static final Map<Long, String> CAPABILITIES_LOG_MAP = new HashMap<Long, String>(){
        {
            this.put(1L, "EMERGENCY_OVER_MMTEL");
            this.put(2L, "SIP_DELEGATE_CREATION");
        }
    };
    public static final String SERVICE_INTERFACE = "android.telephony.ims.ImsService";
    private final SparseArray<SparseArray<ImsFeature>> mFeaturesBySlot = new SparseArray();
    private final SparseArray<SparseBooleanArray> mCreateImsFeatureWithSlotIdFlagMap = new SparseArray();
    private IImsServiceControllerListener mListener;
    private Executor mExecutor;
    protected final IBinder mImsServiceController = new IImsServiceController.Stub(){

        @Override
        public void setListener(IImsServiceControllerListener l) {
            ImsService.this.mListener = l;
        }

        @Override
        public IImsMmTelFeature createMmTelFeature(int slotId, int subId) {
            MmTelFeature f = (MmTelFeature)ImsService.this.getImsFeature(slotId, 1);
            if (f == null) {
                return this.executeMethodAsyncForResult(() -> ImsService.this.createMmTelFeatureInternal(slotId, subId), "createMmTelFeature");
            }
            return f.getBinder();
        }

        @Override
        public IImsMmTelFeature createEmergencyOnlyMmTelFeature(int slotId) {
            MmTelFeature f = (MmTelFeature)ImsService.this.getImsFeature(slotId, 1);
            if (f == null) {
                return this.executeMethodAsyncForResult(() -> ImsService.this.createEmergencyOnlyMmTelFeatureInternal(slotId), "createEmergencyOnlyMmTelFeature");
            }
            return f.getBinder();
        }

        @Override
        public IImsRcsFeature createRcsFeature(int slotId, int subId) {
            RcsFeature f = (RcsFeature)ImsService.this.getImsFeature(slotId, 2);
            if (f == null) {
                return this.executeMethodAsyncForResult(() -> ImsService.this.createRcsFeatureInternal(slotId, subId), "createRcsFeature");
            }
            return f.getBinder();
        }

        @Override
        public void addFeatureStatusCallback(int slotId, int featureType, IImsFeatureStatusCallback c) {
            this.executeMethodAsync(() -> ImsService.this.addImsFeatureStatusCallback(slotId, featureType, c), "addFeatureStatusCallback");
        }

        @Override
        public void removeFeatureStatusCallback(int slotId, int featureType, IImsFeatureStatusCallback c) {
            this.executeMethodAsync(() -> ImsService.this.removeImsFeatureStatusCallback(slotId, featureType, c), "removeFeatureStatusCallback");
        }

        @Override
        public void removeImsFeature(int slotId, int featureType, boolean changeSubId) {
            if (changeSubId && ImsService.this.isImsFeatureCreatedForSlot(slotId, featureType)) {
                Log.w(ImsService.LOG_TAG, "Do not remove Ims feature for compatibility");
                return;
            }
            this.executeMethodAsync(() -> ImsService.this.removeImsFeature(slotId, featureType), "removeImsFeature");
            ImsService.this.setImsFeatureCreatedForSlot(slotId, featureType, false);
        }

        @Override
        public ImsFeatureConfiguration querySupportedImsFeatures() {
            return this.executeMethodAsyncForResult(() -> ImsService.this.querySupportedImsFeatures(), "ImsFeatureConfiguration");
        }

        @Override
        public long getImsServiceCapabilities() {
            return this.executeMethodAsyncForResult(() -> {
                long sanitizedCaps;
                long caps = ImsService.this.getImsServiceCapabilities();
                if (caps != (sanitizedCaps = ImsService.sanitizeCapabilities(caps))) {
                    Log.w(ImsService.LOG_TAG, "removing invalid bits from field: 0x" + Long.toHexString(caps ^ sanitizedCaps));
                }
                return sanitizedCaps;
            }, "getImsServiceCapabilities");
        }

        @Override
        public void notifyImsServiceReadyForFeatureCreation() {
            this.executeMethodAsync(() -> ImsService.this.readyForFeatureCreation(), "notifyImsServiceReadyForFeatureCreation");
        }

        @Override
        public IImsConfig getConfig(int slotId, int subId) {
            return this.executeMethodAsyncForResult(() -> {
                ImsConfigImplBase c = ImsService.this.getConfigForSubscription(slotId, subId);
                if (c != null) {
                    c.setDefaultExecutor(ImsService.this.mExecutor);
                    return c.getIImsConfig();
                }
                return null;
            }, "getConfig");
        }

        @Override
        public IImsRegistration getRegistration(int slotId, int subId) {
            return this.executeMethodAsyncForResult(() -> {
                ImsRegistrationImplBase r = ImsService.this.getRegistrationForSubscription(slotId, subId);
                if (r != null) {
                    r.setDefaultExecutor(ImsService.this.mExecutor);
                    return r.getBinder();
                }
                return null;
            }, "getRegistration");
        }

        @Override
        public ISipTransport getSipTransport(int slotId) {
            return this.executeMethodAsyncForResult(() -> {
                SipTransportImplBase s = ImsService.this.getSipTransport(slotId);
                if (s != null) {
                    s.setDefaultExecutor(ImsService.this.mExecutor);
                    return s.getBinder();
                }
                return null;
            }, "getSipTransport");
        }

        @Override
        public void enableIms(int slotId, int subId) {
            this.executeMethodAsync(() -> ImsService.this.enableImsForSubscription(slotId, subId), "enableIms");
        }

        @Override
        public void disableIms(int slotId, int subId) {
            this.executeMethodAsync(() -> ImsService.this.disableImsForSubscription(slotId, subId), "disableIms");
        }

        private void executeMethodAsync(Runnable r, String errorLogName) {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), ImsService.this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(ImsService.LOG_TAG, "ImsService Binder - " + errorLogName + " exception: " + e.getMessage());
            }
        }

        private <T> T executeMethodAsyncForResult(Supplier<T> r, String errorLogName) {
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), ImsService.this.mExecutor);
            try {
                return (T)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.w(ImsService.LOG_TAG, "ImsService Binder - " + errorLogName + " exception: " + e.getMessage());
                return null;
            }
        }
    };

    public ImsService() {
        this.mExecutor = this.getExecutor();
        if (this.mExecutor == null) {
            this.mExecutor = Runnable::run;
        }
    }

    @Override
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            Log.i(LOG_TAG, "ImsService Bound.");
            return this.mImsServiceController;
        }
        return null;
    }

    private IImsMmTelFeature createMmTelFeatureInternal(int slotId, int subscriptionId) {
        MmTelFeature f = this.createMmTelFeatureForSubscription(slotId, subscriptionId);
        if (f != null) {
            this.setupFeature(f, slotId, 1);
            f.setDefaultExecutor(this.mExecutor);
            return f.getBinder();
        }
        Log.e(LOG_TAG, "createMmTelFeatureInternal: null feature returned.");
        return null;
    }

    private IImsMmTelFeature createEmergencyOnlyMmTelFeatureInternal(int slotId) {
        MmTelFeature f = this.createEmergencyOnlyMmTelFeature(slotId);
        if (f != null) {
            this.setupFeature(f, slotId, 1);
            f.setDefaultExecutor(this.mExecutor);
            return f.getBinder();
        }
        Log.e(LOG_TAG, "createEmergencyOnlyMmTelFeatureInternal: null feature returned.");
        return null;
    }

    private IImsRcsFeature createRcsFeatureInternal(int slotId, int subI) {
        RcsFeature f = this.createRcsFeatureForSubscription(slotId, subI);
        if (f != null) {
            f.setDefaultExecutor(this.mExecutor);
            this.setupFeature(f, slotId, 2);
            return f.getBinder();
        }
        Log.e(LOG_TAG, "createRcsFeatureInternal: null feature returned.");
        return null;
    }

    private void setupFeature(ImsFeature f, int slotId, int featureType) {
        f.initialize(this, slotId);
        this.addImsFeature(slotId, featureType, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImsFeatureStatusCallback(int slotId, int featureType, IImsFeatureStatusCallback c) {
        SparseArray<SparseArray<ImsFeature>> sparseArray = this.mFeaturesBySlot;
        synchronized (sparseArray) {
            SparseArray<ImsFeature> features = this.mFeaturesBySlot.get(slotId);
            if (features == null) {
                Log.w(LOG_TAG, "Can not add ImsFeatureStatusCallback - no features on slot " + slotId);
                return;
            }
            ImsFeature f = features.get(featureType);
            if (f != null) {
                f.addImsFeatureStatusCallback(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeImsFeatureStatusCallback(int slotId, int featureType, IImsFeatureStatusCallback c) {
        SparseArray<SparseArray<ImsFeature>> sparseArray = this.mFeaturesBySlot;
        synchronized (sparseArray) {
            SparseArray<ImsFeature> features = this.mFeaturesBySlot.get(slotId);
            if (features == null) {
                Log.w(LOG_TAG, "Can not remove ImsFeatureStatusCallback - no features on slot " + slotId);
                return;
            }
            ImsFeature f = features.get(featureType);
            if (f != null) {
                f.removeImsFeatureStatusCallback(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImsFeature(int slotId, int featureType, ImsFeature f) {
        SparseArray<SparseArray<ImsFeature>> sparseArray = this.mFeaturesBySlot;
        synchronized (sparseArray) {
            SparseArray<ImsFeature> features = this.mFeaturesBySlot.get(slotId);
            if (features == null) {
                features = new SparseArray();
                this.mFeaturesBySlot.put(slotId, features);
            }
            features.put(featureType, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeImsFeature(int slotId, int featureType) {
        SparseArray<SparseArray<ImsFeature>> sparseArray = this.mFeaturesBySlot;
        synchronized (sparseArray) {
            SparseArray<ImsFeature> features = this.mFeaturesBySlot.get(slotId);
            if (features == null) {
                Log.w(LOG_TAG, "Can not remove ImsFeature. No ImsFeatures exist on slot " + slotId);
                return;
            }
            ImsFeature f = features.get(featureType);
            if (f == null) {
                Log.w(LOG_TAG, "Can not remove ImsFeature. No feature with type " + featureType + " exists on slot " + slotId);
                return;
            }
            f.onFeatureRemoved();
            features.remove(featureType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public ImsFeature getImsFeature(int slotId, int featureType) {
        SparseArray<SparseArray<ImsFeature>> sparseArray = this.mFeaturesBySlot;
        synchronized (sparseArray) {
            SparseArray<ImsFeature> features = this.mFeaturesBySlot.get(slotId);
            if (features == null) {
                return null;
            }
            return features.get(featureType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setImsFeatureCreatedForSlot(int slotId, int featureType, boolean createdForSlot) {
        SparseArray<SparseBooleanArray> sparseArray = this.mCreateImsFeatureWithSlotIdFlagMap;
        synchronized (sparseArray) {
            this.getImsFeatureCreatedForSlot(slotId).put(featureType, createdForSlot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean isImsFeatureCreatedForSlot(int slotId, int featureType) {
        SparseArray<SparseBooleanArray> sparseArray = this.mCreateImsFeatureWithSlotIdFlagMap;
        synchronized (sparseArray) {
            return this.getImsFeatureCreatedForSlot(slotId).get(featureType);
        }
    }

    private SparseBooleanArray getImsFeatureCreatedForSlot(int slotId) {
        SparseBooleanArray createFlag = this.mCreateImsFeatureWithSlotIdFlagMap.get(slotId);
        if (createFlag == null) {
            createFlag = new SparseBooleanArray();
            this.mCreateImsFeatureWithSlotIdFlagMap.put(slotId, createFlag);
        }
        return createFlag;
    }

    public ImsFeatureConfiguration querySupportedImsFeatures() {
        return new ImsFeatureConfiguration();
    }

    public void onUpdateSupportedImsFeatures(ImsFeatureConfiguration c) throws RemoteException {
        if (this.mListener == null) {
            throw new IllegalStateException("Framework is not ready");
        }
        this.mListener.onUpdateSupportedImsFeatures(c);
    }

    @SuppressLint(value={"OnNameExpected"})
    public long getImsServiceCapabilities() {
        return 0L;
    }

    public void readyForFeatureCreation() {
    }

    public void enableImsForSubscription(int slotId, int subscriptionId) {
        this.enableIms(slotId);
    }

    public void disableImsForSubscription(int slotId, int subscriptionId) {
        this.disableIms(slotId);
    }

    @Deprecated
    public void enableIms(int slotId) {
    }

    @Deprecated
    public void disableIms(int slotId) {
    }

    public MmTelFeature createMmTelFeatureForSubscription(int slotId, int subscriptionId) {
        this.setImsFeatureCreatedForSlot(slotId, 1, true);
        return this.createMmTelFeature(slotId);
    }

    public RcsFeature createRcsFeatureForSubscription(int slotId, int subscriptionId) {
        this.setImsFeatureCreatedForSlot(slotId, 2, true);
        return this.createRcsFeature(slotId);
    }

    public MmTelFeature createEmergencyOnlyMmTelFeature(int slotId) {
        this.setImsFeatureCreatedForSlot(slotId, 1, true);
        return this.createMmTelFeature(slotId);
    }

    @Deprecated
    public MmTelFeature createMmTelFeature(int slotId) {
        return null;
    }

    @Deprecated
    public RcsFeature createRcsFeature(int slotId) {
        return null;
    }

    public ImsConfigImplBase getConfigForSubscription(int slotId, int subscriptionId) {
        return this.getConfig(slotId);
    }

    public ImsRegistrationImplBase getRegistrationForSubscription(int slotId, int subscriptionId) {
        return this.getRegistration(slotId);
    }

    @Deprecated
    public ImsConfigImplBase getConfig(int slotId) {
        return new ImsConfigImplBase();
    }

    @Deprecated
    public ImsRegistrationImplBase getRegistration(int slotId) {
        return new ImsRegistrationImplBase();
    }

    @SuppressLint(value={"OnNameExpected"})
    public SipTransportImplBase getSipTransport(int slotId) {
        return null;
    }

    private static long sanitizeCapabilities(long caps) {
        long filter = -1L;
        caps &= (filter <<= (int)(CAPABILITY_MAX_INDEX + 1L)) ^ 0xFFFFFFFFFFFFFFFFL;
        return caps &= 0xFFFFFFFFFFFFFFFEL;
    }

    public static String getCapabilitiesString(long caps) {
        StringBuffer result = new StringBuffer();
        result.append("capabilities={ ");
        long filter = -1L;
        for (long i = 0L; (caps & filter) != 0L && i <= 63L; ++i) {
            long bitToCheck = 1L << (int)i;
            if ((caps & bitToCheck) != 0L) {
                result.append(CAPABILITIES_LOG_MAP.getOrDefault(bitToCheck, bitToCheck + "?"));
                result.append(" ");
            }
            filter <<= 1;
        }
        result.append("}");
        return result.toString();
    }

    public Executor getExecutor() {
        return Runnable::run;
    }

    public static class Listener
    extends IImsServiceControllerListener.Stub {
        @Override
        public void onUpdateSupportedImsFeatures(ImsFeatureConfiguration c) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsServiceCapability {
    }
}

