/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.telephony.BinderCacheManager;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.ims.ImsException;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.ImsStateCallback;
import android.telephony.ims.RegistrationManager;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.feature.MmTelFeature;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.IIntegerConsumer;
import com.android.internal.telephony.ITelephony;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ImsMmTelManager
implements RegistrationManager {
    private static final String TAG = "ImsMmTelManager";
    public static final int WIFI_MODE_WIFI_ONLY = 0;
    public static final int WIFI_MODE_CELLULAR_PREFERRED = 1;
    public static final int WIFI_MODE_WIFI_PREFERRED = 2;
    private final Context mContext;
    private final int mSubId;
    private final BinderCacheManager<ITelephony> mBinderCache;

    @SystemApi
    @Deprecated
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    @SuppressLint(value={"ManagerLookup"})
    public static ImsMmTelManager createForSubscriptionId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            throw new IllegalArgumentException("Invalid subscription ID");
        }
        return new ImsMmTelManager(subId, new BinderCacheManager<ITelephony>(ImsMmTelManager::getITelephonyInterface));
    }

    @VisibleForTesting
    public ImsMmTelManager(int subId, BinderCacheManager<ITelephony> binderCache) {
        this(null, subId, binderCache);
    }

    @VisibleForTesting
    public ImsMmTelManager(Context context, int subId, BinderCacheManager<ITelephony> binderCache) {
        this.mContext = context;
        this.mSubId = subId;
        this.mBinderCache = binderCache;
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void registerImsRegistrationCallback(Executor executor, RegistrationCallback c) throws ImsException {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        c.setExecutor(executor);
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new ImsException("Could not find Telephony Service.", 1);
        }
        try {
            iTelephony.registerImsRegistrationCallback(this.mSubId, c.getBinder());
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    public void registerImsRegistrationCallback(Executor executor, RegistrationManager.RegistrationCallback c) throws ImsException {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        c.setExecutor(executor);
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new ImsException("Could not find Telephony Service.", 1);
        }
        try {
            iTelephony.registerImsRegistrationCallback(this.mSubId, c.getBinder());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void unregisterImsRegistrationCallback(RegistrationCallback c) {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.unregisterImsRegistrationCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    public void unregisterImsRegistrationCallback(RegistrationManager.RegistrationCallback c) {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.unregisterImsRegistrationCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void getRegistrationState(final Executor executor, final Consumer<Integer> stateCallback) {
        if (stateCallback == null) {
            throw new IllegalArgumentException("Must include a non-null callback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.getImsMmTelRegistrationState(this.mSubId, new IIntegerConsumer.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(int result) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> stateCallback.accept(result));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            });
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.w(TAG, "Error getting registration state: " + e);
            executor.execute(() -> stateCallback.accept(0));
        }
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    public void getRegistrationTransportType(final Executor executor, final Consumer<Integer> transportTypeCallback) {
        if (transportTypeCallback == null) {
            throw new IllegalArgumentException("Must include a non-null callback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.getImsMmTelRegistrationTransportType(this.mSubId, new IIntegerConsumer.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(int result) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> transportTypeCallback.accept(result));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            });
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.w(TAG, "Error getting transport type: " + e);
            executor.execute(() -> transportTypeCallback.accept(-1));
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    public void registerMmTelCapabilityCallback(Executor executor, CapabilityCallback c) throws ImsException {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        c.setExecutor(executor);
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new ImsException("Could not find Telephony Service.", 1);
        }
        try {
            iTelephony.registerMmTelCapabilityCallback(this.mSubId, c.getBinder());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        catch (IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    public void unregisterMmTelCapabilityCallback(CapabilityCallback c) {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            Log.w(TAG, "Could not find Telephony Service.");
            return;
        }
        try {
            iTelephony.unregisterMmTelCapabilityCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    public boolean isAdvancedCallingSettingEnabled() {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.isAdvancedCallingSettingEnabled(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setAdvancedCallingSettingEnabled(boolean isEnabled) {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setAdvancedCallingSettingEnabled(this.mSubId, isEnabled);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isCapable(int capability, int imsRegTech) {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.isCapable(this.mSubId, capability, imsRegTech);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isAvailable(int capability, int imsRegTech) {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.isAvailable(this.mSubId, capability, imsRegTech);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void isSupported(int capability, int transportType, final Executor executor, final Consumer<Boolean> callback) throws ImsException {
        if (callback == null) {
            throw new IllegalArgumentException("Must include a non-null Consumer.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new ImsException("Could not find Telephony Service.", 1);
        }
        try {
            iTelephony.isMmTelCapabilitySupported(this.mSubId, new IIntegerConsumer.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(int result) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.accept(result == 1));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            }, capability, transportType);
        }
        catch (ServiceSpecificException sse) {
            throw new ImsException(sse.getMessage(), sse.errorCode);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    public boolean isVtSettingEnabled() {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.isVtSettingEnabled(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setVtSettingEnabled(boolean isEnabled) {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setVtSettingEnabled(this.mSubId, isEnabled);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    public boolean isVoWiFiSettingEnabled() {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.isVoWiFiSettingEnabled(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setVoWiFiSettingEnabled(boolean isEnabled) {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setVoWiFiSettingEnabled(this.mSubId, isEnabled);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    public boolean isCrossSimCallingEnabled() throws ImsException {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new ImsException("Could not find Telephony Service.", 1);
        }
        try {
            return iTelephony.isCrossSimCallingEnabledByUser(this.mSubId);
        }
        catch (ServiceSpecificException sse) {
            throw new ImsException(sse.getMessage(), sse.errorCode);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setCrossSimCallingEnabled(boolean isEnabled) throws ImsException {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new ImsException("Could not find Telephony Service.", 1);
        }
        try {
            iTelephony.setCrossSimCallingEnabled(this.mSubId, isEnabled);
        }
        catch (ServiceSpecificException sse) {
            throw new ImsException(sse.getMessage(), sse.errorCode);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    public boolean isVoWiFiRoamingSettingEnabled() {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.isVoWiFiRoamingSettingEnabled(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setVoWiFiRoamingSettingEnabled(boolean isEnabled) {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setVoWiFiRoamingSettingEnabled(this.mSubId, isEnabled);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setVoWiFiNonPersistent(boolean isCapable, int mode) {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setVoWiFiNonPersistent(this.mSubId, isCapable, mode);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    public int getVoWiFiModeSetting() {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.getVoWiFiModeSetting(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setVoWiFiModeSetting(int mode) {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setVoWiFiModeSetting(this.mSubId, mode);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getVoWiFiRoamingModeSetting() {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.getVoWiFiRoamingModeSetting(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setVoWiFiRoamingModeSetting(int mode) {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setVoWiFiRoamingModeSetting(this.mSubId, mode);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setRttCapabilitySetting(boolean isEnabled) {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            iTelephony.setRttCapabilitySetting(this.mSubId, isEnabled);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    public boolean isTtyOverVolteEnabled() {
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        try {
            return iTelephony.isTtyOverVolteEnabled(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 3) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void getFeatureState(final Executor executor, final Consumer<Integer> callback) throws ImsException {
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Must include a non-null Consumer.");
        }
        ITelephony iTelephony = this.getITelephony();
        if (iTelephony == null) {
            throw new ImsException("Could not find Telephony Service.", 1);
        }
        try {
            iTelephony.getImsMmTelFeatureState(this.mSubId, new IIntegerConsumer.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(int result) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.accept(result));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            });
        }
        catch (ServiceSpecificException sse) {
            throw new ImsException(sse.getMessage(), sse.errorCode);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRECISE_PHONE_STATE", "android.permission.READ_PRIVILEGED_PHONE_STATE"})
    public void registerImsStateCallback(Executor executor, ImsStateCallback callback) throws ImsException {
        Objects.requireNonNull(callback, "Must include a non-null ImsStateCallback.");
        Objects.requireNonNull(executor, "Must include a non-null Executor.");
        callback.init(executor);
        ITelephony telephony = this.mBinderCache.listenOnBinder(callback, callback::binderDied);
        if (telephony == null) {
            throw new ImsException("Telephony server is down", 1);
        }
        try {
            telephony.registerImsStateCallback(this.mSubId, 1, callback.getCallbackBinder(), this.getOpPackageName());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    public void unregisterImsStateCallback(ImsStateCallback callback) {
        Objects.requireNonNull(callback, "Must include a non-null ImsStateCallback.");
        ITelephony telephony = this.mBinderCache.removeRunnable(callback);
        try {
            if (telephony != null) {
                telephony.unregisterImsStateCallback(callback.getCallbackBinder());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private String getOpPackageName() {
        if (this.mContext != null) {
            return this.mContext.getOpPackageName();
        }
        return null;
    }

    private ITelephony getITelephony() {
        return this.mBinderCache.getBinder();
    }

    private static ITelephony getITelephonyInterface() {
        ITelephony binder = ITelephony.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyServiceRegisterer().get());
        return binder;
    }

    public static class CapabilityCallback {
        private final CapabilityBinder mBinder = new CapabilityBinder(this);

        public void onCapabilitiesStatusChanged(MmTelFeature.MmTelCapabilities capabilities) {
        }

        public IImsCapabilityCallback getBinder() {
            return this.mBinder;
        }

        public void setExecutor(Executor executor) {
            this.mBinder.setExecutor(executor);
        }

        private static class CapabilityBinder
        extends IImsCapabilityCallback.Stub {
            private final CapabilityCallback mLocalCallback;
            private Executor mExecutor;

            CapabilityBinder(CapabilityCallback c) {
                this.mLocalCallback = c;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCapabilitiesStatusChanged(int config) {
                if (this.mLocalCallback == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onCapabilitiesStatusChanged(new MmTelFeature.MmTelCapabilities(config)));
                }
                finally {
                    CapabilityBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            @Override
            public void onQueryCapabilityConfiguration(int capability, int radioTech, boolean isEnabled) {
            }

            @Override
            public void onChangeCapabilityConfigurationError(int capability, int radioTech, int reason) {
            }

            private void setExecutor(Executor executor) {
                this.mExecutor = executor;
            }
        }
    }

    @Deprecated
    @SystemApi
    public static class RegistrationCallback
    extends RegistrationManager.RegistrationCallback {
        @Override
        public void onRegistered(int imsTransportType) {
        }

        @Override
        public void onRegistering(int imsTransportType) {
        }

        @Override
        public void onUnregistered(ImsReasonInfo info) {
        }

        @Override
        public void onTechnologyChangeFailed(int imsTransportType, ImsReasonInfo info) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WiFiCallingMode {
    }
}

