/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.euicc;

import android.annotation.SystemApi;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.service.euicc.EuiccProfileInfo;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.euicc.EuiccNotification;
import android.telephony.euicc.EuiccRulesAuthTable;
import android.util.Log;
import com.android.internal.telephony.euicc.IAuthenticateServerCallback;
import com.android.internal.telephony.euicc.ICancelSessionCallback;
import com.android.internal.telephony.euicc.IDeleteProfileCallback;
import com.android.internal.telephony.euicc.IDisableProfileCallback;
import com.android.internal.telephony.euicc.IEuiccCardController;
import com.android.internal.telephony.euicc.IGetAllProfilesCallback;
import com.android.internal.telephony.euicc.IGetDefaultSmdpAddressCallback;
import com.android.internal.telephony.euicc.IGetEuiccChallengeCallback;
import com.android.internal.telephony.euicc.IGetEuiccInfo1Callback;
import com.android.internal.telephony.euicc.IGetEuiccInfo2Callback;
import com.android.internal.telephony.euicc.IGetProfileCallback;
import com.android.internal.telephony.euicc.IGetRulesAuthTableCallback;
import com.android.internal.telephony.euicc.IGetSmdsAddressCallback;
import com.android.internal.telephony.euicc.IListNotificationsCallback;
import com.android.internal.telephony.euicc.ILoadBoundProfilePackageCallback;
import com.android.internal.telephony.euicc.IPrepareDownloadCallback;
import com.android.internal.telephony.euicc.IRemoveNotificationFromListCallback;
import com.android.internal.telephony.euicc.IResetMemoryCallback;
import com.android.internal.telephony.euicc.IRetrieveNotificationCallback;
import com.android.internal.telephony.euicc.IRetrieveNotificationListCallback;
import com.android.internal.telephony.euicc.ISetDefaultSmdpAddressCallback;
import com.android.internal.telephony.euicc.ISetNicknameCallback;
import com.android.internal.telephony.euicc.ISwitchToProfileCallback;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

@SystemApi
public class EuiccCardManager {
    private static final String TAG = "EuiccCardManager";
    public static final int CANCEL_REASON_END_USER_REJECTED = 0;
    public static final int CANCEL_REASON_POSTPONED = 1;
    public static final int CANCEL_REASON_TIMEOUT = 2;
    public static final int CANCEL_REASON_PPR_NOT_ALLOWED = 3;
    public static final int RESET_OPTION_DELETE_OPERATIONAL_PROFILES = 1;
    public static final int RESET_OPTION_DELETE_FIELD_LOADED_TEST_PROFILES = 2;
    public static final int RESET_OPTION_RESET_DEFAULT_SMDP_ADDRESS = 4;
    public static final int RESULT_PROFILE_NOT_FOUND = 1;
    public static final int RESULT_OK = 0;
    public static final int RESULT_UNKNOWN_ERROR = -1;
    public static final int RESULT_EUICC_NOT_FOUND = -2;
    public static final int RESULT_CALLER_NOT_ALLOWED = -3;
    private final Context mContext;

    public EuiccCardManager(Context context) {
        this.mContext = context;
    }

    private IEuiccCardController getIEuiccCardController() {
        return IEuiccCardController.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getEuiccCardControllerServiceRegisterer().get());
    }

    public void requestAllProfiles(String cardId, final Executor executor, final ResultCallback<EuiccProfileInfo[]> callback) {
        try {
            this.getIEuiccCardController().getAllProfiles(this.mContext.getOpPackageName(), cardId, new IGetAllProfilesCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, EuiccProfileInfo[] profiles) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, profiles));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling getAllProfiles", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestProfile(String cardId, String iccid, final Executor executor, final ResultCallback<EuiccProfileInfo> callback) {
        try {
            this.getIEuiccCardController().getProfile(this.mContext.getOpPackageName(), cardId, iccid, new IGetProfileCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, EuiccProfileInfo profile) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, profile));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling getProfile", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestEnabledProfileForPort(String cardId, int portIndex, final Executor executor, final ResultCallback<EuiccProfileInfo> callback) {
        try {
            this.getIEuiccCardController().getEnabledProfile(this.mContext.getOpPackageName(), cardId, portIndex, new IGetProfileCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, EuiccProfileInfo profile) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, profile));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling requestEnabledProfileForPort", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void disableProfile(String cardId, String iccid, boolean refresh, final Executor executor, final ResultCallback<Void> callback) {
        try {
            this.getIEuiccCardController().disableProfile(this.mContext.getOpPackageName(), cardId, iccid, refresh, new IDisableProfileCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, null));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling disableProfile", e);
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void switchToProfile(String cardId, String iccid, boolean refresh, final Executor executor, final ResultCallback<EuiccProfileInfo> callback) {
        try {
            this.getIEuiccCardController().switchToProfile(this.mContext.getOpPackageName(), cardId, iccid, 0, refresh, new ISwitchToProfileCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, EuiccProfileInfo profile) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, profile));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling switchToProfile", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void switchToProfile(String cardId, String iccid, int portIndex, boolean refresh, final Executor executor, final ResultCallback<EuiccProfileInfo> callback) {
        try {
            this.getIEuiccCardController().switchToProfile(this.mContext.getOpPackageName(), cardId, iccid, portIndex, refresh, new ISwitchToProfileCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, EuiccProfileInfo profile) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, profile));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling switchToProfile", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void setNickname(String cardId, String iccid, String nickname, final Executor executor, final ResultCallback<Void> callback) {
        try {
            this.getIEuiccCardController().setNickname(this.mContext.getOpPackageName(), cardId, iccid, nickname, new ISetNicknameCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, null));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling setNickname", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void deleteProfile(String cardId, String iccid, final Executor executor, final ResultCallback<Void> callback) {
        try {
            this.getIEuiccCardController().deleteProfile(this.mContext.getOpPackageName(), cardId, iccid, new IDeleteProfileCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, null));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling deleteProfile", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void resetMemory(String cardId, int options, final Executor executor, final ResultCallback<Void> callback) {
        try {
            this.getIEuiccCardController().resetMemory(this.mContext.getOpPackageName(), cardId, options, new IResetMemoryCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, null));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling resetMemory", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestDefaultSmdpAddress(String cardId, final Executor executor, final ResultCallback<String> callback) {
        try {
            this.getIEuiccCardController().getDefaultSmdpAddress(this.mContext.getOpPackageName(), cardId, new IGetDefaultSmdpAddressCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, String address) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, address));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling getDefaultSmdpAddress", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestSmdsAddress(String cardId, final Executor executor, final ResultCallback<String> callback) {
        try {
            this.getIEuiccCardController().getSmdsAddress(this.mContext.getOpPackageName(), cardId, new IGetSmdsAddressCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, String address) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, address));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling getSmdsAddress", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void setDefaultSmdpAddress(String cardId, String defaultSmdpAddress, final Executor executor, final ResultCallback<Void> callback) {
        try {
            this.getIEuiccCardController().setDefaultSmdpAddress(this.mContext.getOpPackageName(), cardId, defaultSmdpAddress, new ISetDefaultSmdpAddressCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, null));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling setDefaultSmdpAddress", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestRulesAuthTable(String cardId, final Executor executor, final ResultCallback<EuiccRulesAuthTable> callback) {
        try {
            this.getIEuiccCardController().getRulesAuthTable(this.mContext.getOpPackageName(), cardId, new IGetRulesAuthTableCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, EuiccRulesAuthTable rat) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, rat));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling getRulesAuthTable", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestEuiccChallenge(String cardId, final Executor executor, final ResultCallback<byte[]> callback) {
        try {
            this.getIEuiccCardController().getEuiccChallenge(this.mContext.getOpPackageName(), cardId, new IGetEuiccChallengeCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, byte[] challenge) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, challenge));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling getEuiccChallenge", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestEuiccInfo1(String cardId, final Executor executor, final ResultCallback<byte[]> callback) {
        try {
            this.getIEuiccCardController().getEuiccInfo1(this.mContext.getOpPackageName(), cardId, new IGetEuiccInfo1Callback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, byte[] info) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, info));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling getEuiccInfo1", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestEuiccInfo2(String cardId, final Executor executor, final ResultCallback<byte[]> callback) {
        try {
            this.getIEuiccCardController().getEuiccInfo2(this.mContext.getOpPackageName(), cardId, new IGetEuiccInfo2Callback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, byte[] info) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, info));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling getEuiccInfo2", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void authenticateServer(String cardId, String matchingId, byte[] serverSigned1, byte[] serverSignature1, byte[] euiccCiPkIdToBeUsed, byte[] serverCertificate, final Executor executor, final ResultCallback<byte[]> callback) {
        try {
            this.getIEuiccCardController().authenticateServer(this.mContext.getOpPackageName(), cardId, matchingId, serverSigned1, serverSignature1, euiccCiPkIdToBeUsed, serverCertificate, new IAuthenticateServerCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, byte[] response) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, response));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling authenticateServer", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void prepareDownload(String cardId, byte[] hashCc, byte[] smdpSigned2, byte[] smdpSignature2, byte[] smdpCertificate, final Executor executor, final ResultCallback<byte[]> callback) {
        try {
            this.getIEuiccCardController().prepareDownload(this.mContext.getOpPackageName(), cardId, hashCc, smdpSigned2, smdpSignature2, smdpCertificate, new IPrepareDownloadCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, byte[] response) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, response));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling prepareDownload", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void loadBoundProfilePackage(String cardId, byte[] boundProfilePackage, final Executor executor, final ResultCallback<byte[]> callback) {
        try {
            this.getIEuiccCardController().loadBoundProfilePackage(this.mContext.getOpPackageName(), cardId, boundProfilePackage, new ILoadBoundProfilePackageCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, byte[] response) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, response));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling loadBoundProfilePackage", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void cancelSession(String cardId, byte[] transactionId, int reason, final Executor executor, final ResultCallback<byte[]> callback) {
        try {
            this.getIEuiccCardController().cancelSession(this.mContext.getOpPackageName(), cardId, transactionId, reason, new ICancelSessionCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, byte[] response) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, response));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling cancelSession", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void listNotifications(String cardId, int events, final Executor executor, final ResultCallback<EuiccNotification[]> callback) {
        try {
            this.getIEuiccCardController().listNotifications(this.mContext.getOpPackageName(), cardId, events, new IListNotificationsCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, EuiccNotification[] notifications) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, notifications));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling listNotifications", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void retrieveNotificationList(String cardId, int events, final Executor executor, final ResultCallback<EuiccNotification[]> callback) {
        try {
            this.getIEuiccCardController().retrieveNotificationList(this.mContext.getOpPackageName(), cardId, events, new IRetrieveNotificationListCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, EuiccNotification[] notifications) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, notifications));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling retrieveNotificationList", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void retrieveNotification(String cardId, int seqNumber, final Executor executor, final ResultCallback<EuiccNotification> callback) {
        try {
            this.getIEuiccCardController().retrieveNotification(this.mContext.getOpPackageName(), cardId, seqNumber, new IRetrieveNotificationCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode, EuiccNotification notification) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, notification));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling retrieveNotification", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeNotificationFromList(String cardId, int seqNumber, final Executor executor, final ResultCallback<Void> callback) {
        try {
            this.getIEuiccCardController().removeNotificationFromList(this.mContext.getOpPackageName(), cardId, seqNumber, new IRemoveNotificationFromListCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int resultCode) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onComplete(resultCode, null));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling removeNotificationFromList", e);
            throw e.rethrowFromSystemServer();
        }
    }

    public static interface ResultCallback<T> {
        public void onComplete(int var1, T var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResetOption {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CancelReason {
    }
}

