/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.app.PropertyInvalidatedCache;
import android.app.role.RoleManager;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextParams;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.OutcomeReceiver;
import android.os.ParcelFileDescriptor;
import android.os.ParcelUuid;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.provider.Settings;
import android.provider.Telephony;
import android.service.carrier.CarrierIdentifier;
import android.sysprop.TelephonyProperties;
import android.telecom.PhoneAccount;
import android.telecom.PhoneAccountHandle;
import android.telecom.TelecomManager;
import android.telephony.AnomalyReporter;
import android.telephony.AvailableNetworkInfo;
import android.telephony.CallForwardingInfo;
import android.telephony.CarrierConfigManager;
import android.telephony.CarrierRestrictionRules;
import android.telephony.CellIdentity;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.ClientRequestStats;
import android.telephony.IBootstrapAuthenticationCallback;
import android.telephony.ICellInfoCallback;
import android.telephony.IccOpenLogicalChannelResponse;
import android.telephony.ImsiEncryptionInfo;
import android.telephony.ModemActivityInfo;
import android.telephony.NeighboringCellInfo;
import android.telephony.NetworkScan;
import android.telephony.NetworkScanRequest;
import android.telephony.NumberVerificationCallback;
import android.telephony.PhoneCapability;
import android.telephony.PhoneNumberRange;
import android.telephony.PhoneStateListener;
import android.telephony.PinResult;
import android.telephony.RadioAccessFamily;
import android.telephony.RadioAccessSpecifier;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SignalStrengthUpdateRequest;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyCallback;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.TelephonyHistogram;
import android.telephony.TelephonyRegistryManager;
import android.telephony.TelephonyScanManager;
import android.telephony.ThermalMitigationRequest;
import android.telephony.UiccCardInfo;
import android.telephony.UiccPortInfo;
import android.telephony.UiccSlotInfo;
import android.telephony.UiccSlotMapping;
import android.telephony.UssdResponse;
import android.telephony.VisualVoicemailSmsFilterSettings;
import android.telephony.data.ApnSetting;
import android.telephony.data.NetworkSlicingConfig;
import android.telephony.emergency.EmergencyNumber;
import android.telephony.gba.UaSecurityProtocolIdentifier;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsRegistration;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.telephony.CellNetworkScanResult;
import com.android.internal.telephony.IBooleanConsumer;
import com.android.internal.telephony.ICallForwardingInfoCallback;
import com.android.internal.telephony.IIntegerConsumer;
import com.android.internal.telephony.INumberVerificationCallback;
import com.android.internal.telephony.IOns;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.ISetOpportunisticDataCallback;
import com.android.internal.telephony.ISms;
import com.android.internal.telephony.ISub;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.IUpdateAvailableNetworksCallback;
import com.android.internal.telephony.IccLogicalChannelRequest;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.RILConstants;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.util.Preconditions;
import com.android.telephony.Rlog;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TelephonyManager {
    private static final String TAG = "TelephonyManager";
    private TelephonyRegistryManager mTelephonyRegistryMgr;
    private static final long CALLBACK_ON_MORE_ERROR_CODE_CHANGE = 130595455L;
    public static final String MODEM_ACTIVITY_RESULT_KEY = "controller_activity";
    public static final String EXCEPTION_RESULT_KEY = "exception";
    public static final String PHONE_PROCESS_NAME = "com.android.phone";
    public static final int NETWORK_SELECTION_MODE_UNKNOWN = 0;
    public static final int NETWORK_SELECTION_MODE_AUTO = 1;
    public static final int NETWORK_SELECTION_MODE_MANUAL = 2;
    public static final int OTASP_UNINITIALIZED = 0;
    public static final int OTASP_UNKNOWN = 1;
    public static final int OTASP_NEEDED = 2;
    public static final int OTASP_NOT_NEEDED = 3;
    public static final int OTASP_SIM_UNPROVISIONED = 5;
    @SystemApi
    public static final int KEY_TYPE_EPDG = 1;
    @SystemApi
    public static final int KEY_TYPE_WLAN = 2;
    @SystemApi
    public static final int SRVCC_STATE_HANDOVER_NONE = -1;
    @SystemApi
    public static final int SRVCC_STATE_HANDOVER_STARTED = 0;
    @SystemApi
    public static final int SRVCC_STATE_HANDOVER_COMPLETED = 1;
    @SystemApi
    public static final int SRVCC_STATE_HANDOVER_FAILED = 2;
    @SystemApi
    public static final int SRVCC_STATE_HANDOVER_CANCELED = 3;
    public static final int UNSUPPORTED_CARD_ID = -1;
    public static final int UNINITIALIZED_CARD_ID = -2;
    public static final int DEFAULT_PORT_INDEX = 0;
    public static final int INVALID_PORT_INDEX = -1;
    private final Context mContext;
    private final int mSubId;
    @UnsupportedAppUsage
    private SubscriptionManager mSubscriptionManager;
    private TelephonyScanManager mTelephonyScanManager;
    private static final Object sCacheLock = new Object();
    private static boolean sServiceHandleCacheEnabled = true;
    @GuardedBy(value={"sCacheLock"})
    private static ITelephony sITelephony;
    @GuardedBy(value={"sCacheLock"})
    private static IPhoneSubInfo sIPhoneSubInfo;
    @GuardedBy(value={"sCacheLock"})
    private static ISub sISub;
    @GuardedBy(value={"sCacheLock"})
    private static ISms sISms;
    @GuardedBy(value={"sCacheLock"})
    private static final DeathRecipient sServiceDeath;
    public static final String CACHE_KEY_PHONE_ACCOUNT_TO_SUBID = "cache_key.telephony.phone_account_to_subid";
    private static final int CACHE_MAX_SIZE = 4;
    private PropertyInvalidatedCache<PhoneAccountHandle, Integer> mPhoneAccountHandleToSubIdCache = new PropertyInvalidatedCache<PhoneAccountHandle, Integer>(4, "cache_key.telephony.phone_account_to_subid"){

        @Override
        public Integer recompute(PhoneAccountHandle phoneAccountHandle) {
            try {
                ITelephony telephony = TelephonyManager.this.getITelephony();
                if (telephony != null) {
                    return telephony.getSubIdForPhoneAccountHandle(phoneAccountHandle, TelephonyManager.this.mContext.getOpPackageName(), TelephonyManager.this.mContext.getAttributionTag());
                }
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            return -1;
        }
    };
    private static TelephonyManager sInstance;
    private static final int MAXIMUM_CALL_COMPOSER_PICTURE_SIZE = 80000;
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static final String ACTION_PHONE_STATE_CHANGED = "android.intent.action.PHONE_STATE";
    public static final String ACTION_RESPOND_VIA_MESSAGE = "android.intent.action.RESPOND_VIA_MESSAGE";
    @SystemApi
    public static final String ACTION_EMERGENCY_ASSISTANCE = "android.telephony.action.EMERGENCY_ASSISTANCE";
    public static final String METADATA_HIDE_VOICEMAIL_SETTINGS_MENU = "android.telephony.HIDE_VOICEMAIL_SETTINGS_MENU";
    public static final String ACTION_CONFIGURE_VOICEMAIL = "android.telephony.action.CONFIGURE_VOICEMAIL";
    public static final String EXTRA_HIDE_PUBLIC_SETTINGS = "android.telephony.extra.HIDE_PUBLIC_SETTINGS";
    public static final boolean EMERGENCY_ASSISTANCE_ENABLED = true;
    public static final String EXTRA_STATE = "state";
    public static final String EXTRA_STATE_IDLE;
    public static final String EXTRA_STATE_RINGING;
    public static final String EXTRA_STATE_OFFHOOK;
    @Deprecated
    public static final String EXTRA_INCOMING_NUMBER = "incoming_number";
    public static final String ACTION_CALL_DISCONNECT_CAUSE_CHANGED = "android.intent.action.CALL_DISCONNECT_CAUSE";
    @Deprecated
    public static final String EXTRA_DISCONNECT_CAUSE = "disconnect_cause";
    public static final String EXTRA_PRECISE_DISCONNECT_CAUSE = "precise_disconnect_cause";
    public static final String ACTION_SHOW_VOICEMAIL_NOTIFICATION = "android.telephony.action.SHOW_VOICEMAIL_NOTIFICATION";
    public static final String EXTRA_PHONE_ACCOUNT_HANDLE = "android.telephony.extra.PHONE_ACCOUNT_HANDLE";
    public static final String EXTRA_NOTIFICATION_COUNT = "android.telephony.extra.NOTIFICATION_COUNT";
    public static final String EXTRA_VOICEMAIL_NUMBER = "android.telephony.extra.VOICEMAIL_NUMBER";
    public static final String EXTRA_CALL_VOICEMAIL_INTENT = "android.telephony.extra.CALL_VOICEMAIL_INTENT";
    public static final String EXTRA_LAUNCH_VOICEMAIL_SETTINGS_INTENT = "android.telephony.extra.LAUNCH_VOICEMAIL_SETTINGS_INTENT";
    public static final String EXTRA_IS_REFRESH = "android.telephony.extra.IS_REFRESH";
    public static final String EVENT_HANDOVER_VIDEO_FROM_WIFI_TO_LTE = "android.telephony.event.EVENT_HANDOVER_VIDEO_FROM_WIFI_TO_LTE";
    public static final String EVENT_HANDOVER_VIDEO_FROM_LTE_TO_WIFI = "android.telephony.event.EVENT_HANDOVER_VIDEO_FROM_LTE_TO_WIFI";
    public static final String EVENT_HANDOVER_TO_WIFI_FAILED = "android.telephony.event.EVENT_HANDOVER_TO_WIFI_FAILED";
    public static final String EVENT_DOWNGRADE_DATA_LIMIT_REACHED = "android.telephony.event.EVENT_DOWNGRADE_DATA_LIMIT_REACHED";
    public static final String EVENT_DOWNGRADE_DATA_DISABLED = "android.telephony.event.EVENT_DOWNGRADE_DATA_DISABLED";
    public static final String EVENT_NOTIFY_INTERNATIONAL_CALL_ON_WFC = "android.telephony.event.EVENT_NOTIFY_INTERNATIONAL_CALL_ON_WFC";
    public static final String EVENT_CALL_FORWARDED = "android.telephony.event.EVENT_CALL_FORWARDED";
    public static final String EVENT_SUPPLEMENTARY_SERVICE_NOTIFICATION = "android.telephony.event.EVENT_SUPPLEMENTARY_SERVICE_NOTIFICATION";
    public static final String EXTRA_NOTIFICATION_TYPE = "android.telephony.extra.NOTIFICATION_TYPE";
    public static final String EXTRA_NOTIFICATION_CODE = "android.telephony.extra.NOTIFICATION_CODE";
    public static final String EXTRA_NOTIFICATION_MESSAGE = "android.telephony.extra.NOTIFICATION_MESSAGE";
    public static final String VVM_TYPE_OMTP = "vvm_type_omtp";
    public static final String VVM_TYPE_CVVM = "vvm_type_cvvm";
    @SystemApi
    public static final String EXTRA_VISUAL_VOICEMAIL_ENABLED_BY_USER_BOOL = "android.telephony.extra.VISUAL_VOICEMAIL_ENABLED_BY_USER_BOOL";
    @SystemApi
    public static final String EXTRA_VOICEMAIL_SCRAMBLED_PIN_STRING = "android.telephony.extra.VOICEMAIL_SCRAMBLED_PIN_STRING";
    public static final String ACTION_MULTI_SIM_CONFIG_CHANGED = "android.telephony.action.MULTI_SIM_CONFIG_CHANGED";
    public static final String EXTRA_ACTIVE_SIM_SUPPORTED_COUNT = "android.telephony.extra.ACTIVE_SIM_SUPPORTED_COUNT";
    public static final String USSD_RESPONSE = "USSD_RESPONSE";
    public static final int USSD_RETURN_SUCCESS = 100;
    public static final int USSD_RETURN_FAILURE = -1;
    public static final int USSD_ERROR_SERVICE_UNAVAIL = -2;
    public static final int CDMA_ROAMING_MODE_RADIO_DEFAULT = -1;
    public static final int CDMA_ROAMING_MODE_HOME = 0;
    public static final int CDMA_ROAMING_MODE_AFFILIATED = 1;
    public static final int CDMA_ROAMING_MODE_ANY = 2;
    public static final int UNKNOWN_CARRIER_ID = -1;
    public static final int UNKNOWN_CARRIER_ID_LIST_VERSION = -1;
    public static final String ACTION_SUBSCRIPTION_CARRIER_IDENTITY_CHANGED = "android.telephony.action.SUBSCRIPTION_CARRIER_IDENTITY_CHANGED";
    public static final String EXTRA_CARRIER_ID = "android.telephony.extra.CARRIER_ID";
    public static final String EXTRA_CARRIER_NAME = "android.telephony.extra.CARRIER_NAME";
    public static final String ACTION_SUBSCRIPTION_SPECIFIC_CARRIER_IDENTITY_CHANGED = "android.telephony.action.SUBSCRIPTION_SPECIFIC_CARRIER_IDENTITY_CHANGED";
    public static final String EXTRA_SPECIFIC_CARRIER_ID = "android.telephony.extra.SPECIFIC_CARRIER_ID";
    public static final String EXTRA_SPECIFIC_CARRIER_NAME = "android.telephony.extra.SPECIFIC_CARRIER_NAME";
    public static final String EXTRA_SUBSCRIPTION_ID = "android.telephony.extra.SUBSCRIPTION_ID";
    public static final String ACTION_SERVICE_PROVIDERS_UPDATED = "android.telephony.action.SERVICE_PROVIDERS_UPDATED";
    public static final String EXTRA_SHOW_PLMN = "android.telephony.extra.SHOW_PLMN";
    public static final String EXTRA_PLMN = "android.telephony.extra.PLMN";
    public static final String EXTRA_SHOW_SPN = "android.telephony.extra.SHOW_SPN";
    public static final String EXTRA_SPN = "android.telephony.extra.SPN";
    public static final String EXTRA_DATA_SPN = "android.telephony.extra.DATA_SPN";
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static final String ACTION_DATA_STALL_DETECTED = "android.intent.action.DATA_STALL_DETECTED";
    public static final String ACTION_CARRIER_MESSAGING_CLIENT_SERVICE = "android.telephony.action.CARRIER_MESSAGING_CLIENT_SERVICE";
    public static final String EXTRA_RECOVERY_ACTION = "recoveryAction";
    private static final long MAX_NUMBER_VERIFICATION_TIMEOUT_MILLIS = 60000L;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public static final String ACTION_ANOMALY_REPORTED = "android.telephony.action.ANOMALY_REPORTED";
    @SystemApi
    public static final String EXTRA_ANOMALY_ID = "android.telephony.extra.ANOMALY_ID";
    @SystemApi
    public static final String EXTRA_ANOMALY_DESCRIPTION = "android.telephony.extra.ANOMALY_DESCRIPTION";
    public static final String ACTION_PRIMARY_SUBSCRIPTION_LIST_CHANGED = "android.telephony.action.PRIMARY_SUBSCRIPTION_LIST_CHANGED";
    public static final String EXTRA_DEFAULT_SUBSCRIPTION_SELECT_TYPE = "android.telephony.extra.DEFAULT_SUBSCRIPTION_SELECT_TYPE";
    public static final int EXTRA_DEFAULT_SUBSCRIPTION_SELECT_TYPE_NONE = 0;
    public static final int EXTRA_DEFAULT_SUBSCRIPTION_SELECT_TYPE_DATA = 1;
    public static final int EXTRA_DEFAULT_SUBSCRIPTION_SELECT_TYPE_VOICE = 2;
    public static final int EXTRA_DEFAULT_SUBSCRIPTION_SELECT_TYPE_SMS = 3;
    public static final int EXTRA_DEFAULT_SUBSCRIPTION_SELECT_TYPE_ALL = 4;
    public static final int EXTRA_DEFAULT_SUBSCRIPTION_SELECT_TYPE_DISMISS = 5;
    public static final String EXTRA_SIM_COMBINATION_WARNING_TYPE = "android.telephony.extra.SIM_COMBINATION_WARNING_TYPE";
    public static final int EXTRA_SIM_COMBINATION_WARNING_TYPE_NONE = 0;
    public static final int EXTRA_SIM_COMBINATION_WARNING_TYPE_DUAL_CDMA = 1;
    public static final String EXTRA_SIM_COMBINATION_NAMES = "android.telephony.extra.SIM_COMBINATION_NAMES";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_EMERGENCY_CALLBACK_MODE_CHANGED = "android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED";
    @SystemApi
    public static final String EXTRA_PHONE_IN_ECM_STATE = "android.telephony.extra.PHONE_IN_ECM_STATE";
    public static final String ACTION_CARRIER_SIGNAL_REDIRECTED = "android.telephony.action.CARRIER_SIGNAL_REDIRECTED";
    public static final String ACTION_CARRIER_SIGNAL_REQUEST_NETWORK_FAILED = "android.telephony.action.CARRIER_SIGNAL_REQUEST_NETWORK_FAILED";
    public static final String ACTION_CARRIER_SIGNAL_PCO_VALUE = "android.telephony.action.CARRIER_SIGNAL_PCO_VALUE";
    public static final String ACTION_CARRIER_SIGNAL_DEFAULT_NETWORK_AVAILABLE = "android.telephony.action.CARRIER_SIGNAL_DEFAULT_NETWORK_AVAILABLE";
    public static final String ACTION_CARRIER_SIGNAL_RESET = "android.telephony.action.CARRIER_SIGNAL_RESET";
    public static final String EXTRA_REDIRECTION_URL = "android.telephony.extra.REDIRECTION_URL";
    public static final String EXTRA_DATA_FAIL_CAUSE = "android.telephony.extra.DATA_FAIL_CAUSE";
    public static final String EXTRA_APN_TYPE = "android.telephony.extra.APN_TYPE";
    public static final String EXTRA_APN_PROTOCOL = "android.telephony.extra.APN_PROTOCOL";
    public static final String EXTRA_PCO_ID = "android.telephony.extra.PCO_ID";
    public static final String EXTRA_PCO_VALUE = "android.telephony.extra.PCO_VALUE";
    public static final String EXTRA_DEFAULT_NETWORK_AVAILABLE = "android.telephony.extra.DEFAULT_NETWORK_AVAILABLE";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_EMERGENCY_CALL_STATE_CHANGED = "android.intent.action.EMERGENCY_CALL_STATE_CHANGED";
    @SystemApi
    public static final String EXTRA_PHONE_IN_EMERGENCY_CALL = "android.telephony.extra.PHONE_IN_EMERGENCY_CALL";
    @SystemApi
    public static final String ACTION_SHOW_NOTICE_ECM_BLOCK_OTHERS = "android.telephony.action.SHOW_NOTICE_ECM_BLOCK_OTHERS";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED = "android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_DEFAULT_VOICE_SUBSCRIPTION_CHANGED = "android.intent.action.ACTION_DEFAULT_VOICE_SUBSCRIPTION_CHANGED";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_REQUEST_OMADM_CONFIGURATION_UPDATE = "com.android.omadm.service.CONFIGURATION_UPDATE";
    public static final int PHONE_TYPE_NONE = 0;
    public static final int PHONE_TYPE_GSM = 1;
    public static final int PHONE_TYPE_CDMA = 2;
    public static final int PHONE_TYPE_SIP = 3;
    public static final int PHONE_TYPE_IMS = 5;
    public static final int PHONE_TYPE_THIRD_PARTY = 4;
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;
    public static final int NETWORK_TYPE_GSM = 16;
    public static final int NETWORK_TYPE_TD_SCDMA = 17;
    public static final int NETWORK_TYPE_IWLAN = 18;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int NETWORK_TYPE_LTE_CA = 19;
    public static final int NETWORK_TYPE_NR = 20;
    private static final int[] NETWORK_TYPES;
    public static final int SIM_STATE_UNKNOWN = 0;
    public static final int SIM_STATE_ABSENT = 1;
    public static final int SIM_STATE_PIN_REQUIRED = 2;
    public static final int SIM_STATE_PUK_REQUIRED = 3;
    public static final int SIM_STATE_NETWORK_LOCKED = 4;
    public static final int SIM_STATE_READY = 5;
    public static final int SIM_STATE_NOT_READY = 6;
    public static final int SIM_STATE_PERM_DISABLED = 7;
    public static final int SIM_STATE_CARD_IO_ERROR = 8;
    public static final int SIM_STATE_CARD_RESTRICTED = 9;
    @SystemApi
    public static final int SIM_STATE_LOADED = 10;
    @SystemApi
    public static final int SIM_STATE_PRESENT = 11;
    @SystemApi
    public static final String EXTRA_SIM_STATE = "android.telephony.extra.SIM_STATE";
    @SystemApi
    public static final String ACTION_SIM_CARD_STATE_CHANGED = "android.telephony.action.SIM_CARD_STATE_CHANGED";
    @SystemApi
    public static final String ACTION_SIM_APPLICATION_STATE_CHANGED = "android.telephony.action.SIM_APPLICATION_STATE_CHANGED";
    @SystemApi
    public static final String ACTION_SIM_SLOT_STATUS_CHANGED = "android.telephony.action.SIM_SLOT_STATUS_CHANGED";
    public static final String ACTION_SECRET_CODE = "android.telephony.action.SECRET_CODE";
    public static final String KEY_CALL_COMPOSER_PICTURE_HANDLE = "call_composer_picture_handle";
    @SystemApi
    public static final int SIM_ACTIVATION_STATE_UNKNOWN = 0;
    @SystemApi
    public static final int SIM_ACTIVATION_STATE_ACTIVATING = 1;
    @SystemApi
    public static final int SIM_ACTIVATION_STATE_ACTIVATED = 2;
    @SystemApi
    public static final int SIM_ACTIVATION_STATE_DEACTIVATED = 3;
    @SystemApi
    public static final int SIM_ACTIVATION_STATE_RESTRICTED = 4;
    public static final int CALL_STATE_IDLE = 0;
    public static final int CALL_STATE_RINGING = 1;
    public static final int CALL_STATE_OFFHOOK = 2;
    public static final int DATA_ACTIVITY_NONE = 0;
    public static final int DATA_ACTIVITY_IN = 1;
    public static final int DATA_ACTIVITY_OUT = 2;
    public static final int DATA_ACTIVITY_INOUT = 3;
    public static final int DATA_ACTIVITY_DORMANT = 4;
    public static final int DATA_UNKNOWN = -1;
    public static final int DATA_DISCONNECTED = 0;
    public static final int DATA_CONNECTING = 1;
    public static final int DATA_CONNECTED = 2;
    public static final int DATA_SUSPENDED = 3;
    public static final int DATA_DISCONNECTING = 4;
    public static final int DATA_HANDOVER_IN_PROGRESS = 5;
    private static final long GET_DATA_STATE_R_VERSION = 148534348L;
    public static final int ERI_ON = 0;
    public static final int ERI_OFF = 1;
    public static final int ERI_FLASH = 2;
    public static final int ERI_ICON_MODE_NORMAL = 0;
    public static final int ERI_ICON_MODE_FLASH = 1;
    private static final long NULL_TELEPHONY_THROW_NO_CB = 182185642L;
    public static final int APPTYPE_UNKNOWN = 0;
    public static final int APPTYPE_SIM = 1;
    public static final int APPTYPE_USIM = 2;
    public static final int APPTYPE_RUIM = 3;
    public static final int APPTYPE_CSIM = 4;
    public static final int APPTYPE_ISIM = 5;
    public static final int AUTHTYPE_EAP_SIM = 128;
    public static final int AUTHTYPE_EAP_AKA = 129;
    public static final int NETWORK_MODE_WCDMA_PREF = 0;
    public static final int NETWORK_MODE_GSM_ONLY = 1;
    public static final int NETWORK_MODE_WCDMA_ONLY = 2;
    public static final int NETWORK_MODE_GSM_UMTS = 3;
    public static final int NETWORK_MODE_CDMA_EVDO = 4;
    public static final int NETWORK_MODE_CDMA_NO_EVDO = 5;
    public static final int NETWORK_MODE_EVDO_NO_CDMA = 6;
    public static final int NETWORK_MODE_GLOBAL = 7;
    public static final int NETWORK_MODE_LTE_CDMA_EVDO = 8;
    public static final int NETWORK_MODE_LTE_GSM_WCDMA = 9;
    public static final int NETWORK_MODE_LTE_CDMA_EVDO_GSM_WCDMA = 10;
    public static final int NETWORK_MODE_LTE_ONLY = 11;
    public static final int NETWORK_MODE_LTE_WCDMA = 12;
    public static final int NETWORK_MODE_TDSCDMA_ONLY = 13;
    public static final int NETWORK_MODE_TDSCDMA_WCDMA = 14;
    public static final int NETWORK_MODE_LTE_TDSCDMA = 15;
    public static final int NETWORK_MODE_TDSCDMA_GSM = 16;
    public static final int NETWORK_MODE_LTE_TDSCDMA_GSM = 17;
    public static final int NETWORK_MODE_TDSCDMA_GSM_WCDMA = 18;
    public static final int NETWORK_MODE_LTE_TDSCDMA_WCDMA = 19;
    public static final int NETWORK_MODE_LTE_TDSCDMA_GSM_WCDMA = 20;
    public static final int NETWORK_MODE_TDSCDMA_CDMA_EVDO_GSM_WCDMA = 21;
    public static final int NETWORK_MODE_LTE_TDSCDMA_CDMA_EVDO_GSM_WCDMA = 22;
    public static final int NETWORK_MODE_NR_ONLY = 23;
    public static final int NETWORK_MODE_NR_LTE = 24;
    public static final int NETWORK_MODE_NR_LTE_CDMA_EVDO = 25;
    public static final int NETWORK_MODE_NR_LTE_GSM_WCDMA = 26;
    public static final int NETWORK_MODE_NR_LTE_CDMA_EVDO_GSM_WCDMA = 27;
    public static final int NETWORK_MODE_NR_LTE_WCDMA = 28;
    public static final int NETWORK_MODE_NR_LTE_TDSCDMA = 29;
    public static final int NETWORK_MODE_NR_LTE_TDSCDMA_GSM = 30;
    public static final int NETWORK_MODE_NR_LTE_TDSCDMA_WCDMA = 31;
    public static final int NETWORK_MODE_NR_LTE_TDSCDMA_GSM_WCDMA = 32;
    public static final int NETWORK_MODE_NR_LTE_TDSCDMA_CDMA_EVDO_GSM_WCDMA = 33;
    public static final int DEFAULT_PREFERRED_NETWORK_MODE;
    public static final int ALLOWED_NETWORK_TYPES_REASON_USER = 0;
    @SystemApi
    public static final int ALLOWED_NETWORK_TYPES_REASON_POWER = 1;
    public static final int ALLOWED_NETWORK_TYPES_REASON_CARRIER = 2;
    @SystemApi
    public static final int ALLOWED_NETWORK_TYPES_REASON_ENABLE_2G = 3;
    @SystemApi
    public static final int CARRIER_PRIVILEGE_STATUS_HAS_ACCESS = 1;
    @SystemApi
    public static final int CARRIER_PRIVILEGE_STATUS_NO_ACCESS = 0;
    @SystemApi
    public static final int CARRIER_PRIVILEGE_STATUS_RULES_NOT_LOADED = -1;
    @SystemApi
    public static final int CARRIER_PRIVILEGE_STATUS_ERROR_LOADING_RULES = -2;
    public static final int CALL_COMPOSER_STATUS_OFF = 0;
    public static final int CALL_COMPOSER_STATUS_ON = 1;
    @SystemApi
    public static final int RADIO_POWER_OFF = 0;
    @SystemApi
    public static final int RADIO_POWER_ON = 1;
    @SystemApi
    public static final int RADIO_POWER_UNAVAILABLE = 2;
    @SystemApi
    public static final int CDMA_SUBSCRIPTION_UNKNOWN = -1;
    @SystemApi
    public static final int CDMA_SUBSCRIPTION_RUIM_SIM = 0;
    @SystemApi
    public static final int CDMA_SUBSCRIPTION_NV = 1;
    public static final int CARD_POWER_DOWN = 0;
    public static final int CARD_POWER_UP = 1;
    public static final int CARD_POWER_UP_PASS_THROUGH = 2;
    @SystemApi
    public static final int SET_CARRIER_RESTRICTION_SUCCESS = 0;
    @SystemApi
    public static final int SET_CARRIER_RESTRICTION_NOT_SUPPORTED = 1;
    @SystemApi
    public static final int SET_CARRIER_RESTRICTION_ERROR = 2;
    @SystemApi
    public static final int SET_SIM_POWER_STATE_SUCCESS = 0;
    @SystemApi
    public static final int SET_SIM_POWER_STATE_ALREADY_IN_STATE = 1;
    @SystemApi
    public static final int SET_SIM_POWER_STATE_MODEM_ERROR = 2;
    @SystemApi
    public static final int SET_SIM_POWER_STATE_SIM_ERROR = 3;
    @SystemApi
    public static final int SET_SIM_POWER_STATE_NOT_SUPPORTED = 4;
    public static final int ENABLE_VONR_SUCCESS = 0;
    public static final int ENABLE_VONR_RADIO_NOT_AVAILABLE = 2;
    public static final int ENABLE_VONR_RADIO_ERROR = 3;
    public static final int ENABLE_VONR_RADIO_INVALID_STATE = 4;
    public static final int ENABLE_VONR_REQUEST_NOT_SUPPORTED = 5;
    public static final int DATA_ENABLED_REASON_UNKNOWN = -1;
    public static final int DATA_ENABLED_REASON_USER = 0;
    public static final int DATA_ENABLED_REASON_POLICY = 1;
    public static final int DATA_ENABLED_REASON_CARRIER = 2;
    public static final int DATA_ENABLED_REASON_THERMAL = 3;
    public static final int DATA_ENABLED_REASON_OVERRIDE = 4;
    public static final int INDICATION_FILTER_SIGNAL_STRENGTH = 1;
    public static final int INDICATION_FILTER_FULL_NETWORK_STATE = 2;
    public static final int INDICATION_FILTER_DATA_CALL_DORMANCY_CHANGED = 4;
    public static final int INDICATION_FILTER_LINK_CAPACITY_ESTIMATE = 8;
    public static final int INDICATION_FILTER_PHYSICAL_CHANNEL_CONFIG = 16;
    public static final long NETWORK_TYPE_BITMASK_UNKNOWN = 0L;
    public static final long NETWORK_TYPE_BITMASK_GSM = 32768L;
    public static final long NETWORK_TYPE_BITMASK_GPRS = 1L;
    public static final long NETWORK_TYPE_BITMASK_EDGE = 2L;
    public static final long NETWORK_TYPE_BITMASK_CDMA = 8L;
    @SuppressLint(value={"AllUpper"})
    public static final long NETWORK_TYPE_BITMASK_1xRTT = 64L;
    public static final long NETWORK_TYPE_BITMASK_EVDO_0 = 16L;
    public static final long NETWORK_TYPE_BITMASK_EVDO_A = 32L;
    public static final long NETWORK_TYPE_BITMASK_EVDO_B = 2048L;
    public static final long NETWORK_TYPE_BITMASK_EHRPD = 8192L;
    public static final long NETWORK_TYPE_BITMASK_HSUPA = 256L;
    public static final long NETWORK_TYPE_BITMASK_HSDPA = 128L;
    public static final long NETWORK_TYPE_BITMASK_HSPA = 512L;
    public static final long NETWORK_TYPE_BITMASK_HSPAP = 16384L;
    public static final long NETWORK_TYPE_BITMASK_UMTS = 4L;
    public static final long NETWORK_TYPE_BITMASK_TD_SCDMA = 65536L;
    public static final long NETWORK_TYPE_BITMASK_LTE = 4096L;
    public static final long NETWORK_TYPE_BITMASK_LTE_CA = 262144L;
    public static final long NETWORK_TYPE_BITMASK_NR = 524288L;
    public static final long NETWORK_TYPE_BITMASK_IWLAN = 131072L;
    public static final long NETWORK_CLASS_BITMASK_2G = 32843L;
    public static final long NETWORK_CLASS_BITMASK_3G = 93108L;
    public static final long NETWORK_CLASS_BITMASK_4G = 397312L;
    public static final long NETWORK_CLASS_BITMASK_5G = 524288L;
    public static final long NETWORK_STANDARDS_FAMILY_BITMASK_3GPP = 906119L;
    public static final long NETWORK_STANDARDS_FAMILY_BITMASK_3GPP2 = 10360L;
    @SystemApi
    public static final int INVALID_EMERGENCY_NUMBER_DB_VERSION = -1;
    public static final int SET_OPPORTUNISTIC_SUB_SUCCESS = 0;
    public static final int SET_OPPORTUNISTIC_SUB_VALIDATION_FAILED = 1;
    public static final int SET_OPPORTUNISTIC_SUB_INACTIVE_SUBSCRIPTION = 2;
    public static final int SET_OPPORTUNISTIC_SUB_NO_OPPORTUNISTIC_SUB_AVAILABLE = 3;
    public static final int SET_OPPORTUNISTIC_SUB_REMOTE_SERVICE_EXCEPTION = 4;
    public static final int UPDATE_AVAILABLE_NETWORKS_SUCCESS = 0;
    public static final int UPDATE_AVAILABLE_NETWORKS_UNKNOWN_FAILURE = 1;
    public static final int UPDATE_AVAILABLE_NETWORKS_ABORTED = 2;
    public static final int UPDATE_AVAILABLE_NETWORKS_INVALID_ARGUMENTS = 3;
    public static final int UPDATE_AVAILABLE_NETWORKS_NO_CARRIER_PRIVILEGE = 4;
    public static final int UPDATE_AVAILABLE_NETWORKS_DISABLE_MODEM_FAIL = 5;
    public static final int UPDATE_AVAILABLE_NETWORKS_ENABLE_MODEM_FAIL = 6;
    public static final int UPDATE_AVAILABLE_NETWORKS_MULTIPLE_NETWORKS_NOT_SUPPORTED = 7;
    public static final int UPDATE_AVAILABLE_NETWORKS_NO_OPPORTUNISTIC_SUB_AVAILABLE = 8;
    public static final int UPDATE_AVAILABLE_NETWORKS_REMOTE_SERVICE_EXCEPTION = 9;
    public static final int UPDATE_AVAILABLE_NETWORKS_SERVICE_IS_DISABLED = 10;
    public static final int UPDATE_AVAILABLE_NETWORKS_SIM_PORT_NOT_AVAILABLE = 11;
    public static final String ACTION_NETWORK_COUNTRY_CHANGED = "android.telephony.action.NETWORK_COUNTRY_CHANGED";
    public static final String EXTRA_NETWORK_COUNTRY = "android.telephony.extra.NETWORK_COUNTRY";
    public static final String EXTRA_LAST_KNOWN_NETWORK_COUNTRY = "android.telephony.extra.LAST_KNOWN_NETWORK_COUNTRY";
    public static final int MULTISIM_ALLOWED = 0;
    public static final int MULTISIM_NOT_SUPPORTED_BY_HARDWARE = 1;
    public static final int MULTISIM_NOT_SUPPORTED_BY_CARRIER = 2;
    @SystemApi
    public static final int CALL_WAITING_STATUS_ENABLED = 1;
    @SystemApi
    public static final int CALL_WAITING_STATUS_DISABLED = 2;
    @SystemApi
    public static final int CALL_WAITING_STATUS_UNKNOWN_ERROR = 3;
    @SystemApi
    public static final int CALL_WAITING_STATUS_NOT_SUPPORTED = 4;
    @SystemApi
    public static final int CALL_WAITING_STATUS_FDN_CHECK_FAILURE = 5;
    @SystemApi
    public static final int MOBILE_DATA_POLICY_DATA_ON_NON_DEFAULT_DURING_VOICE_CALL = 1;
    @SystemApi
    public static final int MOBILE_DATA_POLICY_MMS_ALWAYS_ALLOWED = 2;
    public static final int CHANGE_ICC_LOCK_SUCCESS = Integer.MAX_VALUE;
    @SystemApi
    public static final int ENABLE_NR_DUAL_CONNECTIVITY_SUCCESS = 0;
    @SystemApi
    public static final int ENABLE_NR_DUAL_CONNECTIVITY_NOT_SUPPORTED = 1;
    @SystemApi
    public static final int ENABLE_NR_DUAL_CONNECTIVITY_RADIO_NOT_AVAILABLE = 2;
    @SystemApi
    public static final int ENABLE_NR_DUAL_CONNECTIVITY_RADIO_ERROR = 3;
    @SystemApi
    public static final int ENABLE_NR_DUAL_CONNECTIVITY_INVALID_STATE = 4;
    @SystemApi
    public static final int NR_DUAL_CONNECTIVITY_ENABLE = 1;
    @SystemApi
    public static final int NR_DUAL_CONNECTIVITY_DISABLE = 2;
    @SystemApi
    public static final int NR_DUAL_CONNECTIVITY_DISABLE_IMMEDIATE = 3;
    @SystemApi
    public static final String CAPABILITY_SECONDARY_LINK_BANDWIDTH_VISIBLE = "CAPABILITY_SECONDARY_LINK_BANDWIDTH_VISIBLE";
    @SystemApi
    public static final String CAPABILITY_USES_ALLOWED_NETWORK_TYPES_BITMASK = "CAPABILITY_USES_ALLOWED_NETWORK_TYPES_BITMASK";
    @SystemApi
    public static final String CAPABILITY_NR_DUAL_CONNECTIVITY_CONFIGURATION_AVAILABLE = "CAPABILITY_NR_DUAL_CONNECTIVITY_CONFIGURATION_AVAILABLE";
    @SystemApi
    public static final String CAPABILITY_THERMAL_MITIGATION_DATA_THROTTLING = "CAPABILITY_THERMAL_MITIGATION_DATA_THROTTLING";
    public static final String CAPABILITY_SLICING_CONFIG_SUPPORTED = "CAPABILITY_SLICING_CONFIG_SUPPORTED";
    public static final String CAPABILITY_PHYSICAL_CHANNEL_CONFIG_1_6_SUPPORTED = "CAPABILITY_PHYSICAL_CHANNEL_CONFIG_1_6_SUPPORTED";
    public static final String CAPABILITY_SIM_PHONEBOOK_IN_MODEM = "CAPABILITY_SIM_PHONEBOOK_IN_MODEM";
    @SystemApi
    public static final int THERMAL_MITIGATION_RESULT_SUCCESS = 0;
    @SystemApi
    public static final int THERMAL_MITIGATION_RESULT_MODEM_ERROR = 1;
    @SystemApi
    public static final int THERMAL_MITIGATION_RESULT_MODEM_NOT_AVAILABLE = 2;
    @SystemApi
    public static final int THERMAL_MITIGATION_RESULT_INVALID_STATE = 3;
    @SystemApi
    public static final int THERMAL_MITIGATION_RESULT_UNKNOWN_ERROR = 4;
    public static final int INCLUDE_LOCATION_DATA_NONE = 0;
    public static final int INCLUDE_LOCATION_DATA_COARSE = 1;
    public static final int INCLUDE_LOCATION_DATA_FINE = 2;
    @SystemApi
    public static final int GBA_FAILURE_REASON_UNKNOWN = 0;
    @SystemApi
    public static final int GBA_FAILURE_REASON_FEATURE_NOT_SUPPORTED = 1;
    @SystemApi
    public static final int GBA_FAILURE_REASON_FEATURE_NOT_READY = 2;
    @SystemApi
    public static final int GBA_FAILURE_REASON_NETWORK_FAILURE = 3;
    @SystemApi
    public static final int GBA_FAILURE_REASON_INCORRECT_NAF_ID = 4;
    @SystemApi
    public static final int GBA_FAILURE_REASON_SECURITY_PROTOCOL_NOT_SUPPORTED = 5;
    @SystemApi
    public static final int PREPARE_UNATTENDED_REBOOT_SUCCESS = 0;
    @SystemApi
    public static final int PREPARE_UNATTENDED_REBOOT_PIN_REQUIRED = 1;
    @SystemApi
    public static final int PREPARE_UNATTENDED_REBOOT_ERROR = 2;
    public static final String KEY_SLICING_CONFIG_HANDLE = "slicing_config_handle";

    @UnsupportedAppUsage
    public TelephonyManager(Context context) {
        this(context, Integer.MAX_VALUE);
    }

    @UnsupportedAppUsage
    public TelephonyManager(Context context, int subId) {
        this.mSubId = subId;
        this.mContext = this.mergeAttributionAndRenouncedPermissions(context.getApplicationContext(), context);
        this.mSubscriptionManager = SubscriptionManager.from(this.mContext);
    }

    @UnsupportedAppUsage
    private TelephonyManager() {
        this.mContext = null;
        this.mSubId = -1;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=28)
    public static TelephonyManager getDefault() {
        return sInstance;
    }

    private Context mergeAttributionAndRenouncedPermissions(Context to, Context from) {
        Context contextToReturn = from;
        if (to != null) {
            contextToReturn = !Objects.equals(from.getAttributionTag(), to.getAttributionTag()) ? to.createAttributionContext(from.getAttributionTag()) : to;
            Set<String> renouncedPermissions = from.getAttributionSource().getRenouncedPermissions();
            if (!renouncedPermissions.isEmpty()) {
                contextToReturn = to.getParams() != null ? contextToReturn.createContext(new ContextParams.Builder(to.getParams()).setRenouncedPermissions(renouncedPermissions).build()) : contextToReturn.createContext(new ContextParams.Builder().setRenouncedPermissions(renouncedPermissions).build());
            }
        }
        return contextToReturn;
    }

    private String getOpPackageName() {
        if (this.mContext != null) {
            return this.mContext.getOpPackageName();
        }
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return null;
        }
        try {
            return telephony.getCurrentPackageName();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private String getAttributionTag() {
        if (this.mContext != null) {
            return this.mContext.getAttributionTag();
        }
        return null;
    }

    private Set<String> getRenouncedPermissions() {
        if (this.mContext != null) {
            return this.mContext.getAttributionSource().getRenouncedPermissions();
        }
        return Collections.emptySet();
    }

    private static void runOnBackgroundThread(Runnable r) {
        try {
            BackgroundThread.getExecutor().execute(r);
        }
        catch (RejectedExecutionException e) {
            throw new IllegalStateException("Failed to post a callback from the caller's thread context.", e);
        }
    }

    @UnsupportedAppUsage
    public MultiSimVariants getMultiSimConfiguration() {
        String mSimConfig = TelephonyProperties.multi_sim_config().orElse("");
        if (mSimConfig.equals("dsds")) {
            return MultiSimVariants.DSDS;
        }
        if (mSimConfig.equals("dsda")) {
            return MultiSimVariants.DSDA;
        }
        if (mSimConfig.equals("tsts")) {
            return MultiSimVariants.TSTS;
        }
        return MultiSimVariants.UNKNOWN;
    }

    @Deprecated
    public int getPhoneCount() {
        return this.getActiveModemCount();
    }

    public int getActiveModemCount() {
        int modemCount = 1;
        switch (this.getMultiSimConfiguration()) {
            case UNKNOWN: {
                modemCount = 1;
                if (this.isVoiceCapable() || this.isSmsCapable() || this.isDataCapable()) break;
                modemCount = 0;
                break;
            }
            case DSDS: 
            case DSDA: {
                modemCount = 2;
                break;
            }
            case TSTS: {
                modemCount = 3;
            }
        }
        return modemCount;
    }

    public int getSupportedModemCount() {
        return TelephonyProperties.max_active_modems().orElse(this.getActiveModemCount());
    }

    @SystemApi
    public int getMaxNumberOfSimultaneouslyActiveSims() {
        switch (this.getMultiSimConfiguration()) {
            case UNKNOWN: 
            case DSDS: 
            case TSTS: {
                return 1;
            }
            case DSDA: {
                return 2;
            }
        }
        return 1;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public static TelephonyManager from(Context context) {
        return (TelephonyManager)context.getSystemService("phone");
    }

    public TelephonyManager createForSubscriptionId(int subId) {
        return new TelephonyManager(this.mContext, subId);
    }

    public TelephonyManager createForPhoneAccountHandle(PhoneAccountHandle phoneAccountHandle) {
        int subId = this.getSubscriptionId(phoneAccountHandle);
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return null;
        }
        return new TelephonyManager(this.mContext, subId);
    }

    @UnsupportedAppUsage
    public boolean isMultiSimEnabled() {
        return this.getPhoneCount() > 1;
    }

    public static long getMaximumCallComposerPictureSize() {
        return 80000L;
    }

    @RequiresPermission(anyOf={"android.permission.READ_PHONE_STATE", "android.permission.READ_BASIC_PHONE_STATE"})
    public String getDeviceSoftwareVersion() {
        return this.getDeviceSoftwareVersion(this.getSlotIndex());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public String getDeviceSoftwareVersion(int slotIndex) {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return null;
        }
        try {
            return telephony.getDeviceSoftwareVersionForSlot(slotIndex, this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getDeviceId() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getDeviceIdWithFeature(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getDeviceId(int slotIndex) {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getDeviceIdForPhone(slotIndex, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getImei() {
        return this.getImei(this.getSlotIndex());
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getImei(int slotIndex) {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return null;
        }
        try {
            return telephony.getImeiForSlot(slotIndex, this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getTypeAllocationCode() {
        return this.getTypeAllocationCode(this.getSlotIndex());
    }

    public String getTypeAllocationCode(int slotIndex) {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return null;
        }
        try {
            return telephony.getTypeAllocationCodeForSlot(slotIndex);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getMeid() {
        return this.getMeid(this.getSlotIndex());
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getMeid(int slotIndex) {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return null;
        }
        try {
            String meid = telephony.getMeidForSlot(slotIndex, this.getOpPackageName(), this.getAttributionTag());
            if (TextUtils.isEmpty(meid)) {
                Log.d(TAG, "getMeid: return null because MEID is not available");
                return null;
            }
            return meid;
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getManufacturerCode() {
        return this.getManufacturerCode(this.getSlotIndex());
    }

    public String getManufacturerCode(int slotIndex) {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return null;
        }
        try {
            return telephony.getManufacturerCodeForSlot(slotIndex);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getNai() {
        return this.getNaiBySubscriberId(this.getSubId());
    }

    @UnsupportedAppUsage
    public String getNai(int slotIndex) {
        int[] subId = SubscriptionManager.getSubId(slotIndex);
        if (subId == null) {
            return null;
        }
        return this.getNaiBySubscriberId(subId[0]);
    }

    private String getNaiBySubscriberId(int subId) {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            String nai = info.getNaiForSubscriber(subId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            if (Log.isLoggable(TAG, 2)) {
                Rlog.v(TAG, "Nai = " + nai);
            }
            return nai;
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public CellLocation getCellLocation() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                Rlog.d(TAG, "getCellLocation returning null because telephony is null");
                return null;
            }
            CellIdentity cellIdentity = telephony.getCellLocation(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            CellLocation cl = cellIdentity.asCellLocation();
            if (cl == null || cl.isEmpty()) {
                Rlog.d(TAG, "getCellLocation returning null because CellLocation is empty or phone type doesn't match CellLocation type");
                return null;
            }
            return cl;
        }
        catch (RemoteException ex) {
            Rlog.d(TAG, "getCellLocation returning null due to RemoteException " + ex);
            return null;
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_COARSE_LOCATION")
    public List<NeighboringCellInfo> getNeighboringCellInfo() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getNeighboringCellInfo(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @SystemApi
    public int getCurrentPhoneType() {
        return this.getCurrentPhoneType(this.getSubId());
    }

    @SystemApi
    public int getCurrentPhoneType(int subId) {
        int phoneId = subId == -1 ? 0 : SubscriptionManager.getPhoneId(subId);
        return this.getCurrentPhoneTypeForSlot(phoneId);
    }

    public int getCurrentPhoneTypeForSlot(int slotIndex) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getActivePhoneTypeForSlot(slotIndex);
            }
            return this.getPhoneTypeFromProperty(slotIndex);
        }
        catch (RemoteException ex) {
            return this.getPhoneTypeFromProperty(slotIndex);
        }
        catch (NullPointerException ex) {
            return this.getPhoneTypeFromProperty(slotIndex);
        }
    }

    public int getPhoneType() {
        if (!this.isVoiceCapable()) {
            return 0;
        }
        return this.getCurrentPhoneType();
    }

    private int getPhoneTypeFromProperty() {
        return this.getPhoneTypeFromProperty(this.getPhoneId());
    }

    @UnsupportedAppUsage
    private int getPhoneTypeFromProperty(int phoneId) {
        Integer type = TelephonyManager.getTelephonyProperty(phoneId, TelephonyProperties.current_active_phone(), null);
        if (type != null) {
            return type;
        }
        return this.getPhoneTypeFromNetworkType(phoneId);
    }

    private int getPhoneTypeFromNetworkType() {
        return this.getPhoneTypeFromNetworkType(this.getPhoneId());
    }

    private int getPhoneTypeFromNetworkType(int phoneId) {
        Integer mode = TelephonyManager.getTelephonyProperty(phoneId, TelephonyProperties.default_network(), null);
        if (mode != null) {
            return TelephonyManager.getPhoneType(mode);
        }
        return 0;
    }

    @UnsupportedAppUsage
    public static int getPhoneType(int networkMode) {
        switch (networkMode) {
            case 4: 
            case 5: 
            case 6: {
                return 2;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                return 1;
            }
            case 7: 
            case 8: 
            case 21: {
                return 2;
            }
            case 11: {
                if (TelephonyProperties.lte_on_cdma_device().orElse(0) == 1) {
                    return 2;
                }
                return 1;
            }
        }
        return 1;
    }

    @SystemApi
    public static long getMaxNumberVerificationTimeoutMillis() {
        return 60000L;
    }

    public String getNetworkOperatorName() {
        return this.getNetworkOperatorName(this.getSubId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public String getNetworkOperatorName(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return TelephonyManager.getTelephonyProperty(phoneId, TelephonyProperties.operator_alpha(), "");
    }

    public String getNetworkOperator() {
        return this.getNetworkOperatorForPhone(this.getPhoneId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public String getNetworkOperator(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getNetworkOperatorForPhone(phoneId);
    }

    @UnsupportedAppUsage
    public String getNetworkOperatorForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, TelephonyProperties.operator_numeric(), "");
    }

    public String getNetworkSpecifier() {
        return String.valueOf(this.getSubId());
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public PersistableBundle getCarrierConfig() {
        CarrierConfigManager carrierConfigManager = this.mContext.getSystemService(CarrierConfigManager.class);
        return carrierConfigManager.getConfigForSubId(this.getSubId());
    }

    public boolean isNetworkRoaming() {
        return this.isNetworkRoaming(this.getSubId());
    }

    @UnsupportedAppUsage
    public boolean isNetworkRoaming(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return TelephonyManager.getTelephonyProperty(phoneId, TelephonyProperties.operator_is_roaming(), false);
    }

    public String getNetworkCountryIso() {
        return this.getNetworkCountryIso(this.getSlotIndex());
    }

    public String getNetworkCountryIso(int slotIndex) {
        try {
            if (slotIndex != Integer.MAX_VALUE && !SubscriptionManager.isValidSlotIndex(slotIndex)) {
                throw new IllegalArgumentException("invalid slot index " + slotIndex);
            }
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return "";
            }
            return telephony.getNetworkCountryIsoForPhone(slotIndex);
        }
        catch (RemoteException ex) {
            return "";
        }
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link #getNetworkCountryIso(int)} instead.")
    public String getNetworkCountryIsoForPhone(int phoneId) {
        return this.getNetworkCountryIso(phoneId);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static int[] getAllNetworkTypes() {
        return (int[])NETWORK_TYPES.clone();
    }

    @Deprecated
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public int getNetworkType() {
        return this.getNetworkType(this.getSubId(SubscriptionManager.getActiveDataSubscriptionId()));
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @UnsupportedAppUsage(maxTargetSdk=28)
    public int getNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getNetworkTypeForSubscriber(subId, this.getOpPackageName(), this.getAttributionTag());
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PHONE_STATE", "android.permission.READ_BASIC_PHONE_STATE"})
    public int getDataNetworkType() {
        return this.getDataNetworkType(this.getSubId(SubscriptionManager.getActiveDataSubscriptionId()));
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @UnsupportedAppUsage(maxTargetSdk=28)
    public int getDataNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getDataNetworkTypeForSubscriber(subId, this.getOpPackageName(), this.getAttributionTag());
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PHONE_STATE", "android.permission.READ_BASIC_PHONE_STATE"})
    public int getVoiceNetworkType() {
        return this.getVoiceNetworkType(this.getSubId());
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @UnsupportedAppUsage(maxTargetSdk=28)
    public int getVoiceNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVoiceNetworkTypeForSubscriber(subId, this.getOpPackageName(), this.getAttributionTag());
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    @UnsupportedAppUsage
    public String getNetworkTypeName() {
        return TelephonyManager.getNetworkTypeName(this.getNetworkType());
    }

    @UnsupportedAppUsage
    public static String getNetworkTypeName(int type) {
        switch (type) {
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 8: {
                return "HSDPA";
            }
            case 9: {
                return "HSUPA";
            }
            case 10: {
                return "HSPA";
            }
            case 4: {
                return "CDMA";
            }
            case 5: {
                return "CDMA - EvDo rev. 0";
            }
            case 6: {
                return "CDMA - EvDo rev. A";
            }
            case 12: {
                return "CDMA - EvDo rev. B";
            }
            case 7: {
                return "CDMA - 1xRTT";
            }
            case 13: {
                return "LTE";
            }
            case 14: {
                return "CDMA - eHRPD";
            }
            case 11: {
                return "iDEN";
            }
            case 15: {
                return "HSPA+";
            }
            case 16: {
                return "GSM";
            }
            case 17: {
                return "TD_SCDMA";
            }
            case 18: {
                return "IWLAN";
            }
            case 19: {
                return "LTE_CA";
            }
            case 20: {
                return "NR";
            }
            case 0: {
                return "UNKNOWN";
            }
        }
        return "UNKNOWN(" + type + ")";
    }

    public static long getBitMaskForNetworkType(int networkType) {
        switch (networkType) {
            case 16: {
                return 32768L;
            }
            case 1: {
                return 1L;
            }
            case 2: {
                return 2L;
            }
            case 4: {
                return 8L;
            }
            case 7: {
                return 64L;
            }
            case 5: {
                return 16L;
            }
            case 6: {
                return 32L;
            }
            case 12: {
                return 2048L;
            }
            case 14: {
                return 8192L;
            }
            case 9: {
                return 256L;
            }
            case 8: {
                return 128L;
            }
            case 10: {
                return 512L;
            }
            case 15: {
                return 16384L;
            }
            case 3: {
                return 4L;
            }
            case 17: {
                return 65536L;
            }
            case 13: {
                return 4096L;
            }
            case 19: {
                return 262144L;
            }
            case 20: {
                return 524288L;
            }
            case 18: {
                return 131072L;
            }
            case 11: {
                return 1024L;
            }
        }
        return 0L;
    }

    public boolean hasIccCard() {
        return this.hasIccCard(this.getSlotIndex());
    }

    @UnsupportedAppUsage
    public boolean hasIccCard(int slotIndex) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return false;
            }
            return telephony.hasIccCardUsingSlotIndex(slotIndex);
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    @SimState
    public int getSimState() {
        int simState = this.getSimStateIncludingLoaded();
        if (simState == 10) {
            simState = 5;
        }
        return simState;
    }

    @SimState
    private int getSimStateIncludingLoaded() {
        int slotIndex = this.getSlotIndex();
        if (slotIndex < 0) {
            for (int i = 0; i < this.getPhoneCount(); ++i) {
                int simState = this.getSimState(i);
                if (simState == 1) continue;
                Rlog.d(TAG, "getSimState: default sim:" + slotIndex + ", sim state for slotIndex=" + i + " is " + simState + ", return state as unknown");
                return 0;
            }
            Rlog.d(TAG, "getSimState: default sim:" + slotIndex + ", all SIMs absent, return state as absent");
            return 1;
        }
        return SubscriptionManager.getSimStateForSlotIndex(slotIndex);
    }

    @SystemApi
    @SimState
    public int getSimCardState() {
        int simState = this.getSimState();
        return this.getSimCardStateFromSimState(simState);
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    @SimState
    public int getSimCardState(int physicalSlotIndex) {
        int activePort = this.getFirstActivePortIndex(physicalSlotIndex);
        int simState = this.getSimState(this.getLogicalSlotIndex(physicalSlotIndex, activePort));
        return this.getSimCardStateFromSimState(simState);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    @SimState
    public int getSimCardState(int physicalSlotIndex, int portIndex) {
        int simState = this.getSimState(this.getLogicalSlotIndex(physicalSlotIndex, portIndex));
        return this.getSimCardStateFromSimState(simState);
    }

    @SimState
    private int getSimCardStateFromSimState(int simState) {
        switch (simState) {
            case 0: 
            case 1: 
            case 8: 
            case 9: {
                return simState;
            }
        }
        return 11;
    }

    private int getLogicalSlotIndex(int physicalSlotIndex, int portIndex) {
        UiccSlotInfo[] slotInfos = this.getUiccSlotsInfo();
        if (slotInfos != null && physicalSlotIndex >= 0 && physicalSlotIndex < slotInfos.length && slotInfos[physicalSlotIndex] != null) {
            for (UiccPortInfo portInfo : slotInfos[physicalSlotIndex].getPorts()) {
                if (portInfo.getPortIndex() != portIndex) continue;
                return portInfo.getLogicalSlotIndex();
            }
        }
        return -1;
    }

    @SystemApi
    @SimState
    public int getSimApplicationState() {
        int simState = this.getSimStateIncludingLoaded();
        return this.getSimApplicationStateFromSimState(simState);
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    @SimState
    public int getSimApplicationState(int physicalSlotIndex) {
        int activePort = this.getFirstActivePortIndex(physicalSlotIndex);
        int simState = SubscriptionManager.getSimStateForSlotIndex(this.getLogicalSlotIndex(physicalSlotIndex, activePort));
        return this.getSimApplicationStateFromSimState(simState);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    @SimState
    public int getSimApplicationState(int physicalSlotIndex, int portIndex) {
        int simState = SubscriptionManager.getSimStateForSlotIndex(this.getLogicalSlotIndex(physicalSlotIndex, portIndex));
        return this.getSimApplicationStateFromSimState(simState);
    }

    @SimState
    private int getSimApplicationStateFromSimState(int simState) {
        switch (simState) {
            case 0: 
            case 1: 
            case 8: 
            case 9: {
                return 0;
            }
            case 5: {
                return 6;
            }
        }
        return simState;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isApplicationOnUicc(int appType) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.isApplicationOnUicc(this.getSubId(), appType);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isApplicationOnUicc", e);
        }
        return false;
    }

    @SimState
    public int getSimState(int slotIndex) {
        int simState = SubscriptionManager.getSimStateForSlotIndex(slotIndex);
        if (simState == 10) {
            simState = 5;
        }
        return simState;
    }

    public String getSimOperator() {
        return this.getSimOperatorNumeric();
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public String getSimOperator(int subId) {
        return this.getSimOperatorNumeric(subId);
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public String getSimOperatorNumeric() {
        int subId = this.mSubId;
        if (!(SubscriptionManager.isUsableSubIdValue(subId) || SubscriptionManager.isUsableSubIdValue(subId = SubscriptionManager.getDefaultDataSubscriptionId()) || SubscriptionManager.isUsableSubIdValue(subId = SubscriptionManager.getDefaultSmsSubscriptionId()) || SubscriptionManager.isUsableSubIdValue(subId = SubscriptionManager.getDefaultVoiceSubscriptionId()))) {
            subId = SubscriptionManager.getDefaultSubscriptionId();
        }
        return this.getSimOperatorNumeric(subId);
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public String getSimOperatorNumeric(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getSimOperatorNumericForPhone(phoneId);
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public String getSimOperatorNumericForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, TelephonyProperties.icc_operator_numeric(), "");
    }

    public String getSimOperatorName() {
        return this.getSimOperatorNameForPhone(this.getPhoneId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public String getSimOperatorName(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getSimOperatorNameForPhone(phoneId);
    }

    @UnsupportedAppUsage
    public String getSimOperatorNameForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, TelephonyProperties.icc_operator_alpha(), "");
    }

    public String getSimCountryIso() {
        return TelephonyManager.getSimCountryIsoForPhone(this.getPhoneId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public static String getSimCountryIso(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return TelephonyManager.getSimCountryIsoForPhone(phoneId);
    }

    @UnsupportedAppUsage
    public static String getSimCountryIsoForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, TelephonyProperties.icc_operator_iso_country(), "");
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getSimSerialNumber() {
        return this.getSimSerialNumber(this.getSubId());
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    @UnsupportedAppUsage
    public String getSimSerialNumber(int subId) {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getIccSerialNumberForSubscriber(subId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isLteCdmaEvdoGsmWcdmaEnabled() {
        return this.getLteOnCdmaMode(this.getSubId()) == 1;
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    @UnsupportedAppUsage
    public int getLteOnCdmaMode(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return -1;
            }
            return telephony.getLteOnCdmaModeForSubscriber(subId, this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public int getCardIdForDefaultEuicc() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return -2;
            }
            return telephony.getCardIdForDefaultEuicc(this.mSubId, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            return -2;
        }
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public List<UiccCardInfo> getUiccCardsInfo() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                Log.e(TAG, "Error in getUiccCardsInfo: unable to connect to Telephony service.");
                return new ArrayList<UiccCardInfo>();
            }
            return telephony.getUiccCardsInfo(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in getUiccCardsInfo: " + e);
            return new ArrayList<UiccCardInfo>();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public UiccSlotInfo[] getUiccSlotsInfo() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getUiccSlotsInfo(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void refreshUiccProfile() {
        try {
            ITelephony telephony = this.getITelephony();
            telephony.refreshUiccProfile(this.mSubId);
        }
        catch (RemoteException ex) {
            Rlog.w(TAG, "RemoteException", ex);
        }
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean switchSlots(int[] physicalSlots) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return false;
            }
            return telephony.switchSlots(physicalSlots);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private static boolean isSlotMappingValid(Collection<UiccSlotMapping> slotMapping) {
        Map<Integer, List<UiccSlotMapping>> slotMappingInfo = slotMapping.stream().collect(Collectors.groupingBy(UiccSlotMapping::getLogicalSlotIndex));
        for (Map.Entry<Integer, List<UiccSlotMapping>> entry : slotMappingInfo.entrySet()) {
            List<UiccSlotMapping> logicalSlotMap = entry.getValue();
            if (logicalSlotMap.size() <= 1) continue;
            return false;
        }
        Map<List, List<UiccSlotMapping>> slotMapInfos = slotMapping.stream().collect(Collectors.groupingBy(slot -> Arrays.asList(slot.getPhysicalSlotIndex(), slot.getPortIndex())));
        for (Map.Entry<List, List<UiccSlotMapping>> entry : slotMapInfos.entrySet()) {
            List<UiccSlotMapping> portAndPhysicalSlotList = entry.getValue();
            if (portAndPhysicalSlotList.size() <= 1) continue;
            return false;
        }
        return true;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setSimSlotMapping(Collection<UiccSlotMapping> slotMapping) {
        block5: {
            try {
                ITelephony telephony = this.getITelephony();
                if (telephony != null) {
                    if (TelephonyManager.isSlotMappingValid(slotMapping)) {
                        boolean result = telephony.setSimSlotMapping(new ArrayList<UiccSlotMapping>(slotMapping));
                        if (!result) {
                            throw new IllegalStateException("setSimSlotMapping has failed");
                        }
                        break block5;
                    }
                    throw new IllegalArgumentException("Duplicate UiccSlotMapping data found");
                }
                throw new IllegalStateException("telephony service is null.");
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public Map<Integer, Integer> getLogicalToPhysicalSlotMapping() {
        HashMap<Integer, Integer> slotMapping = new HashMap<Integer, Integer>();
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                List<UiccSlotMapping> simSlotsMapping = telephony.getSlotsMapping(this.mContext.getOpPackageName());
                for (UiccSlotMapping slotMap : simSlotsMapping) {
                    slotMapping.put(slotMap.getLogicalSlotIndex(), slotMap.getPhysicalSlotIndex());
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "getSlotsMapping RemoteException", e);
        }
        return slotMapping;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public Collection<UiccSlotMapping> getSimSlotMapping() {
        List<UiccSlotMapping> slotMap;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            slotMap = telephony.getSlotsMapping(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        return slotMap;
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getSubscriberId() {
        return this.getSubscriberId(this.getSubId());
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    @UnsupportedAppUsage(maxTargetSdk=28)
    public String getSubscriberId(int subId) {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getSubscriberIdForSubscriber(subId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public ImsiEncryptionInfo getCarrierInfoForImsiEncryption(int keyType) {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                Rlog.e(TAG, "IMSI error: Subscriber Info is null");
                return null;
            }
            int subId = this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId());
            if (keyType != 1 && keyType != 2) {
                throw new IllegalArgumentException("IMSI error: Invalid key type");
            }
            ImsiEncryptionInfo imsiEncryptionInfo = info.getCarrierInfoForImsiEncryption(subId, keyType, this.mContext.getOpPackageName());
            if (imsiEncryptionInfo == null && this.isImsiEncryptionRequired(subId, keyType)) {
                Rlog.e(TAG, "IMSI error: key is required but not found");
                throw new IllegalArgumentException("IMSI error: key is required but not found");
            }
            return imsiEncryptionInfo;
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getCarrierInfoForImsiEncryption RemoteException" + ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getCarrierInfoForImsiEncryption NullPointerException" + ex);
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void resetCarrierKeysForImsiEncryption() {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                throw new RuntimeException("IMSI error: Subscriber Info is null");
            }
            int subId = this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId());
            info.resetCarrierKeysForImsiEncryption(subId, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "Telephony#getCarrierInfoForImsiEncryption RemoteException" + ex);
        }
    }

    private static boolean isKeyEnabled(int keyAvailability, int keyType) {
        int returnValue = keyAvailability >> keyType - 1 & 1;
        return returnValue == 1;
    }

    private boolean isImsiEncryptionRequired(int subId, int keyType) {
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        if (configManager == null) {
            return false;
        }
        PersistableBundle pb = configManager.getConfigForSubId(subId);
        if (pb == null) {
            return false;
        }
        int keyAvailability = pb.getInt("imsi_key_availability_int");
        return TelephonyManager.isKeyEnabled(keyAvailability, keyType);
    }

    public void setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo) {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return;
            }
            info.setCarrierInfoForImsiEncryption(this.mSubId, this.mContext.getOpPackageName(), imsiEncryptionInfo);
        }
        catch (NullPointerException ex) {
            return;
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setCarrierInfoForImsiEncryption RemoteException", ex);
            return;
        }
    }

    public void uploadCallComposerPicture(Path pictureToUpload, String contentType, Executor executor, final OutcomeReceiver<ParcelUuid, CallComposerException> callback) {
        Objects.requireNonNull(pictureToUpload);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        RoleManager rm = this.mContext.getSystemService(RoleManager.class);
        if (!rm.isRoleHeld("android.app.role.DIALER")) {
            throw new SecurityException("You must hold RoleManager.ROLE_DIALER to do this");
        }
        executor.execute(() -> {
            try {
                long size;
                if (Looper.getMainLooper().isCurrentThread()) {
                    Log.w(TAG, "Uploading call composer picture on main thread! hic sunt dracones!");
                }
                if ((size = Files.size(pictureToUpload)) > TelephonyManager.getMaximumCallComposerPictureSize()) {
                    callback.onError(new CallComposerException(2, null));
                    return;
                }
                final InputStream fileStream = Files.newInputStream(pictureToUpload, new OpenOption[0]);
                try {
                    this.uploadCallComposerPicture(fileStream, contentType, executor, new OutcomeReceiver<ParcelUuid, CallComposerException>(){

                        @Override
                        public void onResult(ParcelUuid result) {
                            try {
                                fileStream.close();
                            }
                            catch (IOException e) {
                                Log.e(TelephonyManager.TAG, "Error closing file input stream when uploading call composer pic");
                            }
                            callback.onResult(result);
                        }

                        @Override
                        public void onError(CallComposerException error) {
                            try {
                                fileStream.close();
                            }
                            catch (IOException e) {
                                Log.e(TelephonyManager.TAG, "Error closing file input stream when uploading call composer pic");
                            }
                            callback.onError(error);
                        }
                    });
                }
                catch (Exception e) {
                    Log.e(TAG, "Got exception calling into stream-version of uploadCallComposerPicture: " + e);
                    try {
                        fileStream.close();
                    }
                    catch (IOException e1) {
                        Log.e(TAG, "Error closing file input stream when uploading call composer pic");
                    }
                }
            }
            catch (IOException e) {
                Log.e(TAG, "IOException when uploading call composer pic:" + e);
                callback.onError(new CallComposerException(5, e));
            }
        });
    }

    public void uploadCallComposerPicture(InputStream pictureToUpload, String contentType, final Executor executor, final OutcomeReceiver<ParcelUuid, CallComposerException> callback) {
        ParcelFileDescriptor readFd;
        ParcelFileDescriptor writeFd;
        Objects.requireNonNull(pictureToUpload);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            throw new IllegalStateException("Telephony service not available.");
        }
        try {
            ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createReliablePipe();
            writeFd = pipe[1];
            readFd = pipe[0];
        }
        catch (IOException e) {
            executor.execute(() -> callback.onError(new CallComposerException(5, e)));
            return;
        }
        ParcelFileDescriptor.AutoCloseOutputStream output = new ParcelFileDescriptor.AutoCloseOutputStream(writeFd);
        try {
            telephony.uploadCallComposerPicture(this.getSubId(), this.mContext.getOpPackageName(), contentType, readFd, new ResultReceiver(null){

                @Override
                protected void onReceiveResult(int resultCode, Bundle result) {
                    if (resultCode != -1) {
                        executor.execute(() -> callback.onError(new CallComposerException(resultCode, null)));
                        return;
                    }
                    ParcelUuid resultUuid = (ParcelUuid)result.getParcelable(TelephonyManager.KEY_CALL_COMPOSER_PICTURE_HANDLE);
                    if (resultUuid == null) {
                        Log.e(TelephonyManager.TAG, "Got null uuid without an error while uploading call composer pic");
                        executor.execute(() -> callback.onError(new CallComposerException(0, null)));
                        return;
                    }
                    executor.execute(() -> callback.onResult(resultUuid));
                }
            });
        }
        catch (RemoteException e) {
            Log.e(TAG, "Remote exception uploading call composer pic:" + e);
            e.rethrowAsRuntimeException();
        }
        executor.execute(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public String getGroupIdLevel1() {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getGroupIdLevel1ForSubscriber(this.getSubId(), this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @UnsupportedAppUsage
    public String getGroupIdLevel1(int subId) {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getGroupIdLevel1ForSubscriber(subId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.READ_PHONE_STATE", "android.permission.READ_SMS", "android.permission.READ_PHONE_NUMBERS"})
    public String getLine1Number() {
        return this.getLine1Number(this.getSubId());
    }

    @RequiresPermission(anyOf={"android.permission.READ_PHONE_STATE", "android.permission.READ_SMS", "android.permission.READ_PHONE_NUMBERS"})
    @UnsupportedAppUsage
    public String getLine1Number(int subId) {
        String number = null;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                number = telephony.getLine1NumberForDisplay(subId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException telephony) {
        }
        catch (NullPointerException telephony) {
            // empty catch block
        }
        if (number != null) {
            return number;
        }
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getLine1NumberForSubscriber(subId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Deprecated
    public boolean setLine1NumberForDisplay(String alphaTag, String number) {
        return this.setLine1NumberForDisplay(this.getSubId(), alphaTag, number);
    }

    public boolean setLine1NumberForDisplay(int subId, String alphaTag, String number) {
        try {
            this.mSubscriptionManager.setCarrierPhoneNumber(subId, number == null ? "" : number);
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setLine1NumberForDisplayForSubscriber(subId, alphaTag, number);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public String getLine1AlphaTag() {
        return this.getLine1AlphaTag(this.getSubId());
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @UnsupportedAppUsage
    public String getLine1AlphaTag(int subId) {
        String alphaTag = null;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                alphaTag = telephony.getLine1AlphaTagForDisplay(subId, this.getOpPackageName(), this.getAttributionTag());
            }
        }
        catch (RemoteException telephony) {
        }
        catch (NullPointerException telephony) {
            // empty catch block
        }
        if (alphaTag != null) {
            return alphaTag;
        }
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getLine1AlphaTagForSubscriber(subId, this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public String[] getMergedSubscriberIds() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getMergedSubscriberIds(this.getSubId(), this.getOpPackageName(), this.getAttributionTag());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String[] getMergedImsisFromGroup() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getMergedImsisFromGroup(this.getSubId(), this.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return new String[0];
    }

    @RequiresPermission(anyOf={"android.permission.READ_PHONE_STATE", "android.permission.READ_SMS", "android.permission.READ_PHONE_NUMBERS"})
    @UnsupportedAppUsage
    public String getMsisdn() {
        return this.getMsisdn(this.getSubId());
    }

    @RequiresPermission(anyOf={"android.permission.READ_PHONE_STATE", "android.permission.READ_SMS", "android.permission.READ_PHONE_NUMBERS"})
    @UnsupportedAppUsage(maxTargetSdk=28)
    public String getMsisdn(int subId) {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getMsisdnForSubscriber(subId, this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public String getVoiceMailNumber() {
        return this.getVoiceMailNumber(this.getSubId());
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @UnsupportedAppUsage
    public String getVoiceMailNumber(int subId) {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getVoiceMailNumberForSubscriber(subId, this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public boolean setVoiceMailNumber(String alphaTag, String number) {
        return this.setVoiceMailNumber(this.getSubId(), alphaTag, number);
    }

    public boolean setVoiceMailNumber(int subId, String alphaTag, String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setVoiceMailNumber(subId, alphaTag, number);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    @SystemApi
    @Deprecated
    @SuppressLint(value={"RequiresPermission"})
    public void setVisualVoicemailEnabled(PhoneAccountHandle phoneAccountHandle, boolean enabled) {
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @SuppressLint(value={"RequiresPermission"})
    public boolean isVisualVoicemailEnabled(PhoneAccountHandle phoneAccountHandle) {
        return false;
    }

    @SystemApi
    @SuppressLint(value={"RequiresPermission"})
    public Bundle getVisualVoicemailSettings() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVisualVoicemailSettings(this.mContext.getOpPackageName(), this.mSubId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public String getVisualVoicemailPackageName() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVisualVoicemailPackageName(this.mContext.getOpPackageName(), this.getAttributionTag(), this.getSubId());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public void setVisualVoicemailSmsFilterSettings(VisualVoicemailSmsFilterSettings settings) {
        if (settings == null) {
            this.disableVisualVoicemailSmsFilter(this.mSubId);
        } else {
            this.enableVisualVoicemailSmsFilter(this.mSubId, settings);
        }
    }

    public void sendVisualVoicemailSms(String number, int port, String text, PendingIntent sentIntent) {
        this.sendVisualVoicemailSmsForSubscriber(this.mSubId, number, port, text, sentIntent);
    }

    public void enableVisualVoicemailSmsFilter(int subId, VisualVoicemailSmsFilterSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("Settings cannot be null");
        }
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.enableVisualVoicemailSmsFilter(this.mContext.getOpPackageName(), subId, settings);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void disableVisualVoicemailSmsFilter(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.disableVisualVoicemailSmsFilter(this.mContext.getOpPackageName(), subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public VisualVoicemailSmsFilterSettings getVisualVoicemailSmsFilterSettings(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVisualVoicemailSmsFilterSettings(this.mContext.getOpPackageName(), subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public VisualVoicemailSmsFilterSettings getActiveVisualVoicemailSmsFilterSettings(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getActiveVisualVoicemailSmsFilterSettings(subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @RequiresPermission(value="android.permission.SEND_SMS")
    public void sendVisualVoicemailSmsForSubscriber(int subId, String number, int port, String text, PendingIntent sentIntent) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.sendVisualVoicemailSmsForSubscriber(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), subId, number, port, text, sentIntent);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setVoiceActivationState(int activationState) {
        this.setVoiceActivationState(this.getSubId(), activationState);
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setVoiceActivationState(int subId, int activationState) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setVoiceActivationState(subId, activationState);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setDataActivationState(int activationState) {
        this.setDataActivationState(this.getSubId(), activationState);
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setDataActivationState(int subId, int activationState) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setDataActivationState(subId, activationState);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getVoiceActivationState() {
        return this.getVoiceActivationState(this.getSubId());
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getVoiceActivationState(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVoiceActivationState(subId, this.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getDataActivationState() {
        return this.getDataActivationState(this.getSubId());
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getDataActivationState(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getDataActivationState(subId, this.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @UnsupportedAppUsage
    public int getVoiceMessageCount() {
        return this.getVoiceMessageCount(this.getSubId());
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @UnsupportedAppUsage
    public int getVoiceMessageCount(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            return telephony.getVoiceMessageCountForSubscriber(subId, this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public String getVoiceMailAlphaTag() {
        return this.getVoiceMailAlphaTag(this.getSubId());
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @UnsupportedAppUsage
    public String getVoiceMailAlphaTag(int subId) {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getVoiceMailAlphaTagForSubscriber(subId, this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public void sendDialerSpecialCode(String inputCode) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return;
            }
            telephony.sendDialerSpecialCode(this.mContext.getOpPackageName(), inputCode);
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "Telephony#sendDialerSpecialCode RemoteException" + ex);
        }
    }

    @UnsupportedAppUsage
    public String getIsimImpi() {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getIsimImpi(this.getSubId());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getIsimDomain() {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getIsimDomain(this.getSubId());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String[] getIsimImpu() {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getIsimImpu(this.getSubId());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.READ_PHONE_STATE", conditional=true)
    public int getCallState() {
        TelecomManager telecomManager;
        if (this.mContext != null && (telecomManager = this.mContext.getSystemService(TelecomManager.class)) != null) {
            return telecomManager.getCallState();
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public int getCallStateForSubscription() {
        return this.getCallState(this.getSubId());
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.READ_PHONE_STATE", conditional=true)
    public int getCallState(int subId) {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return 0;
        }
        try {
            return telephony.getCallStateForSubscription(subId, this.mContext.getPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    @UnsupportedAppUsage
    private IPhoneSubInfo getSubscriberInfo() {
        return TelephonyManager.getSubscriberInfoService();
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE", conditional=true)
    public int getCallStateForSlot(int slotIndex) {
        try {
            int[] subId = SubscriptionManager.getSubId(slotIndex);
            ITelephony telephony = this.getITelephony();
            if (telephony == null || subId == null || subId.length == 0) {
                return 0;
            }
            return telephony.getCallStateForSubscription(subId[0], this.mContext.getPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException | NullPointerException ex) {
            return 0;
        }
    }

    public int getDataActivity() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            return telephony.getDataActivityForSubId(this.getSubId(SubscriptionManager.getActiveDataSubscriptionId()));
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getDataState() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            int state = telephony.getDataStateForSubId(this.getSubId(SubscriptionManager.getActiveDataSubscriptionId()));
            if (state == 4 && !Compatibility.isChangeEnabled(148534348L)) {
                return 2;
            }
            return state;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28)
    private ITelephony getITelephony() {
        if (!sServiceHandleCacheEnabled) {
            return ITelephony.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyServiceRegisterer().get());
        }
        if (sITelephony == null) {
            ITelephony temp = ITelephony.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyServiceRegisterer().get());
            Object object = sCacheLock;
            synchronized (object) {
                if (sITelephony == null && temp != null) {
                    try {
                        sITelephony = temp;
                        sITelephony.asBinder().linkToDeath(sServiceDeath, 0);
                    }
                    catch (Exception e) {
                        sITelephony = null;
                    }
                }
            }
        }
        return sITelephony;
    }

    private IOns getIOns() {
        return IOns.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getOpportunisticNetworkServiceRegisterer().get());
    }

    @Deprecated
    public void listen(PhoneStateListener listener, int events) {
        if (this.mContext == null) {
            return;
        }
        boolean notifyNow = this.getITelephony() != null;
        TelephonyRegistryManager telephonyRegistry = (TelephonyRegistryManager)this.mContext.getSystemService("telephony_registry");
        if (telephonyRegistry != null) {
            Set<String> renouncedPermissions = this.getRenouncedPermissions();
            boolean renounceFineLocationAccess = renouncedPermissions.contains("android.permission.ACCESS_FINE_LOCATION");
            boolean renounceCoarseLocationAccess = renouncedPermissions.contains("android.permission.ACCESS_COARSE_LOCATION");
            telephonyRegistry.listenFromListener(this.mSubId, renounceFineLocationAccess, renounceCoarseLocationAccess, this.getOpPackageName(), this.getAttributionTag(), listener, events, notifyNow);
        } else {
            Rlog.w(TAG, "telephony registry not ready.");
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getCdmaEnhancedRoamingIndicatorDisplayNumber() {
        return this.getCdmaEriIconIndex(this.getSubId());
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    @UnsupportedAppUsage
    public int getCdmaEriIconIndex(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return -1;
            }
            return telephony.getCdmaEriIconIndexForSubscriber(subId, this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    @UnsupportedAppUsage
    public int getCdmaEriIconMode(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return -1;
            }
            return telephony.getCdmaEriIconModeForSubscriber(subId, this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public String getCdmaEriText() {
        return this.getCdmaEriText(this.getSubId());
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @UnsupportedAppUsage
    public String getCdmaEriText(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getCdmaEriTextForSubscriber(subId, this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public boolean isVoiceCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(0x11101F1);
    }

    public boolean isSmsCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(0x11101B0);
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public List<CellInfo> getAllCellInfo() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getAllCellInfo(this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public void requestCellInfoUpdate(final Executor executor, final CellInfoCallback callback) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                if (Compatibility.isChangeEnabled(182185642L)) {
                    throw new IllegalStateException("Telephony is null");
                }
                return;
            }
            telephony.requestCellInfoUpdate(this.getSubId(), new ICellInfoCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCellInfo(List<CellInfo> cellInfo) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onCellInfo(cellInfo));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onError(int errorCode, String exceptionName, String message) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onError(errorCode, TelephonyManager.createThrowableByClassName(exceptionName, message)));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            }, this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            TelephonyManager.runOnBackgroundThread(() -> executor.execute(() -> callback.onError(2, ex)));
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.MODIFY_PHONE_STATE"})
    public void requestCellInfoUpdate(WorkSource workSource, final Executor executor, final CellInfoCallback callback) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                if (Compatibility.isChangeEnabled(182185642L)) {
                    throw new IllegalStateException("Telephony is null");
                }
                return;
            }
            telephony.requestCellInfoUpdateWithWorkSource(this.getSubId(), new ICellInfoCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCellInfo(List<CellInfo> cellInfo) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onCellInfo(cellInfo));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onError(int errorCode, String exceptionName, String message) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onError(errorCode, TelephonyManager.createThrowableByClassName(exceptionName, message)));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            }, this.getOpPackageName(), this.getAttributionTag(), workSource);
        }
        catch (RemoteException ex) {
            TelephonyManager.runOnBackgroundThread(() -> executor.execute(() -> callback.onError(2, ex)));
        }
    }

    private static Throwable createThrowableByClassName(String className, String message) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(className);
            return (Throwable)c.getConstructor(String.class).newInstance(message);
        }
        catch (ClassCastException | ReflectiveOperationException exception) {
            return new RuntimeException(className + ": " + message);
        }
    }

    public void setCellInfoListRate(int rateInMillis) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setCellInfoListRate(rateInMillis);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String getMmsUserAgent() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getMmsUserAgent(this.getSubId());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public String getMmsUAProfUrl() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getMmsUAProfUrl(this.getSubId());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private int getFirstActivePortIndex(int physicalSlotIndex) {
        Optional<UiccPortInfo> result;
        UiccSlotInfo[] slotInfos = this.getUiccSlotsInfo();
        if (slotInfos != null && physicalSlotIndex >= 0 && physicalSlotIndex < slotInfos.length && slotInfos[physicalSlotIndex] != null && (result = slotInfos[physicalSlotIndex].getPorts().stream().filter(portInfo -> portInfo.isActive()).findFirst()).isPresent()) {
            return result.get().getPortIndex();
        }
        return -1;
    }

    @Deprecated
    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(String AID) {
        return this.iccOpenLogicalChannel(this.getSubId(), AID, -1);
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public IccOpenLogicalChannelResponse iccOpenLogicalChannelBySlot(int slotIndex, String aid, int p2) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                IccLogicalChannelRequest request = new IccLogicalChannelRequest();
                request.slotIndex = slotIndex;
                request.portIndex = this.getFirstActivePortIndex(slotIndex);
                request.aid = aid;
                request.p2 = p2;
                request.callingPackage = this.getOpPackageName();
                request.binder = new Binder();
                return telephony.iccOpenLogicalChannel(request);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public IccOpenLogicalChannelResponse iccOpenLogicalChannelByPort(int slotIndex, int portIndex, String aid, int p2) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                IccLogicalChannelRequest request = new IccLogicalChannelRequest();
                request.slotIndex = slotIndex;
                request.portIndex = portIndex;
                request.aid = aid;
                request.p2 = p2;
                request.callingPackage = this.getOpPackageName();
                request.binder = new Binder();
                return telephony.iccOpenLogicalChannel(request);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            throw ex.rethrowAsRuntimeException();
        }
    }

    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(String AID, int p2) {
        return this.iccOpenLogicalChannel(this.getSubId(), AID, p2);
    }

    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(int subId, String AID, int p2) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                IccLogicalChannelRequest request = new IccLogicalChannelRequest();
                request.subId = subId;
                request.callingPackage = this.getOpPackageName();
                request.aid = AID;
                request.p2 = p2;
                request.binder = new Binder();
                return telephony.iccOpenLogicalChannel(request);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean iccCloseLogicalChannelBySlot(int slotIndex, int channel) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                IccLogicalChannelRequest request = new IccLogicalChannelRequest();
                request.slotIndex = slotIndex;
                request.portIndex = this.getFirstActivePortIndex(slotIndex);
                request.channel = channel;
                return telephony.iccCloseLogicalChannel(request);
            }
        }
        catch (RemoteException telephony) {
        }
        catch (NullPointerException telephony) {
        }
        catch (IllegalStateException ex) {
            Rlog.e(TAG, "iccCloseLogicalChannel IllegalStateException", ex);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void iccCloseLogicalChannelByPort(int slotIndex, int portIndex, int channel) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            IccLogicalChannelRequest request = new IccLogicalChannelRequest();
            request.slotIndex = slotIndex;
            request.portIndex = portIndex;
            request.channel = channel;
            telephony.iccCloseLogicalChannel(request);
        }
        catch (RemoteException ex) {
            throw ex.rethrowAsRuntimeException();
        }
    }

    public boolean iccCloseLogicalChannel(int channel) {
        try {
            return this.iccCloseLogicalChannel(this.getSubId(), channel);
        }
        catch (IllegalStateException ex) {
            Rlog.e(TAG, "iccCloseLogicalChannel IllegalStateException", ex);
            return false;
        }
    }

    public boolean iccCloseLogicalChannel(int subId, int channel) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                IccLogicalChannelRequest request = new IccLogicalChannelRequest();
                request.subId = subId;
                request.channel = channel;
                return telephony.iccCloseLogicalChannel(request);
            }
        }
        catch (RemoteException telephony) {
        }
        catch (NullPointerException telephony) {
        }
        catch (IllegalStateException ex) {
            Rlog.e(TAG, "iccCloseLogicalChannel IllegalStateException", ex);
        }
        return false;
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public String iccTransmitApduLogicalChannelBySlot(int slotIndex, int channel, int cla, int instruction, int p1, int p2, int p3, String data) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccTransmitApduLogicalChannelByPort(slotIndex, this.getFirstActivePortIndex(slotIndex), channel, cla, instruction, p1, p2, p3, data);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public String iccTransmitApduLogicalChannelByPort(int slotIndex, int portIndex, int channel, int cla, int instruction, int p1, int p2, int p3, String data) {
        String response;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            response = telephony.iccTransmitApduLogicalChannelByPort(slotIndex, portIndex, channel, cla, instruction, p1, p2, p3, data);
        }
        catch (RemoteException ex) {
            throw ex.rethrowAsRuntimeException();
        }
        return response;
    }

    public String iccTransmitApduLogicalChannel(int channel, int cla, int instruction, int p1, int p2, int p3, String data) {
        return this.iccTransmitApduLogicalChannel(this.getSubId(), channel, cla, instruction, p1, p2, p3, data);
    }

    public String iccTransmitApduLogicalChannel(int subId, int channel, int cla, int instruction, int p1, int p2, int p3, String data) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccTransmitApduLogicalChannel(subId, channel, cla, instruction, p1, p2, p3, data);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public String iccTransmitApduBasicChannelBySlot(int slotIndex, int cla, int instruction, int p1, int p2, int p3, String data) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccTransmitApduBasicChannelByPort(slotIndex, this.getFirstActivePortIndex(slotIndex), this.getOpPackageName(), cla, instruction, p1, p2, p3, data);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public String iccTransmitApduBasicChannelByPort(int slotIndex, int portIndex, int cla, int instruction, int p1, int p2, int p3, String data) {
        String response;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            response = telephony.iccTransmitApduBasicChannelByPort(slotIndex, portIndex, this.getOpPackageName(), cla, instruction, p1, p2, p3, data);
        }
        catch (RemoteException ex) {
            throw ex.rethrowAsRuntimeException();
        }
        return response;
    }

    public String iccTransmitApduBasicChannel(int cla, int instruction, int p1, int p2, int p3, String data) {
        return this.iccTransmitApduBasicChannel(this.getSubId(), cla, instruction, p1, p2, p3, data);
    }

    public String iccTransmitApduBasicChannel(int subId, int cla, int instruction, int p1, int p2, int p3, String data) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccTransmitApduBasicChannel(subId, this.getOpPackageName(), cla, instruction, p1, p2, p3, data);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    public byte[] iccExchangeSimIO(int fileID, int command, int p1, int p2, int p3, String filePath) {
        return this.iccExchangeSimIO(this.getSubId(), fileID, command, p1, p2, p3, filePath);
    }

    public byte[] iccExchangeSimIO(int subId, int fileID, int command, int p1, int p2, int p3, String filePath) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccExchangeSimIO(subId, fileID, command, p1, p2, p3, filePath);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public String sendEnvelopeWithStatus(String content) {
        return this.sendEnvelopeWithStatus(this.getSubId(), content);
    }

    public String sendEnvelopeWithStatus(int subId, String content) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.sendEnvelopeWithStatus(subId, content);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    @UnsupportedAppUsage
    public String nvReadItem(int itemID) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvReadItem(itemID);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvReadItem RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvReadItem NPE", ex);
        }
        return "";
    }

    public boolean nvWriteItem(int itemID, String itemValue) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvWriteItem(itemID, itemValue);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvWriteItem RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvWriteItem NPE", ex);
        }
        return false;
    }

    public boolean nvWriteCdmaPrl(byte[] preferredRoamingList) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvWriteCdmaPrl(preferredRoamingList);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvWriteCdmaPrl RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvWriteCdmaPrl NPE", ex);
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean nvResetConfig(int resetType) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                if (resetType == 1) {
                    return telephony.rebootModem(this.getSlotIndex());
                }
                if (resetType == 3) {
                    return telephony.resetModemConfig(this.getSlotIndex());
                }
                Rlog.e(TAG, "nvResetConfig unsupported reset type");
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvResetConfig RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvResetConfig NPE", ex);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean resetRadioConfig() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.resetModemConfig(this.getSlotIndex());
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "resetRadioConfig RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "resetRadioConfig NPE", ex);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean rebootRadio() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.rebootModem(this.getSlotIndex());
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "rebootRadio RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "rebootRadio NPE", ex);
        }
        return false;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void rebootModem() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            telephony.rebootModem(this.getSlotIndex());
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "rebootRadio RemoteException", ex);
            throw ex.rethrowAsRuntimeException();
        }
    }

    public int getSubscriptionId() {
        return this.getSubId();
    }

    private int getSubId() {
        if (SubscriptionManager.isUsableSubIdValue(this.mSubId)) {
            return this.mSubId;
        }
        return SubscriptionManager.getDefaultSubscriptionId();
    }

    @UnsupportedAppUsage
    private int getSubId(int preferredSubId) {
        if (SubscriptionManager.isUsableSubIdValue(this.mSubId)) {
            return this.mSubId;
        }
        return preferredSubId;
    }

    private int getPhoneId() {
        return SubscriptionManager.getPhoneId(this.getSubId());
    }

    @UnsupportedAppUsage
    private int getPhoneId(int preferredSubId) {
        return SubscriptionManager.getPhoneId(this.getSubId(preferredSubId));
    }

    @VisibleForTesting
    @UnsupportedAppUsage
    public int getSlotIndex() {
        int slotIndex = SubscriptionManager.getSlotIndex(this.getSubId());
        if (slotIndex == -1) {
            slotIndex = Integer.MAX_VALUE;
        }
        return slotIndex;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void requestNumberVerification(PhoneNumberRange range, long timeoutMillis, final Executor executor, final NumberVerificationCallback callback) {
        if (executor == null) {
            throw new NullPointerException("Executor must be non-null");
        }
        if (callback == null) {
            throw new NullPointerException("Callback must be non-null");
        }
        INumberVerificationCallback.Stub internalCallback = new INumberVerificationCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallReceived(String phoneNumber) {
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callback.onCallReceived(phoneNumber));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVerificationFailed(int reason) {
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callback.onVerificationFailed(reason));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        };
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                if (Compatibility.isChangeEnabled(182185642L)) {
                    throw new IllegalStateException("Telephony is null");
                }
                return;
            }
            telephony.requestNumberVerification(range, timeoutMillis, internalCallback, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "requestNumberVerification RemoteException", ex);
            TelephonyManager.runOnBackgroundThread(() -> executor.execute(() -> callback.onVerificationFailed(0)));
        }
    }

    private static <T> List<T> updateTelephonyProperty(List<T> prop, int phoneId, T value) {
        ArrayList<T> ret = new ArrayList<T>(prop);
        while (ret.size() <= phoneId) {
            ret.add(null);
        }
        ret.set(phoneId, value);
        return ret;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int getIntAtIndex(ContentResolver cr, String name, int index) throws Settings.SettingNotFoundException {
        String v = Settings.Global.getString(cr, name);
        if (v != null) {
            String[] valArray = v.split(",");
            if (index >= 0 && index < valArray.length && valArray[index] != null) {
                try {
                    return Integer.parseInt(valArray[index]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new Settings.SettingNotFoundException(name);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static boolean putIntAtIndex(ContentResolver cr, String name, int index, int value) {
        int i;
        String data = "";
        String[] valArray = null;
        String v = Settings.Global.getString(cr, name);
        if (index == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("putIntAtIndex index == MAX_VALUE index=" + index);
        }
        if (index < 0) {
            throw new IllegalArgumentException("putIntAtIndex index < 0 index=" + index);
        }
        if (v != null) {
            valArray = v.split(",");
        }
        for (i = 0; i < index; ++i) {
            String str = "";
            if (valArray != null && i < valArray.length) {
                str = valArray[i];
            }
            data = data + str + ",";
        }
        data = data + value;
        if (valArray != null) {
            for (i = index + 1; i < valArray.length; ++i) {
                data = data + "," + valArray[i];
            }
        }
        return Settings.Global.putString(cr, name, data);
    }

    @UnsupportedAppUsage
    public static String getTelephonyProperty(int phoneId, String property, String defaultVal) {
        String propVal = null;
        String prop = SystemProperties.get(property);
        if (prop != null && prop.length() > 0) {
            String[] values = prop.split(",");
            if (phoneId >= 0 && phoneId < values.length && values[phoneId] != null) {
                propVal = values[phoneId];
            }
        }
        return propVal == null ? defaultVal : propVal;
    }

    private static <T> T getTelephonyProperty(int phoneId, List<T> prop, T defaultValue) {
        T ret = null;
        if (phoneId >= 0 && phoneId < prop.size()) {
            ret = prop.get(phoneId);
        }
        return ret != null ? ret : (T)defaultValue;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static String getTelephonyProperty(String property, String defaultVal) {
        String propVal = SystemProperties.get(property);
        return TextUtils.isEmpty(propVal) ? defaultVal : propVal;
    }

    @UnsupportedAppUsage
    public int getSimCount() {
        return this.getPhoneCount();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getIsimIst() {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getIsimIst(this.getSubId());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @UnsupportedAppUsage
    public String[] getIsimPcscf() {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getIsimPcscf(this.getSubId());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIccAuthentication(int appType, int authType, String data) {
        return this.getIccAuthentication(this.getSubId(), appType, authType, data);
    }

    @UnsupportedAppUsage
    public String getIccAuthentication(int subId, int appType, int authType, String data) {
        try {
            IPhoneSubInfo info = TelephonyManager.getSubscriberInfoService();
            if (info == null) {
                return null;
            }
            return info.getIccSimChallengeResponse(subId, appType, authType, data, this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public String[] getForbiddenPlmns() {
        return this.getForbiddenPlmns(this.getSubId(), 2);
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public String[] getForbiddenPlmns(int subId, int appType) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getForbiddenPlmns(subId, appType, this.mContext.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public int setForbiddenPlmns(List<String> fplmns) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return -1;
            }
            return telephony.setForbiddenPlmns(this.getSubId(), 2, fplmns, this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setForbiddenPlmns RemoteException: " + ex.getMessage());
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setForbiddenPlmns NullPointerException: " + ex.getMessage());
        }
        return -1;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void resetIms(int slotIndex) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.resetIms(slotIndex);
            }
        }
        catch (RemoteException e) {
            Rlog.e(TAG, "toggleImsOnOff, RemoteException: " + e.getMessage());
        }
    }

    public void enableIms(int slotId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.enableIms(slotId);
            }
        }
        catch (RemoteException e) {
            Rlog.e(TAG, "enableIms, RemoteException: " + e.getMessage());
        }
    }

    public void disableIms(int slotId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.disableIms(slotId);
            }
        }
        catch (RemoteException e) {
            Rlog.e(TAG, "disableIms, RemoteException: " + e.getMessage());
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public IImsRegistration getImsRegistration(int slotIndex, int feature) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getImsRegistration(slotIndex, feature);
            }
        }
        catch (RemoteException e) {
            Rlog.e(TAG, "getImsRegistration, RemoteException: " + e.getMessage());
        }
        return null;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public IImsConfig getImsConfig(int slotIndex, int feature) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getImsConfig(slotIndex, feature);
            }
        }
        catch (RemoteException e) {
            Rlog.e(TAG, "getImsRegistration, RemoteException: " + e.getMessage());
        }
        return null;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setImsRegistrationState(boolean registered) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setImsRegistrationState(registered);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    @UnsupportedAppUsage
    public int getPreferredNetworkType(int subId) {
        return RadioAccessFamily.getNetworkTypeFromRaf((int)this.getAllowedNetworkTypesBitmask());
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public long getPreferredNetworkTypeBitmask() {
        return this.getAllowedNetworkTypesBitmask();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public long getAllowedNetworkTypesBitmask() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getAllowedNetworkTypesBitmask(this.getSubId());
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getAllowedNetworkTypesBitmask RemoteException", ex);
        }
        return 0L;
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public long getAllowedNetworkTypes() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getAllowedNetworkTypesForReason(this.getSubId(), 2);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getAllowedNetworkTypes RemoteException", ex);
        }
        return -1L;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setNetworkSelectionModeAutomatic() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setNetworkSelectionModeAutomatic(this.getSubId());
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setNetworkSelectionModeAutomatic RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setNetworkSelectionModeAutomatic NPE", ex);
        }
    }

    @RequiresPermission(allOf={"android.permission.MODIFY_PHONE_STATE", "android.permission.ACCESS_COARSE_LOCATION"})
    public CellNetworkScanResult getAvailableNetworks() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCellNetworkScanResults(this.getSubId(), this.getOpPackageName(), this.getAttributionTag());
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getAvailableNetworks RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getAvailableNetworks NPE", ex);
        }
        return new CellNetworkScanResult(4, null);
    }

    @RequiresPermission(allOf={"android.permission.MODIFY_PHONE_STATE", "android.permission.ACCESS_FINE_LOCATION"})
    public NetworkScan requestNetworkScan(NetworkScanRequest request, Executor executor, TelephonyScanManager.NetworkScanCallback callback) {
        return this.requestNetworkScan(2, request, executor, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.MODIFY_PHONE_STATE", "android.permission.ACCESS_FINE_LOCATION"})
    public NetworkScan requestNetworkScan(int includeLocationData, NetworkScanRequest request, Executor executor, TelephonyScanManager.NetworkScanCallback callback) {
        Object object = sCacheLock;
        synchronized (object) {
            if (this.mTelephonyScanManager == null) {
                this.mTelephonyScanManager = new TelephonyScanManager();
            }
        }
        return this.mTelephonyScanManager.requestNetworkScan(this.getSubId(), includeLocationData != 2, request, executor, callback, this.getOpPackageName(), this.getAttributionTag());
    }

    @Deprecated
    @RequiresPermission(allOf={"android.permission.MODIFY_PHONE_STATE", "android.permission.ACCESS_FINE_LOCATION"})
    public NetworkScan requestNetworkScan(NetworkScanRequest request, TelephonyScanManager.NetworkScanCallback callback) {
        return this.requestNetworkScan(request, AsyncTask.SERIAL_EXECUTOR, callback);
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean setNetworkSelectionModeManual(String operatorNumeric, boolean persistSelection) {
        return this.setNetworkSelectionModeManual(new OperatorInfo("", "", operatorNumeric), persistSelection);
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean setNetworkSelectionModeManual(String operatorNumeric, boolean persistSelection, int ran) {
        return this.setNetworkSelectionModeManual(new OperatorInfo("", "", operatorNumeric, ran), persistSelection);
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean setNetworkSelectionModeManual(OperatorInfo operatorInfo, boolean persistSelection) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setNetworkSelectionModeManual(this.getSubId(), operatorInfo, persistSelection);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setNetworkSelectionModeManual RemoteException", ex);
        }
        return false;
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    public int getNetworkSelectionMode() {
        int mode = 0;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                mode = telephony.getNetworkSelectionMode(this.getSubId());
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getNetworkSelectionMode RemoteException", ex);
        }
        return mode;
    }

    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public String getManualNetworkSelectionPlmn() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null && this.isManualNetworkSelectionAllowed()) {
                return telephony.getManualNetworkSelectionPlmn(this.getSubId());
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getManualNetworkSelectionPlmn RemoteException", ex);
        }
        return "";
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isInEmergencySmsMode() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isInEmergencySmsMode();
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "isInEmergencySmsMode RemoteException", ex);
        }
        return false;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean setPreferredNetworkType(int subId, int networkType) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setAllowedNetworkTypesForReason(subId, 0, RadioAccessFamily.getRafFromNetworkType(networkType));
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setPreferredNetworkType RemoteException", ex);
        }
        return false;
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean setPreferredNetworkTypeBitmask(long networkTypeBitmask) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                networkTypeBitmask = this.checkNetworkTypeBitmask(networkTypeBitmask);
                return telephony.setAllowedNetworkTypesForReason(this.getSubId(), 0, networkTypeBitmask);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setPreferredNetworkTypeBitmask RemoteException", ex);
        }
        return false;
    }

    private long checkNetworkTypeBitmask(long networkTypeBitmask) {
        if ((networkTypeBitmask & 0x40000L) != 0L) {
            networkTypeBitmask ^= 0x40000L;
            networkTypeBitmask |= 0x1000L;
        }
        return networkTypeBitmask;
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean setAllowedNetworkTypes(long allowedNetworkTypes) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                allowedNetworkTypes = this.checkNetworkTypeBitmask(allowedNetworkTypes);
                return telephony.setAllowedNetworkTypesForReason(this.getSubId(), 2, allowedNetworkTypes);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setAllowedNetworkTypes RemoteException", ex);
        }
        return false;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setAllowedNetworkTypesForReason(int reason, long allowedNetworkTypes) {
        if (!TelephonyManager.isValidAllowedNetworkTypesReason(reason)) {
            throw new IllegalArgumentException("invalid AllowedNetworkTypesReason.");
        }
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            allowedNetworkTypes = this.checkNetworkTypeBitmask(allowedNetworkTypes);
            telephony.setAllowedNetworkTypesForReason(this.getSubId(), reason, allowedNetworkTypes);
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setAllowedNetworkTypesForReason RemoteException", ex);
            ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public long getAllowedNetworkTypesForReason(int reason) {
        if (!TelephonyManager.isValidAllowedNetworkTypesReason(reason)) {
            throw new IllegalArgumentException("invalid AllowedNetworkTypesReason.");
        }
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getAllowedNetworkTypesForReason(this.getSubId(), reason);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getAllowedNetworkTypesForReason RemoteException", ex);
            ex.rethrowFromSystemServer();
            return -1L;
        }
    }

    public static boolean isValidAllowedNetworkTypesReason(int reason) {
        switch (reason) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static long getAllNetworkTypesBitmask() {
        return 916479L;
    }

    public static String convertNetworkTypeBitmaskToString(long networkTypeBitmask) {
        String networkTypeName = IntStream.rangeClosed(1, 20).filter(x -> (networkTypeBitmask & TelephonyManager.getBitMaskForNetworkType(x)) == TelephonyManager.getBitMaskForNetworkType(x)).mapToObj(x -> TelephonyManager.getNetworkTypeName(x)).collect(Collectors.joining("|"));
        return TextUtils.isEmpty(networkTypeName) ? "UNKNOWN" : networkTypeName;
    }

    public boolean setPreferredNetworkTypeToGlobal() {
        return this.setPreferredNetworkTypeToGlobal(this.getSubId());
    }

    public boolean setPreferredNetworkTypeToGlobal(int subId) {
        return this.setPreferredNetworkType(subId, 27);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean isTetheringApnRequired() {
        return this.isTetheringApnRequired(this.getSubId(SubscriptionManager.getActiveDataSubscriptionId()));
    }

    public boolean isTetheringApnRequired(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isTetheringApnRequiredForSubscriber(subId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "hasMatchedTetherApnSetting RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "hasMatchedTetherApnSetting NPE", ex);
        }
        return false;
    }

    public boolean hasCarrierPrivileges() {
        return this.hasCarrierPrivileges(this.getSubId());
    }

    public boolean hasCarrierPrivileges(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCarrierPrivilegeStatus(subId) == 1;
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "hasCarrierPrivileges RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "hasCarrierPrivileges NPE", ex);
        }
        return false;
    }

    public boolean setOperatorBrandOverride(String brand) {
        return this.setOperatorBrandOverride(this.getSubId(), brand);
    }

    public boolean setOperatorBrandOverride(int subId, String brand) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setOperatorBrandOverride(subId, brand);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setOperatorBrandOverride RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setOperatorBrandOverride NPE", ex);
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean setRoamingOverride(List<String> gsmRoamingList, List<String> gsmNonRoamingList, List<String> cdmaRoamingList, List<String> cdmaNonRoamingList) {
        return this.setRoamingOverride(this.getSubId(), gsmRoamingList, gsmNonRoamingList, cdmaRoamingList, cdmaNonRoamingList);
    }

    public boolean setRoamingOverride(int subId, List<String> gsmRoamingList, List<String> gsmNonRoamingList, List<String> cdmaRoamingList, List<String> cdmaNonRoamingList) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setRoamingOverride(subId, gsmRoamingList, gsmNonRoamingList, cdmaRoamingList, cdmaNonRoamingList);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setRoamingOverride RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setRoamingOverride NPE", ex);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public String getCdmaMdn() {
        return this.getCdmaMdn(this.getSubId());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public String getCdmaMdn(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getCdmaMdn(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public String getCdmaMin() {
        return this.getCdmaMin(this.getSubId());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public String getCdmaMin(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getCdmaMin(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int checkCarrierPrivilegesForPackage(String pkgName) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.checkCarrierPrivilegesForPackage(this.getSubId(), pkgName);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "checkCarrierPrivilegesForPackage RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "checkCarrierPrivilegesForPackage NPE", ex);
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int checkCarrierPrivilegesForPackageAnyPhone(String pkgName) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.checkCarrierPrivilegesForPackageAnyPhone(pkgName);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "checkCarrierPrivilegesForPackageAnyPhone RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "checkCarrierPrivilegesForPackageAnyPhone NPE", ex);
        }
        return 0;
    }

    @SystemApi
    public List<String> getCarrierPackageNamesForIntent(Intent intent) {
        return this.getCarrierPackageNamesForIntentAndPhone(intent, this.getPhoneId());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public List<String> getCarrierPackageNamesForIntentAndPhone(Intent intent, int phoneId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCarrierPackageNamesForIntentAndPhone(intent, phoneId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getCarrierPackageNamesForIntentAndPhone RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getCarrierPackageNamesForIntentAndPhone NPE", ex);
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getCarrierServicePackageName() {
        return this.getCarrierServicePackageNameForLogicalSlot(this.getPhoneId());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getCarrierServicePackageNameForLogicalSlot(int logicalSlotIndex) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCarrierServicePackageNameForLogicalSlot(logicalSlotIndex);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getCarrierServicePackageNameForLogicalSlot RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getCarrierServicePackageNameForLogicalSlot NPE", ex);
        }
        return null;
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public List<String> getPackagesWithCarrierPrivileges() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getPackagesWithCarrierPrivileges(this.getPhoneId());
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getPackagesWithCarrierPrivileges RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getPackagesWithCarrierPrivileges NPE", ex);
        }
        return Collections.EMPTY_LIST;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public List<String> getCarrierPrivilegedPackagesForAllActiveSubscriptions() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getPackagesWithCarrierPrivilegesForAllPhones();
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getCarrierPrivilegedPackagesForAllActiveSubscriptions RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getCarrierPrivilegedPackagesForAllActiveSubscriptions NPE", ex);
        }
        return Collections.EMPTY_LIST;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setCallComposerStatus(@CallComposerStatus int status) {
        if (status > 1 || status < 0) {
            throw new IllegalArgumentException("requested status is invalid");
        }
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setCallComposerStatus(this.getSubId(), status);
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Error calling ITelephony#setCallComposerStatus", ex);
            ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    @CallComposerStatus
    public int getCallComposerStatus() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCallComposerStatus(this.getSubId());
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Error calling ITelephony#getCallComposerStatus", ex);
            ex.rethrowFromSystemServer();
        }
        return 0;
    }

    @SystemApi
    @SuppressLint(value={"RequiresPermission"})
    public void dial(String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.dial(number);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#dial", e);
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.CALL_PHONE")
    public void call(String callingPackage, String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.call(callingPackage, number);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#call", e);
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.CALL_PHONE")
    public boolean endCall() {
        return false;
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void answerRingingCall() {
    }

    @Deprecated
    @SystemApi
    @SuppressLint(value={"RequiresPermission"})
    public void silenceRinger() {
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PHONE_STATE"})
    public boolean isOffhook() {
        TelecomManager tm = (TelecomManager)this.mContext.getSystemService("telecom");
        return tm.isInCall();
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PHONE_STATE"})
    public boolean isRinging() {
        TelecomManager tm = (TelecomManager)this.mContext.getSystemService("telecom");
        return tm.isRinging();
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PHONE_STATE"})
    public boolean isIdle() {
        TelecomManager tm = (TelecomManager)this.mContext.getSystemService("telecom");
        return !tm.isInCall();
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PHONE_STATE"})
    public boolean isRadioOn() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isRadioOnWithFeature(this.getOpPackageName(), this.getAttributionTag());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isRadioOn", e);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean supplyPin(String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPinForSubscriber(this.getSubId(), pin);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyPinForSubscriber", e);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean supplyPuk(String puk, String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPukForSubscriber(this.getSubId(), puk, pin);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyPukForSubscriber", e);
        }
        return false;
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public int[] supplyPinReportResult(String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPinReportResultForSubscriber(this.getSubId(), pin);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyPinReportResultForSubscriber", e);
        }
        return new int[0];
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public int[] supplyPukReportResult(String puk, String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPukReportResultForSubscriber(this.getSubId(), puk, pin);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyPukReportResultForSubscriber", e);
        }
        return new int[0];
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public PinResult supplyIccLockPin(String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                int[] result = telephony.supplyPinReportResultForSubscriber(this.getSubId(), pin);
                return new PinResult(result[0], result[1]);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyIccLockPin", e);
            e.rethrowFromSystemServer();
            return PinResult.getDefaultFailedResult();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public PinResult supplyIccLockPuk(String puk, String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                int[] result = telephony.supplyPukReportResultForSubscriber(this.getSubId(), puk, pin);
                return new PinResult(result[0], result[1]);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyIccLockPuk", e);
            e.rethrowFromSystemServer();
            return PinResult.getDefaultFailedResult();
        }
    }

    @RequiresPermission(value="android.permission.CALL_PHONE")
    public void sendUssdRequest(String ussdRequest, final UssdResponseCallback callback, Handler handler) {
        Preconditions.checkNotNull(callback, "UssdResponseCallback cannot be null.");
        final TelephonyManager telephonyManager = this;
        ResultReceiver wrappedCallback = new ResultReceiver(handler){

            @Override
            protected void onReceiveResult(int resultCode, Bundle ussdResponse) {
                Rlog.d(TelephonyManager.TAG, "USSD:" + resultCode);
                Preconditions.checkNotNull(ussdResponse, "ussdResponse cannot be null.");
                UssdResponse response = (UssdResponse)ussdResponse.getParcelable(TelephonyManager.USSD_RESPONSE);
                if (resultCode == 100) {
                    callback.onReceiveUssdResponse(telephonyManager, response.getUssdRequest(), response.getReturnMessage());
                } else {
                    callback.onReceiveUssdResponseFailed(telephonyManager, response.getUssdRequest(), resultCode);
                }
            }
        };
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.handleUssdRequest(this.getSubId(), ussdRequest, wrappedCallback);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#sendUSSDCode", e);
            UssdResponse response = new UssdResponse(ussdRequest, "");
            Bundle returnData = new Bundle();
            returnData.putParcelable(USSD_RESPONSE, response);
            wrappedCallback.send(-2, returnData);
        }
    }

    public boolean isConcurrentVoiceAndDataSupported() {
        try {
            ITelephony telephony = this.getITelephony();
            return telephony == null ? false : telephony.isConcurrentVoiceAndDataAllowed(this.getSubId());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isConcurrentVoiceAndDataAllowed", e);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean handlePinMmi(String dialString) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.handlePinMmi(dialString);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#handlePinMmi", e);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean handlePinMmiForSubscriber(int subId, String dialString) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.handlePinMmiForSubscriber(subId, dialString);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#handlePinMmi", e);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void toggleRadioOnOff() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.toggleRadioOnOff();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#toggleRadioOnOff", e);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean setRadio(boolean turnOn) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setRadio(turnOn);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setRadio", e);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean setRadioPower(boolean turnOn) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setRadioPower(turnOn);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setRadioPower", e);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void shutdownAllRadios() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.shutdownMobileRadios();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#shutdownAllRadios", e);
            e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isAnyRadioPoweredOn() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.needMobileRadioShutdown();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isAnyRadioPoweredOn", e);
            e.rethrowAsRuntimeException();
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PHONE_STATE"})
    public int getRadioPowerState() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getRadioPowerState(this.getSlotIndex(), this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return 2;
    }

    @SystemApi
    public void updateServiceLocation() {
        Log.e(TAG, "Do not call TelephonyManager#updateServiceLocation()");
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean enableDataConnectivity() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.enableDataConnectivity(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#enableDataConnectivity", e);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean disableDataConnectivity() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.disableDataConnectivity(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#disableDataConnectivity", e);
        }
        return false;
    }

    @SystemApi
    public boolean isDataConnectivityPossible() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isDataConnectivityPossible(this.getSubId(SubscriptionManager.getActiveDataSubscriptionId()));
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isDataAllowed", e);
        }
        return false;
    }

    @SystemApi
    public boolean needsOtaServiceProvisioning() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.needsOtaServiceProvisioning();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#needsOtaServiceProvisioning", e);
        }
        return false;
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getMobileProvisioningUrl() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getMobileProvisioningUrl();
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "Telephony#getMobileProvisioningUrl RemoteException" + ex);
            return null;
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setDataEnabled(boolean enable) {
        this.setDataEnabled(this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId()), enable);
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setDataEnabled(int subId, boolean enable) {
        try {
            this.setDataEnabledForReason(subId, 0, enable);
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Error calling setDataEnabledForReason e:" + e);
        }
    }

    @SystemApi
    @Deprecated
    public boolean getDataEnabled() {
        return this.isDataEnabled();
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_NETWORK_STATE", "android.permission.MODIFY_PHONE_STATE", "android.permission.READ_PHONE_STATE", "android.permission.READ_BASIC_PHONE_STATE"})
    public boolean isDataEnabled() {
        try {
            return this.isDataEnabledForReason(0);
        }
        catch (IllegalStateException ise) {
            Log.e(TAG, "Error calling #isDataEnabled, returning default (false).", ise);
            return false;
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_NETWORK_STATE", "android.permission.READ_PHONE_STATE", "android.permission.READ_BASIC_PHONE_STATE"})
    public boolean isDataRoamingEnabled() {
        boolean isDataRoamingEnabled = false;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                isDataRoamingEnabled = telephony.isDataRoamingEnabled(this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId()));
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isDataRoamingEnabled", e);
        }
        return isDataRoamingEnabled;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getCdmaRoamingMode() {
        int mode = -1;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            mode = telephony.getCdmaRoamingMode(this.getSubId());
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Error calling ITelephony#getCdmaRoamingMode", ex);
            ex.rethrowFromSystemServer();
        }
        return mode;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setCdmaRoamingMode(int mode) {
        block5: {
            if (this.getPhoneType() != 2) {
                throw new IllegalStateException("Phone does not support CDMA.");
            }
            try {
                ITelephony telephony = this.getITelephony();
                if (telephony != null) {
                    boolean result = telephony.setCdmaRoamingMode(this.getSubId(), mode);
                    if (!result) {
                        throw new IllegalStateException("radio is unavailable.");
                    }
                    break block5;
                }
                throw new IllegalStateException("telephony service is null.");
            }
            catch (RemoteException ex) {
                Log.e(TAG, "Error calling ITelephony#setCdmaRoamingMode", ex);
                ex.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getCdmaSubscriptionMode() {
        int mode = 0;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            mode = telephony.getCdmaSubscriptionMode(this.getSubId());
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Error calling ITelephony#getCdmaSubscriptionMode", ex);
            ex.rethrowFromSystemServer();
        }
        return mode;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setCdmaSubscriptionMode(int mode) {
        block5: {
            if (this.getPhoneType() != 2) {
                throw new IllegalStateException("Phone does not support CDMA.");
            }
            try {
                ITelephony telephony = this.getITelephony();
                if (telephony != null) {
                    boolean result = telephony.setCdmaSubscriptionMode(this.getSubId(), mode);
                    if (!result) {
                        throw new IllegalStateException("radio is unavailable.");
                    }
                    break block5;
                }
                throw new IllegalStateException("telephony service is null.");
            }
            catch (RemoteException ex) {
                Log.e(TAG, "Error calling ITelephony#setCdmaSubscriptionMode", ex);
                ex.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setDataRoamingEnabled(boolean isEnabled) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setDataRoamingEnabled(this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId()), isEnabled);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setDataRoamingEnabled", e);
        }
    }

    @Deprecated
    @SystemApi
    public boolean getDataEnabled(int subId) {
        try {
            return this.isDataEnabledForReason(subId, 0);
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Error calling isDataEnabledForReason e:" + e);
            return false;
        }
    }

    @Deprecated
    public int invokeOemRilRequestRaw(byte[] oemReq, byte[] oemResp) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.invokeOemRilRequestRaw(oemReq, oemResp);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return -1;
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void enableVideoCalling(boolean enable) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.enableVideoCalling(enable);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#enableVideoCalling", e);
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PHONE_STATE"})
    public boolean isVideoCallingEnabled() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isVideoCallingEnabled(this.getOpPackageName(), this.getAttributionTag());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isVideoCallingEnabled", e);
        }
        return false;
    }

    public boolean canChangeDtmfToneLength() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.canChangeDtmfToneLength(this.mSubId, this.getOpPackageName(), this.getAttributionTag());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#canChangeDtmfToneLength", e);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#canChangeDtmfToneLength", e);
        }
        return false;
    }

    public boolean isWorldPhone() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isWorldPhone(this.mSubId, this.getOpPackageName(), this.getAttributionTag());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isWorldPhone", e);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#isWorldPhone", e);
        }
        return false;
    }

    @Deprecated
    public boolean isTtyModeSupported() {
        try {
            TelecomManager telecomManager = null;
            if (this.mContext != null) {
                telecomManager = this.mContext.getSystemService(TelecomManager.class);
            }
            if (telecomManager != null) {
                return telecomManager.isTtySupported();
            }
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling TelecomManager#isTtySupported", e);
        }
        return false;
    }

    public boolean isRttSupported() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isRttSupported(this.mSubId);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isRttSupported", e);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#isWorldPhone", e);
        }
        return false;
    }

    public boolean isHearingAidCompatibilitySupported() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isHearingAidCompatibilitySupported();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isHearingAidCompatibilitySupported", e);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#isHearingAidCompatibilitySupported", e);
        }
        return false;
    }

    public boolean isImsRegistered(int subId) {
        try {
            return this.getITelephony().isImsRegistered(subId);
        }
        catch (RemoteException | NullPointerException ex) {
            return false;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean isImsRegistered() {
        try {
            return this.getITelephony().isImsRegistered(this.getSubId());
        }
        catch (RemoteException | NullPointerException ex) {
            return false;
        }
    }

    @UnsupportedAppUsage
    public boolean isVolteAvailable() {
        try {
            return this.getITelephony().isAvailable(this.getSubId(), 1, 0);
        }
        catch (RemoteException | NullPointerException ex) {
            return false;
        }
    }

    @UnsupportedAppUsage
    public boolean isVideoTelephonyAvailable() {
        try {
            return this.getITelephony().isVideoTelephonyAvailable(this.getSubId());
        }
        catch (RemoteException | NullPointerException ex) {
            return false;
        }
    }

    @UnsupportedAppUsage
    public boolean isWifiCallingAvailable() {
        try {
            return this.getITelephony().isWifiCallingAvailable(this.getSubId());
        }
        catch (RemoteException | NullPointerException ex) {
            return false;
        }
    }

    public int getImsRegTechnologyForMmTel() {
        try {
            return this.getITelephony().getImsRegTechnologyForMmTel(this.getSubId());
        }
        catch (RemoteException ex) {
            return -1;
        }
    }

    public void setSimOperatorNumeric(String numeric) {
        int phoneId = this.getPhoneId();
        this.setSimOperatorNumericForPhone(phoneId, numeric);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setSimOperatorNumericForPhone(int phoneId, String numeric) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            List<String> newList = TelephonyManager.updateTelephonyProperty(TelephonyProperties.icc_operator_numeric(), phoneId, numeric);
            TelephonyProperties.icc_operator_numeric(newList);
        }
    }

    public void setSimOperatorName(String name) {
        int phoneId = this.getPhoneId();
        this.setSimOperatorNameForPhone(phoneId, name);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setSimOperatorNameForPhone(int phoneId, String name) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            List<String> newList = TelephonyManager.updateTelephonyProperty(TelephonyProperties.icc_operator_alpha(), phoneId, name);
            TelephonyProperties.icc_operator_alpha(newList);
        }
    }

    public void setSimCountryIso(String iso) {
        int phoneId = this.getPhoneId();
        this.setSimCountryIsoForPhone(phoneId, iso);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setSimCountryIsoForPhone(int phoneId, String iso) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            List<String> newList = TelephonyManager.updateTelephonyProperty(TelephonyProperties.icc_operator_iso_country(), phoneId, iso);
            TelephonyProperties.icc_operator_iso_country(newList);
        }
    }

    public void setSimState(String state) {
        int phoneId = this.getPhoneId();
        this.setSimStateForPhone(phoneId, state);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setSimStateForPhone(int phoneId, String state) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            List<String> newList = TelephonyManager.updateTelephonyProperty(TelephonyProperties.sim_state(), phoneId, state);
            TelephonyProperties.sim_state(newList);
        }
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setSimPowerState(int state) {
        this.setSimPowerStateForSlot(this.getSlotIndex(), state);
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setSimPowerStateForSlot(int slotIndex, int state) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setSimPowerStateForSlot(slotIndex, state);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setSimPowerStateForSlot", e);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#setSimPowerStateForSlot", e);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setSimPowerState(int state, Executor executor, Consumer<Integer> callback) {
        this.setSimPowerStateForSlot(this.getSlotIndex(), state, executor, callback);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setSimPowerStateForSlot(int slotIndex, int state, final Executor executor, final Consumer<Integer> callback) {
        if (state != 0 && state != 1 && state != 2) {
            throw new IllegalArgumentException("requested SIM state is invalid");
        }
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("Telephony is null.");
            }
            IIntegerConsumer.Stub internalCallback = new IIntegerConsumer.Stub(){

                @Override
                public void accept(int result) {
                    executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.accept(result)));
                }
            };
            if (telephony == null) {
                if (Compatibility.isChangeEnabled(182185642L)) {
                    throw new IllegalStateException("Telephony is null");
                }
                return;
            }
            telephony.setSimPowerStateForSlotWithCallback(slotIndex, state, internalCallback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setSimPowerStateForSlot", e);
            TelephonyManager.runOnBackgroundThread(() -> executor.execute(() -> callback.accept(2)));
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#setSimPowerStateForSlot", e);
        }
    }

    public void setBasebandVersion(String version) {
        int phoneId = this.getPhoneId();
        this.setBasebandVersionForPhone(phoneId, version);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setBasebandVersionForPhone(int phoneId, String version) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            List<String> newList = TelephonyManager.updateTelephonyProperty(TelephonyProperties.baseband_version(), phoneId, version);
            TelephonyProperties.baseband_version(newList);
        }
    }

    public String getBasebandVersion() {
        int phoneId = this.getPhoneId();
        return this.getBasebandVersionForPhone(phoneId);
    }

    public String getBasebandVersionForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, TelephonyProperties.baseband_version(), "");
    }

    public void setPhoneType(int type) {
        int phoneId = this.getPhoneId();
        this.setPhoneType(phoneId, type);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setPhoneType(int phoneId, int type) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            List<Integer> newList = TelephonyManager.updateTelephonyProperty(TelephonyProperties.current_active_phone(), phoneId, type);
            TelephonyProperties.current_active_phone(newList);
        }
    }

    public String getOtaSpNumberSchema(String defaultValue) {
        int phoneId = this.getPhoneId();
        return this.getOtaSpNumberSchemaForPhone(phoneId, defaultValue);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public String getOtaSpNumberSchemaForPhone(int phoneId, String defaultValue) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            return TelephonyManager.getTelephonyProperty(phoneId, TelephonyProperties.otasp_num_schema(), defaultValue);
        }
        return defaultValue;
    }

    public boolean getSmsReceiveCapable(boolean defaultValue) {
        int phoneId = this.getPhoneId();
        return this.getSmsReceiveCapableForPhone(phoneId, defaultValue);
    }

    public boolean getSmsReceiveCapableForPhone(int phoneId, boolean defaultValue) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            return TelephonyManager.getTelephonyProperty(phoneId, TelephonyProperties.sms_receive(), defaultValue);
        }
        return defaultValue;
    }

    public boolean getSmsSendCapable(boolean defaultValue) {
        int phoneId = this.getPhoneId();
        return this.getSmsSendCapableForPhone(phoneId, defaultValue);
    }

    public boolean getSmsSendCapableForPhone(int phoneId, boolean defaultValue) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            return TelephonyManager.getTelephonyProperty(phoneId, TelephonyProperties.sms_send(), defaultValue);
        }
        return defaultValue;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public ComponentName getAndUpdateDefaultRespondViaMessageApplication() {
        return SmsApplication.getDefaultRespondViaMessageApplication(this.mContext, true);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public ComponentName getDefaultRespondViaMessageApplication() {
        return SmsApplication.getDefaultRespondViaMessageApplication(this.mContext, false);
    }

    public void setNetworkOperatorName(String name) {
        int phoneId = this.getPhoneId();
        this.setNetworkOperatorNameForPhone(phoneId, name);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setNetworkOperatorNameForPhone(int phoneId, String name) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            List<String> newList = TelephonyManager.updateTelephonyProperty(TelephonyProperties.operator_alpha(), phoneId, name);
            try {
                TelephonyProperties.operator_alpha(newList);
            }
            catch (IllegalArgumentException e) {
                Log.e(TAG, "setNetworkOperatorNameForPhone: ", e);
                int numberOfEntries = newList.size();
                int maxOperatorLength = (91 - numberOfEntries) / numberOfEntries;
                for (int i = 0; i < newList.size(); ++i) {
                    if (newList.get(i) == null) continue;
                    newList.set(i, TextUtils.truncateStringForUtf8Storage(newList.get(i), maxOperatorLength));
                }
                TelephonyProperties.operator_alpha(newList);
                Log.e(TAG, "successfully truncated operator_alpha: " + newList);
            }
        }
    }

    public void setNetworkOperatorNumeric(String numeric) {
        int phoneId = this.getPhoneId();
        this.setNetworkOperatorNumericForPhone(phoneId, numeric);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setNetworkOperatorNumericForPhone(int phoneId, String numeric) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            List<String> newList = TelephonyManager.updateTelephonyProperty(TelephonyProperties.operator_numeric(), phoneId, numeric);
            TelephonyProperties.operator_numeric(newList);
        }
    }

    public void setNetworkRoaming(boolean isRoaming) {
        int phoneId = this.getPhoneId();
        this.setNetworkRoamingForPhone(phoneId, isRoaming);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setNetworkRoamingForPhone(int phoneId, boolean isRoaming) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            List<Boolean> newList = TelephonyManager.updateTelephonyProperty(TelephonyProperties.operator_is_roaming(), phoneId, isRoaming);
            TelephonyProperties.operator_is_roaming(newList);
        }
    }

    public void setDataNetworkType(int type) {
        int phoneId = this.getPhoneId(SubscriptionManager.getDefaultDataSubscriptionId());
        this.setDataNetworkTypeForPhone(phoneId, type);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setDataNetworkTypeForPhone(int phoneId, int type) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            List<String> newList = TelephonyManager.updateTelephonyProperty(TelephonyProperties.data_network_type(), phoneId, ServiceState.rilRadioTechnologyToString(type));
            TelephonyProperties.data_network_type(newList);
        }
    }

    @UnsupportedAppUsage
    public int getSubIdForPhoneAccount(PhoneAccount phoneAccount) {
        int retval = -1;
        if (phoneAccount != null && phoneAccount.hasCapabilities(4)) {
            retval = this.getSubscriptionId(phoneAccount.getAccountHandle());
        }
        return retval;
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public PhoneAccountHandle getPhoneAccountHandle() {
        return this.getPhoneAccountHandleForSubscriptionId(this.getSubId());
    }

    public PhoneAccountHandle getPhoneAccountHandleForSubscriptionId(int subscriptionId) {
        PhoneAccountHandle returnValue = null;
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                returnValue = service.getPhoneAccountHandleForSubscriptionId(subscriptionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return returnValue;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public int getSubscriptionId(PhoneAccountHandle phoneAccountHandle) {
        return this.mPhoneAccountHandleToSubIdCache.query(phoneAccountHandle);
    }

    public void factoryReset(int subId) {
        try {
            Log.d(TAG, "factoryReset: subId=" + subId);
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.factoryReset(subId, this.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONNECTIVITY_INTERNAL")
    public void resetSettings() {
        try {
            Log.d(TAG, "resetSettings: subId=" + this.getSubId());
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.factoryReset(this.getSubId(), this.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public Locale getSimLocale() {
        try {
            String languageTag;
            ITelephony telephony = this.getITelephony();
            if (telephony != null && !TextUtils.isEmpty(languageTag = telephony.getSimLocaleForSubscriber(this.getSubId()))) {
                return Locale.forLanguageTag(languageTag);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public String getLocaleFromDefaultSim() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getSimLocaleForSubscriber(this.getSubId());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void requestModemActivityInfo(final Executor executor, final OutcomeReceiver<ModemActivityInfo, ModemActivityInfoException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        ResultReceiver wrapperResultReceiver = new ResultReceiver(null){

            @Override
            protected void onReceiveResult(int resultCode, Bundle data) {
                if (data == null) {
                    Log.w(TelephonyManager.TAG, "requestModemActivityInfo: received null bundle");
                    this.sendErrorToListener(0);
                    return;
                }
                data.setDefusable(true);
                if (data.containsKey(TelephonyManager.EXCEPTION_RESULT_KEY)) {
                    int receivedErrorCode = data.getInt(TelephonyManager.EXCEPTION_RESULT_KEY);
                    this.sendErrorToListener(receivedErrorCode);
                    return;
                }
                if (!data.containsKey(TelephonyManager.MODEM_ACTIVITY_RESULT_KEY)) {
                    Log.w(TelephonyManager.TAG, "requestModemActivityInfo: Bundle did not contain expected key");
                    this.sendErrorToListener(0);
                    return;
                }
                Object receivedResult = data.getParcelable(TelephonyManager.MODEM_ACTIVITY_RESULT_KEY);
                if (!(receivedResult instanceof ModemActivityInfo)) {
                    Log.w(TelephonyManager.TAG, "requestModemActivityInfo: Bundle contained something that wasn't a ModemActivityInfo.");
                    this.sendErrorToListener(0);
                    return;
                }
                ModemActivityInfo modemActivityInfo = (ModemActivityInfo)receivedResult;
                if (!modemActivityInfo.isValid()) {
                    Log.w(TelephonyManager.TAG, "requestModemActivityInfo: Received an invalid ModemActivityInfo");
                    this.sendErrorToListener(2);
                    return;
                }
                Log.d(TelephonyManager.TAG, "requestModemActivityInfo: Sending result to app: " + modemActivityInfo);
                this.sendResultToListener(modemActivityInfo);
            }

            private void sendResultToListener(ModemActivityInfo info) {
                Binder.withCleanCallingIdentity(() -> executor.execute(() -> callback.onResult(info)));
            }

            private void sendErrorToListener(int code) {
                ModemActivityInfoException e = new ModemActivityInfoException(code);
                Binder.withCleanCallingIdentity(() -> executor.execute(() -> callback.onError(e)));
            }
        };
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.requestModemActivityInfo(wrapperResultReceiver);
                return;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getModemActivityInfo", e);
        }
        executor.execute(() -> callback.onError(new ModemActivityInfoException(1)));
    }

    @RequiresPermission(allOf={"android.permission.READ_PHONE_STATE", "android.permission.ACCESS_COARSE_LOCATION"})
    public ServiceState getServiceState() {
        return this.getServiceState(this.getLocationData());
    }

    @RequiresPermission(allOf={"android.permission.READ_PHONE_STATE", "android.permission.ACCESS_COARSE_LOCATION"})
    public ServiceState getServiceState(int includeLocationData) {
        return this.getServiceStateForSubscriber(this.getSubId(), includeLocationData != 2, includeLocationData == 0);
    }

    private ServiceState getServiceStateForSubscriber(int subId, boolean renounceFineLocationAccess, boolean renounceCoarseLocationAccess) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getServiceStateForSubscriber(subId, renounceFineLocationAccess, renounceCoarseLocationAccess, this.getOpPackageName(), this.getAttributionTag());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getServiceStateForSubscriber", e);
        }
        catch (NullPointerException e) {
            AnomalyReporter.reportAnomaly(UUID.fromString("a3ab0b9d-f2aa-4baf-911d-7096c0d4645a"), "getServiceStateForSubscriber " + subId + " NPE");
        }
        return null;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public ServiceState getServiceStateForSubscriber(int subId) {
        return this.getServiceStateForSubscriber(this.getSubId(), false, false);
    }

    public Uri getVoicemailRingtoneUri(PhoneAccountHandle accountHandle) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getVoicemailRingtoneUri(accountHandle);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getVoicemailRingtoneUri", e);
        }
        return null;
    }

    @Deprecated
    public void setVoicemailRingtoneUri(PhoneAccountHandle phoneAccountHandle, Uri uri) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.setVoicemailRingtoneUri(this.getOpPackageName(), phoneAccountHandle, uri);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setVoicemailRingtoneUri", e);
        }
    }

    public boolean isVoicemailVibrationEnabled(PhoneAccountHandle accountHandle) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.isVoicemailVibrationEnabled(accountHandle);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isVoicemailVibrationEnabled", e);
        }
        return false;
    }

    @Deprecated
    public void setVoicemailVibrationEnabled(PhoneAccountHandle phoneAccountHandle, boolean enabled) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.setVoicemailVibrationEnabled(this.getOpPackageName(), phoneAccountHandle, enabled);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isVoicemailVibrationEnabled", e);
        }
    }

    public int getSimCarrierId() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getSubscriptionCarrierId(this.getSubId());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return -1;
    }

    public CharSequence getSimCarrierIdName() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getSubscriptionCarrierName(this.getSubId());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public int getSimSpecificCarrierId() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getSubscriptionSpecificCarrierId(this.getSubId());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return -1;
    }

    public CharSequence getSimSpecificCarrierIdName() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getSubscriptionSpecificCarrierName(this.getSubId());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public int getCarrierIdFromSimMccMnc() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getCarrierIdFromMccMnc(this.getSlotIndex(), this.getSimOperator(), true);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return -1;
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getCarrierIdFromMccMnc(String mccmnc) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getCarrierIdFromMccMnc(this.getSlotIndex(), mccmnc, false);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return -1;
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public List<String> getCertsFromCarrierPrivilegeAccessRules() {
        List<String> certs = null;
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                certs = service.getCertsFromCarrierPrivilegeAccessRules(this.getSubId());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return certs == null ? Collections.emptyList() : certs;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getAidForAppType(int appType) {
        return this.getAidForAppType(this.getSubId(), appType);
    }

    public String getAidForAppType(int subId, int appType) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getAidForAppType(subId, appType);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getAidForAppType", e);
        }
        return null;
    }

    public String getEsn() {
        return this.getEsn(this.getSubId());
    }

    public String getEsn(int subId) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getEsn(subId);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getEsn", e);
        }
        return null;
    }

    @SystemApi
    public String getCdmaPrlVersion() {
        return this.getCdmaPrlVersion(this.getSubId());
    }

    public String getCdmaPrlVersion(int subId) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getCdmaPrlVersion(subId);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getCdmaPrlVersion", e);
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public List<TelephonyHistogram> getTelephonyHistograms() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getTelephonyHistograms();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getTelephonyHistograms", e);
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public int setAllowedCarriers(int slotIndex, List<CarrierIdentifier> carriers) {
        if (carriers == null || !SubscriptionManager.isValidPhoneId(slotIndex)) {
            return -1;
        }
        CarrierRestrictionRules carrierRestrictionRules = CarrierRestrictionRules.newBuilder().setAllowedCarriers(carriers).setDefaultCarrierRestriction(carriers.isEmpty() ? 1 : 0).build();
        int result = this.setCarrierRestrictionRules(carrierRestrictionRules);
        if (result == 0) {
            return carriers.size();
        }
        return -1;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public int setCarrierRestrictionRules(CarrierRestrictionRules rules) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.setAllowedCarriers(rules);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setAllowedCarriers", e);
        }
        catch (NullPointerException e) {
            Log.e(TAG, "Error calling ITelephony#setAllowedCarriers", e);
        }
        return 2;
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public List<CarrierIdentifier> getAllowedCarriers(int slotIndex) {
        CarrierRestrictionRules carrierRestrictionRule;
        if (SubscriptionManager.isValidPhoneId(slotIndex) && (carrierRestrictionRule = this.getCarrierRestrictionRules()) != null) {
            return carrierRestrictionRule.getAllowedCarriers();
        }
        return new ArrayList<CarrierIdentifier>(0);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public CarrierRestrictionRules getCarrierRestrictionRules() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getAllowedCarriers();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getAllowedCarriers", e);
        }
        catch (NullPointerException e) {
            Log.e(TAG, "Error calling ITelephony#getAllowedCarriers", e);
        }
        return null;
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setCarrierDataEnabled(boolean enabled) {
        try {
            this.setDataEnabledForReason(2, enabled);
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Error calling setDataEnabledForReason e:" + e);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setRadioEnabled(boolean enabled) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.carrierActionSetRadioEnabled(this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId()), enabled);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#carrierActionSetRadioEnabled", e);
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public int setVoNrEnabled(boolean enabled) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.setVoNrEnabled(this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId()), enabled);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setVoNrEnabled", e);
            return 4;
        }
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isVoNrEnabled() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isVoNrEnabled(this.getSubId());
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "isVoNrEnabled RemoteException", ex);
            ex.rethrowFromSystemServer();
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void reportDefaultNetworkStatus(boolean report) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.carrierActionReportDefaultNetworkStatus(this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId()), report);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#carrierActionReportDefaultNetworkStatus", e);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void resetAllCarrierActions() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.carrierActionResetAll(this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId()));
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#carrierActionResetAll", e);
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setPolicyDataEnabled(boolean enabled) {
        try {
            this.setDataEnabledForReason(1, enabled);
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Error calling setDataEnabledForReason e:" + e);
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setDataEnabledForReason(int reason, boolean enabled) {
        this.setDataEnabledForReason(this.getSubId(), reason, enabled);
    }

    private void setDataEnabledForReason(int subId, int reason, boolean enabled) {
        try {
            ITelephony service = this.getITelephony();
            if (service == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            service.setDataEnabledForReason(subId, reason, enabled, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Telephony#setDataEnabledForReason RemoteException", ex);
            ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_NETWORK_STATE", "android.permission.READ_PHONE_STATE", "android.permission.MODIFY_PHONE_STATE", "android.permission.READ_BASIC_PHONE_STATE"})
    public boolean isDataEnabledForReason(int reason) {
        return this.isDataEnabledForReason(this.getSubId(), reason);
    }

    private boolean isDataEnabledForReason(int subId, int reason) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.isDataEnabledForReason(subId, reason);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Telephony#isDataEnabledForReason RemoteException", ex);
            ex.rethrowFromSystemServer();
            return false;
        }
    }

    public List<ClientRequestStats> getClientRequestStats(int subId) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getClientRequestStats(this.getOpPackageName(), this.getAttributionTag(), subId);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getClientRequestStats", e);
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean getEmergencyCallbackMode() {
        return this.getEmergencyCallbackMode(this.getSubId());
    }

    public boolean getEmergencyCallbackMode(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return false;
            }
            return telephony.getEmergencyCallbackMode(subId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getEmergencyCallbackMode", e);
            return false;
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRECISE_PHONE_STATE", "android.permission.READ_PRIVILEGED_PHONE_STATE"})
    public boolean isManualNetworkSelectionAllowed() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isManualNetworkSelectionAllowed(this.getSubId());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isManualNetworkSelectionAllowed", e);
        }
        return true;
    }

    public SignalStrength getSignalStrength() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getSignalStrength(this.getSubId());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getSignalStrength", e);
        }
        return null;
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_NETWORK_STATE", "android.permission.READ_PHONE_STATE", "android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_BASIC_PHONE_STATE"})
    public boolean isDataConnectionAllowed() {
        boolean retVal = false;
        try {
            int subId = this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId());
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                retVal = telephony.isDataEnabled(subId);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error isDataConnectionAllowed", e);
        }
        return retVal;
    }

    public boolean isDataCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17891706);
    }

    @Deprecated
    public void setCarrierTestOverride(String mccmnc, String imsi, String iccid, String gid1, String gid2, String plmn, String spn) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setCarrierTestOverride(this.getSubId(), mccmnc, imsi, iccid, gid1, gid2, plmn, spn, null, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setCarrierTestOverride(String mccmnc, String imsi, String iccid, String gid1, String gid2, String plmn, String spn, String carrierPriviledgeRules, String apn) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setCarrierTestOverride(this.getSubId(), mccmnc, imsi, iccid, gid1, gid2, plmn, spn, carrierPriviledgeRules, apn);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @UnsupportedAppUsage
    public int getCarrierIdListVersion() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCarrierIdListVersion(this.getSubId());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return -1;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public int getNumberOfModemsWithSimultaneousDataConnections() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getNumberOfModemsWithSimultaneousDataConnections(this.getSubId(), this.getOpPackageName(), this.getAttributionTag());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean setOpportunisticNetworkState(boolean enable) {
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        boolean ret = false;
        try {
            IOns iOpportunisticNetworkService = this.getIOns();
            if (iOpportunisticNetworkService != null) {
                ret = iOpportunisticNetworkService.setEnable(enable, pkgForDebug);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "enableOpportunisticNetwork RemoteException", ex);
        }
        return ret;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isOpportunisticNetworkEnabled() {
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        boolean isEnabled = false;
        try {
            IOns iOpportunisticNetworkService = this.getIOns();
            if (iOpportunisticNetworkService != null) {
                isEnabled = iOpportunisticNetworkService.isEnabled(pkgForDebug);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "enableOpportunisticNetwork RemoteException", ex);
        }
        return isEnabled;
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public long getSupportedRadioAccessFamily() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getRadioAccessFamily(this.getSlotIndex(), this.getOpPackageName());
            }
            return 0L;
        }
        catch (RemoteException ex) {
            return 0L;
        }
        catch (NullPointerException ex) {
            return 0L;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void notifyOtaEmergencyNumberDbInstalled() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            telephony.notifyOtaEmergencyNumberDbInstalled();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "notifyOtaEmergencyNumberDatabaseInstalled RemoteException", ex);
            ex.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_ACTIVE_EMERGENCY_SESSION")
    public void updateOtaEmergencyNumberDbFilePath(ParcelFileDescriptor otaParcelFileDescriptor) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            telephony.updateOtaEmergencyNumberDbFilePath(otaParcelFileDescriptor);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "updateOtaEmergencyNumberDbFilePath RemoteException", ex);
            ex.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_ACTIVE_EMERGENCY_SESSION")
    public void resetOtaEmergencyNumberDbFilePath() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            telephony.resetOtaEmergencyNumberDbFilePath();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "resetOtaEmergencyNumberDbFilePath RemoteException", ex);
            ex.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isEmergencyAssistanceEnabled() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", "isEmergencyAssistanceEnabled");
        return true;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public Map<Integer, List<EmergencyNumber>> getEmergencyNumberList() {
        HashMap<Integer, List<EmergencyNumber>> emergencyNumberList = new HashMap<Integer, List<EmergencyNumber>>();
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getEmergencyNumberList(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getEmergencyNumberList RemoteException", ex);
            ex.rethrowAsRuntimeException();
            return emergencyNumberList;
        }
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public Map<Integer, List<EmergencyNumber>> getEmergencyNumberList(int categories) {
        Map<Integer, List<EmergencyNumber>> emergencyNumberListForCategories = new HashMap<Integer, List<EmergencyNumber>>();
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            Map emergencyNumberList = telephony.getEmergencyNumberList(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            emergencyNumberListForCategories = this.filterEmergencyNumbersByCategories(emergencyNumberList, categories);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getEmergencyNumberList with Categories RemoteException", ex);
            ex.rethrowAsRuntimeException();
        }
        return emergencyNumberListForCategories;
    }

    @VisibleForTesting
    public Map<Integer, List<EmergencyNumber>> filterEmergencyNumbersByCategories(Map<Integer, List<EmergencyNumber>> emergencyNumberList, int categories) {
        HashMap<Integer, List<EmergencyNumber>> emergencyNumberListForCategories = new HashMap<Integer, List<EmergencyNumber>>();
        if (emergencyNumberList != null) {
            for (Integer subscriptionId : emergencyNumberList.keySet()) {
                List<EmergencyNumber> allNumbersForSub = emergencyNumberList.get(subscriptionId);
                ArrayList<EmergencyNumber> numbersForCategoriesPerSub = new ArrayList<EmergencyNumber>();
                for (EmergencyNumber number : allNumbersForSub) {
                    if (!number.isInEmergencyServiceCategories(categories)) continue;
                    numbersForCategoriesPerSub.add(number);
                }
                emergencyNumberListForCategories.put(subscriptionId, numbersForCategoriesPerSub);
            }
        }
        return emergencyNumberListForCategories;
    }

    public boolean isEmergencyNumber(String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isEmergencyNumber(number, true);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            Log.e(TAG, "isEmergencyNumber RemoteException", ex);
            ex.rethrowAsRuntimeException();
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isPotentialEmergencyNumber(String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isEmergencyNumber(number, false);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            Log.e(TAG, "isEmergencyNumber RemoteException", ex);
            ex.rethrowAsRuntimeException();
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getEmergencyNumberDbVersion() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getEmergencyNumberDbVersion(this.getSubId());
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getEmergencyNumberDbVersion RemoteException", ex);
            ex.rethrowAsRuntimeException();
        }
        return -1;
    }

    public void setPreferredOpportunisticDataSubscription(int subId, boolean needValidation, final Executor executor, final Consumer<Integer> callback) {
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        try {
            IOns iOpportunisticNetworkService = this.getIOns();
            if (iOpportunisticNetworkService == null) {
                if (Compatibility.isChangeEnabled(182185642L)) {
                    throw new IllegalStateException("Opportunistic Network Service is null");
                }
                throw new RemoteException("Null Opportunistic Network Service!");
            }
            ISetOpportunisticDataCallback.Stub callbackStub = new ISetOpportunisticDataCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int result) {
                    if (executor == null || callback == null) {
                        return;
                    }
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.accept(result));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            };
            iOpportunisticNetworkService.setPreferredDataSubscriptionId(subId, needValidation, callbackStub, pkgForDebug);
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setPreferredOpportunisticDataSubscription RemoteException", ex);
            if (executor == null || callback == null) {
                return;
            }
            TelephonyManager.runOnBackgroundThread(() -> executor.execute(() -> {
                if (Compatibility.isChangeEnabled(130595455L)) {
                    callback.accept(4);
                } else {
                    callback.accept(2);
                }
            }));
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PHONE_STATE"})
    public int getPreferredOpportunisticDataSubscription() {
        String packageName = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        String attributionTag = this.mContext != null ? this.mContext.getAttributionTag() : null;
        int subId = -1;
        try {
            IOns iOpportunisticNetworkService = this.getIOns();
            if (iOpportunisticNetworkService != null) {
                subId = iOpportunisticNetworkService.getPreferredDataSubscriptionId(packageName, attributionTag);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getPreferredDataSubscriptionId RemoteException", ex);
        }
        return subId;
    }

    public void updateAvailableNetworks(List<AvailableNetworkInfo> availableNetworks, final Executor executor, final Consumer<Integer> callback) {
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        Objects.requireNonNull(availableNetworks, "availableNetworks must not be null.");
        try {
            IOns iOpportunisticNetworkService = this.getIOns();
            if (iOpportunisticNetworkService == null) {
                if (Compatibility.isChangeEnabled(182185642L)) {
                    throw new IllegalStateException("Opportunistic Network Service is null");
                }
                throw new RemoteException("Null Opportunistic Network Service!");
            }
            IUpdateAvailableNetworksCallback.Stub callbackStub = new IUpdateAvailableNetworksCallback.Stub(){

                @Override
                public void onComplete(int result) {
                    if (executor == null || callback == null) {
                        return;
                    }
                    Binder.withCleanCallingIdentity(() -> executor.execute(() -> callback.accept(result)));
                }
            };
            iOpportunisticNetworkService.updateAvailableNetworks(availableNetworks, callbackStub, pkgForDebug);
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "updateAvailableNetworks RemoteException", ex);
            if (executor == null || callback == null) {
                return;
            }
            TelephonyManager.runOnBackgroundThread(() -> executor.execute(() -> {
                if (Compatibility.isChangeEnabled(130595455L)) {
                    callback.accept(9);
                } else {
                    callback.accept(1);
                }
            }));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean enableModemForSlot(int slotIndex, boolean enable) {
        boolean ret = false;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                ret = telephony.enableModemForSlot(slotIndex, enable);
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "enableModem RemoteException", ex);
        }
        return ret;
    }

    @RequiresPermission(anyOf={"android.permission.READ_PHONE_STATE", "android.permission.READ_PRIVILEGED_PHONE_STATE"})
    public boolean isModemEnabledForSlot(int slotIndex) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isModemEnabledForSlot(slotIndex, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "enableModem RemoteException", ex);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setMultiSimCarrierRestriction(boolean isMultiSimCarrierRestricted) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.setMultiSimCarrierRestriction(isMultiSimCarrierRestricted);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "setMultiSimCarrierRestriction RemoteException", e);
        }
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public int isMultiSimSupported() {
        if (this.getSupportedModemCount() < 2) {
            return 1;
        }
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.isMultiSimSupported(this.getOpPackageName(), this.getAttributionTag());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "isMultiSimSupported RemoteException", e);
        }
        return 1;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void switchMultiSimConfig(int numOfSims) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.switchMultiSimConfig(numOfSims);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "switchMultiSimConfig RemoteException", ex);
        }
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public boolean doesSwitchMultiSimConfigTriggerReboot() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.doesSwitchMultiSimConfigTriggerReboot(this.getSubId(), this.getOpPackageName(), this.getAttributionTag());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "doesSwitchMultiSimConfigTriggerReboot RemoteException", e);
        }
        return false;
    }

    @UnsupportedAppUsage
    public Pair<Integer, Integer> getRadioHalVersion() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                int version = service.getRadioHalVersion();
                if (version == -1) {
                    return new Pair<Integer, Integer>(-1, -1);
                }
                return new Pair<Integer, Integer>(version / 100, version % 100);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "getRadioHalVersion() RemoteException", e);
        }
        return new Pair<Integer, Integer>(-1, -1);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getCarrierPrivilegeStatus(int uid) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCarrierPrivilegeStatusForUid(this.getSubId(), uid);
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getCarrierPrivilegeStatus RemoteException", ex);
        }
        return 0;
    }

    public List<ApnSetting> getDevicePolicyOverrideApns(Context context) {
        try (Cursor cursor = context.getContentResolver().query(Telephony.Carriers.DPC_URI, null, null, null, null);){
            if (cursor == null) {
                List<ApnSetting> list = Collections.emptyList();
                return list;
            }
            ArrayList<ApnSetting> apnList = new ArrayList<ApnSetting>();
            cursor.moveToPosition(-1);
            while (cursor.moveToNext()) {
                ApnSetting apn = ApnSetting.makeApnSetting(cursor);
                apnList.add(apn);
            }
            ArrayList<ApnSetting> arrayList = apnList;
            return arrayList;
        }
    }

    public int addDevicePolicyOverrideApn(Context context, ApnSetting apnSetting) {
        Uri resultUri = context.getContentResolver().insert(Telephony.Carriers.DPC_URI, apnSetting.toContentValues());
        int resultId = -1;
        if (resultUri != null) {
            try {
                resultId = Integer.parseInt(resultUri.getLastPathSegment());
            }
            catch (NumberFormatException e) {
                Rlog.e(TAG, "Failed to parse inserted override APN id: " + resultUri.getLastPathSegment());
            }
        }
        return resultId;
    }

    public boolean modifyDevicePolicyOverrideApn(Context context, int apnId, ApnSetting apnSetting) {
        return context.getContentResolver().update(Uri.withAppendedPath(Telephony.Carriers.DPC_URI, Integer.toString(apnId)), apnSetting.toContentValues(), null, null) > 0;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isDataEnabledForApn(int apnType) {
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.isDataEnabledForApn(apnType, this.getSubId(), pkgForDebug);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "Telephony#isDataEnabledForApn RemoteException" + ex);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isApnMetered(int apnType) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.isApnMetered(apnType, this.getSubId());
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "Telephony#isApnMetered RemoteException" + ex);
        }
        return true;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setSystemSelectionChannels(List<RadioAccessSpecifier> specifiers, Executor executor, Consumer<Boolean> callback) {
        Objects.requireNonNull(specifiers, "Specifiers must not be null.");
        Objects.requireNonNull(executor, "Executor must not be null.");
        Objects.requireNonNull(callback, "Callback must not be null.");
        this.setSystemSelectionChannelsInternal(specifiers, executor, callback);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setSystemSelectionChannels(List<RadioAccessSpecifier> specifiers) {
        Objects.requireNonNull(specifiers, "Specifiers must not be null.");
        this.setSystemSelectionChannelsInternal(specifiers, null, null);
    }

    private void setSystemSelectionChannelsInternal(List<RadioAccessSpecifier> specifiers, final Executor executor, final Consumer<Boolean> callback) {
        IBooleanConsumer.Stub aidlConsumer = callback == null ? null : new IBooleanConsumer.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(boolean result) {
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callback.accept(result));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        };
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.setSystemSelectionChannels(specifiers, this.getSubId(), aidlConsumer);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "Telephony#setSystemSelectionChannels RemoteException" + ex);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public List<RadioAccessSpecifier> getSystemSelectionChannels() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getSystemSelectionChannels(this.getSubId());
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "Telephony#getSystemSelectionChannels RemoteException" + ex);
            return new ArrayList<RadioAccessSpecifier>();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean matchesCurrentSimOperator(String mccmnc, int mvnoType, String mvnoMatchData) {
        try {
            if (!mccmnc.equals(this.getSimOperator())) {
                return false;
            }
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.isMvnoMatched(this.getSlotIndex(), mvnoType, mvnoMatchData);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "Telephony#matchesCurrentSimOperator RemoteException" + ex);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void getCallForwarding(int callForwardingReason, final Executor executor, final CallForwardingInfoCallback callback) {
        if (callForwardingReason < 0 || callForwardingReason > 5) {
            throw new IllegalArgumentException("callForwardingReason is out of range");
        }
        ICallForwardingInfoCallback.Stub internalCallback = new ICallForwardingInfoCallback.Stub(){

            @Override
            public void onCallForwardingInfoAvailable(CallForwardingInfo info) {
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onCallForwardingInfoAvailable(info)));
            }

            @Override
            public void onError(int error) {
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(error)));
            }
        };
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.getCallForwarding(this.getSubId(), callForwardingReason, internalCallback);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getCallForwarding RemoteException", ex);
            ex.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setCallForwarding(CallForwardingInfo callForwardingInfo, final Executor executor, final Consumer<Integer> resultListener) {
        if (callForwardingInfo == null) {
            throw new IllegalArgumentException("callForwardingInfo is null");
        }
        int callForwardingReason = callForwardingInfo.getReason();
        if (callForwardingReason < 0 || callForwardingReason > 5) {
            throw new IllegalArgumentException("callForwardingReason is out of range");
        }
        if (callForwardingInfo.isEnabled()) {
            if (callForwardingInfo.getNumber() == null) {
                throw new IllegalArgumentException("callForwarding number is null");
            }
            if (callForwardingReason == 2 && callForwardingInfo.getTimeoutSeconds() <= 0) {
                throw new IllegalArgumentException("callForwarding timeout isn't positive");
            }
        }
        if (resultListener != null) {
            Objects.requireNonNull(executor);
        }
        IIntegerConsumer.Stub internalCallback = new IIntegerConsumer.Stub(){

            @Override
            public void accept(int result) {
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
            }
        };
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setCallForwarding(this.getSubId(), callForwardingInfo, internalCallback);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setCallForwarding RemoteException", ex);
            ex.rethrowAsRuntimeException();
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setCallForwarding NPE", ex);
            throw ex;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void getCallWaitingStatus(final Executor executor, final Consumer<Integer> resultListener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        IIntegerConsumer.Stub internalCallback = new IIntegerConsumer.Stub(){

            @Override
            public void accept(int result) {
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
            }
        };
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.getCallWaitingStatus(this.getSubId(), internalCallback);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getCallWaitingStatus RemoteException", ex);
            ex.rethrowAsRuntimeException();
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getCallWaitingStatus NPE", ex);
            throw ex;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setCallWaitingEnabled(boolean enabled, final Executor executor, final Consumer<Integer> resultListener) {
        if (resultListener != null) {
            Objects.requireNonNull(executor);
        }
        IIntegerConsumer.Stub internalCallback = new IIntegerConsumer.Stub(){

            @Override
            public void accept(int result) {
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
            }
        };
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setCallWaitingStatus(this.getSubId(), enabled, internalCallback);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setCallWaitingStatus RemoteException", ex);
            ex.rethrowAsRuntimeException();
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setCallWaitingStatus NPE", ex);
            throw ex;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setMobileDataPolicyEnabled(int policy, boolean enabled) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.setMobileDataPolicyEnabled(this.getSubId(), policy, enabled);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "Telephony#setMobileDataPolicyEnabled RemoteException" + ex);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isMobileDataPolicyEnabled(int policy) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.isMobileDataPolicyEnabled(this.getSubId(), policy);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "Telephony#isMobileDataPolicyEnabled RemoteException" + ex);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isIccLockEnabled() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isIccLockEnabled(this.getSubId());
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException e) {
            Log.e(TAG, "isIccLockEnabled RemoteException", e);
            e.rethrowFromSystemServer();
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public PinResult setIccLockEnabled(boolean enabled, String pin) {
        Preconditions.checkNotNull(pin, "setIccLockEnabled pin can't be null.");
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                int result = telephony.setIccLockEnabled(this.getSubId(), enabled, pin);
                if (result == Integer.MAX_VALUE) {
                    return new PinResult(0, 0);
                }
                if (result < 0) {
                    return PinResult.getDefaultFailedResult();
                }
                return new PinResult(1, result);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException e) {
            Log.e(TAG, "setIccLockEnabled RemoteException", e);
            e.rethrowFromSystemServer();
            return PinResult.getDefaultFailedResult();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public PinResult changeIccLockPin(String oldPin, String newPin) {
        Preconditions.checkNotNull(oldPin, "changeIccLockPin oldPin can't be null.");
        Preconditions.checkNotNull(newPin, "changeIccLockPin newPin can't be null.");
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                int result = telephony.changeIccLockPassword(this.getSubId(), oldPin, newPin);
                if (result == Integer.MAX_VALUE) {
                    return new PinResult(0, 0);
                }
                if (result < 0) {
                    return PinResult.getDefaultFailedResult();
                }
                return new PinResult(1, result);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException e) {
            Log.e(TAG, "changeIccLockPin RemoteException", e);
            e.rethrowFromSystemServer();
            return PinResult.getDefaultFailedResult();
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void notifyUserActivity() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.userActivity();
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "notifyUserActivity exception: " + e.getMessage());
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public int setNrDualConnectivityState(int nrDualConnectivityState) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setNrDualConnectivityState(this.getSubId(), nrDualConnectivityState);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setNrDualConnectivityState RemoteException", ex);
            ex.rethrowFromSystemServer();
            return 4;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isNrDualConnectivityEnabled() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isNrDualConnectivityEnabled(this.getSubId());
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "isNRDualConnectivityEnabled RemoteException", ex);
            ex.rethrowFromSystemServer();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetServiceCache() {
        Object object = sCacheLock;
        synchronized (object) {
            if (sITelephony != null) {
                sITelephony.asBinder().unlinkToDeath(sServiceDeath, 0);
                sITelephony = null;
            }
            if (sISub != null) {
                sISub.asBinder().unlinkToDeath(sServiceDeath, 0);
                sISub = null;
                SubscriptionManager.clearCaches();
            }
            if (sISms != null) {
                sISms.asBinder().unlinkToDeath(sServiceDeath, 0);
                sISms = null;
            }
            if (sIPhoneSubInfo != null) {
                sIPhoneSubInfo.asBinder().unlinkToDeath(sServiceDeath, 0);
                sIPhoneSubInfo = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IPhoneSubInfo getSubscriberInfoService() {
        if (!sServiceHandleCacheEnabled) {
            return IPhoneSubInfo.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getPhoneSubServiceRegisterer().get());
        }
        if (sIPhoneSubInfo == null) {
            IPhoneSubInfo temp = IPhoneSubInfo.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getPhoneSubServiceRegisterer().get());
            Object object = sCacheLock;
            synchronized (object) {
                if (sIPhoneSubInfo == null && temp != null) {
                    try {
                        sIPhoneSubInfo = temp;
                        sIPhoneSubInfo.asBinder().linkToDeath(sServiceDeath, 0);
                    }
                    catch (Exception e) {
                        sIPhoneSubInfo = null;
                    }
                }
            }
        }
        return sIPhoneSubInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ISub getSubscriptionService() {
        if (!sServiceHandleCacheEnabled) {
            return ISub.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getSubscriptionServiceRegisterer().get());
        }
        if (sISub == null) {
            ISub temp = ISub.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getSubscriptionServiceRegisterer().get());
            Object object = sCacheLock;
            synchronized (object) {
                if (sISub == null && temp != null) {
                    try {
                        sISub = temp;
                        sISub.asBinder().linkToDeath(sServiceDeath, 0);
                    }
                    catch (Exception e) {
                        sISub = null;
                    }
                }
            }
        }
        return sISub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ISms getSmsService() {
        if (!sServiceHandleCacheEnabled) {
            return ISms.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getSmsServiceRegisterer().get());
        }
        if (sISms == null) {
            ISms temp = ISms.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getSmsServiceRegisterer().get());
            Object object = sCacheLock;
            synchronized (object) {
                if (sISms == null && temp != null) {
                    try {
                        sISms = temp;
                        sISms.asBinder().linkToDeath(sServiceDeath, 0);
                    }
                    catch (Exception e) {
                        sISms = null;
                    }
                }
            }
        }
        return sISms;
    }

    @VisibleForTesting
    public static void disableServiceHandleCaching() {
        sServiceHandleCacheEnabled = false;
    }

    @VisibleForTesting
    public static void enableServiceHandleCaching() {
        sServiceHandleCacheEnabled = true;
    }

    @VisibleForTesting
    public static void setupITelephonyForTest(ITelephony telephony) {
        sITelephony = telephony;
    }

    public boolean canConnectTo5GInDsdsMode() {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return true;
        }
        try {
            return telephony.canConnectTo5GInDsdsMode();
        }
        catch (RemoteException ex) {
            return true;
        }
        catch (NullPointerException ex) {
            return true;
        }
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public List<String> getEquivalentHomePlmns() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getEquivalentHomePlmns(this.getSubId(), this.mContext.getOpPackageName(), this.getAttributionTag());
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "Telephony#getEquivalentHomePlmns RemoteException" + ex);
            return Collections.emptyList();
        }
    }

    public boolean isRadioInterfaceCapabilitySupported(String capability) {
        try {
            if (capability == null) {
                return false;
            }
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isRadioInterfaceCapabilitySupported(capability);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "Telephony#isRadioInterfaceCapabilitySupported RemoteException" + ex);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public int sendThermalMitigationRequest(ThermalMitigationRequest thermalMitigationRequest) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.sendThermalMitigationRequest(this.getSubId(), thermalMitigationRequest, this.getOpPackageName());
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Telephony#thermalMitigationRequest RemoteException", ex);
            ex.rethrowFromSystemServer();
            return 4;
        }
    }

    public void registerTelephonyCallback(Executor executor, TelephonyCallback callback) {
        this.registerTelephonyCallback(this.getLocationData(), executor, callback);
    }

    private int getLocationData() {
        boolean renounceCoarseLocation = this.getRenouncedPermissions().contains("android.permission.ACCESS_COARSE_LOCATION");
        boolean renounceFineLocation = this.getRenouncedPermissions().contains("android.permission.ACCESS_FINE_LOCATION");
        if (renounceCoarseLocation) {
            return 0;
        }
        if (renounceFineLocation) {
            return 1;
        }
        return 2;
    }

    public void registerTelephonyCallback(int includeLocationData, Executor executor, TelephonyCallback callback) {
        if (this.mContext == null) {
            throw new IllegalStateException("telephony service is null.");
        }
        if (executor == null || callback == null) {
            throw new IllegalArgumentException("TelephonyCallback and executor must be non-null");
        }
        this.mTelephonyRegistryMgr = (TelephonyRegistryManager)this.mContext.getSystemService("telephony_registry");
        if (this.mTelephonyRegistryMgr == null) {
            throw new IllegalStateException("telephony service is null.");
        }
        this.mTelephonyRegistryMgr.registerTelephonyCallback(includeLocationData != 2, includeLocationData == 0, executor, this.mSubId, this.getOpPackageName(), this.getAttributionTag(), callback, this.getITelephony() != null);
    }

    public void unregisterTelephonyCallback(TelephonyCallback callback) {
        if (this.mContext == null) {
            throw new IllegalStateException("telephony service is null.");
        }
        if (callback.callback == null) {
            return;
        }
        this.mTelephonyRegistryMgr = this.mContext.getSystemService(TelephonyRegistryManager.class);
        if (this.mTelephonyRegistryMgr == null) {
            throw new IllegalStateException("telephony service is null.");
        }
        this.mTelephonyRegistryMgr.unregisterTelephonyCallback(this.mSubId, this.getOpPackageName(), this.getAttributionTag(), callback, this.getITelephony() != null);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MODIFY_PHONE_STATE", "android.permission.PERFORM_IMS_SINGLE_REGISTRATION"})
    public void bootstrapAuthenticationRequest(int appType, Uri nafId, UaSecurityProtocolIdentifier securityProtocol, boolean forceBootStrapping, final Executor e, final BootstrapAuthenticationCallback callback) {
        try {
            ITelephony service = this.getITelephony();
            if (service == null) {
                e.execute(() -> callback.onAuthenticationFailure(2));
                return;
            }
            service.bootstrapAuthenticationRequest(this.getSubId(), appType, nafId, securityProtocol, forceBootStrapping, new IBootstrapAuthenticationCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onKeysAvailable(int token, byte[] gbaKey, String transactionId) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        e.execute(() -> callback.onKeysAvailable(gbaKey, transactionId));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onAuthenticationFailure(int token, int reason) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        e.execute(() -> callback.onAuthenticationFailure(reason));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            });
        }
        catch (RemoteException exception) {
            Log.e(TAG, "Error calling ITelephony#bootstrapAuthenticationRequest", exception);
            e.execute(() -> callback.onAuthenticationFailure(2));
        }
    }

    public static boolean isNetworkTypeValid(int networkType) {
        return networkType >= 0 && networkType <= 20;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setSignalStrengthUpdateRequest(SignalStrengthUpdateRequest request) {
        Objects.requireNonNull(request, "request must not be null");
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.setSignalStrengthUpdateRequest(this.getSubId(), request, this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setSignalStrengthUpdateRequest", e);
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void clearSignalStrengthUpdateRequest(SignalStrengthUpdateRequest request) {
        Objects.requireNonNull(request, "request must not be null");
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.clearSignalStrengthUpdateRequest(this.getSubId(), request, this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#clearSignalStrengthUpdateRequest", e);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public PhoneCapability getPhoneCapability() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getPhoneCapability();
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            ex.rethrowAsRuntimeException();
            if (this.getActiveModemCount() > 1) {
                return PhoneCapability.DEFAULT_DSDS_CAPABILITY;
            }
            return PhoneCapability.DEFAULT_SSSS_CAPABILITY;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.REBOOT")
    public int prepareForUnattendedReboot() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.prepareForUnattendedReboot();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Telephony#prepareForUnattendedReboot RemoteException", e);
            e.rethrowFromSystemServer();
        }
        return 2;
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void getNetworkSlicingConfiguration(final Executor executor, final OutcomeReceiver<NetworkSlicingConfig, NetworkSlicingException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            telephony.getSlicingConfig(new ResultReceiver(null){

                @Override
                protected void onReceiveResult(int resultCode, Bundle result) {
                    if (resultCode == 1) {
                        executor.execute(() -> callback.onError(new TimeoutException(resultCode)));
                        return;
                    }
                    if (resultCode == 2) {
                        executor.execute(() -> callback.onError(new ModemErrorException(resultCode)));
                        return;
                    }
                    NetworkSlicingConfig slicingConfig = (NetworkSlicingConfig)result.getParcelable(TelephonyManager.KEY_SLICING_CONFIG_HANDLE);
                    executor.execute(() -> callback.onResult(slicingConfig));
                }
            });
        }
        catch (RemoteException ex) {
            ex.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_FINE_LOCATION", "com.android.phone.permission.ACCESS_LAST_KNOWN_CELL_ID"})
    public CellIdentity getLastKnownCellIdentity() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            return telephony.getLastKnownCellIdentity(this.getSubId(), this.getOpPackageName(), this.getAttributionTag());
        }
        catch (RemoteException ex) {
            ex.rethrowAsRuntimeException();
            return null;
        }
    }

    @RequiresPermission(value="android.permission.BIND_TELECOM_CONNECTION_SERVICE")
    public void setVoiceServiceStateOverride(boolean hasService) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("Telephony service is null");
            }
            telephony.setVoiceServiceStateOverride(this.getSubId(), hasService, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            ex.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void registerCarrierPrivilegesCallback(int logicalSlotIndex, Executor executor, CarrierPrivilegesCallback callback) {
        if (this.mContext == null) {
            throw new IllegalStateException("Telephony service is null");
        }
        if (executor == null || callback == null) {
            throw new IllegalArgumentException("CarrierPrivilegesCallback and executor must be non-null");
        }
        this.mTelephonyRegistryMgr = this.mContext.getSystemService(TelephonyRegistryManager.class);
        if (this.mTelephonyRegistryMgr == null) {
            throw new IllegalStateException("Telephony registry service is null");
        }
        this.mTelephonyRegistryMgr.addCarrierPrivilegesCallback(logicalSlotIndex, executor, callback);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void unregisterCarrierPrivilegesCallback(CarrierPrivilegesCallback callback) {
        if (this.mContext == null) {
            throw new IllegalStateException("Telephony service is null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("CarrierPrivilegesCallback must be non-null");
        }
        this.mTelephonyRegistryMgr = this.mContext.getSystemService(TelephonyRegistryManager.class);
        if (this.mTelephonyRegistryMgr == null) {
            throw new IllegalStateException("Telephony registry service is null");
        }
        this.mTelephonyRegistryMgr.removeCarrierPrivilegesCallback(callback);
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setRemovableEsimAsDefaultEuicc(boolean isDefault) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setRemovableEsimAsDefaultEuicc(isDefault, this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in setRemovableEsimAsDefault: " + e);
        }
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isRemovableEsimDefaultEuicc() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isRemovableEsimDefaultEuicc(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in isRemovableEsimDefaultEuicc: " + e);
        }
        return false;
    }

    static {
        sServiceDeath = new DeathRecipient();
        sInstance = new TelephonyManager();
        EXTRA_STATE_IDLE = PhoneConstants.State.IDLE.toString();
        EXTRA_STATE_RINGING = PhoneConstants.State.RINGING.toString();
        EXTRA_STATE_OFFHOOK = PhoneConstants.State.OFFHOOK.toString();
        NETWORK_TYPES = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
        DEFAULT_PREFERRED_NETWORK_MODE = RILConstants.PREFERRED_NETWORK_MODE;
    }

    @SystemApi
    public static interface CarrierPrivilegesCallback {
        public void onCarrierPrivilegesChanged(Set<String> var1, Set<Integer> var2);

        default public void onCarrierServiceChanged(String carrierServicePackageName, int carrierServiceUid) {
        }
    }

    public class ModemErrorException
    extends NetworkSlicingException {
        public ModemErrorException(int errorCode) {
            super(errorCode);
        }
    }

    public class TimeoutException
    extends NetworkSlicingException {
        public TimeoutException(int errorCode) {
            super(errorCode);
        }
    }

    public static class NetworkSlicingException
    extends Exception {
        public static final int SUCCESS = 0;
        public static final int ERROR_TIMEOUT = 1;
        public static final int ERROR_MODEM_ERROR = 2;
        private final int mErrorCode;

        public NetworkSlicingException(int errorCode) {
            this.mErrorCode = errorCode;
        }

        @Override
        public String toString() {
            switch (this.mErrorCode) {
                case 1: {
                    return "ERROR_TIMEOUT";
                }
                case 2: {
                    return "ERROR_MODEM_ERROR";
                }
            }
            return "UNDEFINED";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface NetworkSlicingError {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PrepareUnattendedRebootResult {
    }

    @SystemApi
    public static class BootstrapAuthenticationCallback {
        public void onKeysAvailable(byte[] gbaKey, String transactionId) {
        }

        public void onAuthenticationFailure(int reason) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AuthenticationFailureReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IncludeLocationData {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RadioInterfaceCapability {
    }

    private static class DeathRecipient
    implements IBinder.DeathRecipient {
        private DeathRecipient() {
        }

        @Override
        public void binderDied() {
            TelephonyManager.resetServiceCache();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NrDualConnectivityState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnableNrDualConnectivityResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MobileDataPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CallWaitingStatus {
    }

    @SystemApi
    public static interface CallForwardingInfoCallback {
        public static final int RESULT_SUCCESS = 0;
        public static final int RESULT_ERROR_UNKNOWN = 1;
        public static final int RESULT_ERROR_FDN_CHECK_FAILURE = 2;
        public static final int RESULT_ERROR_NOT_SUPPORTED = 3;

        public void onCallForwardingInfoAvailable(CallForwardingInfo var1);

        public void onError(int var1);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface CallForwardingError {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IsMultiSimSupportedResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UpdateAvailableNetworksResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetOpportunisticSubscriptionResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetworkTypeBitMask {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataEnabledChangedReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataEnabledReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnableVoNrResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetSimPowerStateResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetCarrierRestrictionResult {
    }

    @SystemApi
    public static class ModemActivityInfoException
    extends Exception {
        public static final int ERROR_UNKNOWN = 0;
        public static final int ERROR_PHONE_NOT_AVAILABLE = 1;
        public static final int ERROR_INVALID_INFO_RECEIVED = 2;
        public static final int ERROR_MODEM_RESPONSE_ERROR = 3;
        private final int mErrorCode;

        public ModemActivityInfoException(int errorCode) {
            this.mErrorCode = errorCode;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        @Override
        public String toString() {
            switch (this.mErrorCode) {
                case 0: {
                    return "ERROR_UNKNOWN";
                }
                case 1: {
                    return "ERROR_PHONE_NOT_AVAILABLE";
                }
                case 2: {
                    return "ERROR_INVALID_INFO_RECEIVED";
                }
                case 3: {
                    return "ERROR_MODEM_RESPONSE_ERROR";
                }
            }
            return "UNDEFINED";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ModemActivityInfoError {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SimPowerState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CdmaSubscription {
    }

    public static abstract class UssdResponseCallback {
        public void onReceiveUssdResponse(TelephonyManager telephonyManager, String request, CharSequence response) {
        }

        public void onReceiveUssdResponseFailed(TelephonyManager telephonyManager, String request, int failureCode) {
        }
    }

    public static @interface CallComposerStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AllowedNetworkTypesReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PrefNetworkMode {
    }

    public static abstract class CellInfoCallback {
        public static final int ERROR_TIMEOUT = 1;
        public static final int ERROR_MODEM_ERROR = 2;

        public abstract void onCellInfo(List<CellInfo> var1);

        public void onError(int errorCode, Throwable detail) {
            this.onCellInfo(new ArrayList<CellInfo>());
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface CellInfoCallbackError {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EriIconMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EriIconIndex {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataState {
    }

    public static class CallComposerException
    extends Exception {
        public static final int SUCCESS = -1;
        public static final int ERROR_UNKNOWN = 0;
        public static final int ERROR_REMOTE_END_CLOSED = 1;
        public static final int ERROR_FILE_TOO_LARGE = 2;
        public static final int ERROR_AUTHENTICATION_FAILED = 3;
        public static final int ERROR_INPUT_CLOSED = 4;
        public static final int ERROR_IO_EXCEPTION = 5;
        public static final int ERROR_NETWORK_UNAVAILABLE = 6;
        private final int mErrorCode;
        private final IOException mIOException;

        public CallComposerException(int errorCode, IOException ioException) {
            this.mErrorCode = errorCode;
            this.mIOException = ioException;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        @SuppressLint(value={"AcronymName"})
        public IOException getIOException() {
            return this.mIOException;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface CallComposerError {
        }
    }

    public static @interface SimState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SimCombinationWarningType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DefaultSubscriptionSelectType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CdmaRoamingMode {
    }

    @UnsupportedAppUsage(implicitMember="values()[Landroid/telephony/TelephonyManager$MultiSimVariants;")
    public static enum MultiSimVariants {
        DSDS,
        DSDA,
        TSTS,
        UNKNOWN;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface KeyType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetworkSelectionMode {
    }

    public static interface WifiCallingChoices {
        public static final int ALWAYS_USE = 0;
        public static final int ASK_EVERY_TIME = 1;
        public static final int NEVER_USE = 2;
    }
}

