/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.SignalThresholdInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SignalStrengthUpdateRequest
implements Parcelable {
    private final List<SignalThresholdInfo> mSignalThresholdInfos;
    private final boolean mIsReportingRequestedWhileIdle;
    private final boolean mIsSystemThresholdReportingRequestedWhileIdle;
    private final IBinder mLiveToken;
    public static final Parcelable.Creator<SignalStrengthUpdateRequest> CREATOR = new Parcelable.Creator<SignalStrengthUpdateRequest>(){

        @Override
        public SignalStrengthUpdateRequest createFromParcel(Parcel source) {
            return new SignalStrengthUpdateRequest(source);
        }

        public SignalStrengthUpdateRequest[] newArray(int size) {
            return new SignalStrengthUpdateRequest[size];
        }
    };

    private SignalStrengthUpdateRequest(List<SignalThresholdInfo> signalThresholdInfos, boolean isReportingRequestedWhileIdle, boolean isSystemThresholdReportingRequestedWhileIdle) {
        SignalStrengthUpdateRequest.validate(signalThresholdInfos, isSystemThresholdReportingRequestedWhileIdle);
        this.mSignalThresholdInfos = signalThresholdInfos;
        this.mIsReportingRequestedWhileIdle = isReportingRequestedWhileIdle;
        this.mIsSystemThresholdReportingRequestedWhileIdle = isSystemThresholdReportingRequestedWhileIdle;
        this.mLiveToken = new Binder();
    }

    private SignalStrengthUpdateRequest(Parcel in) {
        this.mSignalThresholdInfos = in.createTypedArrayList(SignalThresholdInfo.CREATOR);
        this.mIsReportingRequestedWhileIdle = in.readBoolean();
        this.mIsSystemThresholdReportingRequestedWhileIdle = in.readBoolean();
        this.mLiveToken = in.readStrongBinder();
    }

    public Collection<SignalThresholdInfo> getSignalThresholdInfos() {
        return Collections.unmodifiableList(this.mSignalThresholdInfos);
    }

    public boolean isReportingRequestedWhileIdle() {
        return this.mIsReportingRequestedWhileIdle;
    }

    @SystemApi
    public boolean isSystemThresholdReportingRequestedWhileIdle() {
        return this.mIsSystemThresholdReportingRequestedWhileIdle;
    }

    public IBinder getLiveToken() {
        return this.mLiveToken;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.mSignalThresholdInfos);
        dest.writeBoolean(this.mIsReportingRequestedWhileIdle);
        dest.writeBoolean(this.mIsSystemThresholdReportingRequestedWhileIdle);
        dest.writeStrongBinder(this.mLiveToken);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SignalStrengthUpdateRequest)) {
            return false;
        }
        SignalStrengthUpdateRequest request = (SignalStrengthUpdateRequest)other;
        return this.mSignalThresholdInfos.equals(request.mSignalThresholdInfos) && this.mIsReportingRequestedWhileIdle == request.mIsReportingRequestedWhileIdle && this.mIsSystemThresholdReportingRequestedWhileIdle == request.mIsSystemThresholdReportingRequestedWhileIdle;
    }

    public int hashCode() {
        return Objects.hash(this.mSignalThresholdInfos, this.mIsReportingRequestedWhileIdle, this.mIsSystemThresholdReportingRequestedWhileIdle);
    }

    public String toString() {
        return "SignalStrengthUpdateRequest{" + "mSignalThresholdInfos=" + this.mSignalThresholdInfos + " mIsReportingRequestedWhileIdle=" + this.mIsReportingRequestedWhileIdle + " mIsSystemThresholdReportingRequestedWhileIdle=" + this.mIsSystemThresholdReportingRequestedWhileIdle + " mLiveToken" + this.mLiveToken + "}";
    }

    private static void validate(Collection<SignalThresholdInfo> infos, boolean isSystemThresholdReportingRequestedWhileIdle) {
        if (infos == null || infos.isEmpty() && !isSystemThresholdReportingRequestedWhileIdle) {
            throw new IllegalArgumentException("SignalThresholdInfo collection is null or empty");
        }
        HashMap ranToTypes = new HashMap(infos.size());
        for (SignalThresholdInfo info : infos) {
            int ran = info.getRadioAccessNetworkType();
            int type = info.getSignalMeasurementType();
            ranToTypes.putIfAbsent(ran, new HashSet());
            if (((Set)ranToTypes.get(ran)).add(type)) continue;
            throw new IllegalArgumentException("SignalMeasurementType " + type + " for RAN " + ran + " is not unique");
        }
    }

    public static class Builder {
        private List<SignalThresholdInfo> mSignalThresholdInfos = null;
        private boolean mIsReportingRequestedWhileIdle = false;
        private boolean mIsSystemThresholdReportingRequestedWhileIdle = false;

        public Builder setSignalThresholdInfos(Collection<SignalThresholdInfo> signalThresholdInfos) {
            Objects.requireNonNull(signalThresholdInfos, "SignalThresholdInfo collection must not be null");
            for (SignalThresholdInfo info : signalThresholdInfos) {
                Objects.requireNonNull(info, "SignalThresholdInfo in the collection must not be null");
            }
            this.mSignalThresholdInfos = new ArrayList<SignalThresholdInfo>(signalThresholdInfos);
            this.mSignalThresholdInfos.sort(Comparator.comparingInt(SignalThresholdInfo::getRadioAccessNetworkType).thenComparing(SignalThresholdInfo::getSignalMeasurementType));
            return this;
        }

        public Builder setReportingRequestedWhileIdle(boolean isReportingRequestedWhileIdle) {
            this.mIsReportingRequestedWhileIdle = isReportingRequestedWhileIdle;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.LISTEN_ALWAYS_REPORTED_SIGNAL_STRENGTH")
        public Builder setSystemThresholdReportingRequestedWhileIdle(boolean isSystemThresholdReportingRequestedWhileIdle) {
            this.mIsSystemThresholdReportingRequestedWhileIdle = isSystemThresholdReportingRequestedWhileIdle;
            return this;
        }

        public SignalStrengthUpdateRequest build() {
            return new SignalStrengthUpdateRequest(this.mSignalThresholdInfos, this.mIsReportingRequestedWhileIdle, this.mIsSystemThresholdReportingRequestedWhileIdle);
        }
    }
}

