/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.telephony.CellSignalStrength;
import android.telephony.ServiceState;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CellSignalStrengthNr
extends CellSignalStrength
implements Parcelable {
    public static final int UNKNOWN_ASU_LEVEL = 99;
    private static final boolean VDBG = false;
    private static final String TAG = "CellSignalStrengthNr";
    private int[] mSsRsrpThresholds = new int[]{-110, -90, -80, -65};
    private int[] mSsRsrqThresholds = new int[]{-31, -19, -7, 6};
    private int[] mSsSinrThresholds = new int[]{-5, 5, 15, 30};
    public static final int USE_SSRSRP = 1;
    public static final int USE_SSRSRQ = 2;
    public static final int USE_SSSINR = 4;
    private int mCsiRsrp;
    private int mCsiRsrq;
    private int mCsiSinr;
    private int mCsiCqiTableIndex;
    private List<Integer> mCsiCqiReport;
    private int mSsRsrp;
    private int mSsRsrq;
    private int mSsSinr;
    private int mLevel;
    private int mParametersUseForLevel;
    private static final CellSignalStrengthNr sInvalid = new CellSignalStrengthNr();
    public static final Parcelable.Creator<CellSignalStrengthNr> CREATOR = new Parcelable.Creator<CellSignalStrengthNr>(){

        @Override
        public CellSignalStrengthNr createFromParcel(Parcel in) {
            return new CellSignalStrengthNr(in);
        }

        public CellSignalStrengthNr[] newArray(int size) {
            return new CellSignalStrengthNr[size];
        }
    };

    public CellSignalStrengthNr() {
        this.setDefaultValues();
    }

    public CellSignalStrengthNr(int csiRsrp, int csiRsrq, int csiSinr, int csiCqiTableIndex, List<Byte> csiCqiReport, int ssRsrp, int ssRsrq, int ssSinr) {
        this.mCsiRsrp = CellSignalStrengthNr.inRangeOrUnavailable(csiRsrp, -140, -44);
        this.mCsiRsrq = CellSignalStrengthNr.inRangeOrUnavailable(csiRsrq, -20, -3);
        this.mCsiSinr = CellSignalStrengthNr.inRangeOrUnavailable(csiSinr, -23, 23);
        this.mCsiCqiTableIndex = CellSignalStrengthNr.inRangeOrUnavailable(csiCqiTableIndex, 1, 3);
        this.mCsiCqiReport = csiCqiReport.stream().map(cqi -> new Integer(CellSignalStrengthNr.inRangeOrUnavailable(Byte.toUnsignedInt(cqi), 0, 15))).collect(Collectors.toList());
        this.mSsRsrp = CellSignalStrengthNr.inRangeOrUnavailable(ssRsrp, -140, -44);
        this.mSsRsrq = CellSignalStrengthNr.inRangeOrUnavailable(ssRsrq, -43, 20);
        this.mSsSinr = CellSignalStrengthNr.inRangeOrUnavailable(ssSinr, -23, 40);
        this.updateLevel(null, null);
    }

    public CellSignalStrengthNr(int csiRsrp, int csiRsrq, int csiSinr, int ssRsrp, int ssRsrq, int ssSinr) {
        this(csiRsrp, csiRsrq, csiSinr, Integer.MAX_VALUE, Collections.emptyList(), ssRsrp, ssRsrq, ssSinr);
    }

    public static int flip(int val) {
        return val != Integer.MAX_VALUE ? -val : val;
    }

    public int getSsRsrp() {
        return this.mSsRsrp;
    }

    public int getSsRsrq() {
        return this.mSsRsrq;
    }

    public int getSsSinr() {
        return this.mSsSinr;
    }

    public int getCsiRsrp() {
        return this.mCsiRsrp;
    }

    public int getCsiRsrq() {
        return this.mCsiRsrq;
    }

    public int getCsiSinr() {
        return this.mCsiSinr;
    }

    public int getCsiCqiTableIndex() {
        return this.mCsiCqiTableIndex;
    }

    public List<Integer> getCsiCqiReport() {
        return this.mCsiCqiReport;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mCsiRsrp);
        dest.writeInt(this.mCsiRsrq);
        dest.writeInt(this.mCsiSinr);
        dest.writeInt(this.mCsiCqiTableIndex);
        dest.writeList(this.mCsiCqiReport);
        dest.writeInt(this.mSsRsrp);
        dest.writeInt(this.mSsRsrq);
        dest.writeInt(this.mSsSinr);
        dest.writeInt(this.mLevel);
    }

    private CellSignalStrengthNr(Parcel in) {
        this.mCsiRsrp = in.readInt();
        this.mCsiRsrq = in.readInt();
        this.mCsiSinr = in.readInt();
        this.mCsiCqiTableIndex = in.readInt();
        this.mCsiCqiReport = in.readArrayList(Integer.class.getClassLoader(), Integer.class);
        this.mSsRsrp = in.readInt();
        this.mSsRsrq = in.readInt();
        this.mSsSinr = in.readInt();
        this.mLevel = in.readInt();
    }

    @Override
    public void setDefaultValues() {
        this.mCsiRsrp = Integer.MAX_VALUE;
        this.mCsiRsrq = Integer.MAX_VALUE;
        this.mCsiSinr = Integer.MAX_VALUE;
        this.mCsiCqiTableIndex = Integer.MAX_VALUE;
        this.mCsiCqiReport = Collections.emptyList();
        this.mSsRsrp = Integer.MAX_VALUE;
        this.mSsRsrq = Integer.MAX_VALUE;
        this.mSsSinr = Integer.MAX_VALUE;
        this.mLevel = 0;
        this.mParametersUseForLevel = 1;
    }

    @Override
    public int getLevel() {
        return this.mLevel;
    }

    private boolean isLevelForParameter(int parameterType) {
        return (parameterType & this.mParametersUseForLevel) == parameterType;
    }

    @Override
    public void updateLevel(PersistableBundle cc, ServiceState ss) {
        if (cc == null) {
            this.mParametersUseForLevel = 1;
        } else {
            this.mParametersUseForLevel = cc.getInt("parameters_use_for_5g_nr_signal_bar_int", 1);
            this.mSsRsrpThresholds = cc.getIntArray("5g_nr_ssrsrp_thresholds_int_array");
            this.mSsRsrqThresholds = cc.getIntArray("5g_nr_ssrsrq_thresholds_int_array");
            this.mSsSinrThresholds = cc.getIntArray("5g_nr_sssinr_thresholds_int_array");
        }
        int ssRsrpLevel = Integer.MAX_VALUE;
        int ssRsrqLevel = Integer.MAX_VALUE;
        int ssSinrLevel = Integer.MAX_VALUE;
        if (this.isLevelForParameter(1)) {
            int rsrpBoost = 0;
            if (ss != null) {
                rsrpBoost = ss.getArfcnRsrpBoost();
            }
            ssRsrpLevel = this.updateLevelWithMeasure(this.mSsRsrp + rsrpBoost, this.mSsRsrpThresholds);
        }
        if (this.isLevelForParameter(2)) {
            ssRsrqLevel = this.updateLevelWithMeasure(this.mSsRsrq, this.mSsRsrqThresholds);
        }
        if (this.isLevelForParameter(4)) {
            ssSinrLevel = this.updateLevelWithMeasure(this.mSsSinr, this.mSsSinrThresholds);
        }
        this.mLevel = Math.min(Math.min(ssRsrpLevel, ssRsrqLevel), ssSinrLevel);
    }

    private int updateLevelWithMeasure(int measure, int[] thresholds) {
        int level = measure == Integer.MAX_VALUE ? 0 : (measure >= thresholds[3] ? 4 : (measure >= thresholds[2] ? 3 : (measure >= thresholds[1] ? 2 : (measure >= thresholds[0] ? 1 : 0))));
        return level;
    }

    @Override
    public int getAsuLevel() {
        int nrDbm = this.getDbm();
        int asuLevel = nrDbm == Integer.MAX_VALUE ? 99 : (nrDbm <= -140 ? 0 : (nrDbm >= -43 ? 97 : nrDbm + 140));
        return asuLevel;
    }

    @Override
    public int getDbm() {
        return this.mSsRsrp;
    }

    public CellSignalStrengthNr(CellSignalStrengthNr s) {
        this.mCsiRsrp = s.mCsiRsrp;
        this.mCsiRsrq = s.mCsiRsrq;
        this.mCsiSinr = s.mCsiSinr;
        this.mCsiCqiTableIndex = s.mCsiCqiTableIndex;
        this.mCsiCqiReport = s.mCsiCqiReport;
        this.mSsRsrp = s.mSsRsrp;
        this.mSsRsrq = s.mSsRsrq;
        this.mSsSinr = s.mSsSinr;
        this.mLevel = s.mLevel;
        this.mParametersUseForLevel = s.mParametersUseForLevel;
    }

    @Override
    public CellSignalStrengthNr copy() {
        return new CellSignalStrengthNr(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mCsiRsrp, this.mCsiRsrq, this.mCsiSinr, this.mCsiCqiTableIndex, this.mCsiCqiReport, this.mSsRsrp, this.mSsRsrq, this.mSsSinr, this.mLevel);
    }

    @Override
    public boolean isValid() {
        return !this.equals(sInvalid);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CellSignalStrengthNr) {
            CellSignalStrengthNr o = (CellSignalStrengthNr)obj;
            return this.mCsiRsrp == o.mCsiRsrp && this.mCsiRsrq == o.mCsiRsrq && this.mCsiSinr == o.mCsiSinr && this.mCsiCqiTableIndex == o.mCsiCqiTableIndex && this.mCsiCqiReport.equals(o.mCsiCqiReport) && this.mSsRsrp == o.mSsRsrp && this.mSsRsrq == o.mSsRsrq && this.mSsSinr == o.mSsSinr && this.mLevel == o.mLevel;
        }
        return false;
    }

    public String toString() {
        return "CellSignalStrengthNr:{" + (" csiRsrp = " + this.mCsiRsrp) + (" csiRsrq = " + this.mCsiRsrq) + (" csiCqiTableIndex = " + this.mCsiCqiTableIndex) + (" csiCqiReport = " + this.mCsiCqiReport) + (" ssRsrp = " + this.mSsRsrp) + (" ssRsrq = " + this.mSsRsrq) + (" ssSinr = " + this.mSsSinr) + (" level = " + this.mLevel) + (" parametersUseForLevel = " + this.mParametersUseForLevel) + " }";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SignalLevelAndReportCriteriaSource {
    }
}

