/*
 * Decompiled with CFR 0.152.
 */
package android.system.suspend.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.system.suspend.internal.SuspendInfo;
import android.system.suspend.internal.WakeLockInfo;
import android.system.suspend.internal.WakeupInfo;

public interface ISuspendControlServiceInternal
extends IInterface {
    public static final String DESCRIPTOR = "android$system$suspend$internal$ISuspendControlServiceInternal".replace('$', '.');

    public boolean enableAutosuspend(IBinder var1) throws RemoteException;

    public boolean forceSuspend() throws RemoteException;

    public WakeLockInfo[] getWakeLockStats() throws RemoteException;

    public WakeupInfo[] getWakeupStats() throws RemoteException;

    public SuspendInfo getSuspendStats() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISuspendControlServiceInternal {
        static final int TRANSACTION_enableAutosuspend = 1;
        static final int TRANSACTION_forceSuspend = 2;
        static final int TRANSACTION_getWakeLockStats = 3;
        static final int TRANSACTION_getWakeupStats = 4;
        static final int TRANSACTION_getSuspendStats = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISuspendControlServiceInternal asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISuspendControlServiceInternal) {
                return (ISuspendControlServiceInternal)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.enableAutosuspend(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 2: {
                    boolean _result = this.forceSuspend();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 3: {
                    Parcelable[] _result = this.getWakeLockStats();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 4: {
                    Parcelable[] _result = this.getWakeupStats();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 5: {
                    SuspendInfo _result = this.getSuspendStats();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ISuspendControlServiceInternal {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enableAutosuspend(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean forceSuspend() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WakeLockInfo[] getWakeLockStats() throws RemoteException {
                WakeLockInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(WakeLockInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WakeupInfo[] getWakeupStats() throws RemoteException {
                WakeupInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(WakeupInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SuspendInfo getSuspendStats() throws RemoteException {
                SuspendInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SuspendInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ISuspendControlServiceInternal {
        @Override
        public boolean enableAutosuspend(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public boolean forceSuspend() throws RemoteException {
            return false;
        }

        @Override
        public WakeLockInfo[] getWakeLockStats() throws RemoteException {
            return null;
        }

        @Override
        public WakeupInfo[] getWakeupStats() throws RemoteException {
            return null;
        }

        @Override
        public SuspendInfo getSuspendStats() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

