/*
 * Decompiled with CFR 0.152.
 */
package android.service.persistentdata;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.RemoteException;
import android.service.persistentdata.IPersistentDataBlockService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class PersistentDataBlockManager {
    private static final String TAG = PersistentDataBlockManager.class.getSimpleName();
    private IPersistentDataBlockService sService;
    public static final int FLASH_LOCK_UNKNOWN = -1;
    public static final int FLASH_LOCK_UNLOCKED = 0;
    public static final int FLASH_LOCK_LOCKED = 1;

    public PersistentDataBlockManager(IPersistentDataBlockService service) {
        this.sService = service;
    }

    @SuppressLint(value={"RequiresPermission"})
    public int write(byte[] data) {
        try {
            return this.sService.write(data);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"RequiresPermission"})
    public byte[] read() {
        try {
            return this.sService.read();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_PDB_STATE")
    public int getDataBlockSize() {
        try {
            return this.sService.getDataBlockSize();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"RequiresPermission"})
    public long getMaximumDataBlockSize() {
        try {
            return this.sService.getMaximumDataBlockSize();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.OEM_UNLOCK_STATE")
    public void wipe() {
        try {
            this.sService.wipe();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.OEM_UNLOCK_STATE")
    public void setOemUnlockEnabled(boolean enabled) {
        try {
            this.sService.setOemUnlockEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_OEM_UNLOCK_STATE", "android.permission.OEM_UNLOCK_STATE"})
    public boolean getOemUnlockEnabled() {
        try {
            return this.sService.getOemUnlockEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_OEM_UNLOCK_STATE", "android.permission.OEM_UNLOCK_STATE"})
    public int getFlashLockState() {
        try {
            return this.sService.getFlashLockState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_PDB_STATE")
    public String getPersistentDataPackageName() {
        try {
            return this.sService.getPersistentDataPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FlashLockState {
    }
}

