/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.content.Context;
import android.security.net.config.ApplicationConfig;
import android.security.net.config.ConfigNetworkSecurityPolicy;
import android.security.net.config.ManifestConfigSource;
import android.util.Log;
import java.security.Provider;
import java.security.Security;
import libcore.net.NetworkSecurityPolicy;

public class NetworkSecurityConfigProvider
extends Provider {
    private static final String LOG_TAG = "nsconfig";
    private static final String PREFIX = NetworkSecurityConfigProvider.class.getPackage().getName() + ".";

    public NetworkSecurityConfigProvider() {
        super("AndroidNSSP", 1.0, "Android Network Security Policy Provider");
        this.put("TrustManagerFactory.PKIX", PREFIX + "RootTrustManagerFactorySpi");
        this.put("Alg.Alias.TrustManagerFactory.X509", "PKIX");
    }

    public static void install(Context context) {
        ApplicationConfig config = new ApplicationConfig(new ManifestConfigSource(context));
        ApplicationConfig.setDefaultInstance(config);
        int pos = Security.insertProviderAt(new NetworkSecurityConfigProvider(), 1);
        if (pos != 1) {
            throw new RuntimeException("Failed to install provider as highest priority provider. Provider was installed at position " + pos);
        }
        NetworkSecurityPolicy.setInstance(new ConfigNetworkSecurityPolicy(config));
    }

    public static void handleNewApplication(Context context) {
        ApplicationConfig config = new ApplicationConfig(new ManifestConfigSource(context));
        ApplicationConfig defaultConfig = ApplicationConfig.getDefaultInstance();
        String mProcessName = context.getApplicationInfo().processName;
        if (defaultConfig != null && defaultConfig.isCleartextTrafficPermitted() != config.isCleartextTrafficPermitted()) {
            Log.w(LOG_TAG, mProcessName + ": New config does not match the previously set config.");
            if (defaultConfig.hasPerDomainConfigs() || config.hasPerDomainConfigs()) {
                throw new RuntimeException("Found multiple conflicting per-domain rules");
            }
            config = defaultConfig.isCleartextTrafficPermitted() ? defaultConfig : config;
        }
        ApplicationConfig.setDefaultInstance(config);
    }
}

