/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore2;

import android.security.KeyStoreException;
import android.security.KeyStoreOperation;
import android.security.keystore.ArrayUtils;
import android.security.keystore2.KeyStoreCryptoOperationStreamer;
import libcore.util.EmptyArray;

class KeyStoreCryptoOperationChunkedStreamer
implements KeyStoreCryptoOperationStreamer {
    private static final int DEFAULT_CHUNK_SIZE_MAX = 32768;
    private static final int DEFAULT_CHUNK_SIZE_THRESHOLD = 2048;
    private final Stream mKeyStoreStream;
    private final int mChunkSizeMax;
    private final int mChunkSizeThreshold;
    private final byte[] mChunk;
    private int mChunkLength = 0;
    private long mConsumedInputSizeBytes = 0L;
    private long mProducedOutputSizeBytes = 0L;

    KeyStoreCryptoOperationChunkedStreamer(Stream operation) {
        this(operation, 2048, 32768);
    }

    KeyStoreCryptoOperationChunkedStreamer(Stream operation, int chunkSizeThreshold) {
        this(operation, chunkSizeThreshold, 32768);
    }

    KeyStoreCryptoOperationChunkedStreamer(Stream operation, int chunkSizeThreshold, int chunkSizeMax) {
        this.mKeyStoreStream = operation;
        this.mChunkSizeMax = chunkSizeMax;
        this.mChunkSizeThreshold = chunkSizeThreshold <= 0 ? 1 : (chunkSizeThreshold > chunkSizeMax ? chunkSizeMax : chunkSizeThreshold);
        this.mChunk = new byte[this.mChunkSizeMax];
    }

    @Override
    public byte[] update(byte[] input, int inputOffset, int inputLength) throws KeyStoreException {
        byte[] o;
        if (inputLength == 0 || input == null) {
            return EmptyArray.BYTE;
        }
        if (inputLength < 0 || inputOffset < 0 || inputOffset + inputLength > input.length) {
            throw new KeyStoreException(-1000, "Input offset and length out of bounds of input array");
        }
        byte[] output = EmptyArray.BYTE;
        if (this.mChunkLength > 0) {
            int inputConsumed = ArrayUtils.copy(input, inputOffset, this.mChunk, this.mChunkLength, inputLength);
            inputLength -= inputConsumed;
            inputOffset += inputConsumed;
            this.mChunkLength += inputConsumed;
            if (this.mChunkLength < this.mChunkSizeMax) {
                return output;
            }
            o = this.mKeyStoreStream.update(this.mChunk);
            if (o != null) {
                output = ArrayUtils.concat(output, o);
            }
            this.mConsumedInputSizeBytes += (long)inputConsumed;
            this.mChunkLength = 0;
        }
        while (inputLength >= this.mChunkSizeThreshold) {
            int nextChunkSize = inputLength < this.mChunkSizeMax ? inputLength : this.mChunkSizeMax;
            o = this.mKeyStoreStream.update(ArrayUtils.subarray(input, inputOffset, nextChunkSize));
            inputLength -= nextChunkSize;
            inputOffset += nextChunkSize;
            this.mConsumedInputSizeBytes += (long)nextChunkSize;
            if (o == null) continue;
            output = ArrayUtils.concat(output, o);
        }
        if (inputLength > 0) {
            this.mChunkLength = ArrayUtils.copy(input, inputOffset, this.mChunk, 0, inputLength);
            this.mConsumedInputSizeBytes += (long)inputLength;
        }
        this.mProducedOutputSizeBytes += (long)output.length;
        return output;
    }

    @Override
    public byte[] doFinal(byte[] input, int inputOffset, int inputLength, byte[] signature) throws KeyStoreException {
        byte[] output = this.update(input, inputOffset, inputLength);
        byte[] finalChunk = ArrayUtils.subarray(this.mChunk, 0, this.mChunkLength);
        byte[] o = this.mKeyStoreStream.finish(finalChunk, signature);
        if (o != null) {
            this.mProducedOutputSizeBytes += (long)o.length;
            output = output != null ? ArrayUtils.concat(output, o) : o;
        }
        return output;
    }

    @Override
    public long getConsumedInputSizeBytes() {
        return this.mConsumedInputSizeBytes;
    }

    @Override
    public long getProducedOutputSizeBytes() {
        return this.mProducedOutputSizeBytes;
    }

    public static class MainDataStream
    implements Stream {
        private final KeyStoreOperation mOperation;

        MainDataStream(KeyStoreOperation operation) {
            this.mOperation = operation;
        }

        @Override
        public byte[] update(byte[] input) throws KeyStoreException {
            return this.mOperation.update(input);
        }

        @Override
        public byte[] finish(byte[] input, byte[] signature) throws KeyStoreException {
            return this.mOperation.finish(input, signature);
        }
    }

    static interface Stream {
        public byte[] update(byte[] var1) throws KeyStoreException;

        public byte[] finish(byte[] var1, byte[] var2) throws KeyStoreException;
    }
}

