/*
 * Decompiled with CFR 0.152.
 */
package android.security.attestationverification;

import android.annotation.RequiresPermission;
import android.content.Context;
import android.os.Bundle;
import android.os.ParcelDuration;
import android.os.RemoteException;
import android.security.attestationverification.AttestationProfile;
import android.security.attestationverification.IAttestationVerificationManagerService;
import android.security.attestationverification.VerificationToken;
import android.util.Log;
import com.android.internal.infra.AndroidFuture;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public class AttestationVerificationManager {
    private static final String TAG = "AVF";
    private static final Duration MAX_TOKEN_AGE = Duration.ofHours(1L);
    private final Context mContext;
    private final IAttestationVerificationManagerService mService;
    public static final int PROFILE_UNKNOWN = 0;
    public static final int PROFILE_APP_DEFINED = 1;
    public static final int PROFILE_SELF_TRUSTED = 2;
    public static final int PROFILE_PEER_DEVICE = 3;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_APP_DEFINED = 1;
    public static final int TYPE_PUBLIC_KEY = 2;
    public static final int TYPE_CHALLENGE = 3;
    public static final int RESULT_UNKNOWN = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_FAILURE = 2;
    public static final String PARAM_PUBLIC_KEY = "localbinding.public_key";
    public static final String PARAM_ID = "localbinding.id";
    public static final String PARAM_CHALLENGE = "localbinding.challenge";

    @RequiresPermission(value="android.permission.USE_ATTESTATION_VERIFICATION_SERVICE")
    public void verifyAttestation(AttestationProfile profile, int localBindingType, Bundle requirements, byte[] attestation, Executor executor, BiConsumer<Integer, VerificationToken> callback) {
        try {
            AndroidFuture resultCallback = new AndroidFuture();
            resultCallback.thenAccept(result -> {
                Log.d(TAG, "verifyAttestation result: " + result.resultCode + " / " + result.token);
                executor.execute(() -> callback.accept(result.resultCode, result.token));
            });
            this.mService.verifyAttestation(profile, localBindingType, requirements, attestation, resultCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_ATTESTATION_VERIFICATION_SERVICE")
    public int verifyToken(AttestationProfile profile, int localBindingType, Bundle requirements, VerificationToken token, Duration maximumAge) {
        Duration usedMaximumAge;
        if (maximumAge == null) {
            usedMaximumAge = MAX_TOKEN_AGE;
        } else {
            if (maximumAge.compareTo(MAX_TOKEN_AGE) > 0) {
                throw new IllegalArgumentException("maximumAge cannot be greater than " + MAX_TOKEN_AGE + "; was " + maximumAge);
            }
            usedMaximumAge = maximumAge;
        }
        try {
            AndroidFuture resultCallback = new AndroidFuture();
            resultCallback.orTimeout(5L, TimeUnit.SECONDS);
            this.mService.verifyToken(token, new ParcelDuration(usedMaximumAge), resultCallback);
            return (Integer)resultCallback.get();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error verifying token.", t);
        }
    }

    public AttestationVerificationManager(Context context, IAttestationVerificationManagerService service) {
        this.mContext = context;
        this.mService = service;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface VerificationResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LocalBindingType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AttestationProfileId {
    }
}

