/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

@SystemApi
public class PermissionGroupUsage
implements Parcelable {
    private final String mPackageName;
    private final int mUid;
    private final long mLastAccessTimeMillis;
    private final String mPermissionGroupName;
    private final boolean mActive;
    private final boolean mPhoneCall;
    private final CharSequence mAttributionTag;
    private final CharSequence mAttributionLabel;
    private final CharSequence mProxyLabel;
    public static final Parcelable.Creator<PermissionGroupUsage> CREATOR = new Parcelable.Creator<PermissionGroupUsage>(){

        public PermissionGroupUsage[] newArray(int size) {
            return new PermissionGroupUsage[size];
        }

        @Override
        public PermissionGroupUsage createFromParcel(Parcel in) {
            return new PermissionGroupUsage(in);
        }
    };

    public PermissionGroupUsage(String packageName, int uid, long lastAccessTimeMillis, String permissionGroupName, boolean active, boolean phoneCall, CharSequence attributionTag, CharSequence attributionLabel, CharSequence proxyLabel) {
        this.mPackageName = packageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
        this.mUid = uid;
        this.mLastAccessTimeMillis = lastAccessTimeMillis;
        this.mPermissionGroupName = permissionGroupName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPermissionGroupName);
        this.mActive = active;
        this.mPhoneCall = phoneCall;
        this.mAttributionTag = attributionTag;
        this.mAttributionLabel = attributionLabel;
        this.mProxyLabel = proxyLabel;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public int getUid() {
        return this.mUid;
    }

    public long getLastAccessTimeMillis() {
        return this.mLastAccessTimeMillis;
    }

    public String getPermissionGroupName() {
        return this.mPermissionGroupName;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public boolean isPhoneCall() {
        return this.mPhoneCall;
    }

    public CharSequence getAttributionTag() {
        return this.mAttributionTag;
    }

    public CharSequence getAttributionLabel() {
        return this.mAttributionLabel;
    }

    public CharSequence getProxyLabel() {
        return this.mProxyLabel;
    }

    public String toString() {
        return "PermissionGroupUsage { packageName = " + this.mPackageName + ", uid = " + this.mUid + ", lastAccessTimeMillis = " + this.mLastAccessTimeMillis + ", permissionGroupName = " + this.mPermissionGroupName + ", active = " + this.mActive + ", phoneCall = " + this.mPhoneCall + ", attributionTag = " + this.mAttributionTag + ", attributionLabel = " + this.mAttributionLabel + ", proxyLabel = " + this.mProxyLabel + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionGroupUsage that = (PermissionGroupUsage)o;
        return Objects.equals(this.mPackageName, that.mPackageName) && this.mUid == that.mUid && this.mLastAccessTimeMillis == that.mLastAccessTimeMillis && Objects.equals(this.mPermissionGroupName, that.mPermissionGroupName) && this.mActive == that.mActive && this.mPhoneCall == that.mPhoneCall && Objects.equals(this.mAttributionTag, that.mAttributionTag) && Objects.equals(this.mAttributionLabel, that.mAttributionLabel) && Objects.equals(this.mProxyLabel, that.mProxyLabel);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mPackageName);
        _hash = 31 * _hash + this.mUid;
        _hash = 31 * _hash + Long.hashCode(this.mLastAccessTimeMillis);
        _hash = 31 * _hash + Objects.hashCode(this.mPermissionGroupName);
        _hash = 31 * _hash + Boolean.hashCode(this.mActive);
        _hash = 31 * _hash + Boolean.hashCode(this.mPhoneCall);
        _hash = 31 * _hash + Objects.hashCode(this.mAttributionTag);
        _hash = 31 * _hash + Objects.hashCode(this.mAttributionLabel);
        _hash = 31 * _hash + Objects.hashCode(this.mProxyLabel);
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int flg = 0;
        if (this.mActive) {
            flg |= 0x10;
        }
        if (this.mPhoneCall) {
            flg |= 0x20;
        }
        if (this.mAttributionTag != null) {
            flg |= 0x40;
        }
        if (this.mAttributionLabel != null) {
            flg |= 0x80;
        }
        if (this.mProxyLabel != null) {
            flg |= 0x100;
        }
        dest.writeInt(flg);
        dest.writeString(this.mPackageName);
        dest.writeInt(this.mUid);
        dest.writeLong(this.mLastAccessTimeMillis);
        dest.writeString(this.mPermissionGroupName);
        if (this.mAttributionTag != null) {
            dest.writeCharSequence(this.mAttributionTag);
        }
        if (this.mAttributionLabel != null) {
            dest.writeCharSequence(this.mAttributionLabel);
        }
        if (this.mProxyLabel != null) {
            dest.writeCharSequence(this.mProxyLabel);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    PermissionGroupUsage(Parcel in) {
        int flg = in.readInt();
        boolean active = (flg & 0x10) != 0;
        boolean phoneCall = (flg & 0x20) != 0;
        String packageName = in.readString();
        int uid = in.readInt();
        long lastAccessTimeMillis = in.readLong();
        String permissionGroupName = in.readString();
        CharSequence attributionTag = (flg & 0x40) == 0 ? null : in.readCharSequence();
        CharSequence attributionLabel = (flg & 0x80) == 0 ? null : in.readCharSequence();
        CharSequence proxyLabel = (flg & 0x100) == 0 ? null : in.readCharSequence();
        this.mPackageName = packageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
        this.mUid = uid;
        this.mLastAccessTimeMillis = lastAccessTimeMillis;
        this.mPermissionGroupName = permissionGroupName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPermissionGroupName);
        this.mActive = active;
        this.mPhoneCall = phoneCall;
        this.mAttributionTag = attributionTag;
        this.mAttributionLabel = attributionLabel;
        this.mProxyLabel = proxyLabel;
    }

    @Deprecated
    private void __metadata() {
    }
}

