/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.vibrator.PrebakedSegment;
import android.os.vibrator.PrimitiveSegment;
import android.os.vibrator.RampSegment;
import android.os.vibrator.StepSegment;

public abstract class VibrationEffectSegment
implements Parcelable {
    static final int PARCEL_TOKEN_PREBAKED = 1;
    static final int PARCEL_TOKEN_PRIMITIVE = 2;
    static final int PARCEL_TOKEN_STEP = 3;
    static final int PARCEL_TOKEN_RAMP = 4;
    public static final Parcelable.Creator<VibrationEffectSegment> CREATOR = new Parcelable.Creator<VibrationEffectSegment>(){

        @Override
        public VibrationEffectSegment createFromParcel(Parcel in) {
            switch (in.readInt()) {
                case 3: {
                    return new StepSegment(in);
                }
                case 4: {
                    return new RampSegment(in);
                }
                case 1: {
                    return new PrebakedSegment(in);
                }
                case 2: {
                    return new PrimitiveSegment(in);
                }
            }
            throw new IllegalStateException("Unexpected vibration event type token in parcel.");
        }

        public VibrationEffectSegment[] newArray(int size) {
            return new VibrationEffectSegment[size];
        }
    };

    VibrationEffectSegment() {
    }

    public abstract long getDuration();

    public abstract boolean isHapticFeedbackCandidate();

    public abstract boolean hasNonZeroAmplitude();

    public abstract void validate();

    public abstract <T extends VibrationEffectSegment> T resolve(int var1);

    public abstract <T extends VibrationEffectSegment> T scale(float var1);

    public abstract <T extends VibrationEffectSegment> T applyEffectStrength(int var1);

    public static void checkFrequencyArgument(float value, String name) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException(name + " must not be NaN");
        }
        if (Float.isInfinite(value)) {
            throw new IllegalArgumentException(name + " must not be infinite");
        }
        if (value < 0.0f) {
            throw new IllegalArgumentException(name + " must be >= 0, got " + value);
        }
    }

    public static void checkDurationArgument(long value, String name) {
        if (value < 0L) {
            throw new IllegalArgumentException(name + " must be >= 0, got " + value);
        }
    }
}

