/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.os.vibrator.VibrationEffectSegment;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class StepSegment
extends VibrationEffectSegment {
    private final float mAmplitude;
    private final float mFrequencyHz;
    private final int mDuration;
    public static final Parcelable.Creator<StepSegment> CREATOR = new Parcelable.Creator<StepSegment>(){

        @Override
        public StepSegment createFromParcel(Parcel in) {
            in.readInt();
            return new StepSegment(in);
        }

        public StepSegment[] newArray(int size) {
            return new StepSegment[size];
        }
    };

    StepSegment(Parcel in) {
        this(in.readFloat(), in.readFloat(), in.readInt());
    }

    public StepSegment(float amplitude, float frequencyHz, int duration) {
        this.mAmplitude = amplitude;
        this.mFrequencyHz = frequencyHz;
        this.mDuration = duration;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StepSegment)) {
            return false;
        }
        StepSegment other = (StepSegment)o;
        return Float.compare(this.mAmplitude, other.mAmplitude) == 0 && Float.compare(this.mFrequencyHz, other.mFrequencyHz) == 0 && this.mDuration == other.mDuration;
    }

    public float getAmplitude() {
        return this.mAmplitude;
    }

    public float getFrequencyHz() {
        return this.mFrequencyHz;
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public boolean isHapticFeedbackCandidate() {
        return true;
    }

    @Override
    public boolean hasNonZeroAmplitude() {
        return Float.compare(this.mAmplitude, 0.0f) != 0;
    }

    @Override
    public void validate() {
        VibrationEffectSegment.checkFrequencyArgument(this.mFrequencyHz, "frequencyHz");
        VibrationEffectSegment.checkDurationArgument(this.mDuration, "duration");
        if (Float.compare(this.mAmplitude, -1.0f) != 0) {
            Preconditions.checkArgumentInRange(this.mAmplitude, 0.0f, 1.0f, "amplitude");
        }
    }

    public StepSegment resolve(int defaultAmplitude) {
        if (defaultAmplitude > 255 || defaultAmplitude <= 0) {
            throw new IllegalArgumentException("amplitude must be between 1 and 255 inclusive (amplitude=" + defaultAmplitude + ")");
        }
        if (Float.compare(this.mAmplitude, -1.0f) != 0) {
            return this;
        }
        return new StepSegment((float)defaultAmplitude / 255.0f, this.mFrequencyHz, this.mDuration);
    }

    public StepSegment scale(float scaleFactor) {
        if (Float.compare(this.mAmplitude, -1.0f) == 0) {
            return this;
        }
        return new StepSegment(VibrationEffect.scale(this.mAmplitude, scaleFactor), this.mFrequencyHz, this.mDuration);
    }

    public StepSegment applyEffectStrength(int effectStrength) {
        return this;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.mAmplitude), Float.valueOf(this.mFrequencyHz), this.mDuration);
    }

    public String toString() {
        return "Step{amplitude=" + this.mAmplitude + ", frequencyHz=" + this.mFrequencyHz + ", duration=" + this.mDuration + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(3);
        out.writeFloat(this.mAmplitude);
        out.writeFloat(this.mFrequencyHz);
        out.writeInt(this.mDuration);
    }
}

