/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.os.vibrator.VibrationEffectSegment;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class PrimitiveSegment
extends VibrationEffectSegment {
    private final int mPrimitiveId;
    private final float mScale;
    private final int mDelay;
    public static final Parcelable.Creator<PrimitiveSegment> CREATOR = new Parcelable.Creator<PrimitiveSegment>(){

        @Override
        public PrimitiveSegment createFromParcel(Parcel in) {
            in.readInt();
            return new PrimitiveSegment(in);
        }

        public PrimitiveSegment[] newArray(int size) {
            return new PrimitiveSegment[size];
        }
    };

    PrimitiveSegment(Parcel in) {
        this(in.readInt(), in.readFloat(), in.readInt());
    }

    public PrimitiveSegment(int id2, float scale, int delay) {
        this.mPrimitiveId = id2;
        this.mScale = scale;
        this.mDelay = delay;
    }

    public int getPrimitiveId() {
        return this.mPrimitiveId;
    }

    public float getScale() {
        return this.mScale;
    }

    public int getDelay() {
        return this.mDelay;
    }

    @Override
    public long getDuration() {
        return -1L;
    }

    @Override
    public boolean isHapticFeedbackCandidate() {
        return true;
    }

    @Override
    public boolean hasNonZeroAmplitude() {
        return true;
    }

    public PrimitiveSegment resolve(int defaultAmplitude) {
        return this;
    }

    public PrimitiveSegment scale(float scaleFactor) {
        return new PrimitiveSegment(this.mPrimitiveId, VibrationEffect.scale(this.mScale, scaleFactor), this.mDelay);
    }

    public PrimitiveSegment applyEffectStrength(int effectStrength) {
        return this;
    }

    @Override
    public void validate() {
        Preconditions.checkArgumentInRange(this.mPrimitiveId, 0, 8, "primitiveId");
        Preconditions.checkArgumentInRange(this.mScale, 0.0f, 1.0f, "scale");
        VibrationEffectSegment.checkDurationArgument(this.mDelay, "delay");
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(2);
        dest.writeInt(this.mPrimitiveId);
        dest.writeFloat(this.mScale);
        dest.writeInt(this.mDelay);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "Primitive{primitive=" + VibrationEffect.Composition.primitiveToString(this.mPrimitiveId) + ", scale=" + this.mScale + ", delay=" + this.mDelay + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimitiveSegment that = (PrimitiveSegment)o;
        return this.mPrimitiveId == that.mPrimitiveId && Float.compare(that.mScale, this.mScale) == 0 && this.mDelay == that.mDelay;
    }

    public int hashCode() {
        return Objects.hash(this.mPrimitiveId, Float.valueOf(this.mScale), this.mDelay);
    }
}

