/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;

public final class Trace {
    private static final String TAG = "Trace";
    public static final long TRACE_TAG_NEVER = 0L;
    public static final long TRACE_TAG_ALWAYS = 1L;
    public static final long TRACE_TAG_GRAPHICS = 2L;
    public static final long TRACE_TAG_INPUT = 4L;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final long TRACE_TAG_VIEW = 8L;
    public static final long TRACE_TAG_WEBVIEW = 16L;
    public static final long TRACE_TAG_WINDOW_MANAGER = 32L;
    public static final long TRACE_TAG_ACTIVITY_MANAGER = 64L;
    public static final long TRACE_TAG_SYNC_MANAGER = 128L;
    public static final long TRACE_TAG_AUDIO = 256L;
    public static final long TRACE_TAG_VIDEO = 512L;
    public static final long TRACE_TAG_CAMERA = 1024L;
    public static final long TRACE_TAG_HAL = 2048L;
    @UnsupportedAppUsage
    public static final long TRACE_TAG_APP = 4096L;
    public static final long TRACE_TAG_RESOURCES = 8192L;
    public static final long TRACE_TAG_DALVIK = 16384L;
    public static final long TRACE_TAG_RS = 32768L;
    public static final long TRACE_TAG_BIONIC = 65536L;
    public static final long TRACE_TAG_POWER = 131072L;
    public static final long TRACE_TAG_PACKAGE_MANAGER = 262144L;
    public static final long TRACE_TAG_SYSTEM_SERVER = 524288L;
    public static final long TRACE_TAG_DATABASE = 0x100000L;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final long TRACE_TAG_NETWORK = 0x200000L;
    public static final long TRACE_TAG_ADB = 0x400000L;
    public static final long TRACE_TAG_VIBRATOR = 0x800000L;
    public static final long TRACE_TAG_AIDL = 0x1000000L;
    public static final long TRACE_TAG_NNAPI = 0x2000000L;
    public static final long TRACE_TAG_RRO = 0x4000000L;
    public static final long TRACE_TAG_THERMAL = 0x8000000L;
    private static final long TRACE_TAG_NOT_READY = Long.MIN_VALUE;
    private static final int MAX_SECTION_NAME_LEN = 127;
    @UnsupportedAppUsage
    private static volatile long sEnabledTags = Long.MIN_VALUE;
    private static int sZygoteDebugFlags = 0;

    @UnsupportedAppUsage
    @CriticalNative
    private static native long nativeGetEnabledTags();

    private static native void nativeSetAppTracingAllowed(boolean var0);

    private static native void nativeSetTracingEnabled(boolean var0);

    @FastNative
    private static native void nativeTraceCounter(long var0, String var2, long var3);

    @FastNative
    private static native void nativeTraceBegin(long var0, String var2);

    @FastNative
    private static native void nativeTraceEnd(long var0);

    @FastNative
    private static native void nativeAsyncTraceBegin(long var0, String var2, int var3);

    @FastNative
    private static native void nativeAsyncTraceEnd(long var0, String var2, int var3);

    @FastNative
    private static native void nativeAsyncTraceForTrackBegin(long var0, String var2, String var3, int var4);

    @FastNative
    private static native void nativeAsyncTraceForTrackEnd(long var0, String var2, String var3, int var4);

    @FastNative
    private static native void nativeInstant(long var0, String var2);

    @FastNative
    private static native void nativeInstantForTrack(long var0, String var2, String var3);

    private Trace() {
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static boolean isTagEnabled(long traceTag) {
        long tags = Trace.nativeGetEnabledTags();
        return (tags & traceTag) != 0L;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static void traceCounter(long traceTag, String counterName, int counterValue) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeTraceCounter(traceTag, counterName, counterValue);
        }
    }

    @UnsupportedAppUsage
    public static void setAppTracingAllowed(boolean allowed) {
        Trace.nativeSetAppTracingAllowed(allowed);
    }

    public static void setTracingEnabled(boolean enabled, int debugFlags) {
        Trace.nativeSetTracingEnabled(enabled);
        sZygoteDebugFlags = debugFlags;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static void traceBegin(long traceTag, String methodName) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeTraceBegin(traceTag, methodName);
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static void traceEnd(long traceTag) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeTraceEnd(traceTag);
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static void asyncTraceBegin(long traceTag, String methodName, int cookie) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeAsyncTraceBegin(traceTag, methodName, cookie);
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static void asyncTraceEnd(long traceTag, String methodName, int cookie) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeAsyncTraceEnd(traceTag, methodName, cookie);
        }
    }

    public static void asyncTraceForTrackBegin(long traceTag, String trackName, String methodName, int cookie) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeAsyncTraceForTrackBegin(traceTag, trackName, methodName, cookie);
        }
    }

    public static void asyncTraceForTrackEnd(long traceTag, String trackName, String methodName, int cookie) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeAsyncTraceForTrackEnd(traceTag, trackName, methodName, cookie);
        }
    }

    public static void instant(long traceTag, String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("methodName cannot be null");
        }
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeInstant(traceTag, methodName);
        }
    }

    public static void instantForTrack(long traceTag, String trackName, String methodName) {
        if (trackName == null) {
            throw new IllegalArgumentException("trackName cannot be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("methodName cannot be null");
        }
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeInstantForTrack(traceTag, trackName, methodName);
        }
    }

    public static boolean isEnabled() {
        return Trace.isTagEnabled(4096L);
    }

    public static void beginSection(String sectionName) {
        if (Trace.isTagEnabled(4096L)) {
            if (sectionName.length() > 127) {
                throw new IllegalArgumentException("sectionName is too long");
            }
            Trace.nativeTraceBegin(4096L, sectionName);
        }
    }

    public static void endSection() {
        if (Trace.isTagEnabled(4096L)) {
            Trace.nativeTraceEnd(4096L);
        }
    }

    public static void beginAsyncSection(String methodName, int cookie) {
        Trace.asyncTraceBegin(4096L, methodName, cookie);
    }

    public static void endAsyncSection(String methodName, int cookie) {
        Trace.asyncTraceEnd(4096L, methodName, cookie);
    }

    public static void setCounter(String counterName, long counterValue) {
        if (Trace.isTagEnabled(4096L)) {
            Trace.nativeTraceCounter(4096L, counterName, counterValue);
        }
    }
}

