/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PropertyInvalidatedCache;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.BatterySaverPolicyConfig;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.IThermalService;
import android.os.IThermalStatusListener;
import android.os.IWakeLockCallback;
import android.os.ParcelDuration;
import android.os.PowerExemptionManager;
import android.os.PowerSaveState;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.WorkSource;
import android.service.dreams.Sandman;
import android.sysprop.InitProperties;
import android.util.ArrayMap;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public class PowerManager {
    private static final String TAG = "PowerManager";
    public static final int PARTIAL_WAKE_LOCK = 1;
    @Deprecated
    public static final int SCREEN_DIM_WAKE_LOCK = 6;
    @Deprecated
    public static final int SCREEN_BRIGHT_WAKE_LOCK = 10;
    @Deprecated
    public static final int FULL_WAKE_LOCK = 26;
    public static final int PROXIMITY_SCREEN_OFF_WAKE_LOCK = 32;
    public static final int DOZE_WAKE_LOCK = 64;
    public static final int DRAW_WAKE_LOCK = 128;
    public static final int WAKE_LOCK_LEVEL_MASK = 65535;
    @Deprecated
    public static final int ACQUIRE_CAUSES_WAKEUP = 0x10000000;
    public static final int ON_AFTER_RELEASE = 0x20000000;
    public static final int UNIMPORTANT_FOR_LOGGING = 0x40000000;
    @RequiresPermission(value="android.permission.DEVICE_POWER")
    public static final int SYSTEM_WAKELOCK = Integer.MIN_VALUE;
    public static final int RELEASE_FLAG_WAIT_FOR_NO_PROXIMITY = 1;
    public static final int RELEASE_FLAG_TIMEOUT = 65536;
    @UnsupportedAppUsage
    public static final int BRIGHTNESS_ON = 255;
    public static final int BRIGHTNESS_OFF = 0;
    public static final int BRIGHTNESS_DEFAULT = -1;
    public static final int BRIGHTNESS_INVALID = -1;
    public static final float BRIGHTNESS_MAX = 1.0f;
    public static final float BRIGHTNESS_MIN = 0.0f;
    public static final float BRIGHTNESS_OFF_FLOAT = -1.0f;
    public static final float BRIGHTNESS_INVALID_FLOAT = Float.NaN;
    @SystemApi
    public static final int USER_ACTIVITY_EVENT_OTHER = 0;
    @SystemApi
    public static final int USER_ACTIVITY_EVENT_BUTTON = 1;
    @SystemApi
    public static final int USER_ACTIVITY_EVENT_TOUCH = 2;
    @SystemApi
    public static final int USER_ACTIVITY_EVENT_ACCESSIBILITY = 3;
    public static final int USER_ACTIVITY_EVENT_ATTENTION = 4;
    public static final int USER_ACTIVITY_EVENT_FACE_DOWN = 5;
    public static final int USER_ACTIVITY_EVENT_DEVICE_STATE = 6;
    @SystemApi
    public static final int USER_ACTIVITY_FLAG_NO_CHANGE_LIGHTS = 1;
    @SystemApi
    public static final int USER_ACTIVITY_FLAG_INDIRECT = 2;
    public static final int GO_TO_SLEEP_REASON_MIN = 0;
    public static final int GO_TO_SLEEP_REASON_APPLICATION = 0;
    public static final int GO_TO_SLEEP_REASON_DEVICE_ADMIN = 1;
    @UnsupportedAppUsage
    public static final int GO_TO_SLEEP_REASON_TIMEOUT = 2;
    public static final int GO_TO_SLEEP_REASON_LID_SWITCH = 3;
    public static final int GO_TO_SLEEP_REASON_POWER_BUTTON = 4;
    public static final int GO_TO_SLEEP_REASON_HDMI = 5;
    public static final int GO_TO_SLEEP_REASON_SLEEP_BUTTON = 6;
    public static final int GO_TO_SLEEP_REASON_ACCESSIBILITY = 7;
    public static final int GO_TO_SLEEP_REASON_FORCE_SUSPEND = 8;
    public static final int GO_TO_SLEEP_REASON_INATTENTIVE = 9;
    public static final int GO_TO_SLEEP_REASON_QUIESCENT = 10;
    public static final int GO_TO_SLEEP_REASON_DISPLAY_GROUP_REMOVED = 11;
    public static final int GO_TO_SLEEP_REASON_DISPLAY_GROUPS_TURNED_OFF = 12;
    public static final int GO_TO_SLEEP_REASON_DEVICE_FOLD = 13;
    public static final int GO_TO_SLEEP_REASON_MAX = 13;
    public static final int GO_TO_SLEEP_FLAG_NO_DOZE = 1;
    public static final int BRIGHTNESS_CONSTRAINT_TYPE_MINIMUM = 0;
    public static final int BRIGHTNESS_CONSTRAINT_TYPE_MAXIMUM = 1;
    public static final int BRIGHTNESS_CONSTRAINT_TYPE_DEFAULT = 2;
    public static final int BRIGHTNESS_CONSTRAINT_TYPE_DIM = 3;
    public static final int BRIGHTNESS_CONSTRAINT_TYPE_DOZE = 4;
    public static final int BRIGHTNESS_CONSTRAINT_TYPE_MINIMUM_VR = 5;
    public static final int BRIGHTNESS_CONSTRAINT_TYPE_MAXIMUM_VR = 6;
    public static final int BRIGHTNESS_CONSTRAINT_TYPE_DEFAULT_VR = 7;
    public static final int WAKE_REASON_UNKNOWN = 0;
    public static final int WAKE_REASON_POWER_BUTTON = 1;
    public static final int WAKE_REASON_APPLICATION = 2;
    public static final int WAKE_REASON_PLUGGED_IN = 3;
    public static final int WAKE_REASON_GESTURE = 4;
    public static final int WAKE_REASON_CAMERA_LAUNCH = 5;
    public static final int WAKE_REASON_WAKE_KEY = 6;
    public static final int WAKE_REASON_WAKE_MOTION = 7;
    public static final int WAKE_REASON_HDMI = 8;
    public static final int WAKE_REASON_LID = 9;
    public static final int WAKE_REASON_DISPLAY_GROUP_ADDED = 10;
    public static final int WAKE_REASON_DISPLAY_GROUP_TURNED_ON = 11;
    public static final int WAKE_REASON_UNFOLD_DEVICE = 12;
    public static final int WAKE_REASON_DREAM_FINISHED = 13;
    public static final String REBOOT_RECOVERY = "recovery";
    public static final String REBOOT_RECOVERY_UPDATE = "recovery-update";
    public static final String REBOOT_REQUESTED_BY_DEVICE_OWNER = "deviceowner";
    public static final String REBOOT_SAFE_MODE = "safemode";
    @SystemApi
    public static final String REBOOT_USERSPACE = "userspace";
    public static final String REBOOT_QUIESCENT = "quiescent";
    public static final String SHUTDOWN_USER_REQUESTED = "userrequested";
    public static final String SHUTDOWN_BATTERY_THERMAL_STATE = "thermal,battery";
    public static final String SHUTDOWN_THERMAL_STATE = "thermal";
    public static final String SHUTDOWN_LOW_BATTERY = "battery";
    public static final int SHUTDOWN_REASON_UNKNOWN = 0;
    public static final int SHUTDOWN_REASON_SHUTDOWN = 1;
    public static final int SHUTDOWN_REASON_REBOOT = 2;
    public static final int SHUTDOWN_REASON_USER_REQUESTED = 3;
    public static final int SHUTDOWN_REASON_THERMAL_SHUTDOWN = 4;
    public static final int SHUTDOWN_REASON_LOW_BATTERY = 5;
    public static final int SHUTDOWN_REASON_BATTERY_THERMAL = 6;
    public static final int LOCATION_MODE_NO_CHANGE = 0;
    public static final int LOCATION_MODE_GPS_DISABLED_WHEN_SCREEN_OFF = 1;
    public static final int LOCATION_MODE_ALL_DISABLED_WHEN_SCREEN_OFF = 2;
    public static final int LOCATION_MODE_FOREGROUND_ONLY = 3;
    public static final int LOCATION_MODE_THROTTLE_REQUESTS_WHEN_SCREEN_OFF = 4;
    public static final int MIN_LOCATION_MODE = 0;
    public static final int MAX_LOCATION_MODE = 4;
    @SystemApi
    public static final int SOUND_TRIGGER_MODE_ALL_ENABLED = 0;
    @SystemApi
    public static final int SOUND_TRIGGER_MODE_CRITICAL_ONLY = 1;
    @SystemApi
    public static final int SOUND_TRIGGER_MODE_ALL_DISABLED = 2;
    public static final int MIN_SOUND_TRIGGER_MODE = 0;
    public static final int MAX_SOUND_TRIGGER_MODE = 2;
    private static final String CACHE_KEY_IS_POWER_SAVE_MODE_PROPERTY = "cache_key.is_power_save_mode";
    private static final String CACHE_KEY_IS_INTERACTIVE_PROPERTY = "cache_key.is_interactive";
    private static final int MAX_CACHE_ENTRIES = 1;
    private final PropertyInvalidatedCache<Void, Boolean> mPowerSaveModeCache = new PropertyInvalidatedCache<Void, Boolean>(1, "cache_key.is_power_save_mode"){

        @Override
        public Boolean recompute(Void query) {
            try {
                return PowerManager.this.mService.isPowerSaveMode();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    };
    private final PropertyInvalidatedCache<Void, Boolean> mInteractiveCache = new PropertyInvalidatedCache<Void, Boolean>(1, "cache_key.is_interactive"){

        @Override
        public Boolean recompute(Void query) {
            try {
                return PowerManager.this.mService.isInteractive();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    };
    final Context mContext;
    @UnsupportedAppUsage
    final IPowerManager mService;
    @UnsupportedAppUsage(maxTargetSdk=28)
    final Handler mHandler;
    final IThermalService mThermalService;
    private PowerExemptionManager mPowerExemptionManager;
    private final ArrayMap<OnThermalStatusChangedListener, IThermalStatusListener> mListenerMap = new ArrayMap();
    @SystemApi
    public static final int POWER_SAVE_MODE_TRIGGER_PERCENTAGE = 0;
    @SystemApi
    public static final int POWER_SAVE_MODE_TRIGGER_DYNAMIC = 1;
    public static final int THERMAL_STATUS_NONE = 0;
    public static final int THERMAL_STATUS_LIGHT = 1;
    public static final int THERMAL_STATUS_MODERATE = 2;
    public static final int THERMAL_STATUS_SEVERE = 3;
    public static final int THERMAL_STATUS_CRITICAL = 4;
    public static final int THERMAL_STATUS_EMERGENCY = 5;
    public static final int THERMAL_STATUS_SHUTDOWN = 6;
    private final AtomicLong mLastHeadroomUpdate = new AtomicLong(0L);
    private static final int MINIMUM_HEADROOM_TIME_MILLIS = 500;
    public static final String ACTION_ENHANCED_DISCHARGE_PREDICTION_CHANGED = "android.os.action.ENHANCED_DISCHARGE_PREDICTION_CHANGED";
    public static final String ACTION_POWER_SAVE_MODE_CHANGED = "android.os.action.POWER_SAVE_MODE_CHANGED";
    public static final String ACTION_POWER_SAVE_MODE_CHANGED_INTERNAL = "android.os.action.POWER_SAVE_MODE_CHANGED_INTERNAL";
    public static final String ACTION_DEVICE_IDLE_MODE_CHANGED = "android.os.action.DEVICE_IDLE_MODE_CHANGED";
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_DEVICE_LIGHT_IDLE_MODE_CHANGED = "android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED";
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, publicAlternatives="Use {@link #ACTION_DEVICE_LIGHT_IDLE_MODE_CHANGED} instead")
    public static final String ACTION_LIGHT_DEVICE_IDLE_MODE_CHANGED = "android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED";
    public static final String ACTION_POWER_SAVE_WHITELIST_CHANGED = "android.os.action.POWER_SAVE_WHITELIST_CHANGED";
    public static final String ACTION_POWER_SAVE_TEMP_WHITELIST_CHANGED = "android.os.action.POWER_SAVE_TEMP_WHITELIST_CHANGED";
    public static final String ACTION_LOW_POWER_STANDBY_ENABLED_CHANGED = "android.os.action.LOW_POWER_STANDBY_ENABLED_CHANGED";
    public static final int PRE_IDLE_TIMEOUT_MODE_NORMAL = 0;
    public static final int PRE_IDLE_TIMEOUT_MODE_LONG = 1;
    public static final int PRE_IDLE_TIMEOUT_MODE_SHORT = 2;

    public static String sleepReasonToString(int sleepReason) {
        switch (sleepReason) {
            case 7: {
                return "accessibility";
            }
            case 0: {
                return "application";
            }
            case 1: {
                return "device_admin";
            }
            case 13: {
                return "device_folded";
            }
            case 11: {
                return "display_group_removed";
            }
            case 12: {
                return "display_groups_turned_off";
            }
            case 8: {
                return "force_suspend";
            }
            case 5: {
                return "hdmi";
            }
            case 9: {
                return "inattentive";
            }
            case 3: {
                return "lid_switch";
            }
            case 4: {
                return "power_button";
            }
            case 10: {
                return REBOOT_QUIESCENT;
            }
            case 6: {
                return "sleep_button";
            }
            case 2: {
                return "timeout";
            }
        }
        return Integer.toString(sleepReason);
    }

    public static String wakeReasonToString(int wakeReason) {
        switch (wakeReason) {
            case 0: {
                return "WAKE_REASON_UNKNOWN";
            }
            case 1: {
                return "WAKE_REASON_POWER_BUTTON";
            }
            case 2: {
                return "WAKE_REASON_APPLICATION";
            }
            case 3: {
                return "WAKE_REASON_PLUGGED_IN";
            }
            case 4: {
                return "WAKE_REASON_GESTURE";
            }
            case 5: {
                return "WAKE_REASON_CAMERA_LAUNCH";
            }
            case 6: {
                return "WAKE_REASON_WAKE_KEY";
            }
            case 7: {
                return "WAKE_REASON_WAKE_MOTION";
            }
            case 8: {
                return "WAKE_REASON_HDMI";
            }
            case 9: {
                return "WAKE_REASON_LID";
            }
            case 10: {
                return "WAKE_REASON_DISPLAY_GROUP_ADDED";
            }
            case 11: {
                return "WAKE_REASON_DISPLAY_GROUP_TURNED_ON";
            }
            case 12: {
                return "WAKE_REASON_UNFOLD_DEVICE";
            }
            case 13: {
                return "WAKE_REASON_DREAM_FINISHED";
            }
        }
        return Integer.toString(wakeReason);
    }

    public static String locationPowerSaveModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "NO_CHANGE";
            }
            case 1: {
                return "GPS_DISABLED_WHEN_SCREEN_OFF";
            }
            case 2: {
                return "ALL_DISABLED_WHEN_SCREEN_OFF";
            }
            case 3: {
                return "FOREGROUND_ONLY";
            }
            case 4: {
                return "THROTTLE_REQUESTS_WHEN_SCREEN_OFF";
            }
        }
        return Integer.toString(mode);
    }

    public PowerManager(Context context, IPowerManager service, IThermalService thermalService, Handler handler) {
        this.mContext = context;
        this.mService = service;
        this.mThermalService = thermalService;
        this.mHandler = handler;
    }

    private PowerExemptionManager getPowerExemptionManager() {
        if (this.mPowerExemptionManager == null) {
            this.mPowerExemptionManager = this.mContext.getSystemService(PowerExemptionManager.class);
        }
        return this.mPowerExemptionManager;
    }

    @UnsupportedAppUsage
    public int getMinimumScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17694928);
    }

    @UnsupportedAppUsage
    public int getMaximumScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17694927);
    }

    @UnsupportedAppUsage
    public int getDefaultScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17694926);
    }

    public int getMinimumScreenBrightnessForVrSetting() {
        return this.mContext.getResources().getInteger(17694925);
    }

    public int getMaximumScreenBrightnessForVrSetting() {
        return this.mContext.getResources().getInteger(17694924);
    }

    public int getDefaultScreenBrightnessForVrSetting() {
        return this.mContext.getResources().getInteger(17694923);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public float getBrightnessConstraint(int constraint) {
        try {
            return this.mService.getBrightnessConstraint(constraint);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public WakeLock newWakeLock(int levelAndFlags, String tag) {
        PowerManager.validateWakeLockParameters(levelAndFlags, tag);
        return new WakeLock(levelAndFlags, tag, this.mContext.getOpPackageName(), -1);
    }

    public WakeLock newWakeLock(int levelAndFlags, String tag, int displayId) {
        PowerManager.validateWakeLockParameters(levelAndFlags, tag);
        return new WakeLock(levelAndFlags, tag, this.mContext.getOpPackageName(), displayId);
    }

    @UnsupportedAppUsage
    public static void validateWakeLockParameters(int levelAndFlags, String tag) {
        switch (levelAndFlags & 0xFFFF) {
            case 1: 
            case 6: 
            case 10: 
            case 26: 
            case 32: 
            case 64: 
            case 128: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Must specify a valid wake lock level.");
            }
        }
        if (tag == null) {
            throw new IllegalArgumentException("The tag must not be null.");
        }
    }

    @Deprecated
    public void userActivity(long when, boolean noChangeLights) {
        this.userActivity(when, 0, noChangeLights ? 1 : 0);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.DEVICE_POWER", "android.permission.USER_ACTIVITY"})
    public void userActivity(long when, int event, int flags) {
        try {
            this.mService.userActivity(this.mContext.getDisplayId(), when, event, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void goToSleep(long time) {
        this.goToSleep(time, 0, 0);
    }

    @UnsupportedAppUsage
    public void goToSleep(long time, int reason, int flags) {
        try {
            this.mService.goToSleep(time, reason, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void wakeUp(long time) {
        this.wakeUp(time, 0, "wakeUp");
    }

    @Deprecated
    @UnsupportedAppUsage
    public void wakeUp(long time, String details) {
        this.wakeUp(time, 0, details);
    }

    public void wakeUp(long time, int reason, String details) {
        try {
            this.mService.wakeUp(time, reason, details, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void nap(long time) {
        try {
            this.mService.nap(time);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.READ_DREAM_STATE", "android.permission.WRITE_DREAM_STATE"})
    public void dream(long time) {
        Sandman.startDreamByUserRequest(this.mContext);
    }

    public void boostScreenBrightness(long time) {
        try {
            this.mService.boostScreenBrightness(time);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isWakeLockLevelSupported(int level) {
        try {
            return this.mService.isWakeLockLevelSupported(level);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean isScreenOn() {
        return this.isInteractive();
    }

    public boolean isInteractive() {
        return this.mInteractiveCache.query(null);
    }

    public static boolean isRebootingUserspaceSupportedImpl() {
        return InitProperties.is_userspace_reboot_supported().orElse(false);
    }

    public boolean isRebootingUserspaceSupported() {
        return PowerManager.isRebootingUserspaceSupportedImpl();
    }

    @RequiresPermission(value="android.permission.REBOOT")
    public void reboot(String reason) {
        if (REBOOT_USERSPACE.equals(reason) && !this.isRebootingUserspaceSupported()) {
            throw new UnsupportedOperationException("Attempted userspace reboot on a device that doesn't support it");
        }
        try {
            this.mService.reboot(false, reason, true);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REBOOT")
    public void rebootSafeMode() {
        try {
            this.mService.rebootSafeMode(false, true);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isPowerSaveMode() {
        return this.mPowerSaveModeCache.query(null);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.DEVICE_POWER", "android.permission.POWER_SAVER"})
    public boolean setPowerSaveModeEnabled(boolean mode) {
        try {
            return this.mService.setPowerSaveModeEnabled(mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public BatterySaverPolicyConfig getFullPowerSavePolicy() {
        try {
            return this.mService.getFullPowerSavePolicy();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.DEVICE_POWER", "android.permission.POWER_SAVER"})
    public boolean setFullPowerSavePolicy(BatterySaverPolicyConfig config) {
        try {
            return this.mService.setFullPowerSavePolicy(config);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.POWER_SAVER")
    public boolean setDynamicPowerSaveHint(boolean powerSaveHint, int disableThreshold) {
        try {
            return this.mService.setDynamicPowerSaveHint(powerSaveHint, disableThreshold);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.DEVICE_POWER", "android.permission.POWER_SAVER"})
    public boolean setAdaptivePowerSavePolicy(BatterySaverPolicyConfig config) {
        try {
            return this.mService.setAdaptivePowerSavePolicy(config);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.DEVICE_POWER", "android.permission.POWER_SAVER"})
    public boolean setAdaptivePowerSaveEnabled(boolean enabled) {
        try {
            return this.mService.setAdaptivePowerSaveEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public int getPowerSaveModeTrigger() {
        try {
            return this.mService.getPowerSaveModeTrigger();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.BATTERY_PREDICTION", "android.permission.DEVICE_POWER"})
    public void setBatteryDischargePrediction(Duration timeRemaining, boolean isPersonalized) {
        if (timeRemaining == null) {
            throw new IllegalArgumentException("time remaining must not be null");
        }
        try {
            this.mService.setBatteryDischargePrediction(new ParcelDuration(timeRemaining), isPersonalized);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Duration getBatteryDischargePrediction() {
        try {
            ParcelDuration parcelDuration = this.mService.getBatteryDischargePrediction();
            if (parcelDuration == null) {
                return null;
            }
            return parcelDuration.getDuration();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isBatteryDischargePredictionPersonalized() {
        try {
            return this.mService.isBatteryDischargePredictionPersonalized();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public PowerSaveState getPowerSaveState(int serviceType) {
        try {
            return this.mService.getPowerSaveState(serviceType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getLocationPowerSaveMode() {
        PowerSaveState powerSaveState = this.getPowerSaveState(1);
        if (!powerSaveState.batterySaverEnabled) {
            return 0;
        }
        return powerSaveState.locationMode;
    }

    public int getSoundTriggerPowerSaveMode() {
        PowerSaveState powerSaveState = this.getPowerSaveState(8);
        if (!powerSaveState.batterySaverEnabled) {
            return 0;
        }
        return powerSaveState.soundTriggerMode;
    }

    public boolean isDeviceIdleMode() {
        try {
            return this.mService.isDeviceIdleMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isDeviceLightIdleMode() {
        try {
            return this.mService.isLightDeviceIdleMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=31, publicAlternatives="Use {@link #isDeviceLightIdleMode()} instead.")
    public boolean isLightDeviceIdleMode() {
        return this.isDeviceLightIdleMode();
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public boolean isLowPowerStandbySupported() {
        try {
            return this.mService.isLowPowerStandbySupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isLowPowerStandbyEnabled() {
        try {
            return this.mService.isLowPowerStandbyEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public void setLowPowerStandbyEnabled(boolean enabled) {
        try {
            this.mService.setLowPowerStandbyEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public void setLowPowerStandbyActiveDuringMaintenance(boolean activeDuringMaintenance) {
        try {
            this.mService.setLowPowerStandbyActiveDuringMaintenance(activeDuringMaintenance);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_LOW_POWER_STANDBY", "android.permission.DEVICE_POWER"})
    public void forceLowPowerStandbyActive(boolean active) {
        try {
            this.mService.forceLowPowerStandbyActive(active);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isIgnoringBatteryOptimizations(String packageName) {
        return this.getPowerExemptionManager().isAllowListed(packageName, true);
    }

    public void shutdown(boolean confirm, String reason, boolean wait) {
        try {
            this.mService.shutdown(confirm, reason, wait);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isSustainedPerformanceModeSupported() {
        return this.mContext.getResources().getBoolean(17891790);
    }

    public int getCurrentThermalStatus() {
        try {
            return this.mThermalService.getCurrentThermalStatus();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void addThermalStatusListener(OnThermalStatusChangedListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        this.addThermalStatusListener(this.mContext.getMainExecutor(), listener);
    }

    public void addThermalStatusListener(final Executor executor, final OnThermalStatusChangedListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Preconditions.checkArgument(!this.mListenerMap.containsKey(listener), "Listener already registered: %s", listener);
        IThermalStatusListener.Stub internalListener = new IThermalStatusListener.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStatusChange(int status) {
                long token = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener.onThermalStatusChanged(status));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        };
        try {
            if (!this.mThermalService.registerThermalStatusListener(internalListener)) {
                throw new RuntimeException("Listener failed to set");
            }
            this.mListenerMap.put(listener, internalListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeThermalStatusListener(OnThermalStatusChangedListener listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        IThermalStatusListener internalListener = this.mListenerMap.get(listener);
        Preconditions.checkArgument(internalListener != null, "Listener was not added");
        try {
            if (!this.mThermalService.unregisterThermalStatusListener(internalListener)) {
                throw new RuntimeException("Listener failed to remove");
            }
            this.mListenerMap.remove(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public float getThermalHeadroom(int forecastSeconds) {
        long now = SystemClock.elapsedRealtime();
        long timeSinceLastUpdate = now - this.mLastHeadroomUpdate.get();
        if (timeSinceLastUpdate < 500L) {
            return Float.NaN;
        }
        try {
            float forecast = this.mThermalService.getThermalHeadroom(forecastSeconds);
            this.mLastHeadroomUpdate.set(SystemClock.elapsedRealtime());
            return forecast;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setDozeAfterScreenOff(boolean dozeAfterScreenOf) {
        try {
            this.mService.setDozeAfterScreenOff(dozeAfterScreenOf);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DREAM_STATE")
    public boolean isAmbientDisplayAvailable() {
        try {
            return this.mService.isAmbientDisplayAvailable();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void suppressAmbientDisplay(String token, boolean suppress) {
        try {
            this.mService.suppressAmbientDisplay(token, suppress);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DREAM_STATE")
    public boolean isAmbientDisplaySuppressedForToken(String token) {
        try {
            return this.mService.isAmbientDisplaySuppressedForToken(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DREAM_STATE")
    public boolean isAmbientDisplaySuppressed() {
        try {
            return this.mService.isAmbientDisplaySuppressed();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.READ_DREAM_STATE", "android.permission.READ_DREAM_SUPPRESSION"})
    public boolean isAmbientDisplaySuppressedForTokenByApp(String token, int appUid) {
        try {
            return this.mService.isAmbientDisplaySuppressedForTokenByApp(token, appUid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getLastShutdownReason() {
        try {
            return this.mService.getLastShutdownReason();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getLastSleepReason() {
        try {
            return this.mService.getLastSleepReason();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.DEVICE_POWER")
    public boolean forceSuspend() {
        try {
            return this.mService.forceSuspend();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void invalidatePowerSaveModeCaches() {
        PropertyInvalidatedCache.invalidateCache(CACHE_KEY_IS_POWER_SAVE_MODE_PROPERTY);
    }

    public static void invalidateIsInteractiveCaches() {
        PropertyInvalidatedCache.invalidateCache(CACHE_KEY_IS_INTERACTIVE_PROPERTY);
    }

    public class WakeLock {
        @UnsupportedAppUsage
        private int mFlags;
        @UnsupportedAppUsage
        private String mTag;
        private final String mPackageName;
        private final IBinder mToken;
        private int mInternalCount;
        private int mExternalCount;
        private boolean mRefCounted = true;
        private boolean mHeld;
        private WorkSource mWorkSource;
        private String mHistoryTag;
        private final String mTraceName;
        private final int mDisplayId;
        private WakeLockStateListener mListener;
        private IWakeLockCallback mCallback;
        private final Runnable mReleaser = () -> this.release(65536);

        WakeLock(int flags, String tag, String packageName, int displayId) {
            this.mFlags = flags;
            this.mTag = tag;
            this.mPackageName = packageName;
            this.mToken = new Binder();
            this.mTraceName = "WakeLock (" + this.mTag + ")";
            this.mDisplayId = displayId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (this.mHeld) {
                    Log.wtf(PowerManager.TAG, "WakeLock finalized while still held: " + this.mTag);
                    Trace.asyncTraceEnd(131072L, this.mTraceName, 0);
                    try {
                        PowerManager.this.mService.releaseWakeLock(this.mToken, 0);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setReferenceCounted(boolean value) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.mRefCounted = value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.acquireLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire(long timeout) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.acquireLocked();
                PowerManager.this.mHandler.postDelayed(this.mReleaser, timeout);
            }
        }

        private void acquireLocked() {
            ++this.mInternalCount;
            ++this.mExternalCount;
            if (!this.mRefCounted || this.mInternalCount == 1) {
                PowerManager.this.mHandler.removeCallbacks(this.mReleaser);
                Trace.asyncTraceBegin(131072L, this.mTraceName, 0);
                try {
                    PowerManager.this.mService.acquireWakeLock(this.mToken, this.mFlags, this.mTag, this.mPackageName, this.mWorkSource, this.mHistoryTag, this.mDisplayId, this.mCallback);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                this.mHeld = true;
            }
        }

        public void release() {
            this.release(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(int flags) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (this.mInternalCount > 0) {
                    --this.mInternalCount;
                }
                if ((flags & 0x10000) == 0) {
                    --this.mExternalCount;
                }
                if (!this.mRefCounted || this.mInternalCount == 0) {
                    PowerManager.this.mHandler.removeCallbacks(this.mReleaser);
                    if (this.mHeld) {
                        Trace.asyncTraceEnd(131072L, this.mTraceName, 0);
                        try {
                            PowerManager.this.mService.releaseWakeLock(this.mToken, flags);
                        }
                        catch (RemoteException e) {
                            throw e.rethrowFromSystemServer();
                        }
                        this.mHeld = false;
                    }
                }
                if (this.mRefCounted && this.mExternalCount < 0) {
                    throw new RuntimeException("WakeLock under-locked " + this.mTag);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isHeld() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setWorkSource(WorkSource ws) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                boolean changed;
                if (ws != null && ws.isEmpty()) {
                    ws = null;
                }
                if (ws == null) {
                    changed = this.mWorkSource != null;
                    this.mWorkSource = null;
                } else if (this.mWorkSource == null) {
                    changed = true;
                    this.mWorkSource = new WorkSource(ws);
                } else {
                    boolean bl = changed = !this.mWorkSource.equals(ws);
                    if (changed) {
                        this.mWorkSource.set(ws);
                    }
                }
                if (changed && this.mHeld) {
                    try {
                        PowerManager.this.mService.updateWakeLockWorkSource(this.mToken, this.mWorkSource, this.mHistoryTag);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }

        public void setTag(String tag) {
            this.mTag = tag;
        }

        public String getTag() {
            return this.mTag;
        }

        public void setHistoryTag(String tag) {
            this.mHistoryTag = tag;
        }

        public void setUnimportantForLogging(boolean state) {
            this.mFlags = state ? (this.mFlags |= 0x40000000) : (this.mFlags &= 0xBFFFFFFF);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                return "WakeLock{" + Integer.toHexString(System.identityHashCode(this)) + " held=" + this.mHeld + ", refCount=" + this.mInternalCount + "}";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dumpDebug(ProtoOutputStream proto, long fieldId) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                long token = proto.start(fieldId);
                proto.write(0x10900000001L, this.mTag);
                proto.write(1138166333442L, this.mPackageName);
                proto.write(1133871366147L, this.mHeld);
                proto.write(1120986464260L, this.mInternalCount);
                if (this.mWorkSource != null) {
                    this.mWorkSource.dumpDebug(proto, 1146756268037L);
                }
                proto.end(token);
            }
        }

        @SuppressLint(value={"WakelockTimeout"})
        public Runnable wrap(Runnable r) {
            this.acquire();
            return () -> {
                try {
                    r.run();
                }
                finally {
                    this.release();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStateListener(final Executor executor, final WakeLockStateListener listener) {
            Preconditions.checkNotNull(executor, "executor cannot be null");
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (listener != this.mListener) {
                    this.mListener = listener;
                    this.mCallback = listener != null ? new IWakeLockCallback.Stub(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onStateChanged(boolean enabled) {
                            long token = Binder.clearCallingIdentity();
                            try {
                                executor.execute(() -> listener.onStateChanged(enabled));
                            }
                            finally {
                                Binder.restoreCallingIdentity(token);
                            }
                        }
                    } : null;
                    if (this.mHeld) {
                        try {
                            PowerManager.this.mService.updateWakeLockCallback(this.mToken, this.mCallback);
                        }
                        catch (RemoteException e) {
                            throw e.rethrowFromSystemServer();
                        }
                    }
                }
            }
        }
    }

    public static interface WakeLockStateListener {
        public void onStateChanged(boolean var1);
    }

    public static interface OnThermalStatusChangedListener {
        public void onThermalStatusChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ThermalStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AutoPowerSaveModeTriggers {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SoundTriggerPowerSaveMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LocationPowerSaveMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ServiceType {
        public static final int NULL = 0;
        public static final int LOCATION = 1;
        public static final int VIBRATION = 2;
        public static final int ANIMATION = 3;
        public static final int FULL_BACKUP = 4;
        public static final int KEYVALUE_BACKUP = 5;
        public static final int NETWORK_FIREWALL = 6;
        public static final int SCREEN_BRIGHTNESS = 7;
        public static final int SOUND = 8;
        public static final int BATTERY_STATS = 9;
        public static final int DATA_SAVER = 10;
        public static final int AOD = 14;
        public static final int FORCE_ALL_APPS_STANDBY = 11;
        public static final int FORCE_BACKGROUND_CHECK = 12;
        public static final int OPTIONAL_SENSORS = 13;
        public static final int QUICK_DOZE = 15;
        public static final int NIGHT_MODE = 16;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShutdownReason {
    }

    public static class SleepData {
        public final long goToSleepUptimeMillis;
        public final int goToSleepReason;

        public SleepData(long goToSleepUptimeMillis, int goToSleepReason) {
            this.goToSleepUptimeMillis = goToSleepUptimeMillis;
            this.goToSleepReason = goToSleepReason;
        }

        public boolean equals(Object o) {
            if (o instanceof SleepData) {
                SleepData other = (SleepData)o;
                return this.goToSleepUptimeMillis == other.goToSleepUptimeMillis && this.goToSleepReason == other.goToSleepReason;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.goToSleepUptimeMillis, this.goToSleepReason);
        }
    }

    public static class WakeData {
        public final long wakeTime;
        public final int wakeReason;
        public final long sleepDuration;

        public WakeData(long wakeTime, int wakeReason, long sleepDuration) {
            this.wakeTime = wakeTime;
            this.wakeReason = wakeReason;
            this.sleepDuration = sleepDuration;
        }

        public boolean equals(Object o) {
            if (o instanceof WakeData) {
                WakeData other = (WakeData)o;
                return this.wakeTime == other.wakeTime && this.wakeReason == other.wakeReason && this.sleepDuration == other.sleepDuration;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.wakeTime, this.wakeReason, this.sleepDuration);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GoToSleepReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WakeReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BrightnessConstraint {
    }
}

