/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.PendingIntent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IPullAtomCallback;
import android.os.Parcel;
import android.os.RemoteException;

public interface IStatsManagerService
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IStatsManagerService";

    public void setDataFetchOperation(long var1, PendingIntent var3, String var4) throws RemoteException;

    public void removeDataFetchOperation(long var1, String var3) throws RemoteException;

    public long[] setActiveConfigsChangedOperation(PendingIntent var1, String var2) throws RemoteException;

    public void removeActiveConfigsChangedOperation(String var1) throws RemoteException;

    public void setBroadcastSubscriber(long var1, long var3, PendingIntent var5, String var6) throws RemoteException;

    public void unsetBroadcastSubscriber(long var1, long var3, String var5) throws RemoteException;

    public long[] getRegisteredExperimentIds() throws RemoteException;

    public byte[] getMetadata(String var1) throws RemoteException;

    public byte[] getData(long var1, String var3) throws RemoteException;

    public void addConfiguration(long var1, byte[] var3, String var4) throws RemoteException;

    public void removeConfiguration(long var1, String var3) throws RemoteException;

    public void registerPullAtomCallback(int var1, long var2, long var4, int[] var6, IPullAtomCallback var7) throws RemoteException;

    public void unregisterPullAtomCallback(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStatsManagerService {
        static final int TRANSACTION_setDataFetchOperation = 1;
        static final int TRANSACTION_removeDataFetchOperation = 2;
        static final int TRANSACTION_setActiveConfigsChangedOperation = 3;
        static final int TRANSACTION_removeActiveConfigsChangedOperation = 4;
        static final int TRANSACTION_setBroadcastSubscriber = 5;
        static final int TRANSACTION_unsetBroadcastSubscriber = 6;
        static final int TRANSACTION_getRegisteredExperimentIds = 7;
        static final int TRANSACTION_getMetadata = 8;
        static final int TRANSACTION_getData = 9;
        static final int TRANSACTION_addConfiguration = 10;
        static final int TRANSACTION_removeConfiguration = 11;
        static final int TRANSACTION_registerPullAtomCallback = 12;
        static final int TRANSACTION_unregisterPullAtomCallback = 13;

        public Stub() {
            this.attachInterface(this, IStatsManagerService.DESCRIPTOR);
        }

        public static IStatsManagerService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IStatsManagerService.DESCRIPTOR);
            if (iin != null && iin instanceof IStatsManagerService) {
                return (IStatsManagerService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IStatsManagerService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    long _arg0 = data.readLong();
                    PendingIntent _arg1 = data.readTypedObject(PendingIntent.CREATOR);
                    String _arg2 = data.readString();
                    this.setDataFetchOperation(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    this.removeDataFetchOperation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    PendingIntent _arg0 = data.readTypedObject(PendingIntent.CREATOR);
                    String _arg1 = data.readString();
                    long[] _result = this.setActiveConfigsChangedOperation(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLongArray(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    this.removeActiveConfigsChangedOperation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    PendingIntent _arg2 = data.readTypedObject(PendingIntent.CREATOR);
                    String _arg3 = data.readString();
                    this.setBroadcastSubscriber(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    String _arg2 = data.readString();
                    this.unsetBroadcastSubscriber(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    long[] _result = this.getRegisteredExperimentIds();
                    reply.writeNoException();
                    reply.writeLongArray(_result);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    byte[] _result = this.getMetadata(_arg0);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 9: {
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    byte[] _result = this.getData(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 10: {
                    long _arg0 = data.readLong();
                    byte[] _arg1 = data.createByteArray();
                    String _arg2 = data.readString();
                    this.addConfiguration(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    this.removeConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    int[] _arg3 = data.createIntArray();
                    IPullAtomCallback _arg4 = IPullAtomCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerPullAtomCallback(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    this.unregisterPullAtomCallback(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IStatsManagerService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IStatsManagerService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDataFetchOperation(long configId, PendingIntent pendingIntent, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsManagerService.DESCRIPTOR);
                    _data.writeLong(configId);
                    _data.writeTypedObject(pendingIntent, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeDataFetchOperation(long configId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsManagerService.DESCRIPTOR);
                    _data.writeLong(configId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long[] setActiveConfigsChangedOperation(PendingIntent pendingIntent, String packageName) throws RemoteException {
                long[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsManagerService.DESCRIPTOR);
                    _data.writeTypedObject(pendingIntent, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createLongArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeActiveConfigsChangedOperation(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsManagerService.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBroadcastSubscriber(long configKey, long subscriberId, PendingIntent pendingIntent, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsManagerService.DESCRIPTOR);
                    _data.writeLong(configKey);
                    _data.writeLong(subscriberId);
                    _data.writeTypedObject(pendingIntent, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unsetBroadcastSubscriber(long configKey, long subscriberId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsManagerService.DESCRIPTOR);
                    _data.writeLong(configKey);
                    _data.writeLong(subscriberId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long[] getRegisteredExperimentIds() throws RemoteException {
                long[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsManagerService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createLongArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getMetadata(String packageName) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsManagerService.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getData(long key, String packageName) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsManagerService.DESCRIPTOR);
                    _data.writeLong(key);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addConfiguration(long configId, byte[] config, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsManagerService.DESCRIPTOR);
                    _data.writeLong(configId);
                    _data.writeByteArray(config);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeConfiguration(long configId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsManagerService.DESCRIPTOR);
                    _data.writeLong(configId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPullAtomCallback(int atomTag, long coolDownMillis, long timeoutMillis, int[] additiveFields, IPullAtomCallback pullerCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsManagerService.DESCRIPTOR);
                    _data.writeInt(atomTag);
                    _data.writeLong(coolDownMillis);
                    _data.writeLong(timeoutMillis);
                    _data.writeIntArray(additiveFields);
                    _data.writeStrongInterface(pullerCallback);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterPullAtomCallback(int atomTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IStatsManagerService.DESCRIPTOR);
                    _data.writeInt(atomTag);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IStatsManagerService {
        @Override
        public void setDataFetchOperation(long configId, PendingIntent pendingIntent, String packageName) throws RemoteException {
        }

        @Override
        public void removeDataFetchOperation(long configId, String packageName) throws RemoteException {
        }

        @Override
        public long[] setActiveConfigsChangedOperation(PendingIntent pendingIntent, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public void removeActiveConfigsChangedOperation(String packageName) throws RemoteException {
        }

        @Override
        public void setBroadcastSubscriber(long configKey, long subscriberId, PendingIntent pendingIntent, String packageName) throws RemoteException {
        }

        @Override
        public void unsetBroadcastSubscriber(long configKey, long subscriberId, String packageName) throws RemoteException {
        }

        @Override
        public long[] getRegisteredExperimentIds() throws RemoteException {
            return null;
        }

        @Override
        public byte[] getMetadata(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public byte[] getData(long key, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public void addConfiguration(long configId, byte[] config, String packageName) throws RemoteException {
        }

        @Override
        public void removeConfiguration(long configId, String packageName) throws RemoteException {
        }

        @Override
        public void registerPullAtomCallback(int atomTag, long coolDownMillis, long timeoutMillis, int[] additiveFields, IPullAtomCallback pullerCallback) throws RemoteException {
        }

        @Override
        public void unregisterPullAtomCallback(int atomTag) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

