/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.database.CursorWindow;
import android.os.PowerComponents;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

public abstract class BatteryConsumer {
    private static final String TAG = "BatteryConsumer";
    public static final int POWER_COMPONENT_ANY = -1;
    public static final int POWER_COMPONENT_SCREEN = 0;
    public static final int POWER_COMPONENT_CPU = 1;
    public static final int POWER_COMPONENT_BLUETOOTH = 2;
    public static final int POWER_COMPONENT_CAMERA = 3;
    public static final int POWER_COMPONENT_AUDIO = 4;
    public static final int POWER_COMPONENT_VIDEO = 5;
    public static final int POWER_COMPONENT_FLASHLIGHT = 6;
    public static final int POWER_COMPONENT_SYSTEM_SERVICES = 7;
    public static final int POWER_COMPONENT_MOBILE_RADIO = 8;
    public static final int POWER_COMPONENT_SENSORS = 9;
    public static final int POWER_COMPONENT_GNSS = 10;
    public static final int POWER_COMPONENT_WIFI = 11;
    public static final int POWER_COMPONENT_WAKELOCK = 12;
    public static final int POWER_COMPONENT_MEMORY = 13;
    public static final int POWER_COMPONENT_PHONE = 14;
    public static final int POWER_COMPONENT_AMBIENT_DISPLAY = 15;
    public static final int POWER_COMPONENT_IDLE = 16;
    public static final int POWER_COMPONENT_REATTRIBUTED_TO_OTHER_CONSUMERS = 17;
    public static final int POWER_COMPONENT_COUNT = 18;
    public static final int FIRST_CUSTOM_POWER_COMPONENT_ID = 1000;
    public static final int LAST_CUSTOM_POWER_COMPONENT_ID = 9999;
    private static final String[] sPowerComponentNames = new String[18];
    public static final int POWER_MODEL_UNDEFINED = 0;
    public static final int POWER_MODEL_POWER_PROFILE = 1;
    public static final int POWER_MODEL_MEASURED_ENERGY = 2;
    public static final int PROCESS_STATE_UNSPECIFIED = 0;
    public static final int PROCESS_STATE_ANY = 0;
    public static final int PROCESS_STATE_FOREGROUND = 1;
    public static final int PROCESS_STATE_BACKGROUND = 2;
    public static final int PROCESS_STATE_FOREGROUND_SERVICE = 3;
    public static final int PROCESS_STATE_CACHED = 4;
    public static final int PROCESS_STATE_COUNT = 5;
    private static final String[] sProcessStateNames;
    private static final int[] SUPPORTED_POWER_COMPONENTS_PER_PROCESS_STATE;
    static final int COLUMN_INDEX_BATTERY_CONSUMER_TYPE = 0;
    static final int COLUMN_COUNT = 1;
    public static final Dimensions UNSPECIFIED_DIMENSIONS;
    protected final BatteryConsumerData mData;
    protected final PowerComponents mPowerComponents;

    protected BatteryConsumer(BatteryConsumerData data, PowerComponents powerComponents) {
        this.mData = data;
        this.mPowerComponents = powerComponents;
    }

    public BatteryConsumer(BatteryConsumerData data) {
        this.mData = data;
        this.mPowerComponents = new PowerComponents(data);
    }

    public double getConsumedPower() {
        return this.mPowerComponents.getConsumedPower(UNSPECIFIED_DIMENSIONS);
    }

    public double getConsumedPower(Dimensions dimensions) {
        return this.mPowerComponents.getConsumedPower(dimensions);
    }

    public Key[] getKeys(int componentId) {
        return this.mData.getKeys(componentId);
    }

    public Key getKey(int componentId) {
        return this.mData.getKey(componentId, 0);
    }

    public Key getKey(int componentId, int processState) {
        return this.mData.getKey(componentId, processState);
    }

    public double getConsumedPower(int componentId) {
        return this.mPowerComponents.getConsumedPower(this.mData.getKeyOrThrow(componentId, 0));
    }

    public double getConsumedPower(Key key) {
        return this.mPowerComponents.getConsumedPower(key);
    }

    public int getPowerModel(int componentId) {
        return this.mPowerComponents.getPowerModel(this.mData.getKeyOrThrow(componentId, 0));
    }

    public int getPowerModel(Key key) {
        return this.mPowerComponents.getPowerModel(key);
    }

    public double getConsumedPowerForCustomComponent(int componentId) {
        return this.mPowerComponents.getConsumedPowerForCustomComponent(componentId);
    }

    public int getCustomPowerComponentCount() {
        return this.mData.layout.customPowerComponentCount;
    }

    public String getCustomPowerComponentName(int componentId) {
        return this.mPowerComponents.getCustomPowerComponentName(componentId);
    }

    public long getUsageDurationMillis(int componentId) {
        return this.mPowerComponents.getUsageDurationMillis(this.getKey(componentId));
    }

    public long getUsageDurationMillis(Key key) {
        return this.mPowerComponents.getUsageDurationMillis(key);
    }

    public long getUsageDurationForCustomComponentMillis(int componentId) {
        return this.mPowerComponents.getUsageDurationForCustomComponentMillis(componentId);
    }

    public static String powerComponentIdToString(int componentId) {
        if (componentId == -1) {
            return "all";
        }
        return sPowerComponentNames[componentId];
    }

    public static String powerModelToString(int powerModel) {
        switch (powerModel) {
            case 2: {
                return "measured energy";
            }
            case 1: {
                return "power profile";
            }
        }
        return "";
    }

    public static String processStateToString(int processState) {
        return sProcessStateNames[processState];
    }

    public void dump(PrintWriter pw) {
        this.dump(pw, true);
    }

    public abstract void dump(PrintWriter var1, boolean var2);

    boolean hasStatsProtoData() {
        return this.writeStatsProtoImpl(null, 0L);
    }

    void writeStatsProto(ProtoOutputStream proto, long fieldId) {
        this.writeStatsProtoImpl(proto, fieldId);
    }

    private boolean writeStatsProtoImpl(ProtoOutputStream proto, long fieldId) {
        long totalConsumedPowerDeciCoulombs = BatteryConsumer.convertMahToDeciCoulombs(this.getConsumedPower());
        if (totalConsumedPowerDeciCoulombs == 0L) {
            return false;
        }
        if (proto == null) {
            return true;
        }
        long token = proto.start(fieldId);
        proto.write(0x10300000001L, totalConsumedPowerDeciCoulombs);
        this.mPowerComponents.writeStatsProto(proto);
        proto.end(token);
        return true;
    }

    static long convertMahToDeciCoulombs(double powerMah) {
        return (long)(powerMah * 36.0 + 0.5);
    }

    static BatteryConsumerDataLayout createBatteryConsumerDataLayout(String[] customPowerComponentNames, boolean includePowerModels, boolean includeProcessStateData) {
        int columnCount = 1;
        columnCount = Math.max(columnCount, 3);
        columnCount = Math.max(columnCount, 5);
        columnCount = Math.max(columnCount, 2);
        return new BatteryConsumerDataLayout(columnCount, customPowerComponentNames, includePowerModels, includeProcessStateData);
    }

    static {
        BatteryConsumer.sPowerComponentNames[0] = "screen";
        BatteryConsumer.sPowerComponentNames[1] = "cpu";
        BatteryConsumer.sPowerComponentNames[2] = "bluetooth";
        BatteryConsumer.sPowerComponentNames[3] = "camera";
        BatteryConsumer.sPowerComponentNames[4] = "audio";
        BatteryConsumer.sPowerComponentNames[5] = "video";
        BatteryConsumer.sPowerComponentNames[6] = "flashlight";
        BatteryConsumer.sPowerComponentNames[7] = "system_services";
        BatteryConsumer.sPowerComponentNames[8] = "mobile_radio";
        BatteryConsumer.sPowerComponentNames[9] = "sensors";
        BatteryConsumer.sPowerComponentNames[10] = "gnss";
        BatteryConsumer.sPowerComponentNames[11] = "wifi";
        BatteryConsumer.sPowerComponentNames[12] = "wakelock";
        BatteryConsumer.sPowerComponentNames[13] = "memory";
        BatteryConsumer.sPowerComponentNames[14] = "phone";
        BatteryConsumer.sPowerComponentNames[15] = "ambient_display";
        BatteryConsumer.sPowerComponentNames[16] = "idle";
        BatteryConsumer.sPowerComponentNames[17] = "reattributed";
        sProcessStateNames = new String[5];
        BatteryConsumer.sProcessStateNames[0] = "unspecified";
        BatteryConsumer.sProcessStateNames[1] = "fg";
        BatteryConsumer.sProcessStateNames[2] = "bg";
        BatteryConsumer.sProcessStateNames[3] = "fgs";
        BatteryConsumer.sProcessStateNames[4] = "cached";
        SUPPORTED_POWER_COMPONENTS_PER_PROCESS_STATE = new int[]{1, 8, 11, 2};
        UNSPECIFIED_DIMENSIONS = new Dimensions(-1, 0);
    }

    protected static abstract class BaseBuilder<T extends BaseBuilder<?>> {
        protected final BatteryConsumerData mData;
        protected final PowerComponents.Builder mPowerComponentsBuilder;

        public BaseBuilder(BatteryConsumerData data, int consumerType) {
            this.mData = data;
            data.putLong(0, consumerType);
            this.mPowerComponentsBuilder = new PowerComponents.Builder(data);
        }

        public Key[] getKeys(int componentId) {
            return this.mData.getKeys(componentId);
        }

        public Key getKey(int componentId, int processState) {
            return this.mData.getKey(componentId, processState);
        }

        public T setConsumedPower(int componentId, double componentPower) {
            return this.setConsumedPower(componentId, componentPower, 1);
        }

        public T setConsumedPower(int componentId, double componentPower, int powerModel) {
            this.mPowerComponentsBuilder.setConsumedPower(this.getKey(componentId, 0), componentPower, powerModel);
            return (T)this;
        }

        public T setConsumedPower(Key key, double componentPower, int powerModel) {
            this.mPowerComponentsBuilder.setConsumedPower(key, componentPower, powerModel);
            return (T)this;
        }

        public T setConsumedPowerForCustomComponent(int componentId, double componentPower) {
            this.mPowerComponentsBuilder.setConsumedPowerForCustomComponent(componentId, componentPower);
            return (T)this;
        }

        public T setUsageDurationMillis(int componentId, long componentUsageTimeMillis) {
            this.mPowerComponentsBuilder.setUsageDurationMillis(this.getKey(componentId, 0), componentUsageTimeMillis);
            return (T)this;
        }

        public T setUsageDurationMillis(Key key, long componentUsageTimeMillis) {
            this.mPowerComponentsBuilder.setUsageDurationMillis(key, componentUsageTimeMillis);
            return (T)this;
        }

        public T setUsageDurationForCustomComponentMillis(int componentId, long componentUsageTimeMillis) {
            this.mPowerComponentsBuilder.setUsageDurationForCustomComponentMillis(componentId, componentUsageTimeMillis);
            return (T)this;
        }

        public double getTotalPower() {
            return this.mPowerComponentsBuilder.getTotalPower();
        }
    }

    static class BatteryConsumerDataLayout {
        private static final Key[] KEY_ARRAY = new Key[0];
        public final String[] customPowerComponentNames;
        public final int customPowerComponentCount;
        public final boolean powerModelsIncluded;
        public final boolean processStateDataIncluded;
        public final Key[][] keys;
        public final int totalConsumedPowerColumnIndex;
        public final int firstCustomConsumedPowerColumn;
        public final int firstCustomUsageDurationColumn;
        public final int columnCount;
        public final Key[][] processStateKeys;

        private BatteryConsumerDataLayout(int firstColumn, String[] customPowerComponentNames, boolean powerModelsIncluded, boolean includeProcessStateData) {
            this.customPowerComponentNames = customPowerComponentNames;
            this.customPowerComponentCount = customPowerComponentNames.length;
            this.powerModelsIncluded = powerModelsIncluded;
            this.processStateDataIncluded = includeProcessStateData;
            int columnIndex = firstColumn;
            this.totalConsumedPowerColumnIndex = columnIndex++;
            this.keys = new Key[18][];
            ArrayList<Key> perComponentKeys = new ArrayList<Key>();
            for (int componentId = 0; componentId < 18; ++componentId) {
                perComponentKeys.clear();
                perComponentKeys.add(new Key(componentId, 0, powerModelsIncluded ? columnIndex++ : -1, columnIndex++, columnIndex++));
                if (includeProcessStateData) {
                    boolean isSupported = false;
                    for (int id2 : SUPPORTED_POWER_COMPONENTS_PER_PROCESS_STATE) {
                        if (id2 != componentId) continue;
                        isSupported = true;
                        break;
                    }
                    if (isSupported) {
                        for (int processState = 0; processState < 5; ++processState) {
                            if (processState == 0) continue;
                            perComponentKeys.add(new Key(componentId, processState, powerModelsIncluded ? columnIndex++ : -1, columnIndex++, columnIndex++));
                        }
                    }
                }
                this.keys[componentId] = perComponentKeys.toArray(KEY_ARRAY);
            }
            if (includeProcessStateData) {
                this.processStateKeys = new Key[5][];
                ArrayList<Key> perProcStateKeys = new ArrayList<Key>();
                for (int processState = 0; processState < 5; ++processState) {
                    if (processState == 0) continue;
                    perProcStateKeys.clear();
                    for (int i = 0; i < this.keys.length; ++i) {
                        for (int j = 0; j < this.keys[i].length; ++j) {
                            if (this.keys[i][j].processState != processState) continue;
                            perProcStateKeys.add(this.keys[i][j]);
                        }
                    }
                    this.processStateKeys[processState] = perProcStateKeys.toArray(KEY_ARRAY);
                }
            } else {
                this.processStateKeys = null;
            }
            this.firstCustomConsumedPowerColumn = columnIndex;
            this.firstCustomUsageDurationColumn = columnIndex += this.customPowerComponentCount;
            this.columnCount = columnIndex += this.customPowerComponentCount;
        }
    }

    static class BatteryConsumerData {
        private final CursorWindow mCursorWindow;
        private final int mCursorRow;
        public final BatteryConsumerDataLayout layout;

        BatteryConsumerData(CursorWindow cursorWindow, int cursorRow, BatteryConsumerDataLayout layout2) {
            this.mCursorWindow = cursorWindow;
            this.mCursorRow = cursorRow;
            this.layout = layout2;
        }

        static BatteryConsumerData create(CursorWindow cursorWindow, BatteryConsumerDataLayout layout2) {
            int cursorRow = cursorWindow.getNumRows();
            if (!cursorWindow.allocRow()) {
                Slog.e(BatteryConsumer.TAG, "Cannot allocate BatteryConsumerData: too many UIDs: " + cursorRow);
                cursorRow = -1;
            }
            return new BatteryConsumerData(cursorWindow, cursorRow, layout2);
        }

        public Key[] getKeys(int componentId) {
            return this.layout.keys[componentId];
        }

        Key getKeyOrThrow(int componentId, int processState) {
            Key key = this.getKey(componentId, processState);
            if (key == null) {
                if (processState == 0) {
                    throw new IllegalArgumentException("Unsupported power component ID: " + componentId);
                }
                throw new IllegalArgumentException("Unsupported power component ID: " + componentId + " process state: " + processState);
            }
            return key;
        }

        Key getKey(int componentId, int processState) {
            if (componentId >= 18) {
                return null;
            }
            if (processState == 0) {
                return this.layout.keys[componentId][0];
            }
            for (Key key : this.layout.keys[componentId]) {
                if (key.processState != processState) continue;
                return key;
            }
            return null;
        }

        void putInt(int columnIndex, int value) {
            if (this.mCursorRow == -1) {
                return;
            }
            this.mCursorWindow.putLong(value, this.mCursorRow, columnIndex);
        }

        int getInt(int columnIndex) {
            if (this.mCursorRow == -1) {
                return 0;
            }
            return this.mCursorWindow.getInt(this.mCursorRow, columnIndex);
        }

        void putDouble(int columnIndex, double value) {
            if (this.mCursorRow == -1) {
                return;
            }
            this.mCursorWindow.putDouble(value, this.mCursorRow, columnIndex);
        }

        double getDouble(int columnIndex) {
            if (this.mCursorRow == -1) {
                return 0.0;
            }
            return this.mCursorWindow.getDouble(this.mCursorRow, columnIndex);
        }

        void putLong(int columnIndex, long value) {
            if (this.mCursorRow == -1) {
                return;
            }
            this.mCursorWindow.putLong(value, this.mCursorRow, columnIndex);
        }

        long getLong(int columnIndex) {
            if (this.mCursorRow == -1) {
                return 0L;
            }
            return this.mCursorWindow.getLong(this.mCursorRow, columnIndex);
        }

        void putString(int columnIndex, String value) {
            if (this.mCursorRow == -1) {
                return;
            }
            this.mCursorWindow.putString(value, this.mCursorRow, columnIndex);
        }

        String getString(int columnIndex) {
            if (this.mCursorRow == -1) {
                return null;
            }
            return this.mCursorWindow.getString(this.mCursorRow, columnIndex);
        }
    }

    public static class Key {
        public final int powerComponent;
        public final int processState;
        final int mPowerModelColumnIndex;
        final int mPowerColumnIndex;
        final int mDurationColumnIndex;
        private String mShortString;

        private Key(int powerComponent, int processState, int powerModelColumnIndex, int powerColumnIndex, int durationColumnIndex) {
            this.powerComponent = powerComponent;
            this.processState = processState;
            this.mPowerModelColumnIndex = powerModelColumnIndex;
            this.mPowerColumnIndex = powerColumnIndex;
            this.mDurationColumnIndex = durationColumnIndex;
        }

        public boolean equals(Object o) {
            Key key = (Key)o;
            return this.powerComponent == key.powerComponent && this.processState == key.processState;
        }

        public int hashCode() {
            int result = this.powerComponent;
            result = 31 * result + this.processState;
            return result;
        }

        public String toShortString() {
            if (this.mShortString == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(BatteryConsumer.powerComponentIdToString(this.powerComponent));
                if (this.processState != 0) {
                    sb.append(':');
                    sb.append(BatteryConsumer.processStateToString(this.processState));
                }
                this.mShortString = sb.toString();
            }
            return this.mShortString;
        }
    }

    public static class Dimensions {
        public final int powerComponent;
        public final int processState;

        public Dimensions(int powerComponent, int processState) {
            this.powerComponent = powerComponent;
            this.processState = processState;
        }

        public String toString() {
            boolean dimensionSpecified = false;
            StringBuilder sb = new StringBuilder();
            if (this.powerComponent != -1) {
                sb.append("powerComponent=").append(sPowerComponentNames[this.powerComponent]);
                dimensionSpecified = true;
            }
            if (this.processState != 0) {
                if (dimensionSpecified) {
                    sb.append(", ");
                }
                sb.append("processState=").append(sProcessStateNames[this.processState]);
                dimensionSpecified = true;
            }
            if (!dimensionSpecified) {
                sb.append("any components and process states");
            }
            return sb.toString();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProcessState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PowerModel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PowerComponent {
    }
}

