/*
 * Decompiled with CFR 0.152.
 */
package android.ondevicepersonalization;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.ondevicepersonalization.aidl.IOnDevicePersonalizationManagerService;
import android.os.IBinder;
import android.util.Slog;
import java.util.List;

public class OnDevicePersonalizationManager {
    public static final String ON_DEVICE_PERSONALIZATION_SERVICE = "on_device_personalization_service";
    private boolean mBound = false;
    private static final String TAG = "OdpManager";
    private IOnDevicePersonalizationManagerService mService;
    private final Context mContext;
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            OnDevicePersonalizationManager.this.mService = IOnDevicePersonalizationManagerService.Stub.asInterface(service);
            OnDevicePersonalizationManager.this.mBound = true;
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            OnDevicePersonalizationManager.this.mService = null;
            OnDevicePersonalizationManager.this.mBound = false;
        }
    };
    private static final int BIND_SERVICE_INTERVAL_MS = 1000;
    private static final int BIND_SERVICE_RETRY_TIMES = 3;
    private static final String VERSION = "1.0";

    public OnDevicePersonalizationManager(Context context) {
        this.mContext = context;
    }

    public String getVersion() {
        return VERSION;
    }

    private ComponentName resolveService(Intent intent, PackageManager pm) {
        List<ResolveInfo> services = pm.queryIntentServices(intent, PackageManager.ResolveInfoFlags.of(0L));
        if (services == null || services.isEmpty()) {
            Slog.e(TAG, "Failed to find ondevicepersonalization service");
            return null;
        }
        int i = 0;
        if (i < services.size()) {
            ResolveInfo ri = services.get(i);
            ComponentName resolved = new ComponentName(ri.serviceInfo.packageName, ri.serviceInfo.name);
            return resolved;
        }
        Slog.e(TAG, "Didn't find any matching ondevicepersonalization service.");
        return null;
    }
}

