/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.location.Address;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;

public class CivicLocation
implements Parcelable {
    private static final int ADDRESS_LINE_0_ROOM_DESK_FLOOR = 0;
    private static final int ADDRESS_LINE_1_NUMBER_ROAD_SUFFIX_APT = 1;
    private static final int ADDRESS_LINE_2_CITY = 2;
    private static final int ADDRESS_LINE_3_STATE_POSTAL_CODE = 3;
    private static final int ADDRESS_LINE_4_COUNTRY = 4;
    private static final int MIN_CIVIC_BUFFER_SIZE = 3;
    private static final int MAX_CIVIC_BUFFER_SIZE = 256;
    private static final int COUNTRY_CODE_LENGTH = 2;
    private static final int BYTE_MASK = 255;
    private static final int TLV_TYPE_INDEX = 0;
    private static final int TLV_LENGTH_INDEX = 1;
    private static final int TLV_VALUE_INDEX = 2;
    private final boolean mIsValid;
    private final String mCountryCode;
    private SparseArray<String> mCivicAddressElements = new SparseArray(3);
    public static final Parcelable.Creator<CivicLocation> CREATOR = new Parcelable.Creator<CivicLocation>(){

        @Override
        public CivicLocation createFromParcel(Parcel in) {
            return new CivicLocation(in);
        }

        public CivicLocation[] newArray(int size) {
            return new CivicLocation[size];
        }
    };

    public CivicLocation(byte[] civicTLVs, String countryCode) {
        this.mCountryCode = countryCode;
        if (countryCode == null || countryCode.length() != 2) {
            this.mIsValid = false;
            return;
        }
        boolean isValid = false;
        if (civicTLVs != null && civicTLVs.length >= 3 && civicTLVs.length < 256) {
            isValid = this.parseCivicTLVs(civicTLVs);
        }
        this.mIsValid = isValid;
    }

    private CivicLocation(Parcel in) {
        this.mIsValid = in.readByte() != 0;
        this.mCountryCode = in.readString();
        this.mCivicAddressElements = in.readSparseArray(this.getClass().getClassLoader());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeByte((byte)(this.mIsValid ? 1 : 0));
        parcel.writeString(this.mCountryCode);
        parcel.writeSparseArray(this.mCivicAddressElements);
    }

    private boolean parseCivicTLVs(byte[] civicTLVs) {
        byte civicAddressTypeLength;
        int bufferLength = civicTLVs.length;
        for (int bufferPtr = 0; bufferPtr < bufferLength; bufferPtr += civicAddressTypeLength + 2) {
            int civicAddressType = civicTLVs[bufferPtr + 0] & 0xFF;
            civicAddressTypeLength = civicTLVs[bufferPtr + 1];
            if (civicAddressTypeLength == 0) continue;
            if (bufferPtr + 2 + civicAddressTypeLength > bufferLength) {
                return false;
            }
            this.mCivicAddressElements.put(civicAddressType, new String(civicTLVs, bufferPtr + 2, (int)civicAddressTypeLength, StandardCharsets.UTF_8));
        }
        return true;
    }

    public String getCivicElementValue(int key) {
        return this.mCivicAddressElements.get(key);
    }

    public SparseArray<String> toSparseArray() {
        return this.mCivicAddressElements;
    }

    public String toString() {
        return this.mCivicAddressElements.toString();
    }

    public Address toAddress() {
        if (!this.mIsValid) {
            return null;
        }
        Address address = new Address(Locale.US);
        String room = this.formatAddressElement("Room: ", this.getCivicElementValue(28));
        String desk = this.formatAddressElement(" Desk: ", this.getCivicElementValue(33));
        String floor = this.formatAddressElement(", Flr: ", this.getCivicElementValue(27));
        String houseNumber = this.formatAddressElement("", this.getCivicElementValue(19));
        String houseNumberSuffix = this.formatAddressElement("", this.getCivicElementValue(20));
        String road = this.formatAddressElement(" ", this.getCivicElementValue(34));
        String roadSuffix = this.formatAddressElement(" ", this.getCivicElementValue(18));
        String apt = this.formatAddressElement(", Apt: ", this.getCivicElementValue(26));
        String city = this.formatAddressElement("", this.getCivicElementValue(3));
        String state = this.formatAddressElement("", this.getCivicElementValue(1));
        String postalCode = this.formatAddressElement(" ", this.getCivicElementValue(24));
        String addressLine0 = room + desk + floor;
        String addressLine1 = houseNumber + houseNumberSuffix + road + roadSuffix + apt;
        String addressLine2 = city;
        String addressLine3 = state + postalCode;
        String addressLine4 = this.mCountryCode;
        address.setAddressLine(0, addressLine0);
        address.setAddressLine(1, addressLine1);
        address.setAddressLine(2, addressLine2);
        address.setAddressLine(3, addressLine3);
        address.setAddressLine(4, addressLine4);
        address.setFeatureName(this.getCivicElementValue(23));
        address.setSubThoroughfare(this.getCivicElementValue(19));
        address.setThoroughfare(this.getCivicElementValue(34));
        address.setSubLocality(this.getCivicElementValue(5));
        address.setSubAdminArea(this.getCivicElementValue(2));
        address.setAdminArea(this.getCivicElementValue(1));
        address.setPostalCode(this.getCivicElementValue(24));
        address.setCountryCode(this.mCountryCode);
        return address;
    }

    private String formatAddressElement(String label, String value) {
        if (value != null) {
            return label + value;
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CivicLocation)) {
            return false;
        }
        CivicLocation other = (CivicLocation)obj;
        return this.mIsValid == other.mIsValid && Objects.equals(this.mCountryCode, other.mCountryCode) && this.isSparseArrayStringEqual(this.mCivicAddressElements, other.mCivicAddressElements);
    }

    public int hashCode() {
        int[] civicAddressKeys = this.getSparseArrayKeys(this.mCivicAddressElements);
        String[] civicAddressValues = this.getSparseArrayValues(this.mCivicAddressElements);
        return Objects.hash(this.mIsValid, this.mCountryCode, civicAddressKeys, civicAddressValues);
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    private boolean isSparseArrayStringEqual(SparseArray<String> sa1, SparseArray<String> sa2) {
        int size = sa1.size();
        if (size != sa2.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            String sa2Value;
            String sa1Value = sa1.valueAt(i);
            if (sa1Value.equals(sa2Value = sa2.valueAt(i))) continue;
            return false;
        }
        return true;
    }

    private int[] getSparseArrayKeys(SparseArray<String> sa) {
        int size = sa.size();
        int[] keys = new int[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = sa.keyAt(i);
        }
        return keys;
    }

    private String[] getSparseArrayValues(SparseArray<String> sa) {
        int size = sa.size();
        String[] values = new String[size];
        for (int i = 0; i < size; ++i) {
            values[i] = sa.valueAt(i);
        }
        return values;
    }
}

