/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.hotspot2;

import android.annotation.SystemApi;
import android.net.wifi.hotspot2.pps.Credential;
import android.net.wifi.hotspot2.pps.HomeSp;
import android.net.wifi.hotspot2.pps.Policy;
import android.net.wifi.hotspot2.pps.UpdateParameter;
import android.os.Bundle;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.android.layoutlib.bridge.android.AndroidLocale;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PasspointConfiguration
implements Parcelable {
    private static final String TAG = "PasspointConfiguration";
    private static final int CERTIFICATE_SHA256_BYTES = 32;
    public static final int MAX_URL_BYTES = 2048;
    public static final int MAX_NUMBER_OF_ENTRIES = 16;
    public static final int MAX_NUMBER_OF_OI = 36;
    public static final int MAX_STRING_LENGTH = 255;
    public static final long MAX_HESSID_VALUE = 0xFFFFFFFFFFFFL;
    public static final long MAX_OI_VALUE = 0xFFFFFFFFFFL;
    private static final int NULL_VALUE = -1;
    private HomeSp mHomeSp = null;
    private String[] mAaaServerTrustedNames = null;
    private Credential mCredential = null;
    private Policy mPolicy = null;
    private UpdateParameter mSubscriptionUpdate = null;
    private Map<String, byte[]> mTrustRootCertList = null;
    private int mUpdateIdentifier = Integer.MIN_VALUE;
    private int mCredentialPriority = Integer.MIN_VALUE;
    private long mSubscriptionCreationTimeInMillis = Long.MIN_VALUE;
    private long mSubscriptionExpirationTimeMillis = Long.MIN_VALUE;
    private String mSubscriptionType = null;
    private long mUsageLimitUsageTimePeriodInMinutes = Long.MIN_VALUE;
    private long mUsageLimitStartTimeInMillis = Long.MIN_VALUE;
    private long mUsageLimitDataLimit = Long.MIN_VALUE;
    private long mUsageLimitTimeLimitInMinutes = Long.MIN_VALUE;
    private Map<String, String> mServiceFriendlyNames = null;
    private int mCarrierId = -1;
    private int mSubscriptionId = -1;
    private ParcelUuid mSubscriptionGroup = null;
    private boolean mIsAutojoinEnabled = true;
    private boolean mIsMacRandomizationEnabled = true;
    private boolean mIsNonPersistentMacRandomizationEnabled = false;
    private boolean mIsOemPaid;
    private boolean mIsOemPrivate;
    private boolean mIsCarrierMerged;
    private int mMeteredOverride = 0;
    private String mDecoratedIdentityPrefix;
    public static final Parcelable.Creator<PasspointConfiguration> CREATOR = new Parcelable.Creator<PasspointConfiguration>(){

        @Override
        public PasspointConfiguration createFromParcel(Parcel in) {
            PasspointConfiguration config = new PasspointConfiguration();
            config.setHomeSp((HomeSp)in.readParcelable(null));
            config.setCredential((Credential)in.readParcelable(null));
            config.setPolicy((Policy)in.readParcelable(null));
            config.setSubscriptionUpdate((UpdateParameter)in.readParcelable(null));
            config.setTrustRootCertList(this.readTrustRootCerts(in));
            config.setUpdateIdentifier(in.readInt());
            config.setCredentialPriority(in.readInt());
            config.setSubscriptionCreationTimeInMillis(in.readLong());
            config.setSubscriptionExpirationTimeInMillis(in.readLong());
            config.setSubscriptionType(in.readString());
            config.setUsageLimitUsageTimePeriodInMinutes(in.readLong());
            config.setUsageLimitStartTimeInMillis(in.readLong());
            config.setUsageLimitDataLimit(in.readLong());
            config.setUsageLimitTimeLimitInMinutes(in.readLong());
            config.setAaaServerTrustedNames(in.createStringArray());
            Bundle bundle = in.readBundle();
            HashMap friendlyNamesMap = (HashMap)bundle.getSerializable("serviceFriendlyNames");
            config.setServiceFriendlyNames(friendlyNamesMap);
            config.mCarrierId = in.readInt();
            config.mIsAutojoinEnabled = in.readBoolean();
            config.mIsMacRandomizationEnabled = in.readBoolean();
            config.mIsNonPersistentMacRandomizationEnabled = in.readBoolean();
            config.mMeteredOverride = in.readInt();
            config.mSubscriptionId = in.readInt();
            config.mIsCarrierMerged = in.readBoolean();
            config.mIsOemPaid = in.readBoolean();
            config.mIsOemPrivate = in.readBoolean();
            config.mDecoratedIdentityPrefix = in.readString();
            config.mSubscriptionGroup = (ParcelUuid)in.readParcelable(null);
            return config;
        }

        public PasspointConfiguration[] newArray(int size) {
            return new PasspointConfiguration[size];
        }

        private Map<String, byte[]> readTrustRootCerts(Parcel in) {
            int size = in.readInt();
            if (size == -1) {
                return null;
            }
            HashMap<String, byte[]> trustRootCerts = new HashMap<String, byte[]>(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readString();
                byte[] value = in.createByteArray();
                trustRootCerts.put(key, value);
            }
            return trustRootCerts;
        }
    };

    public void setHomeSp(HomeSp homeSp) {
        this.mHomeSp = homeSp;
    }

    public HomeSp getHomeSp() {
        return this.mHomeSp;
    }

    public void setAaaServerTrustedNames(String[] aaaServerTrustedNames) {
        this.mAaaServerTrustedNames = aaaServerTrustedNames;
    }

    public String[] getAaaServerTrustedNames() {
        return this.mAaaServerTrustedNames;
    }

    public void setCredential(Credential credential) {
        this.mCredential = credential;
    }

    public Credential getCredential() {
        return this.mCredential;
    }

    public void setPolicy(Policy policy) {
        this.mPolicy = policy;
    }

    public Policy getPolicy() {
        return this.mPolicy;
    }

    public void setSubscriptionUpdate(UpdateParameter subscriptionUpdate) {
        this.mSubscriptionUpdate = subscriptionUpdate;
    }

    public UpdateParameter getSubscriptionUpdate() {
        return this.mSubscriptionUpdate;
    }

    public void setTrustRootCertList(Map<String, byte[]> trustRootCertList) {
        this.mTrustRootCertList = trustRootCertList;
    }

    public Map<String, byte[]> getTrustRootCertList() {
        return this.mTrustRootCertList;
    }

    public void setUpdateIdentifier(int updateIdentifier) {
        this.mUpdateIdentifier = updateIdentifier;
    }

    public int getUpdateIdentifier() {
        return this.mUpdateIdentifier;
    }

    public void setCredentialPriority(int credentialPriority) {
        this.mCredentialPriority = credentialPriority;
    }

    public int getCredentialPriority() {
        return this.mCredentialPriority;
    }

    public void setSubscriptionCreationTimeInMillis(long subscriptionCreationTimeInMillis) {
        this.mSubscriptionCreationTimeInMillis = subscriptionCreationTimeInMillis;
    }

    public long getSubscriptionCreationTimeInMillis() {
        return this.mSubscriptionCreationTimeInMillis;
    }

    public void setSubscriptionExpirationTimeInMillis(long subscriptionExpirationTimeInMillis) {
        this.mSubscriptionExpirationTimeMillis = subscriptionExpirationTimeInMillis;
    }

    public long getSubscriptionExpirationTimeMillis() {
        return this.mSubscriptionExpirationTimeMillis;
    }

    public void setSubscriptionType(String subscriptionType) {
        this.mSubscriptionType = subscriptionType;
    }

    public String getSubscriptionType() {
        return this.mSubscriptionType;
    }

    public void setUsageLimitUsageTimePeriodInMinutes(long usageLimitUsageTimePeriodInMinutes) {
        this.mUsageLimitUsageTimePeriodInMinutes = usageLimitUsageTimePeriodInMinutes;
    }

    public long getUsageLimitUsageTimePeriodInMinutes() {
        return this.mUsageLimitUsageTimePeriodInMinutes;
    }

    public void setUsageLimitStartTimeInMillis(long usageLimitStartTimeInMillis) {
        this.mUsageLimitStartTimeInMillis = usageLimitStartTimeInMillis;
    }

    public long getUsageLimitStartTimeInMillis() {
        return this.mUsageLimitStartTimeInMillis;
    }

    public void setUsageLimitDataLimit(long usageLimitDataLimit) {
        this.mUsageLimitDataLimit = usageLimitDataLimit;
    }

    public long getUsageLimitDataLimit() {
        return this.mUsageLimitDataLimit;
    }

    public void setUsageLimitTimeLimitInMinutes(long usageLimitTimeLimitInMinutes) {
        this.mUsageLimitTimeLimitInMinutes = usageLimitTimeLimitInMinutes;
    }

    public long getUsageLimitTimeLimitInMinutes() {
        return this.mUsageLimitTimeLimitInMinutes;
    }

    public void setServiceFriendlyNames(Map<String, String> serviceFriendlyNames) {
        this.mServiceFriendlyNames = serviceFriendlyNames;
    }

    public Map<String, String> getServiceFriendlyNames() {
        return this.mServiceFriendlyNames;
    }

    public String getServiceFriendlyName() {
        if (this.mServiceFriendlyNames == null || this.mServiceFriendlyNames.isEmpty()) {
            return null;
        }
        String lang = AndroidLocale.getDefault().getLanguage();
        String friendlyName = this.mServiceFriendlyNames.get(lang);
        if (friendlyName != null) {
            return friendlyName;
        }
        friendlyName = this.mServiceFriendlyNames.get("en");
        if (friendlyName != null) {
            return friendlyName;
        }
        return this.mServiceFriendlyNames.get(this.mServiceFriendlyNames.keySet().stream().findFirst().get());
    }

    public void setCarrierId(int carrierId) {
        this.mCarrierId = carrierId;
    }

    public int getCarrierId() {
        return this.mCarrierId;
    }

    public void setSubscriptionId(int subscriptionId) {
        this.mSubscriptionId = subscriptionId;
    }

    public int getSubscriptionId() {
        return this.mSubscriptionId;
    }

    public void setSubscriptionGroup(ParcelUuid subscriptionGroup) {
        this.mSubscriptionGroup = subscriptionGroup;
    }

    public ParcelUuid getSubscriptionGroup() {
        return this.mSubscriptionGroup;
    }

    public void setAutojoinEnabled(boolean autojoinEnabled) {
        this.mIsAutojoinEnabled = autojoinEnabled;
    }

    public void setMacRandomizationEnabled(boolean enabled) {
        this.mIsMacRandomizationEnabled = enabled;
    }

    public void setNonPersistentMacRandomizationEnabled(boolean enabled) {
        this.mIsNonPersistentMacRandomizationEnabled = enabled;
    }

    public void setMeteredOverride(int meteredOverride) {
        this.mMeteredOverride = meteredOverride;
    }

    @SystemApi
    public boolean isAutojoinEnabled() {
        return this.mIsAutojoinEnabled;
    }

    @SystemApi
    public int getMeteredOverride() {
        return this.mMeteredOverride;
    }

    @SystemApi
    public boolean isMacRandomizationEnabled() {
        return this.mIsMacRandomizationEnabled;
    }

    public boolean isNonPersistentMacRandomizationEnabled() {
        return this.mIsNonPersistentMacRandomizationEnabled;
    }

    public void setOemPaid(boolean isOemPaid) {
        this.mIsOemPaid = isOemPaid;
    }

    public boolean isOemPaid() {
        return this.mIsOemPaid;
    }

    public void setOemPrivate(boolean isOemPrivate) {
        this.mIsOemPrivate = isOemPrivate;
    }

    public boolean isOemPrivate() {
        return this.mIsOemPrivate;
    }

    public void setCarrierMerged(boolean isCarrierMerged) {
        this.mIsCarrierMerged = isCarrierMerged;
    }

    public boolean isCarrierMerged() {
        return this.mIsCarrierMerged;
    }

    public PasspointConfiguration() {
    }

    public PasspointConfiguration(PasspointConfiguration source) {
        if (source == null) {
            return;
        }
        if (source.mHomeSp != null) {
            this.mHomeSp = new HomeSp(source.mHomeSp);
        }
        if (source.mCredential != null) {
            this.mCredential = new Credential(source.mCredential);
        }
        if (source.mPolicy != null) {
            this.mPolicy = new Policy(source.mPolicy);
        }
        if (source.mTrustRootCertList != null) {
            this.mTrustRootCertList = Collections.unmodifiableMap(source.mTrustRootCertList);
        }
        if (source.mSubscriptionUpdate != null) {
            this.mSubscriptionUpdate = new UpdateParameter(source.mSubscriptionUpdate);
        }
        this.mUpdateIdentifier = source.mUpdateIdentifier;
        this.mCredentialPriority = source.mCredentialPriority;
        this.mSubscriptionCreationTimeInMillis = source.mSubscriptionCreationTimeInMillis;
        this.mSubscriptionExpirationTimeMillis = source.mSubscriptionExpirationTimeMillis;
        this.mSubscriptionType = source.mSubscriptionType;
        this.mUsageLimitDataLimit = source.mUsageLimitDataLimit;
        this.mUsageLimitStartTimeInMillis = source.mUsageLimitStartTimeInMillis;
        this.mUsageLimitTimeLimitInMinutes = source.mUsageLimitTimeLimitInMinutes;
        this.mUsageLimitUsageTimePeriodInMinutes = source.mUsageLimitUsageTimePeriodInMinutes;
        this.mServiceFriendlyNames = source.mServiceFriendlyNames;
        this.mAaaServerTrustedNames = source.mAaaServerTrustedNames;
        this.mCarrierId = source.mCarrierId;
        this.mSubscriptionId = source.mSubscriptionId;
        this.mIsAutojoinEnabled = source.mIsAutojoinEnabled;
        this.mIsMacRandomizationEnabled = source.mIsMacRandomizationEnabled;
        this.mIsNonPersistentMacRandomizationEnabled = source.mIsNonPersistentMacRandomizationEnabled;
        this.mMeteredOverride = source.mMeteredOverride;
        this.mIsCarrierMerged = source.mIsCarrierMerged;
        this.mIsOemPaid = source.mIsOemPaid;
        this.mIsOemPrivate = source.mIsOemPrivate;
        this.mDecoratedIdentityPrefix = source.mDecoratedIdentityPrefix;
        this.mSubscriptionGroup = source.mSubscriptionGroup;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mHomeSp, flags);
        dest.writeParcelable(this.mCredential, flags);
        dest.writeParcelable(this.mPolicy, flags);
        dest.writeParcelable(this.mSubscriptionUpdate, flags);
        PasspointConfiguration.writeTrustRootCerts(dest, this.mTrustRootCertList);
        dest.writeInt(this.mUpdateIdentifier);
        dest.writeInt(this.mCredentialPriority);
        dest.writeLong(this.mSubscriptionCreationTimeInMillis);
        dest.writeLong(this.mSubscriptionExpirationTimeMillis);
        dest.writeString(this.mSubscriptionType);
        dest.writeLong(this.mUsageLimitUsageTimePeriodInMinutes);
        dest.writeLong(this.mUsageLimitStartTimeInMillis);
        dest.writeLong(this.mUsageLimitDataLimit);
        dest.writeLong(this.mUsageLimitTimeLimitInMinutes);
        dest.writeStringArray(this.mAaaServerTrustedNames);
        Bundle bundle = new Bundle();
        bundle.putSerializable("serviceFriendlyNames", (HashMap)this.mServiceFriendlyNames);
        dest.writeBundle(bundle);
        dest.writeInt(this.mCarrierId);
        dest.writeBoolean(this.mIsAutojoinEnabled);
        dest.writeBoolean(this.mIsMacRandomizationEnabled);
        dest.writeBoolean(this.mIsNonPersistentMacRandomizationEnabled);
        dest.writeInt(this.mMeteredOverride);
        dest.writeInt(this.mSubscriptionId);
        dest.writeBoolean(this.mIsCarrierMerged);
        dest.writeBoolean(this.mIsOemPaid);
        dest.writeBoolean(this.mIsOemPrivate);
        dest.writeString(this.mDecoratedIdentityPrefix);
        dest.writeParcelable(this.mSubscriptionGroup, flags);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof PasspointConfiguration)) {
            return false;
        }
        PasspointConfiguration that = (PasspointConfiguration)thatObject;
        return (this.mHomeSp == null ? that.mHomeSp == null : this.mHomeSp.equals(that.mHomeSp)) && (this.mAaaServerTrustedNames == null ? that.mAaaServerTrustedNames == null : Arrays.equals(this.mAaaServerTrustedNames, that.mAaaServerTrustedNames)) && (this.mCredential == null ? that.mCredential == null : this.mCredential.equals(that.mCredential)) && (this.mPolicy == null ? that.mPolicy == null : this.mPolicy.equals(that.mPolicy)) && (this.mSubscriptionUpdate == null ? that.mSubscriptionUpdate == null : this.mSubscriptionUpdate.equals(that.mSubscriptionUpdate)) && PasspointConfiguration.isTrustRootCertListEquals(this.mTrustRootCertList, that.mTrustRootCertList) && this.mUpdateIdentifier == that.mUpdateIdentifier && this.mCredentialPriority == that.mCredentialPriority && this.mSubscriptionCreationTimeInMillis == that.mSubscriptionCreationTimeInMillis && this.mSubscriptionExpirationTimeMillis == that.mSubscriptionExpirationTimeMillis && TextUtils.equals(this.mSubscriptionType, that.mSubscriptionType) && this.mUsageLimitUsageTimePeriodInMinutes == that.mUsageLimitUsageTimePeriodInMinutes && this.mUsageLimitStartTimeInMillis == that.mUsageLimitStartTimeInMillis && this.mUsageLimitDataLimit == that.mUsageLimitDataLimit && this.mUsageLimitTimeLimitInMinutes == that.mUsageLimitTimeLimitInMinutes && this.mCarrierId == that.mCarrierId && this.mSubscriptionId == that.mSubscriptionId && this.mIsOemPrivate == that.mIsOemPrivate && this.mIsOemPaid == that.mIsOemPaid && this.mIsCarrierMerged == that.mIsCarrierMerged && this.mIsAutojoinEnabled == that.mIsAutojoinEnabled && this.mIsMacRandomizationEnabled == that.mIsMacRandomizationEnabled && this.mIsNonPersistentMacRandomizationEnabled == that.mIsNonPersistentMacRandomizationEnabled && this.mMeteredOverride == that.mMeteredOverride && (this.mServiceFriendlyNames == null ? that.mServiceFriendlyNames == null : this.mServiceFriendlyNames.equals(that.mServiceFriendlyNames)) && Objects.equals(this.mDecoratedIdentityPrefix, that.mDecoratedIdentityPrefix) && Objects.equals(this.mSubscriptionGroup, that.mSubscriptionGroup);
    }

    public int hashCode() {
        return Objects.hash(this.mHomeSp, this.mCredential, this.mPolicy, this.mSubscriptionUpdate, this.mTrustRootCertList, this.mUpdateIdentifier, this.mCredentialPriority, this.mSubscriptionCreationTimeInMillis, this.mSubscriptionExpirationTimeMillis, this.mUsageLimitUsageTimePeriodInMinutes, this.mUsageLimitStartTimeInMillis, this.mUsageLimitDataLimit, this.mUsageLimitTimeLimitInMinutes, this.mServiceFriendlyNames, this.mCarrierId, this.mIsAutojoinEnabled, this.mIsMacRandomizationEnabled, this.mIsNonPersistentMacRandomizationEnabled, this.mMeteredOverride, this.mSubscriptionId, this.mIsCarrierMerged, this.mIsOemPaid, this.mIsOemPrivate, this.mDecoratedIdentityPrefix, this.mSubscriptionGroup);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UpdateIdentifier: ").append(this.mUpdateIdentifier).append("\n");
        builder.append("CredentialPriority: ").append(this.mCredentialPriority).append("\n");
        builder.append("SubscriptionCreationTime: ").append(this.mSubscriptionCreationTimeInMillis != Long.MIN_VALUE ? new Date(this.mSubscriptionCreationTimeInMillis) : "Not specified").append("\n");
        builder.append("SubscriptionExpirationTime: ").append(this.mSubscriptionExpirationTimeMillis != Long.MIN_VALUE ? new Date(this.mSubscriptionExpirationTimeMillis) : "Not specified").append("\n");
        builder.append("UsageLimitStartTime: ").append(this.mUsageLimitStartTimeInMillis != Long.MIN_VALUE ? new Date(this.mUsageLimitStartTimeInMillis) : "Not specified").append("\n");
        builder.append("UsageTimePeriod: ").append(this.mUsageLimitUsageTimePeriodInMinutes).append("\n");
        builder.append("UsageLimitDataLimit: ").append(this.mUsageLimitDataLimit).append("\n");
        builder.append("UsageLimitTimeLimit: ").append(this.mUsageLimitTimeLimitInMinutes).append("\n");
        builder.append("Provisioned by a subscription server: ").append(this.isOsuProvisioned() ? "Yes" : "No").append("\n");
        if (this.mHomeSp != null) {
            builder.append("HomeSP Begin ---\n");
            builder.append(this.mHomeSp);
            builder.append("HomeSP End ---\n");
        }
        if (this.mCredential != null) {
            builder.append("Credential Begin ---\n");
            builder.append(this.mCredential);
            builder.append("Credential End ---\n");
        }
        if (this.mPolicy != null) {
            builder.append("Policy Begin ---\n");
            builder.append(this.mPolicy);
            builder.append("Policy End ---\n");
        }
        if (this.mSubscriptionUpdate != null) {
            builder.append("SubscriptionUpdate Begin ---\n");
            builder.append(this.mSubscriptionUpdate);
            builder.append("SubscriptionUpdate End ---\n");
        }
        if (this.mTrustRootCertList != null) {
            builder.append("TrustRootCertServers: ").append(this.mTrustRootCertList.keySet()).append("\n");
        }
        if (this.mAaaServerTrustedNames != null) {
            builder.append("AAAServerTrustedNames: ").append(String.join((CharSequence)";", this.mAaaServerTrustedNames)).append("\n");
        }
        if (this.mServiceFriendlyNames != null) {
            builder.append("ServiceFriendlyNames: ").append(this.mServiceFriendlyNames);
        }
        builder.append("CarrierId:" + this.mCarrierId);
        builder.append("SubscriptionId:" + this.mSubscriptionId);
        builder.append("IsAutojoinEnabled:" + this.mIsAutojoinEnabled);
        builder.append("mIsMacRandomizationEnabled:" + this.mIsMacRandomizationEnabled);
        builder.append("mIsNonPersistentMacRandomizationEnabled:" + this.mIsNonPersistentMacRandomizationEnabled);
        builder.append("mMeteredOverride:" + this.mMeteredOverride);
        builder.append("mIsCarrierMerged:" + this.mIsCarrierMerged);
        builder.append("mIsOemPaid:" + this.mIsOemPaid);
        builder.append("mIsOemPrivate:" + this.mIsOemPrivate);
        builder.append("mDecoratedUsernamePrefix:" + this.mDecoratedIdentityPrefix);
        builder.append("mSubscriptionGroup:" + this.mSubscriptionGroup);
        return builder.toString();
    }

    public boolean validate() {
        if (this.mSubscriptionUpdate != null && !this.mSubscriptionUpdate.validate()) {
            return false;
        }
        return this.validateForCommonR1andR2();
    }

    public boolean validateForR2() {
        if (this.mUpdateIdentifier == Integer.MIN_VALUE) {
            return false;
        }
        if (this.mSubscriptionUpdate == null || !this.mSubscriptionUpdate.validate()) {
            return false;
        }
        return this.validateForCommonR1andR2();
    }

    private boolean validateForCommonR1andR2() {
        if (this.mHomeSp == null || !this.mHomeSp.validate()) {
            return false;
        }
        if (this.mCredential == null || !this.mCredential.validate()) {
            return false;
        }
        if (this.mPolicy != null && !this.mPolicy.validate()) {
            return false;
        }
        if (!TextUtils.isEmpty(this.mDecoratedIdentityPrefix)) {
            if (!this.mDecoratedIdentityPrefix.endsWith("!")) {
                EventLog.writeEvent(1397638484, "246539931", -1, "Invalid decorated identity prefix");
                return false;
            }
            String[] decoratedIdentityPrefixArray = this.mDecoratedIdentityPrefix.split("!");
            if (decoratedIdentityPrefixArray.length > 16) {
                Log.d(TAG, "too many decoratedIdentityPrefix");
                return false;
            }
            String[] stringArray = decoratedIdentityPrefixArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String prefix = stringArray[i];
                if (prefix.length() <= 255) continue;
                Log.d(TAG, "The decoratedIdentityPrefix is too long: " + prefix);
                return false;
            }
        }
        if (this.mAaaServerTrustedNames != null) {
            if (this.mAaaServerTrustedNames.length > 16) {
                Log.d(TAG, "Too many AaaServerTrustedNames");
                return false;
            }
            for (String fqdn : this.mAaaServerTrustedNames) {
                if (fqdn.getBytes(StandardCharsets.UTF_8).length <= 255) continue;
                Log.d(TAG, "AaaServerTrustedNames is too long");
                return false;
            }
        }
        if (this.mSubscriptionType != null && this.mSubscriptionType.getBytes(StandardCharsets.UTF_8).length > 255) {
            Log.d(TAG, "SubscriptionType is too long");
            return false;
        }
        if (this.mTrustRootCertList != null) {
            if (this.mTrustRootCertList.size() > 16) {
                Log.d(TAG, "Too many TrustRootCert");
                return false;
            }
            for (Map.Entry entry : this.mTrustRootCertList.entrySet()) {
                String url = (String)entry.getKey();
                byte[] certFingerprint = (byte[])entry.getValue();
                if (TextUtils.isEmpty(url)) {
                    Log.d(TAG, "Empty URL");
                    return false;
                }
                if (url.getBytes(StandardCharsets.UTF_8).length > 2048) {
                    Log.d(TAG, "URL bytes exceeded the max: " + url.getBytes(StandardCharsets.UTF_8).length);
                    return false;
                }
                if (certFingerprint == null) {
                    Log.d(TAG, "Fingerprint not specified");
                    return false;
                }
                if (certFingerprint.length == 32) continue;
                Log.d(TAG, "Incorrect size of trust root certificate SHA-256 fingerprint: " + certFingerprint.length);
                return false;
            }
        }
        return true;
    }

    private static void writeTrustRootCerts(Parcel dest, Map<String, byte[]> trustRootCerts) {
        if (trustRootCerts == null) {
            dest.writeInt(-1);
            return;
        }
        dest.writeInt(trustRootCerts.size());
        for (Map.Entry<String, byte[]> entry : trustRootCerts.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeByteArray(entry.getValue());
        }
    }

    private static boolean isTrustRootCertListEquals(Map<String, byte[]> list1, Map<String, byte[]> list2) {
        if (list1 == null || list2 == null) {
            return list1 == list2;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (Map.Entry<String, byte[]> entry : list1.entrySet()) {
            if (Arrays.equals(entry.getValue(), list2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public boolean isOsuProvisioned() {
        return this.getUpdateIdentifier() != Integer.MIN_VALUE;
    }

    public String getUniqueId() {
        if (this.mCredential == null || this.mHomeSp == null || TextUtils.isEmpty(this.mHomeSp.getFqdn())) {
            throw new IllegalStateException("Credential or HomeSP are not initialized");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s_%x%x", this.mHomeSp.getFqdn(), this.mHomeSp.getUniqueId(), this.mCredential.getUniqueId()));
        return sb.toString();
    }

    @RequiresApi(value=31)
    public void setDecoratedIdentityPrefix(String decoratedIdentityPrefix) {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        if (!TextUtils.isEmpty(decoratedIdentityPrefix) && !decoratedIdentityPrefix.endsWith("!")) {
            throw new IllegalArgumentException("Decorated identity prefix must be delimited by '!'");
        }
        this.mDecoratedIdentityPrefix = decoratedIdentityPrefix;
    }

    @RequiresApi(value=31)
    public String getDecoratedIdentityPrefix() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.mDecoratedIdentityPrefix;
    }
}

