/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.NetworkSpecifier;
import android.net.wifi.aware.AttachCallback;
import android.net.wifi.aware.AwareParams;
import android.net.wifi.aware.AwareResources;
import android.net.wifi.aware.Characteristics;
import android.net.wifi.aware.ConfigRequest;
import android.net.wifi.aware.DiscoverySession;
import android.net.wifi.aware.DiscoverySessionCallback;
import android.net.wifi.aware.IWifiAwareDiscoverySessionCallback;
import android.net.wifi.aware.IWifiAwareEventCallback;
import android.net.wifi.aware.IWifiAwareMacAddressProvider;
import android.net.wifi.aware.IWifiAwareManager;
import android.net.wifi.aware.IdentityChangedListener;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.aware.PublishConfig;
import android.net.wifi.aware.PublishDiscoverySession;
import android.net.wifi.aware.ServiceDiscoveryInfo;
import android.net.wifi.aware.SubscribeConfig;
import android.net.wifi.aware.SubscribeDiscoverySession;
import android.net.wifi.aware.TlvBufferUtils;
import android.net.wifi.aware.WifiAwareNetworkSpecifier;
import android.net.wifi.aware.WifiAwareSession;
import android.net.wifi.aware.WifiAwareUtils;
import android.net.wifi.util.HexEncoding;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.util.Collections;
import java.util.List;

public class WifiAwareManager {
    private static final String TAG = "WifiAwareManager";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    public static final String ACTION_WIFI_AWARE_STATE_CHANGED = "android.net.wifi.aware.action.WIFI_AWARE_STATE_CHANGED";
    @RequiresApi(value=33)
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static final String ACTION_WIFI_AWARE_RESOURCE_CHANGED = "android.net.wifi.aware.action.WIFI_AWARE_RESOURCE_CHANGED";
    public static final String EXTRA_AWARE_RESOURCES = "android.net.wifi.aware.extra.AWARE_RESOURCES";
    public static final int WIFI_AWARE_DATA_PATH_ROLE_INITIATOR = 0;
    public static final int WIFI_AWARE_DATA_PATH_ROLE_RESPONDER = 1;
    public static final int WIFI_AWARE_DISCOVERY_LOST_REASON_UNKNOWN = 0;
    public static final int WIFI_AWARE_DISCOVERY_LOST_REASON_PEER_NOT_VISIBLE = 1;
    private final Context mContext;
    private final IWifiAwareManager mService;
    private final Object mLock = new Object();

    public WifiAwareManager(Context context, IWifiAwareManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isAvailable() {
        try {
            return this.mService.isUsageEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isDeviceAttached() {
        try {
            return this.mService.isDeviceAttached();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isSetChannelOnDataPathSupported() {
        try {
            return this.mService.isSetChannelOnDataPathSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(allOf={"android.permission.CHANGE_WIFI_STATE", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public void enableInstantCommunicationMode(boolean enable) {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        try {
            this.mService.enableInstantCommunicationMode(this.mContext.getOpPackageName(), enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isInstantCommunicationModeEnabled() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        try {
            return this.mService.isInstantCommunicationModeEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public Characteristics getCharacteristics() {
        try {
            return this.mService.getCharacteristics();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public AwareResources getAvailableAwareResources() {
        try {
            return this.mService.getAvailableAwareResources();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE"})
    public void attach(AttachCallback attachCallback, Handler handler) {
        this.attach(handler, null, attachCallback, null);
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE", "android.permission.ACCESS_FINE_LOCATION", "android.permission.NEARBY_WIFI_DEVICES"}, conditional=true)
    public void attach(AttachCallback attachCallback, IdentityChangedListener identityChangedListener, Handler handler) {
        this.attach(handler, null, attachCallback, identityChangedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(Handler handler, ConfigRequest configRequest, AttachCallback attachCallback, IdentityChangedListener identityChangedListener) {
        if (attachCallback == null) {
            throw new IllegalArgumentException("Null callback provided");
        }
        Object object = this.mLock;
        synchronized (object) {
            Looper looper = handler == null ? Looper.getMainLooper() : handler.getLooper();
            try {
                Binder binder = new Binder();
                Bundle extras = new Bundle();
                if (SdkLevel.isAtLeastS()) {
                    extras.putParcelable("EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE", this.mContext.getAttributionSource());
                }
                this.mService.connect(binder, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), new WifiAwareEventCallbackProxy(this, looper, binder, attachCallback, identityChangedListener), configRequest, identityChangedListener != null, extras);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void disconnect(int clientId, Binder binder) {
        try {
            this.mService.disconnect(clientId, binder);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void publish(int clientId, Looper looper, PublishConfig publishConfig, DiscoverySessionCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Null callback provided");
        }
        try {
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable("EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE", this.mContext.getAttributionSource());
            }
            this.mService.publish(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), clientId, publishConfig, new WifiAwareDiscoverySessionCallbackProxy(this, looper, true, callback, clientId), extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void updatePublish(int clientId, int sessionId, PublishConfig publishConfig) {
        try {
            this.mService.updatePublish(clientId, sessionId, publishConfig);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void subscribe(int clientId, Looper looper, SubscribeConfig subscribeConfig, DiscoverySessionCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Null callback provided");
        }
        try {
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable("EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE", this.mContext.getAttributionSource());
            }
            this.mService.subscribe(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), clientId, subscribeConfig, new WifiAwareDiscoverySessionCallbackProxy(this, looper, false, callback, clientId), extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void updateSubscribe(int clientId, int sessionId, SubscribeConfig subscribeConfig) {
        try {
            this.mService.updateSubscribe(clientId, sessionId, subscribeConfig);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void terminateSession(int clientId, int sessionId) {
        try {
            this.mService.terminateSession(clientId, sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void sendMessage(int clientId, int sessionId, PeerHandle peerHandle, byte[] message, int messageId, int retryCount) {
        if (peerHandle == null) {
            throw new IllegalArgumentException("sendMessage: invalid peerHandle - must be non-null");
        }
        try {
            this.mService.sendMessage(clientId, sessionId, peerHandle.peerId, message, messageId, retryCount);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.NETWORK_STACK")
    public void requestMacAddresses(int uid, int[] peerIds, IWifiAwareMacAddressProvider callback) {
        try {
            this.mService.requestMacAddresses(uid, peerIds, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public NetworkSpecifier createNetworkSpecifier(int clientId, int role, int sessionId, PeerHandle peerHandle, byte[] pmk, String passphrase) {
        if (!WifiAwareUtils.isLegacyVersion(this.mContext, 29)) {
            throw new UnsupportedOperationException("API deprecated - use WifiAwareNetworkSpecifier.Builder");
        }
        if (role != 0 && role != 1) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid 'role' argument when creating a network specifier");
        }
        if (!(role != 0 && WifiAwareUtils.isLegacyVersion(this.mContext, 28) || peerHandle != null)) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid peer handle - cannot be null");
        }
        return new WifiAwareNetworkSpecifier(peerHandle == null ? 1 : 0, role, clientId, sessionId, peerHandle != null ? peerHandle.peerId : 0, null, pmk, passphrase, 0, -1);
    }

    public NetworkSpecifier createNetworkSpecifier(int clientId, int role, byte[] peer, byte[] pmk, String passphrase) {
        if (role != 0 && role != 1) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid 'role' argument when creating a network specifier");
        }
        if (!(role != 0 && WifiAwareUtils.isLegacyVersion(this.mContext, 28) || peer != null)) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid peer MAC - cannot be null");
        }
        if (peer != null && peer.length != 6) {
            throw new IllegalArgumentException("createNetworkSpecifier: Invalid peer MAC address");
        }
        return new WifiAwareNetworkSpecifier(peer == null ? 3 : 2, role, clientId, 0, 0, peer, pmk, passphrase, 0, -1);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.OVERRIDE_WIFI_CONFIG", "android.permission.CHANGE_WIFI_STATE"})
    public void setAwareParams(AwareParams params) {
        try {
            this.mService.setAwareParams(params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class WifiAwareDiscoverySessionCallbackProxy
    extends IWifiAwareDiscoverySessionCallback.Stub {
        private static final int CALLBACK_SESSION_STARTED = 0;
        private static final int CALLBACK_SESSION_CONFIG_SUCCESS = 1;
        private static final int CALLBACK_SESSION_CONFIG_FAIL = 2;
        private static final int CALLBACK_SESSION_TERMINATED = 3;
        private static final int CALLBACK_MATCH = 4;
        private static final int CALLBACK_MESSAGE_SEND_SUCCESS = 5;
        private static final int CALLBACK_MESSAGE_SEND_FAIL = 6;
        private static final int CALLBACK_MESSAGE_RECEIVED = 7;
        private static final int CALLBACK_MATCH_WITH_DISTANCE = 8;
        private static final int CALLBACK_MATCH_EXPIRED = 9;
        private static final String MESSAGE_BUNDLE_KEY_MESSAGE = "message";
        private static final String MESSAGE_BUNDLE_KEY_MESSAGE2 = "message2";
        private static final String MESSAGE_BUNDLE_KEY_CIPHER_SUITE = "key_cipher_suite";
        private static final String MESSAGE_BUNDLE_KEY_SCID = "key_scid";
        private final WeakReference<WifiAwareManager> mAwareManager;
        private final boolean mIsPublish;
        private final DiscoverySessionCallback mOriginalCallback;
        private final int mClientId;
        private final Handler mHandler;
        private DiscoverySession mSession;

        WifiAwareDiscoverySessionCallbackProxy(WifiAwareManager mgr, Looper looper, boolean isPublish, DiscoverySessionCallback originalCallback, int clientId) {
            this.mAwareManager = new WeakReference<WifiAwareManager>(mgr);
            this.mIsPublish = isPublish;
            this.mOriginalCallback = originalCallback;
            this.mClientId = clientId;
            this.mHandler = new Handler(looper){

                @Override
                public void handleMessage(Message msg) {
                    if (mAwareManager.get() == null) {
                        Log.w(WifiAwareManager.TAG, "WifiAwareDiscoverySessionCallbackProxy: handleMessage post GC");
                        return;
                    }
                    switch (msg.what) {
                        case 0: {
                            this.onProxySessionStarted(msg.arg1);
                            break;
                        }
                        case 1: {
                            mOriginalCallback.onSessionConfigUpdated();
                            break;
                        }
                        case 2: {
                            mOriginalCallback.onSessionConfigFailed();
                            if (mSession != null) break;
                            mAwareManager.clear();
                            break;
                        }
                        case 3: {
                            this.onProxySessionTerminated(msg.arg1);
                            break;
                        }
                        case 4: 
                        case 8: {
                            List<byte[]> matchFilter = null;
                            Bundle data = msg.getData();
                            byte[] arg = data.getByteArray(WifiAwareDiscoverySessionCallbackProxy.MESSAGE_BUNDLE_KEY_MESSAGE2);
                            try {
                                matchFilter = new TlvBufferUtils.TlvIterable(0, 1, arg).toList();
                            }
                            catch (BufferOverflowException e) {
                                matchFilter = Collections.emptyList();
                                Log.e(WifiAwareManager.TAG, "onServiceDiscovered: invalid match filter byte array '" + new String(HexEncoding.encode(arg)) + "' - cannot be parsed: e=" + e);
                            }
                            if (msg.what == 4) {
                                mOriginalCallback.onServiceDiscovered(new PeerHandle(msg.arg1), data.getByteArray(WifiAwareDiscoverySessionCallbackProxy.MESSAGE_BUNDLE_KEY_MESSAGE), matchFilter);
                                mOriginalCallback.onServiceDiscovered(new ServiceDiscoveryInfo(new PeerHandle(msg.arg1), data.getInt(WifiAwareDiscoverySessionCallbackProxy.MESSAGE_BUNDLE_KEY_CIPHER_SUITE), data.getByteArray(WifiAwareDiscoverySessionCallbackProxy.MESSAGE_BUNDLE_KEY_MESSAGE), matchFilter, data.getByteArray(WifiAwareDiscoverySessionCallbackProxy.MESSAGE_BUNDLE_KEY_SCID)));
                                break;
                            }
                            mOriginalCallback.onServiceDiscoveredWithinRange(new PeerHandle(msg.arg1), msg.getData().getByteArray(WifiAwareDiscoverySessionCallbackProxy.MESSAGE_BUNDLE_KEY_MESSAGE), matchFilter, msg.arg2);
                            mOriginalCallback.onServiceDiscoveredWithinRange(new ServiceDiscoveryInfo(new PeerHandle(msg.arg1), data.getInt(WifiAwareDiscoverySessionCallbackProxy.MESSAGE_BUNDLE_KEY_CIPHER_SUITE), data.getByteArray(WifiAwareDiscoverySessionCallbackProxy.MESSAGE_BUNDLE_KEY_MESSAGE), matchFilter, data.getByteArray(WifiAwareDiscoverySessionCallbackProxy.MESSAGE_BUNDLE_KEY_SCID)), msg.arg2);
                            break;
                        }
                        case 5: {
                            mOriginalCallback.onMessageSendSucceeded(msg.arg1);
                            break;
                        }
                        case 6: {
                            mOriginalCallback.onMessageSendFailed(msg.arg1);
                            break;
                        }
                        case 7: {
                            mOriginalCallback.onMessageReceived(new PeerHandle(msg.arg1), (byte[])msg.obj);
                            break;
                        }
                        case 9: {
                            mOriginalCallback.onServiceLost(new PeerHandle(msg.arg1), 1);
                        }
                    }
                }
            };
        }

        @Override
        public void onSessionStarted(int sessionId) {
            Message msg = this.mHandler.obtainMessage(0);
            msg.arg1 = sessionId;
            this.mHandler.sendMessage(msg);
        }

        @Override
        public void onSessionConfigSuccess() {
            Message msg = this.mHandler.obtainMessage(1);
            this.mHandler.sendMessage(msg);
        }

        @Override
        public void onSessionConfigFail(int reason) {
            Message msg = this.mHandler.obtainMessage(2);
            msg.arg1 = reason;
            this.mHandler.sendMessage(msg);
        }

        @Override
        public void onSessionTerminated(int reason) {
            Message msg = this.mHandler.obtainMessage(3);
            msg.arg1 = reason;
            this.mHandler.sendMessage(msg);
        }

        private void onMatchCommon(int messageType, int peerId, byte[] serviceSpecificInfo, byte[] matchFilter, int distanceMm, int peerCipherSuite, byte[] scid) {
            Bundle data = new Bundle();
            data.putByteArray(MESSAGE_BUNDLE_KEY_MESSAGE, serviceSpecificInfo);
            data.putByteArray(MESSAGE_BUNDLE_KEY_MESSAGE2, matchFilter);
            data.putInt(MESSAGE_BUNDLE_KEY_CIPHER_SUITE, peerCipherSuite);
            data.putByteArray(MESSAGE_BUNDLE_KEY_SCID, scid);
            Message msg = this.mHandler.obtainMessage(messageType);
            msg.arg1 = peerId;
            msg.arg2 = distanceMm;
            msg.setData(data);
            this.mHandler.sendMessage(msg);
        }

        @Override
        public void onMatch(int peerId, byte[] serviceSpecificInfo, byte[] matchFilter, int peerCipherSuite, byte[] scid) {
            this.onMatchCommon(4, peerId, serviceSpecificInfo, matchFilter, 0, peerCipherSuite, scid);
        }

        @Override
        public void onMatchWithDistance(int peerId, byte[] serviceSpecificInfo, byte[] matchFilter, int distanceMm, int peerCipherSuite, byte[] scid) {
            this.onMatchCommon(8, peerId, serviceSpecificInfo, matchFilter, distanceMm, peerCipherSuite, scid);
        }

        @Override
        public void onMatchExpired(int peerId) {
            Message msg = this.mHandler.obtainMessage(9);
            msg.arg1 = peerId;
            this.mHandler.sendMessage(msg);
        }

        @Override
        public void onMessageSendSuccess(int messageId) {
            Message msg = this.mHandler.obtainMessage(5);
            msg.arg1 = messageId;
            this.mHandler.sendMessage(msg);
        }

        @Override
        public void onMessageSendFail(int messageId, int reason) {
            Message msg = this.mHandler.obtainMessage(6);
            msg.arg1 = messageId;
            msg.arg2 = reason;
            this.mHandler.sendMessage(msg);
        }

        @Override
        public void onMessageReceived(int peerId, byte[] message) {
            Message msg = this.mHandler.obtainMessage(7);
            msg.arg1 = peerId;
            msg.obj = message;
            this.mHandler.sendMessage(msg);
        }

        public void onProxySessionStarted(int sessionId) {
            if (this.mSession != null) {
                Log.e(WifiAwareManager.TAG, "onSessionStarted: sessionId=" + sessionId + ": session already created!?");
                throw new IllegalStateException("onSessionStarted: sessionId=" + sessionId + ": session already created!?");
            }
            WifiAwareManager mgr = (WifiAwareManager)this.mAwareManager.get();
            if (mgr == null) {
                Log.w(WifiAwareManager.TAG, "onProxySessionStarted: mgr GC'd");
                return;
            }
            if (this.mIsPublish) {
                PublishDiscoverySession session = new PublishDiscoverySession(mgr, this.mClientId, sessionId);
                this.mSession = session;
                this.mOriginalCallback.onPublishStarted(session);
            } else {
                SubscribeDiscoverySession session = new SubscribeDiscoverySession(mgr, this.mClientId, sessionId);
                this.mSession = session;
                this.mOriginalCallback.onSubscribeStarted(session);
            }
        }

        public void onProxySessionTerminated(int reason) {
            if (this.mSession != null) {
                this.mSession.setTerminated();
                this.mSession = null;
            } else {
                Log.w(WifiAwareManager.TAG, "Proxy: onSessionTerminated called but mSession is null!?");
            }
            this.mAwareManager.clear();
            this.mOriginalCallback.onSessionTerminated();
        }
    }

    private static class WifiAwareEventCallbackProxy
    extends IWifiAwareEventCallback.Stub {
        private static final int CALLBACK_CONNECT_SUCCESS = 0;
        private static final int CALLBACK_CONNECT_FAIL = 1;
        private static final int CALLBACK_IDENTITY_CHANGED = 2;
        private static final int CALLBACK_ATTACH_TERMINATE = 3;
        private final Handler mHandler;
        private final WeakReference<WifiAwareManager> mAwareManager;
        private final Binder mBinder;
        private final Looper mLooper;

        WifiAwareEventCallbackProxy(WifiAwareManager mgr, Looper looper, Binder binder, final AttachCallback attachCallback, final IdentityChangedListener identityChangedListener) {
            this.mAwareManager = new WeakReference<WifiAwareManager>(mgr);
            this.mLooper = looper;
            this.mBinder = binder;
            this.mHandler = new Handler(looper){

                @Override
                public void handleMessage(Message msg) {
                    WifiAwareManager mgr = (WifiAwareManager)mAwareManager.get();
                    if (mgr == null) {
                        Log.w(WifiAwareManager.TAG, "WifiAwareEventCallbackProxy: handleMessage post GC");
                        return;
                    }
                    switch (msg.what) {
                        case 0: {
                            attachCallback.onAttached(new WifiAwareSession(mgr, mBinder, msg.arg1));
                            break;
                        }
                        case 1: {
                            mAwareManager.clear();
                            attachCallback.onAttachFailed();
                            break;
                        }
                        case 2: {
                            if (identityChangedListener == null) {
                                Log.e(WifiAwareManager.TAG, "CALLBACK_IDENTITY_CHANGED: null listener.");
                                break;
                            }
                            identityChangedListener.onIdentityChanged((byte[])msg.obj);
                            break;
                        }
                        case 3: {
                            mAwareManager.clear();
                            attachCallback.onAwareSessionTerminated();
                        }
                    }
                }
            };
        }

        @Override
        public void onConnectSuccess(int clientId) {
            Message msg = this.mHandler.obtainMessage(0);
            msg.arg1 = clientId;
            this.mHandler.sendMessage(msg);
        }

        @Override
        public void onConnectFail(int reason) {
            Message msg = this.mHandler.obtainMessage(1);
            msg.arg1 = reason;
            this.mHandler.sendMessage(msg);
        }

        @Override
        public void onIdentityChanged(byte[] mac) {
            Message msg = this.mHandler.obtainMessage(2);
            msg.obj = mac;
            this.mHandler.sendMessage(msg);
        }

        @Override
        public void onAttachTerminate() {
            Message msg = this.mHandler.obtainMessage(3);
            this.mHandler.sendMessage(msg);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DiscoveryLostReasonCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataPathRole {
    }
}

