/*
 * Decompiled with CFR 0.152.
 */
package android.net.sntp;

import android.net.sntp.Timestamp64;
import java.time.Duration;
import java.util.Objects;

public class Duration64 {
    public static final Duration64 ZERO = new Duration64(0L);
    private final long mBits;

    private Duration64(long bits) {
        this.mBits = bits;
    }

    public static Duration64 between(Timestamp64 startInclusive, Timestamp64 endExclusive) {
        long oneBits = startInclusive.getEraSeconds() << 32 | (long)startInclusive.getFractionBits() & 0xFFFFFFFFL;
        long twoBits = endExclusive.getEraSeconds() << 32 | (long)endExclusive.getFractionBits() & 0xFFFFFFFFL;
        long resultBits = twoBits - oneBits;
        return new Duration64(resultBits);
    }

    public Duration plus(Duration64 other) {
        return this.toDuration().plus(other.toDuration());
    }

    public static Duration64 fromDuration(Duration duration) {
        long seconds = duration.getSeconds();
        if (seconds < Integer.MIN_VALUE || seconds > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        long bits = seconds << 32 | (long)Timestamp64.nanosToFractionBits(duration.getNano()) & 0xFFFFFFFFL;
        return new Duration64(bits);
    }

    public Duration toDuration() {
        int seconds = this.getSeconds();
        int nanos = this.getNanos();
        return Duration.ofSeconds(seconds, nanos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration64 that = (Duration64)o;
        return this.mBits == that.mBits;
    }

    public int hashCode() {
        return Objects.hash(this.mBits);
    }

    public String toString() {
        Duration duration = this.toDuration();
        return Long.toHexString(this.mBits) + "(" + duration.getSeconds() + "s " + duration.getNano() + "ns)";
    }

    public int getSeconds() {
        return (int)(this.mBits >> 32);
    }

    public int getNanos() {
        return Timestamp64.fractionBitsToNanos((int)(this.mBits & 0xFFFFFFFFL));
    }
}

