/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.annotation.RequiresPermission;
import android.app.compat.CompatChanges;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.net.nsd.INsdManager;
import android.net.nsd.INsdManagerCallback;
import android.net.nsd.INsdServiceConnector;
import android.net.nsd.NsdServiceInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.concurrent.Executor;

public class NsdManager {
    private static final String TAG = NsdManager.class.getSimpleName();
    private static final boolean DBG = false;
    public static final long RUN_NATIVE_NSD_ONLY_IF_LEGACY_APPS = 191844585L;
    public static final String ACTION_NSD_STATE_CHANGED = "android.net.nsd.STATE_CHANGED";
    public static final String EXTRA_NSD_STATE = "nsd_state";
    public static final int NSD_STATE_DISABLED = 1;
    public static final int NSD_STATE_ENABLED = 2;
    public static final int DISCOVER_SERVICES = 1;
    public static final int DISCOVER_SERVICES_STARTED = 2;
    public static final int DISCOVER_SERVICES_FAILED = 3;
    public static final int SERVICE_FOUND = 4;
    public static final int SERVICE_LOST = 5;
    public static final int STOP_DISCOVERY = 6;
    public static final int STOP_DISCOVERY_FAILED = 7;
    public static final int STOP_DISCOVERY_SUCCEEDED = 8;
    public static final int REGISTER_SERVICE = 9;
    public static final int REGISTER_SERVICE_FAILED = 10;
    public static final int REGISTER_SERVICE_SUCCEEDED = 11;
    public static final int UNREGISTER_SERVICE = 12;
    public static final int UNREGISTER_SERVICE_FAILED = 13;
    public static final int UNREGISTER_SERVICE_SUCCEEDED = 14;
    public static final int RESOLVE_SERVICE = 15;
    public static final int RESOLVE_SERVICE_FAILED = 16;
    public static final int RESOLVE_SERVICE_SUCCEEDED = 17;
    public static final int DAEMON_CLEANUP = 18;
    public static final int DAEMON_STARTUP = 19;
    public static final int ENABLE = 20;
    public static final int DISABLE = 21;
    public static final int MDNS_SERVICE_EVENT = 22;
    public static final int REGISTER_CLIENT = 23;
    public static final int UNREGISTER_CLIENT = 24;
    public static final int PROTOCOL_DNS_SD = 1;
    private static final SparseArray<String> EVENT_NAMES = new SparseArray();
    private static final int FIRST_LISTENER_KEY = 1;
    private final INsdServiceConnector mService;
    private final Context mContext;
    private int mListenerKey = 1;
    @GuardedBy(value={"mMapLock"})
    private final SparseArray mListenerMap = new SparseArray();
    @GuardedBy(value={"mMapLock"})
    private final SparseArray<NsdServiceInfo> mServiceMap = new SparseArray();
    @GuardedBy(value={"mMapLock"})
    private final SparseArray<Executor> mExecutorMap = new SparseArray();
    private final Object mMapLock = new Object();
    @GuardedBy(value={"mPerNetworkDiscoveryMap"})
    private final ArrayMap<Integer, PerNetworkDiscoveryTracker> mPerNetworkDiscoveryMap = new ArrayMap();
    private final ServiceHandler mHandler;
    public static final int FAILURE_INTERNAL_ERROR = 0;
    public static final int FAILURE_ALREADY_ACTIVE = 3;
    public static final int FAILURE_MAX_LIMIT = 4;

    public static String nameOf(int event) {
        String name = EVENT_NAMES.get(event);
        if (name == null) {
            return Integer.toString(event);
        }
        return name;
    }

    public NsdManager(Context context, INsdManager service) {
        this.mContext = context;
        HandlerThread t = new HandlerThread("NsdManager");
        t.start();
        this.mHandler = new ServiceHandler(t.getLooper());
        try {
            this.mService = service.connect(new NsdCallbackImpl(this.mHandler));
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed to connect to NsdService");
        }
        if (!CompatChanges.isChangeEnabled(191844585L)) {
            try {
                this.mService.startDaemon();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to proactively start daemon");
            }
        }
    }

    private int nextListenerKey() {
        this.mListenerKey = Math.max(1, this.mListenerKey + 1);
        return this.mListenerKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int putListener(Object listener, Executor e, NsdServiceInfo s) {
        int key;
        NsdManager.checkListener(listener);
        Object object = this.mMapLock;
        synchronized (object) {
            int valueIndex = this.mListenerMap.indexOfValue(listener);
            if (valueIndex != -1) {
                throw new IllegalArgumentException("listener already in use");
            }
            key = this.nextListenerKey();
            this.mListenerMap.put(key, listener);
            this.mServiceMap.put(key, s);
            this.mExecutorMap.put(key, e);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(int key) {
        Object object = this.mMapLock;
        synchronized (object) {
            this.mListenerMap.remove(key);
            this.mServiceMap.remove(key);
            this.mExecutorMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getListenerKey(Object listener) {
        NsdManager.checkListener(listener);
        Object object = this.mMapLock;
        synchronized (object) {
            int valueIndex = this.mListenerMap.indexOfValue(listener);
            if (valueIndex == -1) {
                throw new IllegalArgumentException("listener not registered");
            }
            return this.mListenerMap.keyAt(valueIndex);
        }
    }

    private static String getNsdServiceInfoType(NsdServiceInfo s) {
        if (s == null) {
            return "?";
        }
        return s.getServiceType();
    }

    public void registerService(NsdServiceInfo serviceInfo, int protocolType, RegistrationListener listener) {
        this.registerService(serviceInfo, protocolType, Runnable::run, listener);
    }

    public void registerService(NsdServiceInfo serviceInfo, int protocolType, Executor executor, RegistrationListener listener) {
        if (serviceInfo.getPort() <= 0) {
            throw new IllegalArgumentException("Invalid port number");
        }
        NsdManager.checkServiceInfo(serviceInfo);
        NsdManager.checkProtocol(protocolType);
        int key = this.putListener(listener, executor, serviceInfo);
        try {
            this.mService.registerService(key, serviceInfo);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void unregisterService(RegistrationListener listener) {
        int id2 = this.getListenerKey(listener);
        try {
            this.mService.unregisterService(id2);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void discoverServices(String serviceType, int protocolType, DiscoveryListener listener) {
        this.discoverServices(serviceType, protocolType, (Network)null, Runnable::run, listener);
    }

    public void discoverServices(String serviceType, int protocolType, Network network, Executor executor, DiscoveryListener listener) {
        if (TextUtils.isEmpty(serviceType)) {
            throw new IllegalArgumentException("Service type cannot be empty");
        }
        NsdManager.checkProtocol(protocolType);
        NsdServiceInfo s = new NsdServiceInfo();
        s.setServiceType(serviceType);
        s.setNetwork(network);
        int key = this.putListener(listener, executor, s);
        try {
            this.mService.discoverServices(key, s);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public void discoverServices(String serviceType, int protocolType, NetworkRequest networkRequest, Executor executor, DiscoveryListener listener) {
        if (TextUtils.isEmpty(serviceType)) {
            throw new IllegalArgumentException("Service type cannot be empty");
        }
        Objects.requireNonNull(networkRequest, "NetworkRequest cannot be null");
        NsdManager.checkProtocol(protocolType);
        NsdServiceInfo s = new NsdServiceInfo();
        s.setServiceType(serviceType);
        int baseListenerKey = this.putListener(listener, executor, s);
        PerNetworkDiscoveryTracker discoveryInfo = new PerNetworkDiscoveryTracker(serviceType, protocolType, executor, listener);
        ArrayMap<Integer, PerNetworkDiscoveryTracker> arrayMap = this.mPerNetworkDiscoveryMap;
        synchronized (arrayMap) {
            this.mPerNetworkDiscoveryMap.put(baseListenerKey, discoveryInfo);
            discoveryInfo.start(networkRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServiceDiscovery(DiscoveryListener listener) {
        int id2 = this.getListenerKey(listener);
        ArrayMap<Integer, PerNetworkDiscoveryTracker> arrayMap = this.mPerNetworkDiscoveryMap;
        synchronized (arrayMap) {
            PerNetworkDiscoveryTracker info = this.mPerNetworkDiscoveryMap.get(id2);
            if (info != null) {
                info.requestStop();
                return;
            }
        }
        try {
            this.mService.stopDiscovery(id2);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void resolveService(NsdServiceInfo serviceInfo, ResolveListener listener) {
        this.resolveService(serviceInfo, Runnable::run, listener);
    }

    public void resolveService(NsdServiceInfo serviceInfo, Executor executor, ResolveListener listener) {
        NsdManager.checkServiceInfo(serviceInfo);
        int key = this.putListener(listener, executor, serviceInfo);
        try {
            this.mService.resolveService(key, serviceInfo);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    private static void checkListener(Object listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
    }

    private static void checkProtocol(int protocolType) {
        if (protocolType != 1) {
            throw new IllegalArgumentException("Unsupported protocol");
        }
    }

    private static void checkServiceInfo(NsdServiceInfo serviceInfo) {
        Objects.requireNonNull(serviceInfo, "NsdServiceInfo cannot be null");
        if (TextUtils.isEmpty(serviceInfo.getServiceName())) {
            throw new IllegalArgumentException("Service name cannot be empty");
        }
        if (TextUtils.isEmpty(serviceInfo.getServiceType())) {
            throw new IllegalArgumentException("Service type cannot be empty");
        }
    }

    static {
        EVENT_NAMES.put(1, "DISCOVER_SERVICES");
        EVENT_NAMES.put(2, "DISCOVER_SERVICES_STARTED");
        EVENT_NAMES.put(3, "DISCOVER_SERVICES_FAILED");
        EVENT_NAMES.put(4, "SERVICE_FOUND");
        EVENT_NAMES.put(5, "SERVICE_LOST");
        EVENT_NAMES.put(6, "STOP_DISCOVERY");
        EVENT_NAMES.put(7, "STOP_DISCOVERY_FAILED");
        EVENT_NAMES.put(8, "STOP_DISCOVERY_SUCCEEDED");
        EVENT_NAMES.put(9, "REGISTER_SERVICE");
        EVENT_NAMES.put(10, "REGISTER_SERVICE_FAILED");
        EVENT_NAMES.put(11, "REGISTER_SERVICE_SUCCEEDED");
        EVENT_NAMES.put(12, "UNREGISTER_SERVICE");
        EVENT_NAMES.put(13, "UNREGISTER_SERVICE_FAILED");
        EVENT_NAMES.put(14, "UNREGISTER_SERVICE_SUCCEEDED");
        EVENT_NAMES.put(15, "RESOLVE_SERVICE");
        EVENT_NAMES.put(16, "RESOLVE_SERVICE_FAILED");
        EVENT_NAMES.put(17, "RESOLVE_SERVICE_SUCCEEDED");
        EVENT_NAMES.put(18, "DAEMON_CLEANUP");
        EVENT_NAMES.put(19, "DAEMON_STARTUP");
        EVENT_NAMES.put(20, "ENABLE");
        EVENT_NAMES.put(21, "DISABLE");
        EVENT_NAMES.put(22, "MDNS_SERVICE_EVENT");
    }

    @VisibleForTesting
    class ServiceHandler
    extends Handler {
        ServiceHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message message) {
            Executor executor;
            NsdServiceInfo ns;
            Object listener;
            int what = message.what;
            int errorCode = message.arg1;
            int key = message.arg2;
            Object obj = message.obj;
            Object object = NsdManager.this.mMapLock;
            synchronized (object) {
                listener = NsdManager.this.mListenerMap.get(key);
                ns = NsdManager.this.mServiceMap.get(key);
                executor = NsdManager.this.mExecutorMap.get(key);
            }
            if (listener == null) {
                Log.d(TAG, "Stale key " + key);
                return;
            }
            switch (what) {
                case 2: {
                    String s = NsdManager.getNsdServiceInfoType((NsdServiceInfo)obj);
                    executor.execute(() -> ((DiscoveryListener)listener).onDiscoveryStarted(s));
                    break;
                }
                case 3: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((DiscoveryListener)listener).onStartDiscoveryFailed(NsdManager.getNsdServiceInfoType(ns), errorCode));
                    break;
                }
                case 4: {
                    executor.execute(() -> ((DiscoveryListener)listener).onServiceFound((NsdServiceInfo)obj));
                    break;
                }
                case 5: {
                    executor.execute(() -> ((DiscoveryListener)listener).onServiceLost((NsdServiceInfo)obj));
                    break;
                }
                case 7: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((DiscoveryListener)listener).onStopDiscoveryFailed(NsdManager.getNsdServiceInfoType(ns), errorCode));
                    break;
                }
                case 8: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((DiscoveryListener)listener).onDiscoveryStopped(NsdManager.getNsdServiceInfoType(ns)));
                    break;
                }
                case 10: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((RegistrationListener)listener).onRegistrationFailed(ns, errorCode));
                    break;
                }
                case 11: {
                    executor.execute(() -> ((RegistrationListener)listener).onServiceRegistered((NsdServiceInfo)obj));
                    break;
                }
                case 13: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((RegistrationListener)listener).onUnregistrationFailed(ns, errorCode));
                    break;
                }
                case 14: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((RegistrationListener)listener).onServiceUnregistered(ns));
                    break;
                }
                case 16: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((ResolveListener)listener).onResolveFailed(ns, errorCode));
                    break;
                }
                case 17: {
                    NsdManager.this.removeListener(key);
                    executor.execute(() -> ((ResolveListener)listener).onServiceResolved((NsdServiceInfo)obj));
                    break;
                }
                default: {
                    Log.d(TAG, "Ignored " + message);
                }
            }
        }
    }

    public static interface ResolveListener {
        public void onResolveFailed(NsdServiceInfo var1, int var2);

        public void onServiceResolved(NsdServiceInfo var1);
    }

    public static interface RegistrationListener {
        public void onRegistrationFailed(NsdServiceInfo var1, int var2);

        public void onUnregistrationFailed(NsdServiceInfo var1, int var2);

        public void onServiceRegistered(NsdServiceInfo var1);

        public void onServiceUnregistered(NsdServiceInfo var1);
    }

    public static interface DiscoveryListener {
        public void onStartDiscoveryFailed(String var1, int var2);

        public void onStopDiscoveryFailed(String var1, int var2);

        public void onDiscoveryStarted(String var1);

        public void onDiscoveryStopped(String var1);

        public void onServiceFound(NsdServiceInfo var1);

        public void onServiceLost(NsdServiceInfo var1);
    }

    private static class NsdCallbackImpl
    extends INsdManagerCallback.Stub {
        private final Handler mServHandler;

        NsdCallbackImpl(Handler serviceHandler) {
            this.mServHandler = serviceHandler;
        }

        private void sendInfo(int message, int listenerKey, NsdServiceInfo info) {
            this.mServHandler.sendMessage(this.mServHandler.obtainMessage(message, 0, listenerKey, info));
        }

        private void sendError(int message, int listenerKey, int error) {
            this.mServHandler.sendMessage(this.mServHandler.obtainMessage(message, error, listenerKey));
        }

        private void sendNoArg(int message, int listenerKey) {
            this.mServHandler.sendMessage(this.mServHandler.obtainMessage(message, 0, listenerKey));
        }

        @Override
        public void onDiscoverServicesStarted(int listenerKey, NsdServiceInfo info) {
            this.sendInfo(2, listenerKey, info);
        }

        @Override
        public void onDiscoverServicesFailed(int listenerKey, int error) {
            this.sendError(3, listenerKey, error);
        }

        @Override
        public void onServiceFound(int listenerKey, NsdServiceInfo info) {
            this.sendInfo(4, listenerKey, info);
        }

        @Override
        public void onServiceLost(int listenerKey, NsdServiceInfo info) {
            this.sendInfo(5, listenerKey, info);
        }

        @Override
        public void onStopDiscoveryFailed(int listenerKey, int error) {
            this.sendError(7, listenerKey, error);
        }

        @Override
        public void onStopDiscoverySucceeded(int listenerKey) {
            this.sendNoArg(8, listenerKey);
        }

        @Override
        public void onRegisterServiceFailed(int listenerKey, int error) {
            this.sendError(10, listenerKey, error);
        }

        @Override
        public void onRegisterServiceSucceeded(int listenerKey, NsdServiceInfo info) {
            this.sendInfo(11, listenerKey, info);
        }

        @Override
        public void onUnregisterServiceFailed(int listenerKey, int error) {
            this.sendError(13, listenerKey, error);
        }

        @Override
        public void onUnregisterServiceSucceeded(int listenerKey) {
            this.sendNoArg(14, listenerKey);
        }

        @Override
        public void onResolveServiceFailed(int listenerKey, int error) {
            this.sendError(16, listenerKey, error);
        }

        @Override
        public void onResolveServiceSucceeded(int listenerKey, NsdServiceInfo info) {
            this.sendInfo(17, listenerKey, info);
        }
    }

    private class PerNetworkDiscoveryTracker {
        final String mServiceType;
        final int mProtocolType;
        final DiscoveryListener mBaseListener;
        final Executor mBaseExecutor;
        final ArrayMap<Network, DelegatingDiscoveryListener> mPerNetworkListeners = new ArrayMap();
        final ConnectivityManager.NetworkCallback mNetworkCb = new ConnectivityManager.NetworkCallback(){

            @Override
            public void onAvailable(Network network) {
                DelegatingDiscoveryListener wrappedListener = new DelegatingDiscoveryListener(network, PerNetworkDiscoveryTracker.this.mBaseListener, PerNetworkDiscoveryTracker.this.mBaseExecutor);
                PerNetworkDiscoveryTracker.this.mPerNetworkListeners.put(network, wrappedListener);
                NsdManager.this.discoverServices(PerNetworkDiscoveryTracker.this.mServiceType, PerNetworkDiscoveryTracker.this.mProtocolType, network, Runnable::run, (DiscoveryListener)wrappedListener);
            }

            @Override
            public void onLost(Network network) {
                DelegatingDiscoveryListener listener = PerNetworkDiscoveryTracker.this.mPerNetworkListeners.get(network);
                if (listener == null) {
                    return;
                }
                listener.notifyAllServicesLost();
                NsdManager.this.stopServiceDiscovery(listener);
            }
        };
        private boolean mStopRequested;

        public void start(NetworkRequest request) {
            ConnectivityManager cm = NsdManager.this.mContext.getSystemService(ConnectivityManager.class);
            cm.registerNetworkCallback(request, this.mNetworkCb, NsdManager.this.mHandler);
            NsdManager.this.mHandler.post(() -> this.mBaseExecutor.execute(() -> this.mBaseListener.onDiscoveryStarted(this.mServiceType)));
        }

        public void requestStop() {
            NsdManager.this.mHandler.post(() -> {
                this.mStopRequested = true;
                ConnectivityManager cm = NsdManager.this.mContext.getSystemService(ConnectivityManager.class);
                cm.unregisterNetworkCallback(this.mNetworkCb);
                if (this.mPerNetworkListeners.size() == 0) {
                    this.mBaseExecutor.execute(() -> this.mBaseListener.onDiscoveryStopped(this.mServiceType));
                    return;
                }
                for (int i = 0; i < this.mPerNetworkListeners.size(); ++i) {
                    DelegatingDiscoveryListener listener = this.mPerNetworkListeners.valueAt(i);
                    NsdManager.this.stopServiceDiscovery(listener);
                }
            });
        }

        private PerNetworkDiscoveryTracker(String serviceType, int protocolType, Executor baseExecutor, DiscoveryListener baseListener) {
            this.mServiceType = serviceType;
            this.mProtocolType = protocolType;
            this.mBaseExecutor = baseExecutor;
            this.mBaseListener = baseListener;
        }

        private class DelegatingDiscoveryListener
        implements DiscoveryListener {
            private final Network mNetwork;
            private final DiscoveryListener mWrapped;
            private final Executor mWrappedExecutor;
            private final ArraySet<TrackedNsdInfo> mFoundInfo = new ArraySet();

            private DelegatingDiscoveryListener(Network network, DiscoveryListener listener, Executor executor) {
                this.mNetwork = network;
                this.mWrapped = listener;
                this.mWrappedExecutor = executor;
            }

            void notifyAllServicesLost() {
                for (int i = 0; i < this.mFoundInfo.size(); ++i) {
                    TrackedNsdInfo trackedInfo = this.mFoundInfo.valueAt(i);
                    NsdServiceInfo serviceInfo = new NsdServiceInfo(trackedInfo.mServiceName, trackedInfo.mServiceType);
                    serviceInfo.setNetwork(this.mNetwork);
                    this.mWrappedExecutor.execute(() -> this.mWrapped.onServiceLost(serviceInfo));
                }
            }

            @Override
            public void onStartDiscoveryFailed(String serviceType, int errorCode) {
                Log.e(TAG, "Failed to start discovery for " + serviceType + " on " + this.mNetwork + " with code " + errorCode);
                PerNetworkDiscoveryTracker.this.mPerNetworkListeners.remove(this.mNetwork);
            }

            @Override
            public void onDiscoveryStarted(String serviceType) {
            }

            @Override
            public void onStopDiscoveryFailed(String serviceType, int errorCode) {
                Log.e(TAG, "Failed to stop discovery for " + serviceType + " on " + this.mNetwork + " with code " + errorCode);
                PerNetworkDiscoveryTracker.this.mPerNetworkListeners.remove(this.mNetwork);
                if (PerNetworkDiscoveryTracker.this.mStopRequested && PerNetworkDiscoveryTracker.this.mPerNetworkListeners.size() == 0) {
                    this.mWrappedExecutor.execute(() -> this.mWrapped.onDiscoveryStopped(serviceType));
                }
            }

            @Override
            public void onDiscoveryStopped(String serviceType) {
                PerNetworkDiscoveryTracker.this.mPerNetworkListeners.remove(this.mNetwork);
                if (PerNetworkDiscoveryTracker.this.mStopRequested && PerNetworkDiscoveryTracker.this.mPerNetworkListeners.size() == 0) {
                    this.mWrappedExecutor.execute(() -> this.mWrapped.onDiscoveryStopped(serviceType));
                }
            }

            @Override
            public void onServiceFound(NsdServiceInfo serviceInfo) {
                this.mFoundInfo.add(new TrackedNsdInfo(serviceInfo));
                this.mWrappedExecutor.execute(() -> this.mWrapped.onServiceFound(serviceInfo));
            }

            @Override
            public void onServiceLost(NsdServiceInfo serviceInfo) {
                this.mFoundInfo.remove(new TrackedNsdInfo(serviceInfo));
                this.mWrappedExecutor.execute(() -> this.mWrapped.onServiceLost(serviceInfo));
            }
        }

        private class TrackedNsdInfo {
            private final String mServiceName;
            private final String mServiceType;

            TrackedNsdInfo(NsdServiceInfo info) {
                this.mServiceName = info.getServiceName();
                this.mServiceType = info.getServiceType();
            }

            public int hashCode() {
                return Objects.hash(this.mServiceName, this.mServiceType);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof TrackedNsdInfo)) {
                    return false;
                }
                TrackedNsdInfo other = (TrackedNsdInfo)obj;
                return Objects.equals(this.mServiceName, other.mServiceName) && Objects.equals(this.mServiceType, other.mServiceType);
            }
        }
    }
}

