/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.annotation.SuppressLint;
import android.net.ipsec.ike.SaProposal;
import android.os.PersistableBundle;
import android.util.ArraySet;
import com.android.internal.net.ipsec.ike.message.IkeSaPayload;
import com.android.internal.net.utils.build.SdkLevel;
import com.android.internal.net.vcn.util.PersistableBundleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class IkeSaProposal
extends SaProposal {
    private static final String PRF_KEY = "mPseudorandomFunctions";
    private final IkeSaPayload.PrfTransform[] mPseudorandomFunctions;

    public IkeSaProposal(IkeSaPayload.EncryptionTransform[] encryptionAlgos, IkeSaPayload.PrfTransform[] prfs, IkeSaPayload.IntegrityTransform[] integrityAlgos, IkeSaPayload.DhGroupTransform[] dhGroups) {
        super(1, encryptionAlgos, integrityAlgos, dhGroups);
        this.mPseudorandomFunctions = prfs;
    }

    public static IkeSaProposal fromPersistableBundle(PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        Builder builder = new Builder();
        PersistableBundle encryptionBundle = in.getPersistableBundle("mEncryptionAlgorithms");
        Objects.requireNonNull(encryptionBundle, "Encryption algo bundle is null");
        List<IkeSaPayload.EncryptionTransform> encryptList = PersistableBundleUtils.toList(encryptionBundle, IkeSaPayload.EncryptionTransform::fromPersistableBundle);
        for (IkeSaPayload.EncryptionTransform encryptionTransform : encryptList) {
            builder.addEncryptionAlgorithm(encryptionTransform.id, encryptionTransform.getSpecifiedKeyLength());
        }
        int[] integrityAlgoIdArray = in.getIntArray("mIntegrityAlgorithms");
        Objects.requireNonNull(integrityAlgoIdArray, "Integrity algo array is null");
        for (int algo : integrityAlgoIdArray) {
            builder.addIntegrityAlgorithm(algo);
        }
        int[] nArray = in.getIntArray("mDhGroups");
        Objects.requireNonNull(nArray, "DH Group array is null");
        for (int dh : nArray) {
            builder.addDhGroup(dh);
        }
        int[] prfArray = in.getIntArray(PRF_KEY);
        Objects.requireNonNull(prfArray, "PRF array is null");
        for (int prf : prfArray) {
            builder.addPseudorandomFunction(prf);
        }
        return builder.build();
    }

    @Override
    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = super.toPersistableBundle();
        int[] prfArray = this.getPseudorandomFunctions().stream().mapToInt(i -> i).toArray();
        result.putIntArray(PRF_KEY, prfArray);
        return result;
    }

    public static Set<Integer> getSupportedEncryptionAlgorithms() {
        return IkeSaProposal.getKeySet(SUPPORTED_ENCRYPTION_ALGO_TO_STR);
    }

    public static Set<Integer> getSupportedIntegrityAlgorithms() {
        HashSet<Integer> supportedSet = new HashSet<Integer>();
        for (int algo : IkeSaProposal.getKeySet(SUPPORTED_INTEGRITY_ALGO_TO_STR)) {
            if (algo == 8 && !SdkLevel.isAtLeastS()) continue;
            supportedSet.add(algo);
        }
        return supportedSet;
    }

    public static Set<Integer> getSupportedPseudorandomFunctions() {
        HashSet<Integer> supportedSet = new HashSet<Integer>();
        for (int algo : IkeSaProposal.getKeySet(SUPPORTED_PRF_TO_STR)) {
            if (algo == 8 && !SdkLevel.isAtLeastS()) continue;
            supportedSet.add(algo);
        }
        return supportedSet;
    }

    public List<Integer> getPseudorandomFunctions() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (IkeSaPayload.PrfTransform transform : this.mPseudorandomFunctions) {
            result.add(transform.id);
        }
        return result;
    }

    public IkeSaPayload.PrfTransform[] getPrfTransforms() {
        return this.mPseudorandomFunctions;
    }

    @Override
    public IkeSaPayload.Transform[] getAllTransforms() {
        List<IkeSaPayload.Transform> transformList = this.getAllTransformsAsList();
        transformList.addAll(Arrays.asList(this.mPseudorandomFunctions));
        return transformList.toArray(new IkeSaPayload.Transform[transformList.size()]);
    }

    @Override
    public boolean isNegotiatedFrom(SaProposal reqProposal) {
        return super.isNegotiatedFrom(reqProposal) && IkeSaProposal.isTransformSelectedFrom(this.mPseudorandomFunctions, ((IkeSaProposal)reqProposal).mPseudorandomFunctions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.mPseudorandomFunctions));
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o) || !(o instanceof IkeSaProposal)) {
            return false;
        }
        return Arrays.equals(this.mPseudorandomFunctions, ((IkeSaProposal)o).mPseudorandomFunctions);
    }

    public static class Builder
    extends SaProposal.Builder {
        private final Set<IkeSaPayload.PrfTransform> mProposedPrfs = new ArraySet<IkeSaPayload.PrfTransform>();

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addEncryptionAlgorithm(int algorithm, int keyLength) {
            this.validateAndAddEncryptAlgo(algorithm, keyLength, false);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addIntegrityAlgorithm(int algorithm) {
            this.validateAndAddIntegrityAlgo(algorithm, false);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addDhGroup(int dhGroup) {
            this.addDh(dhGroup);
            return this;
        }

        public Builder addPseudorandomFunction(int algorithm) {
            this.mProposedPrfs.add(new IkeSaPayload.PrfTransform(algorithm));
            return this;
        }

        private IkeSaPayload.IntegrityTransform[] buildIntegAlgosOrThrow() {
            if (this.mProposedIntegrityAlgos.isEmpty() && !this.mHasAead) {
                throw new IllegalArgumentException("Invalid SA Proposal: Integrity algorithm must be proposed with normal ciphers in IKE proposal.");
            }
            for (IkeSaPayload.IntegrityTransform transform : this.mProposedIntegrityAlgos) {
                if (transform.id == 0 == this.mHasAead) continue;
                throw new IllegalArgumentException("Invalid SA Proposal: Invalid integrity algorithm configuration for this SA Proposal");
            }
            return this.mProposedIntegrityAlgos.toArray(new IkeSaPayload.IntegrityTransform[this.mProposedIntegrityAlgos.size()]);
        }

        private IkeSaPayload.DhGroupTransform[] buildDhGroupsOrThrow() {
            if (this.mProposedDhGroups.isEmpty()) {
                throw new IllegalArgumentException("Invalid SA Proposal: DH group must be proposed in IKE SA proposal.");
            }
            for (IkeSaPayload.DhGroupTransform transform : this.mProposedDhGroups) {
                if (transform.id != 0) continue;
                throw new IllegalArgumentException("Invalid SA Proposal: None-value DH group invalid in IKE SA proposal");
            }
            return this.mProposedDhGroups.toArray(new IkeSaPayload.DhGroupTransform[this.mProposedDhGroups.size()]);
        }

        private IkeSaPayload.PrfTransform[] buildPrfsOrThrow() {
            if (this.mProposedPrfs.isEmpty()) {
                throw new IllegalArgumentException("Invalid SA Proposal: PRF must be proposed in IKE SA proposal.");
            }
            return this.mProposedPrfs.toArray(new IkeSaPayload.PrfTransform[this.mProposedPrfs.size()]);
        }

        public IkeSaProposal build() {
            IkeSaPayload.EncryptionTransform[] encryptionTransforms = this.buildEncryptAlgosOrThrow();
            IkeSaPayload.PrfTransform[] prfTransforms = this.buildPrfsOrThrow();
            IkeSaPayload.IntegrityTransform[] integrityTransforms = this.buildIntegAlgosOrThrow();
            IkeSaPayload.DhGroupTransform[] dhGroupTransforms = this.buildDhGroupsOrThrow();
            return new IkeSaProposal(encryptionTransforms, prfTransforms, integrityTransforms, dhGroupTransforms);
        }
    }
}

