/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.net.ipsec.ike.IkeDerAsn1DnIdentification;
import android.net.ipsec.ike.IkeFqdnIdentification;
import android.net.ipsec.ike.IkeIpv4AddrIdentification;
import android.net.ipsec.ike.IkeIpv6AddrIdentification;
import android.net.ipsec.ike.IkeKeyIdIdentification;
import android.net.ipsec.ike.IkeRfc822AddrIdentification;
import android.net.ipsec.ike.exceptions.AuthenticationFailedException;
import android.os.PersistableBundle;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class IkeIdentification {
    private static final Set<Integer> SUPPORTED_ID_TYPES = new ArraySet<Integer>();
    private static final int INDEX_SAN_TYPE = 0;
    private static final int INDEX_SAN_DATA = 1;
    public static final int ID_TYPE_IPV4_ADDR = 1;
    public static final int ID_TYPE_FQDN = 2;
    public static final int ID_TYPE_RFC822_ADDR = 3;
    public static final int ID_TYPE_IPV6_ADDR = 5;
    public static final int ID_TYPE_DER_ASN1_DN = 9;
    public static final int ID_TYPE_KEY_ID = 11;
    protected static final int SAN_TYPE_RFC822_NAME = 1;
    protected static final int SAN_TYPE_DNS = 2;
    protected static final int SAN_TYPE_IP_ADDRESS = 7;
    private static final String ID_TYPE_KEY = "idType";
    public final int idType;

    protected IkeIdentification(int type) {
        this.idType = type;
    }

    public static IkeIdentification fromPersistableBundle(PersistableBundle in) {
        int idType = in.getInt(ID_TYPE_KEY);
        switch (idType) {
            case 1: {
                return IkeIpv4AddrIdentification.fromPersistableBundle(in);
            }
            case 2: {
                return IkeFqdnIdentification.fromPersistableBundle(in);
            }
            case 3: {
                return IkeRfc822AddrIdentification.fromPersistableBundle(in);
            }
            case 5: {
                return IkeIpv6AddrIdentification.fromPersistableBundle(in);
            }
            case 9: {
                return IkeDerAsn1DnIdentification.fromPersistableBundle(in);
            }
            case 11: {
                return IkeKeyIdIdentification.fromPersistableBundle(in);
            }
        }
        throw new IllegalArgumentException("Invalid ID type: " + idType);
    }

    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = new PersistableBundle();
        result.putInt(ID_TYPE_KEY, this.idType);
        return result;
    }

    public abstract String getIdTypeString();

    public abstract void validateEndCertIdOrThrow(X509Certificate var1) throws AuthenticationFailedException;

    protected void validateEndCertSanOrThrow(X509Certificate endCert, int expectedSanType, Object expectedSanData) throws AuthenticationFailedException {
        try {
            Collection<List<?>> allSans = endCert.getSubjectAlternativeNames();
            if (allSans == null) {
                throw new AuthenticationFailedException("End certificate does not contain SAN");
            }
            for (List<?> san : allSans) {
                Object item;
                if ((Integer)san.get(0) != expectedSanType || !expectedSanData.equals(item = san.get(1))) continue;
                return;
            }
            throw new AuthenticationFailedException("End certificate SAN and " + this.getIdTypeString() + " ID mismatched");
        }
        catch (CertificateParsingException e) {
            throw new AuthenticationFailedException(e);
        }
    }

    public abstract byte[] getEncodedIdData();

    static {
        SUPPORTED_ID_TYPES.add(1);
        SUPPORTED_ID_TYPES.add(2);
        SUPPORTED_ID_TYPES.add(3);
        SUPPORTED_ID_TYPES.add(5);
        SUPPORTED_ID_TYPES.add(9);
        SUPPORTED_ID_TYPES.add(11);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IdType {
    }
}

