/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.annotation.SuppressLint;
import android.net.IpSecAlgorithm;
import android.net.ipsec.ike.SaProposal;
import android.os.PersistableBundle;
import android.util.ArraySet;
import com.android.internal.net.ipsec.ike.crypto.IkeCipher;
import com.android.internal.net.ipsec.ike.crypto.IkeMacIntegrity;
import com.android.internal.net.ipsec.ike.message.IkeSaPayload;
import com.android.internal.net.utils.build.SdkLevel;
import com.android.internal.net.vcn.util.PersistableBundleUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ChildSaProposal
extends SaProposal {
    private static final Set<Integer> SUPPORTED_IPSEC_ENCRYPTION_BEFORE_SDK_S = new ArraySet<Integer>();
    private static final Set<Integer> SUPPORTED_IPSEC_INTEGRITY_BEFORE_SDK_S;
    private static final String ESN_KEY = "mEsns";
    private final IkeSaPayload.EsnTransform[] mEsns;

    public ChildSaProposal(IkeSaPayload.EncryptionTransform[] encryptionAlgos, IkeSaPayload.IntegrityTransform[] integrityAlgos, IkeSaPayload.DhGroupTransform[] dhGroups, IkeSaPayload.EsnTransform[] esns) {
        super(3, encryptionAlgos, integrityAlgos, dhGroups);
        this.mEsns = esns;
    }

    public static ChildSaProposal fromPersistableBundle(PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        Builder builder = new Builder();
        PersistableBundle encryptionBundle = in.getPersistableBundle("mEncryptionAlgorithms");
        Objects.requireNonNull(encryptionBundle, "Encryption algo bundle is null");
        List<IkeSaPayload.EncryptionTransform> encryptList = PersistableBundleUtils.toList(encryptionBundle, IkeSaPayload.EncryptionTransform::fromPersistableBundle);
        for (IkeSaPayload.EncryptionTransform encryptionTransform : encryptList) {
            builder.addEncryptionAlgorithm(encryptionTransform.id, encryptionTransform.getSpecifiedKeyLength());
        }
        int[] integrityAlgoIdArray = in.getIntArray("mIntegrityAlgorithms");
        Objects.requireNonNull(integrityAlgoIdArray, "Integrity algo array is null");
        for (int algo : integrityAlgoIdArray) {
            builder.addIntegrityAlgorithm(algo);
        }
        int[] nArray = in.getIntArray("mDhGroups");
        Objects.requireNonNull(nArray, "DH Group array is null");
        for (int dh : nArray) {
            builder.addDhGroup(dh);
        }
        int[] esnPolicies = in.getIntArray(ESN_KEY);
        Objects.requireNonNull(esnPolicies, "ESN policy array is null");
        block6: for (int p : esnPolicies) {
            switch (p) {
                case 0: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Proposing ESN policy: " + p + " is unsupported");
                }
            }
        }
        return builder.build();
    }

    @Override
    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = super.toPersistableBundle();
        int[] esnPolicies = Arrays.asList(this.mEsns).stream().mapToInt(esn -> esn.id).toArray();
        result.putIntArray(ESN_KEY, esnPolicies);
        return result;
    }

    public static Set<Integer> getSupportedEncryptionAlgorithms() {
        if (SdkLevel.isAtLeastS()) {
            ArraySet<Integer> algoIds = new ArraySet<Integer>();
            for (int i = 0; i < SUPPORTED_ENCRYPTION_ALGO_TO_STR.size(); ++i) {
                int ikeAlgoId = SUPPORTED_ENCRYPTION_ALGO_TO_STR.keyAt(i);
                String ipSecAlgoName = IkeCipher.getIpSecAlgorithmName(ikeAlgoId);
                if (!IpSecAlgorithm.getSupportedAlgorithms().contains(ipSecAlgoName)) continue;
                algoIds.add(ikeAlgoId);
            }
            return algoIds;
        }
        return SUPPORTED_IPSEC_ENCRYPTION_BEFORE_SDK_S;
    }

    public static Set<Integer> getSupportedIntegrityAlgorithms() {
        ArraySet<Integer> algoIds = new ArraySet<Integer>();
        algoIds.add(0);
        if (SdkLevel.isAtLeastS()) {
            for (int i = 0; i < SUPPORTED_INTEGRITY_ALGO_TO_STR.size(); ++i) {
                int ikeAlgoId = SUPPORTED_INTEGRITY_ALGO_TO_STR.keyAt(i);
                String ipSecAlgoName = IkeMacIntegrity.getIpSecAlgorithmName(ikeAlgoId);
                if (!IpSecAlgorithm.getSupportedAlgorithms().contains(ipSecAlgoName)) continue;
                algoIds.add(ikeAlgoId);
            }
        } else {
            algoIds.addAll(SUPPORTED_IPSEC_INTEGRITY_BEFORE_SDK_S);
        }
        return algoIds;
    }

    public IkeSaPayload.EsnTransform[] getEsnTransforms() {
        return this.mEsns;
    }

    public ChildSaProposal getCopyWithoutDhTransform() {
        return new ChildSaProposal(this.getEncryptionTransforms(), this.getIntegrityTransforms(), new IkeSaPayload.DhGroupTransform[0], this.getEsnTransforms());
    }

    @Override
    public IkeSaPayload.Transform[] getAllTransforms() {
        List<IkeSaPayload.Transform> transformList = this.getAllTransformsAsList();
        transformList.addAll(Arrays.asList(this.mEsns));
        return transformList.toArray(new IkeSaPayload.Transform[transformList.size()]);
    }

    @Override
    public boolean isNegotiatedFrom(SaProposal reqProposal) {
        return super.isNegotiatedFrom(reqProposal) && ChildSaProposal.isTransformSelectedFrom(this.mEsns, ((ChildSaProposal)reqProposal).mEsns);
    }

    public boolean isNegotiatedFromExceptDhGroup(SaProposal saProposal) {
        return this.getProtocolId() == saProposal.getProtocolId() && ChildSaProposal.isTransformSelectedFrom(this.getEncryptionTransforms(), saProposal.getEncryptionTransforms()) && ChildSaProposal.isTransformSelectedFrom(this.getIntegrityTransforms(), saProposal.getIntegrityTransforms()) && ChildSaProposal.isTransformSelectedFrom(this.mEsns, ((ChildSaProposal)saProposal).mEsns);
    }

    public ChildSaProposal getCopyWithAdditionalDhTransform(int dhGroup) {
        return new ChildSaProposal(this.getEncryptionTransforms(), this.getIntegrityTransforms(), new IkeSaPayload.DhGroupTransform[]{new IkeSaPayload.DhGroupTransform(dhGroup)}, this.getEsnTransforms());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.mEsns));
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o) || !(o instanceof ChildSaProposal)) {
            return false;
        }
        return Arrays.equals(this.mEsns, ((ChildSaProposal)o).mEsns);
    }

    static {
        SUPPORTED_IPSEC_ENCRYPTION_BEFORE_SDK_S.add(12);
        SUPPORTED_IPSEC_ENCRYPTION_BEFORE_SDK_S.add(18);
        SUPPORTED_IPSEC_ENCRYPTION_BEFORE_SDK_S.add(19);
        SUPPORTED_IPSEC_ENCRYPTION_BEFORE_SDK_S.add(20);
        SUPPORTED_IPSEC_INTEGRITY_BEFORE_SDK_S = new ArraySet<Integer>();
        SUPPORTED_IPSEC_INTEGRITY_BEFORE_SDK_S.add(2);
        SUPPORTED_IPSEC_INTEGRITY_BEFORE_SDK_S.add(12);
        SUPPORTED_IPSEC_INTEGRITY_BEFORE_SDK_S.add(13);
        SUPPORTED_IPSEC_INTEGRITY_BEFORE_SDK_S.add(14);
    }

    public static class Builder
    extends SaProposal.Builder {
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addEncryptionAlgorithm(int algorithm, int keyLength) {
            this.validateAndAddEncryptAlgo(algorithm, keyLength, true);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addIntegrityAlgorithm(int algorithm) {
            this.validateAndAddIntegrityAlgo(algorithm, true);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addDhGroup(int dhGroup) {
            this.addDh(dhGroup);
            return this;
        }

        private IkeSaPayload.IntegrityTransform[] buildIntegAlgosOrThrow() {
            for (IkeSaPayload.IntegrityTransform transform : this.mProposedIntegrityAlgos) {
                if (transform.id == 0 || !this.mHasAead) continue;
                throw new IllegalArgumentException("Invalid SA Proposal: Only INTEGRITY_ALGORITHM_NONE can be proposed with combined-mode ciphers in any proposal.");
            }
            return this.mProposedIntegrityAlgos.toArray(new IkeSaPayload.IntegrityTransform[this.mProposedIntegrityAlgos.size()]);
        }

        public ChildSaProposal build() {
            IkeSaPayload.EncryptionTransform[] encryptionTransforms = this.buildEncryptAlgosOrThrow();
            IkeSaPayload.IntegrityTransform[] integrityTransforms = this.buildIntegAlgosOrThrow();
            return new ChildSaProposal(encryptionTransforms, integrityTransforms, this.mProposedDhGroups.toArray(new IkeSaPayload.DhGroupTransform[this.mProposedDhGroups.size()]), new IkeSaPayload.EsnTransform[]{new IkeSaPayload.EsnTransform()});
        }
    }
}

