/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class ProfileNetworkPreference
implements Parcelable {
    private final int mPreference;
    private final int mPreferenceEnterpriseId;
    private int[] mIncludedUids = new int[0];
    private int[] mExcludedUids = new int[0];
    public static final Parcelable.Creator<ProfileNetworkPreference> CREATOR = new Parcelable.Creator<ProfileNetworkPreference>(){

        public ProfileNetworkPreference[] newArray(int size) {
            return new ProfileNetworkPreference[size];
        }

        @Override
        public ProfileNetworkPreference createFromParcel(Parcel in) {
            return new ProfileNetworkPreference(in);
        }
    };

    private ProfileNetworkPreference(int preference, int[] includedUids, int[] excludedUids, int preferenceEnterpriseId) {
        this.mPreference = preference;
        this.mPreferenceEnterpriseId = preferenceEnterpriseId;
        this.mIncludedUids = includedUids != null ? (int[])includedUids.clone() : new int[0];
        this.mExcludedUids = excludedUids != null ? (int[])excludedUids.clone() : new int[0];
    }

    private ProfileNetworkPreference(Parcel in) {
        this.mPreference = in.readInt();
        in.readIntArray(this.mIncludedUids);
        in.readIntArray(this.mExcludedUids);
        this.mPreferenceEnterpriseId = in.readInt();
    }

    public int getPreference() {
        return this.mPreference;
    }

    public int[] getIncludedUids() {
        return (int[])this.mIncludedUids.clone();
    }

    public int[] getExcludedUids() {
        return (int[])this.mExcludedUids.clone();
    }

    public int getPreferenceEnterpriseId() {
        return this.mPreferenceEnterpriseId;
    }

    public String toString() {
        return "ProfileNetworkPreference{mPreference=" + this.getPreference() + "mIncludedUids=" + Arrays.toString(this.mIncludedUids) + "mExcludedUids=" + Arrays.toString(this.mExcludedUids) + "mPreferenceEnterpriseId=" + this.mPreferenceEnterpriseId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileNetworkPreference that = (ProfileNetworkPreference)o;
        return this.mPreference == that.mPreference && Arrays.equals(this.mIncludedUids, that.mIncludedUids) && Arrays.equals(this.mExcludedUids, that.mExcludedUids) && this.mPreferenceEnterpriseId == that.mPreferenceEnterpriseId;
    }

    public int hashCode() {
        return this.mPreference + this.mPreferenceEnterpriseId * 2 + Arrays.hashCode(this.mIncludedUids) * 11 + Arrays.hashCode(this.mExcludedUids) * 13;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mPreference);
        dest.writeIntArray(this.mIncludedUids);
        dest.writeIntArray(this.mExcludedUids);
        dest.writeInt(this.mPreferenceEnterpriseId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private int mPreference = 0;
        private int[] mIncludedUids = new int[0];
        private int[] mExcludedUids = new int[0];
        private int mPreferenceEnterpriseId;

        public Builder setPreference(int preference) {
            this.mPreference = preference;
            return this;
        }

        public Builder setIncludedUids(int[] uids) {
            Objects.requireNonNull(uids);
            this.mIncludedUids = (int[])uids.clone();
            return this;
        }

        public Builder setExcludedUids(int[] uids) {
            Objects.requireNonNull(uids);
            this.mExcludedUids = (int[])uids.clone();
            return this;
        }

        private boolean isEnterpriseIdentifierValid(int identifier) {
            return identifier >= 1 && identifier <= 5;
        }

        public ProfileNetworkPreference build() {
            if (this.mIncludedUids.length > 0 && this.mExcludedUids.length > 0) {
                throw new IllegalArgumentException("Both includedUids and excludedUids cannot be nonempty");
            }
            if (this.mPreference != 0 && !this.isEnterpriseIdentifierValid(this.mPreferenceEnterpriseId) || this.mPreference == 0 && this.mPreferenceEnterpriseId != 0) {
                throw new IllegalStateException("Invalid preference enterprise identifier");
            }
            return new ProfileNetworkPreference(this.mPreference, this.mIncludedUids, this.mExcludedUids, this.mPreferenceEnterpriseId);
        }

        public Builder setPreferenceEnterpriseId(int preferenceId) {
            this.mPreferenceEnterpriseId = preferenceId;
            return this;
        }
    }
}

