/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.NetworkCapabilities;
import android.net.NetworkStateSnapshot;
import android.net.TransportInfo;
import android.net.connectivity.com.android.net.module.util.CollectionUtils;
import android.net.connectivity.com.android.net.module.util.NetworkCapabilitiesUtils;
import android.net.connectivity.com.android.net.module.util.NetworkIdentityUtils;
import android.net.wifi.WifiInfo;
import android.telephony.TelephonyManager;
import android.util.proto.ProtoOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Objects;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class NetworkIdentity {
    private static final String TAG = "NetworkIdentity";
    public static final int SUBTYPE_COMBINED = -1;
    public static final int OEM_NONE = 0;
    public static final int OEM_PAID = 1;
    public static final int OEM_PRIVATE = 2;
    private static final long SUPPORTED_OEM_MANAGED_TYPES = 3L;
    final int mType;
    final int mRatType;
    final int mSubId;
    final String mSubscriberId;
    final String mWifiNetworkKey;
    final boolean mRoaming;
    final boolean mMetered;
    final boolean mDefaultNetwork;
    final int mOemManaged;

    public NetworkIdentity(int type, int ratType, String subscriberId, String wifiNetworkKey, boolean roaming, boolean metered, boolean defaultNetwork, int oemManaged, int subId) {
        this.mType = type;
        this.mRatType = ratType;
        this.mSubscriberId = subscriberId;
        this.mWifiNetworkKey = wifiNetworkKey;
        this.mRoaming = roaming;
        this.mMetered = metered;
        this.mDefaultNetwork = defaultNetwork;
        this.mOemManaged = oemManaged;
        this.mSubId = subId;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mRatType, this.mSubscriberId, this.mWifiNetworkKey, this.mRoaming, this.mMetered, this.mDefaultNetwork, this.mOemManaged, this.mSubId);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkIdentity) {
            NetworkIdentity ident = (NetworkIdentity)obj;
            return this.mType == ident.mType && this.mRatType == ident.mRatType && this.mRoaming == ident.mRoaming && Objects.equals(this.mSubscriberId, ident.mSubscriberId) && Objects.equals(this.mWifiNetworkKey, ident.mWifiNetworkKey) && this.mMetered == ident.mMetered && this.mDefaultNetwork == ident.mDefaultNetwork && this.mOemManaged == ident.mOemManaged && this.mSubId == ident.mSubId;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        builder.append("type=").append(this.mType);
        builder.append(", ratType=");
        if (this.mRatType == -1) {
            builder.append("COMBINED");
        } else {
            builder.append(this.mRatType);
        }
        if (this.mSubscriberId != null) {
            builder.append(", subscriberId=").append(NetworkIdentityUtils.scrubSubscriberId(this.mSubscriberId));
        }
        if (this.mWifiNetworkKey != null) {
            builder.append(", wifiNetworkKey=").append(this.mWifiNetworkKey);
        }
        if (this.mRoaming) {
            builder.append(", ROAMING");
        }
        builder.append(", metered=").append(this.mMetered);
        builder.append(", defaultNetwork=").append(this.mDefaultNetwork);
        builder.append(", oemManaged=").append(NetworkIdentity.getOemManagedNames(this.mOemManaged));
        builder.append(", subId=").append(this.mSubId);
        return builder.append("}").toString();
    }

    static String getOemManagedNames(int oemManaged) {
        if (oemManaged == 0) {
            return "OEM_NONE";
        }
        int[] bitPositions = NetworkCapabilitiesUtils.unpackBits(oemManaged);
        ArrayList<String> oemManagedNames = new ArrayList<String>();
        for (int position : bitPositions) {
            oemManagedNames.add(NetworkIdentity.nameOfOemManaged(1 << position));
        }
        return String.join((CharSequence)",", oemManagedNames);
    }

    private static String nameOfOemManaged(int oemManagedBit) {
        switch (oemManagedBit) {
            case 1: {
                return "OEM_PAID";
            }
            case 2: {
                return "OEM_PRIVATE";
            }
        }
        return "Invalid(" + oemManagedBit + ")";
    }

    public void dumpDebug(ProtoOutputStream proto, long tag) {
        long start = proto.start(tag);
        proto.write(0x10500000001L, this.mType);
        proto.write(1133871366148L, this.mRoaming);
        proto.write(1133871366149L, this.mMetered);
        proto.write(1133871366150L, this.mDefaultNetwork);
        proto.write(1120986464263L, this.mOemManaged);
        proto.end(start);
    }

    public int getType() {
        return this.mType;
    }

    public int getRatType() {
        return this.mRatType;
    }

    public String getSubscriberId() {
        return this.mSubscriberId;
    }

    public String getWifiNetworkKey() {
        return this.mWifiNetworkKey;
    }

    public boolean getRoaming() {
        return this.mRoaming;
    }

    public boolean isRoaming() {
        return this.mRoaming;
    }

    public boolean getMetered() {
        return this.mMetered;
    }

    public boolean isMetered() {
        return this.mMetered;
    }

    public boolean getDefaultNetwork() {
        return this.mDefaultNetwork;
    }

    public boolean isDefaultNetwork() {
        return this.mDefaultNetwork;
    }

    public int getOemManaged() {
        return this.mOemManaged;
    }

    public int getSubId() {
        return this.mSubId;
    }

    @Deprecated
    public static NetworkIdentity buildNetworkIdentity(Context context, NetworkStateSnapshot snapshot, boolean defaultNetwork, int ratType) {
        Builder builder = new Builder().setNetworkStateSnapshot(snapshot).setDefaultNetwork(defaultNetwork).setSubId(snapshot.getSubId());
        if (snapshot.getLegacyType() == 0 && ratType != -1) {
            builder.setRatType(ratType);
        }
        return builder.build();
    }

    public static int getOemBitfield(NetworkCapabilities nc) {
        int oemManaged = 0;
        if (nc.hasCapability(22)) {
            oemManaged |= 1;
        }
        if (nc.hasCapability(26)) {
            oemManaged |= 2;
        }
        return oemManaged;
    }

    public static int compare(NetworkIdentity left, NetworkIdentity right) {
        Objects.requireNonNull(right);
        int res = Integer.compare(left.mType, right.mType);
        if (res == 0) {
            res = Integer.compare(left.mRatType, right.mRatType);
        }
        if (res == 0 && left.mSubscriberId != null && right.mSubscriberId != null) {
            res = left.mSubscriberId.compareTo(right.mSubscriberId);
        }
        if (res == 0 && left.mWifiNetworkKey != null && right.mWifiNetworkKey != null) {
            res = left.mWifiNetworkKey.compareTo(right.mWifiNetworkKey);
        }
        if (res == 0) {
            res = Boolean.compare(left.mRoaming, right.mRoaming);
        }
        if (res == 0) {
            res = Boolean.compare(left.mMetered, right.mMetered);
        }
        if (res == 0) {
            res = Boolean.compare(left.mDefaultNetwork, right.mDefaultNetwork);
        }
        if (res == 0) {
            res = Integer.compare(left.mOemManaged, right.mOemManaged);
        }
        if (res == 0) {
            res = Integer.compare(left.mSubId, right.mSubId);
        }
        return res;
    }

    public static class Builder {
        private static final int MAX_NETWORK_TYPE = 18;
        private static final int MIN_NETWORK_TYPE = 0;
        private int mType = -1;
        private int mRatType = -1;
        private String mSubscriberId = null;
        private String mWifiNetworkKey = null;
        private boolean mRoaming = false;
        private boolean mMetered = false;
        private boolean mDefaultNetwork = false;
        private int mOemManaged = 0;
        private int mSubId = -1;

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setNetworkStateSnapshot(NetworkStateSnapshot snapshot) {
            TransportInfo transportInfo;
            this.setType(snapshot.getLegacyType());
            this.setSubscriberId(snapshot.getSubscriberId());
            this.setRoaming(!snapshot.getNetworkCapabilities().hasCapability(18));
            this.setMetered(!snapshot.getNetworkCapabilities().hasCapability(11) && !snapshot.getNetworkCapabilities().hasCapability(25));
            this.setOemManaged(NetworkIdentity.getOemBitfield(snapshot.getNetworkCapabilities()));
            if (this.mType == 1 && (transportInfo = snapshot.getNetworkCapabilities().getTransportInfo()) instanceof WifiInfo) {
                WifiInfo info = (WifiInfo)transportInfo;
                this.setWifiNetworkKey(info.getNetworkKey());
            }
            return this;
        }

        public Builder setType(int type) {
            if ((type < 0 || 18 < type) && type != -1) {
                throw new IllegalArgumentException("Invalid network type: " + type);
            }
            this.mType = type;
            return this;
        }

        public Builder setRatType(int ratType) {
            if (!CollectionUtils.contains(TelephonyManager.getAllNetworkTypes(), ratType) && ratType != 0 && ratType != -2) {
                throw new IllegalArgumentException("Invalid ratType " + ratType);
            }
            this.mRatType = ratType;
            return this;
        }

        public Builder clearRatType() {
            this.mRatType = -1;
            return this;
        }

        public Builder setSubscriberId(String subscriberId) {
            this.mSubscriberId = subscriberId;
            return this;
        }

        public Builder setWifiNetworkKey(String wifiNetworkKey) {
            this.mWifiNetworkKey = wifiNetworkKey;
            return this;
        }

        public Builder setRoaming(boolean roaming) {
            this.mRoaming = roaming;
            return this;
        }

        public Builder setMetered(boolean metered) {
            this.mMetered = metered;
            return this;
        }

        public Builder setDefaultNetwork(boolean defaultNetwork) {
            this.mDefaultNetwork = defaultNetwork;
            return this;
        }

        public Builder setOemManaged(int oemManaged) {
            if ((0xFFFFFFFFFFFFFFFCL & (long)oemManaged) != 0L) {
                throw new IllegalArgumentException("Invalid value for OemManaged : " + oemManaged);
            }
            this.mOemManaged = oemManaged;
            return this;
        }

        public Builder setSubId(int subId) {
            this.mSubId = subId;
            return this;
        }

        private void ensureValidParameters() {
            if (this.mType != 0 && this.mRatType != -1) {
                throw new IllegalArgumentException("Invalid ratType " + this.mRatType + " for type " + this.mType);
            }
            if (this.mType != 1 && this.mWifiNetworkKey != null) {
                throw new IllegalArgumentException("Invalid wifi network key for type " + this.mType);
            }
        }

        public NetworkIdentity build() {
            this.ensureValidParameters();
            return new NetworkIdentity(this.mType, this.mRatType, this.mSubscriberId, this.mWifiNetworkKey, this.mRoaming, this.mMetered, this.mDefaultNetwork, this.mOemManaged, this.mSubId);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OemManaged {
    }
}

