/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Network;
import android.net.TetherStatesParcel;
import android.net.TetheredClient;
import android.net.TetheringCallbackStartedParcel;
import android.net.TetheringConfigurationParcel;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ITetheringEventCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.ITetheringEventCallback";

    public void onCallbackStarted(TetheringCallbackStartedParcel var1) throws RemoteException;

    public void onCallbackStopped(int var1) throws RemoteException;

    public void onUpstreamChanged(Network var1) throws RemoteException;

    public void onConfigurationChanged(TetheringConfigurationParcel var1) throws RemoteException;

    public void onTetherStatesChanged(TetherStatesParcel var1) throws RemoteException;

    public void onTetherClientsChanged(List<TetheredClient> var1) throws RemoteException;

    public void onOffloadStatusChanged(int var1) throws RemoteException;

    public void onSupportedTetheringTypes(long var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITetheringEventCallback {
        static final int TRANSACTION_onCallbackStarted = 1;
        static final int TRANSACTION_onCallbackStopped = 2;
        static final int TRANSACTION_onUpstreamChanged = 3;
        static final int TRANSACTION_onConfigurationChanged = 4;
        static final int TRANSACTION_onTetherStatesChanged = 5;
        static final int TRANSACTION_onTetherClientsChanged = 6;
        static final int TRANSACTION_onOffloadStatusChanged = 7;
        static final int TRANSACTION_onSupportedTetheringTypes = 8;

        public Stub() {
            this.attachInterface(this, ITetheringEventCallback.DESCRIPTOR);
        }

        public static ITetheringEventCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITetheringEventCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ITetheringEventCallback) {
                return (ITetheringEventCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITetheringEventCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    TetheringCallbackStartedParcel _arg0 = data.readTypedObject(TetheringCallbackStartedParcel.CREATOR);
                    this.onCallbackStarted(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    this.onCallbackStopped(_arg0);
                    break;
                }
                case 3: {
                    Network _arg0 = data.readTypedObject(Network.CREATOR);
                    this.onUpstreamChanged(_arg0);
                    break;
                }
                case 4: {
                    TetheringConfigurationParcel _arg0 = data.readTypedObject(TetheringConfigurationParcel.CREATOR);
                    this.onConfigurationChanged(_arg0);
                    break;
                }
                case 5: {
                    TetherStatesParcel _arg0 = data.readTypedObject(TetherStatesParcel.CREATOR);
                    this.onTetherStatesChanged(_arg0);
                    break;
                }
                case 6: {
                    ArrayList<TetheredClient> _arg0 = data.createTypedArrayList(TetheredClient.CREATOR);
                    this.onTetherClientsChanged(_arg0);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    this.onOffloadStatusChanged(_arg0);
                    break;
                }
                case 8: {
                    long _arg0 = data.readLong();
                    this.onSupportedTetheringTypes(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ITetheringEventCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITetheringEventCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallbackStarted(TetheringCallbackStartedParcel parcel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringEventCallback.DESCRIPTOR);
                    _data.writeTypedObject(parcel, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallbackStopped(int errorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringEventCallback.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUpstreamChanged(Network network) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringEventCallback.DESCRIPTOR);
                    _data.writeTypedObject(network, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigurationChanged(TetheringConfigurationParcel config) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringEventCallback.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTetherStatesChanged(TetherStatesParcel states) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringEventCallback.DESCRIPTOR);
                    _data.writeTypedObject(states, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTetherClientsChanged(List<TetheredClient> clients) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringEventCallback.DESCRIPTOR);
                    _data.writeTypedList(clients);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOffloadStatusChanged(int status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringEventCallback.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSupportedTetheringTypes(long supportedBitmap) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringEventCallback.DESCRIPTOR);
                    _data.writeLong(supportedBitmap);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITetheringEventCallback {
        @Override
        public void onCallbackStarted(TetheringCallbackStartedParcel parcel) throws RemoteException {
        }

        @Override
        public void onCallbackStopped(int errorCode) throws RemoteException {
        }

        @Override
        public void onUpstreamChanged(Network network) throws RemoteException {
        }

        @Override
        public void onConfigurationChanged(TetheringConfigurationParcel config) throws RemoteException {
        }

        @Override
        public void onTetherStatesChanged(TetherStatesParcel states) throws RemoteException {
        }

        @Override
        public void onTetherClientsChanged(List<TetheredClient> clients) throws RemoteException {
        }

        @Override
        public void onOffloadStatusChanged(int status) throws RemoteException {
        }

        @Override
        public void onSupportedTetheringTypes(long supportedBitmap) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

