/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IIntResultListener;
import android.net.ITetheringEventCallback;
import android.net.TetheringRequestParcel;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;

public interface ITetheringConnector
extends IInterface {
    public static final String DESCRIPTOR = "android.net.ITetheringConnector";

    public void tether(String var1, String var2, String var3, IIntResultListener var4) throws RemoteException;

    public void untether(String var1, String var2, String var3, IIntResultListener var4) throws RemoteException;

    public void setUsbTethering(boolean var1, String var2, String var3, IIntResultListener var4) throws RemoteException;

    public void startTethering(TetheringRequestParcel var1, String var2, String var3, IIntResultListener var4) throws RemoteException;

    public void stopTethering(int var1, String var2, String var3, IIntResultListener var4) throws RemoteException;

    public void requestLatestTetheringEntitlementResult(int var1, ResultReceiver var2, boolean var3, String var4, String var5) throws RemoteException;

    public void registerTetheringEventCallback(ITetheringEventCallback var1, String var2) throws RemoteException;

    public void unregisterTetheringEventCallback(ITetheringEventCallback var1, String var2) throws RemoteException;

    public void isTetheringSupported(String var1, String var2, IIntResultListener var3) throws RemoteException;

    public void stopAllTethering(String var1, String var2, IIntResultListener var3) throws RemoteException;

    public void setPreferTestNetworks(boolean var1, IIntResultListener var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITetheringConnector {
        static final int TRANSACTION_tether = 1;
        static final int TRANSACTION_untether = 2;
        static final int TRANSACTION_setUsbTethering = 3;
        static final int TRANSACTION_startTethering = 4;
        static final int TRANSACTION_stopTethering = 5;
        static final int TRANSACTION_requestLatestTetheringEntitlementResult = 6;
        static final int TRANSACTION_registerTetheringEventCallback = 7;
        static final int TRANSACTION_unregisterTetheringEventCallback = 8;
        static final int TRANSACTION_isTetheringSupported = 9;
        static final int TRANSACTION_stopAllTethering = 10;
        static final int TRANSACTION_setPreferTestNetworks = 11;

        public Stub() {
            this.attachInterface(this, ITetheringConnector.DESCRIPTOR);
        }

        public static ITetheringConnector asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITetheringConnector.DESCRIPTOR);
            if (iin != null && iin instanceof ITetheringConnector) {
                return (ITetheringConnector)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITetheringConnector.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    IIntResultListener _arg3 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.tether(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    IIntResultListener _arg3 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.untether(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 3: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    IIntResultListener _arg3 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.setUsbTethering(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 4: {
                    TetheringRequestParcel _arg0 = data.readTypedObject(TetheringRequestParcel.CREATOR);
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    IIntResultListener _arg3 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.startTethering(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    IIntResultListener _arg3 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.stopTethering(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    ResultReceiver _arg1 = data.readTypedObject(ResultReceiver.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    this.requestLatestTetheringEntitlementResult(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 7: {
                    ITetheringEventCallback _arg0 = ITetheringEventCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.registerTetheringEventCallback(_arg0, _arg1);
                    break;
                }
                case 8: {
                    ITetheringEventCallback _arg0 = ITetheringEventCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.unregisterTetheringEventCallback(_arg0, _arg1);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    IIntResultListener _arg2 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.isTetheringSupported(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    IIntResultListener _arg2 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.stopAllTethering(_arg0, _arg1, _arg2);
                    break;
                }
                case 11: {
                    boolean _arg0 = data.readBoolean();
                    IIntResultListener _arg1 = IIntResultListener.Stub.asInterface(data.readStrongBinder());
                    this.setPreferTestNetworks(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ITetheringConnector {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITetheringConnector.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tether(String iface, String callerPkg, String callingAttributionTag, IIntResultListener receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringConnector.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeString(callerPkg);
                    _data.writeString(callingAttributionTag);
                    _data.writeStrongInterface(receiver);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void untether(String iface, String callerPkg, String callingAttributionTag, IIntResultListener receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringConnector.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeString(callerPkg);
                    _data.writeString(callingAttributionTag);
                    _data.writeStrongInterface(receiver);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUsbTethering(boolean enable, String callerPkg, String callingAttributionTag, IIntResultListener receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringConnector.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    _data.writeString(callerPkg);
                    _data.writeString(callingAttributionTag);
                    _data.writeStrongInterface(receiver);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startTethering(TetheringRequestParcel request, String callerPkg, String callingAttributionTag, IIntResultListener receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringConnector.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeString(callerPkg);
                    _data.writeString(callingAttributionTag);
                    _data.writeStrongInterface(receiver);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopTethering(int type, String callerPkg, String callingAttributionTag, IIntResultListener receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringConnector.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeString(callerPkg);
                    _data.writeString(callingAttributionTag);
                    _data.writeStrongInterface(receiver);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestLatestTetheringEntitlementResult(int type, ResultReceiver receiver, boolean showEntitlementUi, String callerPkg, String callingAttributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringConnector.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeTypedObject(receiver, 0);
                    _data.writeBoolean(showEntitlementUi);
                    _data.writeString(callerPkg);
                    _data.writeString(callingAttributionTag);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTetheringEventCallback(ITetheringEventCallback callback, String callerPkg) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringConnector.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeString(callerPkg);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterTetheringEventCallback(ITetheringEventCallback callback, String callerPkg) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringConnector.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeString(callerPkg);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isTetheringSupported(String callerPkg, String callingAttributionTag, IIntResultListener receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringConnector.DESCRIPTOR);
                    _data.writeString(callerPkg);
                    _data.writeString(callingAttributionTag);
                    _data.writeStrongInterface(receiver);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopAllTethering(String callerPkg, String callingAttributionTag, IIntResultListener receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringConnector.DESCRIPTOR);
                    _data.writeString(callerPkg);
                    _data.writeString(callingAttributionTag);
                    _data.writeStrongInterface(receiver);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPreferTestNetworks(boolean prefer, IIntResultListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheringConnector.DESCRIPTOR);
                    _data.writeBoolean(prefer);
                    _data.writeStrongInterface(listener);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITetheringConnector {
        @Override
        public void tether(String iface, String callerPkg, String callingAttributionTag, IIntResultListener receiver) throws RemoteException {
        }

        @Override
        public void untether(String iface, String callerPkg, String callingAttributionTag, IIntResultListener receiver) throws RemoteException {
        }

        @Override
        public void setUsbTethering(boolean enable, String callerPkg, String callingAttributionTag, IIntResultListener receiver) throws RemoteException {
        }

        @Override
        public void startTethering(TetheringRequestParcel request, String callerPkg, String callingAttributionTag, IIntResultListener receiver) throws RemoteException {
        }

        @Override
        public void stopTethering(int type, String callerPkg, String callingAttributionTag, IIntResultListener receiver) throws RemoteException {
        }

        @Override
        public void requestLatestTetheringEntitlementResult(int type, ResultReceiver receiver, boolean showEntitlementUi, String callerPkg, String callingAttributionTag) throws RemoteException {
        }

        @Override
        public void registerTetheringEventCallback(ITetheringEventCallback callback, String callerPkg) throws RemoteException {
        }

        @Override
        public void unregisterTetheringEventCallback(ITetheringEventCallback callback, String callerPkg) throws RemoteException {
        }

        @Override
        public void isTetheringSupported(String callerPkg, String callingAttributionTag, IIntResultListener receiver) throws RemoteException {
        }

        @Override
        public void stopAllTethering(String callerPkg, String callingAttributionTag, IIntResultListener receiver) throws RemoteException {
        }

        @Override
        public void setPreferTestNetworks(boolean prefer, IIntResultListener listener) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

