/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.TestNetworkInterface;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITestNetworkManager
extends IInterface {
    public static final String DESCRIPTOR = "android.net.ITestNetworkManager";

    public TestNetworkInterface createInterface(boolean var1, boolean var2, LinkAddress[] var3, String var4) throws RemoteException;

    public void setupTestNetwork(String var1, LinkProperties var2, boolean var3, int[] var4, IBinder var5) throws RemoteException;

    public void teardownTestNetwork(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITestNetworkManager {
        static final int TRANSACTION_createInterface = 1;
        static final int TRANSACTION_setupTestNetwork = 2;
        static final int TRANSACTION_teardownTestNetwork = 3;

        public Stub() {
            this.attachInterface(this, ITestNetworkManager.DESCRIPTOR);
        }

        public static ITestNetworkManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITestNetworkManager.DESCRIPTOR);
            if (iin != null && iin instanceof ITestNetworkManager) {
                return (ITestNetworkManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createInterface";
                }
                case 2: {
                    return "setupTestNetwork";
                }
                case 3: {
                    return "teardownTestNetwork";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITestNetworkManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    LinkAddress[] _arg2 = data.createTypedArray(LinkAddress.CREATOR);
                    String _arg3 = data.readString();
                    TestNetworkInterface _result = this.createInterface(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    LinkProperties _arg1 = data.readTypedObject(LinkProperties.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    int[] _arg3 = data.createIntArray();
                    IBinder _arg4 = data.readStrongBinder();
                    this.setupTestNetwork(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    this.teardownTestNetwork(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements ITestNetworkManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITestNetworkManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TestNetworkInterface createInterface(boolean isTun, boolean bringUp, LinkAddress[] addrs, String iface) throws RemoteException {
                TestNetworkInterface _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestNetworkManager.DESCRIPTOR);
                    _data.writeBoolean(isTun);
                    _data.writeBoolean(bringUp);
                    _data.writeTypedArray(addrs, 0);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TestNetworkInterface.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setupTestNetwork(String iface, LinkProperties lp, boolean isMetered, int[] administratorUids, IBinder binder) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestNetworkManager.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeTypedObject(lp, 0);
                    _data.writeBoolean(isMetered);
                    _data.writeIntArray(administratorUids);
                    _data.writeStrongBinder(binder);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void teardownTestNetwork(int netId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestNetworkManager.DESCRIPTOR);
                    _data.writeInt(netId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITestNetworkManager {
        @Override
        public TestNetworkInterface createInterface(boolean isTun, boolean bringUp, LinkAddress[] addrs, String iface) throws RemoteException {
            return null;
        }

        @Override
        public void setupTestNetwork(String iface, LinkProperties lp, boolean isMetered, int[] administratorUids, IBinder binder) throws RemoteException {
        }

        @Override
        public void teardownTestNetwork(int netId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

